
#include "Variabili.h"

// --------------------------------------------

interrupt void Interrupt_Servizio(void)
{
	IER &= (~M_INT14);									// Impedisce Arrivo Interrupt Timer 2

	uint16_t TempPIEIER;								// Modifica Setaggio Interrupt per permettere arrivo Interrrupt_Main
	TempPIEIER = PieCtrlRegs.PIEIER3.all;
	IER |= M_INT3;
	PieCtrlRegs.PIEIER2.bit.INTx6 = 1;
	PieCtrlRegs.PIEIER2.bit.INTx7 = 0;
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;
	asm (" nop");
	EINT;

	if (SysTime > 2500)
	{
	    SysTime = 0;
	    GpioDataRegs.GPCTOGGLE.bit.GPIO89   = 1;
	}

	DINT;										// Ripristina settaggio corretto Interrupt PWM
	EPwm7Regs.ETCLR.bit.INT = 1;
	PieCtrlRegs.PIEIER3.all = TempPIEIER;

}

// --------------------------------------------
