
#include "Variabili.h"
#include "DCL.h"
#include <math.h>

// -----------------------------------

void xMOTOR_PWMInit(volatile struct EPWM_REGS * Pwm)
{
    EALLOW;

    // Inizializza Periodo del PWM
    (Pwm)->TBPRD = xMOTOR_CLA.sPwmMod.PeriodMax;


    // Inizializza Fase del PWM
    (Pwm)->TBPHS.bit.TBPHS = 0;


    // Inizializza Timer-Base Control Register for EPWM1-EPWM3
    (Pwm)->TBCTL.bit.FREE_SOFT = 1;
    (Pwm)->TBCTL.bit.PHSDIR = TB_UP;
    (Pwm)->TBCTL.bit.CLKDIV = TB_DIV1;
    (Pwm)->TBCTL.bit.HSPCLKDIV = TB_DIV1;
    (Pwm)->TBCTL.bit.SWFSYNC = 0;
    (Pwm)->TBCTL.bit.SYNCOSEL = 0;
    (Pwm)->TBCTL.bit.PRDLD = TB_IMMEDIATE;
    (Pwm)->TBCTL.bit.PHSEN = 0;
    (Pwm)->TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN;
    (Pwm)->TBCTL2.all = 0;


    // Controllo della ricarica
    (Pwm)->CMPCTL.bit.LOADASYNC = 0;
    (Pwm)->CMPCTL.bit.LOADBSYNC = 0;
    (Pwm)->CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
    (Pwm)->CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;
    (Pwm)->CMPCTL.bit.SHDWAMODE = CC_SHADOW;
    (Pwm)->CMPCTL.bit.SHDWBMODE = CC_SHADOW;
    (Pwm)->CMPCTL2.all = 0;


    // Inizializza azione in evento comparazione for EPWM1-EPWM3
    (Pwm)->AQCTL.all = 0;
    (Pwm)->AQTSRCSEL.all = 0;
    (Pwm)->AQCTLA.bit.CAU = AQ_SET;
    (Pwm)->AQCTLA.bit.CAD = AQ_CLEAR;
    (Pwm)->AQCTLA2.all = 0;
    (Pwm)->AQCTLB.all = 0;
    (Pwm)->AQCTLB2.all = 0;


    // Inizializza Dead-Band for EPWM1-EPWM3
    (Pwm)->DBCTL.all            = 0;
    (Pwm)->DBCTL.bit.HALFCYCLE = 0;
    (Pwm)->DBCTL.bit.DEDB_MODE = 0;
    (Pwm)->DBCTL.bit.IN_MODE  = DBA_ALL;
    (Pwm)->DBCTL.bit.OUT_MODE  = DB_FULL_ENABLE;
    (Pwm)->DBCTL.bit.OUTSWAP  = 0;
    (Pwm)->DBCTL.bit.POLSEL    = DB_ACTV_HIC;
    (Pwm)->DBCTL2.all          = 0;

    // Inizializza (disabilita) PWM Chopper for EPWM1-EPWM3
    (Pwm)->PCCTL.bit.CHPEN = CHP_DISABLE;


    // Init Trip Zone Control Register
    (Pwm)->TZSEL.all = 0;                   // nessuna sorgente (/TZ1, ...) selezionata
    (Pwm)->TZDCSEL.all = 0;
    (Pwm)->TZCTL.bit.TZA = TZ_FORCE_LO;
    (Pwm)->TZCTL.bit.TZB = TZ_FORCE_LO;


    // Init Dead-Band Generator Falling/Rising Edge Delay Register for EPWM1-EPWM3
    (Pwm)->DBFED = (xMOTORE_DeadBand * Frequenza_DSP);
    (Pwm)->DBRED = (xMOTORE_DeadBand * Frequenza_DSP);

    EDIS;
}


void xMOTOR_Init()
{

	xMOTOR_CLA.sPwmMod.PeriodMax = (Uint16) ((float32) 0.5*((float32)Frequenza_DSP/Frequenza_PWM)*1000);
	xMOTOR_CLA.sPwmMod.u16DoublePeriod = (xMOTOR_CLA.sPwmMod.PeriodMax) << 1;
	xMOTOR_CLA.sPwmMod.u16HalfPeriod = (xMOTOR_CLA.sPwmMod.PeriodMax) >> 1;

	//Inizializzazione PWM
	xMOTOR.PWM_1 = &PWM_MOTORE_PHASE_A;
	xMOTOR.PWM_2 = &PWM_MOTORE_PHASE_B;
	xMOTOR.PWM_3 = &PWM_MOTORE_PHASE_C;

	xMOTOR_CLA.PWM_1.ptr = &PWM_MOTORE_PHASE_A;
	xMOTOR_CLA.PWM_2.ptr = &PWM_MOTORE_PHASE_B;
	xMOTOR_CLA.PWM_3.ptr = &PWM_MOTORE_PHASE_C;

	xMOTOR_PWMInit(xMOTOR.PWM_1);
	xMOTOR_PWMInit(xMOTOR.PWM_2);
	xMOTOR_PWMInit(xMOTOR.PWM_3);

    (xMOTOR.PWM_1)->TBCTL.bit.SYNCOSEL = 0;		// Settato come Master
    (xMOTOR.PWM_2)->TBCTL.bit.SYNCOSEL = 0;		// Settato come Slave
    (xMOTOR.PWM_3)->TBCTL.bit.SYNCOSEL = 0;		// Settato come Slave

	(xMOTOR.PWM_1)->TBCTL.bit.PHSEN = 1;		// Settato come Master
    (xMOTOR.PWM_2)->TBCTL.bit.PHSEN = 1;		// Settato come Slave
    (xMOTOR.PWM_3)->TBCTL.bit.PHSEN = 1;		// Settato come Slave

	// Interrupt di Servizio (5kHz)
    (xMOTOR.PWM_2)->ETSEL.bit.INTEN = 1;   // Enable EPWM1INT generation
    (xMOTOR.PWM_2)->ETSEL.bit.INTSEL = 1;  // Enable interrupt CNT_zero event
    (xMOTOR.PWM_2)->ETPS.bit.INTPSSEL = 1;   // Generate interrupt on the 1st event
    (xMOTOR.PWM_2)->ETINTPS.bit.INTPRD2 = Frequenza_PWM / Frequenza_Serv_Int;
    (xMOTOR.PWM_2)->ETCLR.bit.INT = 1;     // Enable more interrupts


	// Interrupt Principale (10 kHz)
    (xMOTOR.PWM_1)->ETSEL.bit.INTEN = 1;   // Enable EPWM1INT generation
    (xMOTOR.PWM_1)->ETSEL.bit.INTSEL = 1;  // Enable interrupt CNT_zero event
    (xMOTOR.PWM_1)->ETPS.bit.INTPSSEL = 1;   // Generate interrupt on the 1st event
    (xMOTOR.PWM_1)->ETINTPS.bit.INTPRD2 = Frequenza_PWM / Frequenza_Main_Int;
    (xMOTOR.PWM_1)->ETCLR.bit.INT = 1;     // Enable more interrupts


    // Uscita PWM Genera Interrupt AD gestito dalla CLA (20kHz)
    (xMOTOR.PWM_1)->ETSEL.bit.SOCAEN = 1;
    (xMOTOR.PWM_1)->ETSEL.bit.SOCASEL = 1;		// generate SOC event on timer reload: \/ when low mosfet are ON.
    (xMOTOR.PWM_1)->ETPS.bit.SOCACNT = 1;
    (xMOTOR.PWM_1)->ETPS.bit.SOCAPRD = 1;

}
