//------------------------------------------------------------------------
//
//  Project		:	Ultra-feeder
//  Target		:	F2808
//------------------------------------------------------------------------
//  Filename	:	I2T.h
//  Author 		:	A. G.
//  Date		:	20.04.2002
//------------------------------------------------------------------------
//  History		: 	20.04.2002 - Creation
//
//------------------------------------------------------------------------
//  Description:
//				
//
//------------------------------------------------------------------------
//	A.G:
//
//	File revision:	$revision
//	Project Label:	$label
//
//------------------------------------------------------------------------

/* ------------------------ Local defines ----------------------------- */
#define SYSCLK_C

/* ------------------- Standard header include ------------------------ */

																											
/* -------------------- Custom header include ------------------------- */
#include "Variabili.h"


/* -------------------------- Prototypes ------------------------------ */
void					TimerStop(STimer *t);


/* ----------------------- LOCAL VARIABLES ---------------------------- */

/* ----------------------- GLOBAL VARIABLES --------------------------- */
#pragma DATA_SECTION(SysTime,"CLADataLS0");
int32			            SysTime=0;


/*----------------------------------------------------------------------*/
/*------------------------------ CODE ----------------------------------*/


/*--------------------------------------*/
/* Init and start						*/
/* maximum allowable delay is:			*/
/* 2^15 / (SysTime increments in the	*/
/* selected time unit)					*/
/*--------------------------------------*/
int		TimerInit(STimer *t, int32 limit)
{	
	
	t->value 	= SysTime;
	t->limit	= limit;
	t->state	= TIMER_STATE_COUNTING;
	return true;
}


/*--------------------------------------*/
/* Stop the timer						*/
/*--------------------------------------*/
void	TimerStop(STimer *t)
{	
	
	t->value 	= 0;
	t->limit	= 0;
	t->state	= TIMER_STATE_IDLE;
	
}



/*--------------------------------------*/
/* test 								*/
/*--------------------------------------*/
int		TimerIsWaiting(STimer *t)
{	
	int	    delta;
	
	
	if ( t->state == TIMER_STATE_COUNTING)
	{
		delta = (int)( SysTime - (t->value) );
	      	
		if ( t->limit != 0 )
	    {
			if ( delta >= t->limit )
			{          
				t->limit = 0;
				t->state = TIMER_STATE_END;
				return false;
			}
			else
			{
				return true;
			}
		}
		else
		{
			return false;
		}
	}
	else
		return false;
		
}



/*--------------------------------------*/
/* test if expired						*/
/*--------------------------------------*/
int		TimerIsElapsed(STimer *t)
{
	if (TimerIsWaiting(t))
		return false;
	else if ( t->state == TIMER_STATE_END )
		return true;
	else
		return false;
}		


/*--------------------------------------*/
/* Init and start						*/
/*--------------------------------------*/
int		LongTimerInit(LongSTimer *t, unsigned int SecLimit, unsigned int MsecLimit)
{	
	
	if (MsecLimit != 0)
	{
	    t->ElapsedSeconds = SecLimit;
	    (void)TimerInit( &(t->SecTimer), (int)MsecLimit);
	    t->state	= TIMER_STATE_COUNTING;
	}
	else
	{
	    t->ElapsedSeconds = SecLimit - 1;
	    (void)TimerInit( &(t->SecTimer), iTIME(1000));
	    t->state	= TIMER_STATE_COUNTING;
	}
	return true;
}


/*--------------------------------------*/
/* Stop the timer						*/
/*--------------------------------------*/
void	LongTimerStop(LongSTimer *t)
{	
    (void)TimerStop( &(t->SecTimer) );
	t->ElapsedSeconds 	= 0;
	t->state	        = TIMER_STATE_IDLE;
}



/*--------------------------------------*/
/* test if expired						*/
/*--------------------------------------*/
int		LongTimerIsWaiting(LongSTimer *t)
{
	if ( t->state == TIMER_STATE_COUNTING)
	{
	    
	    if ( !(TimerIsWaiting(&(t->SecTimer))) )
	    {
            if (t->ElapsedSeconds)
            {
                t->ElapsedSeconds--;
                (void)TimerInit( &(t->SecTimer), iTIME(1000));
                return true;
            }
            else
            {
                // finished
                t->state = TIMER_STATE_END;
                (void)TimerStop( &(t->SecTimer) );
                return false;
            }
        }
        else
		    return true;
	}
	else
		return false;
}



/*--------------------------------------*/
/* test 								*/
/*--------------------------------------*/
int		LongTimerIsElapsed(LongSTimer *t)
{
	if (LongTimerIsWaiting(t))
		return false;
	else if ( t->state == TIMER_STATE_END )
		return true;
	else
		return false;
}		

/*----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*/
