//###########################################################################
//
// FILE:   blinky_cpu01.c
//
// TITLE:  LED Blink Example for F2837xS.
//
//! \addtogroup cpu01_example_list
//! <h1> Blinky </h1>
//!
//! This example blinks LED X
//!
//! \note If using a Launchpad, use the Launchpad build configurations.
//!
//
//###########################################################################
// $TI Release: F2837xS Support Library v210 $
// $Release Date: Tue Nov  1 15:35:23 CDT 2016 $
// $Copyright: Copyright (C) 2014-2016 Texas Instruments Incorporated -
//             <a href="http://www.ti.com/">http://www.ti.com/</a> ALL RIGHTS RESERVED $
//###########################################################################

//
// Included Files
//
#include "F28x_Project.h"

//
// Defines
//
#define _LAUNCHXL_F28377S 1

#ifdef _LAUNCHXL_F28377S
#define BLINKY_LED_RED_GPIO    12
#define BLINKY_LED_BLUE_GPIO    13
#else
#define BLINKY_LED_RED_GPIO    31
#define BLINKY_LED_BLUE_GPIO    12
#endif

volatile Uint16 test_LED_global = 0;
volatile Uint16 on = 0;
Uint16 last_on = 0;

void main(void)
{

//
// Step 1. Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the F2837xS_SysCtrl.c file.
//
    InitSysCtrl();

//
// Step 2. Initialize GPIO:
// This example function is found in the F2837xS_Gpio.c file and
// illustrates how to set the GPIO to it's default state.
//
    InitGpio();
    GPIO_SetupPinMux(BLINKY_LED_BLUE_GPIO, GPIO_MUX_CPU1, 0);
    GPIO_SetupPinMux(BLINKY_LED_RED_GPIO, GPIO_MUX_CPU1, 0);
    GPIO_SetupPinOptions(BLINKY_LED_BLUE_GPIO, GPIO_OUTPUT, GPIO_PUSHPULL);
    GPIO_SetupPinOptions(BLINKY_LED_RED_GPIO, GPIO_OUTPUT, GPIO_PUSHPULL);

//
// Step 3. Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts
//
    DINT;

//
// Initialize the PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.
// This function is found in the F2837xS_PieCtrl.c file.
//
    InitPieCtrl();

//
// Disable CPU interrupts and clear all CPU interrupt flags:
//
    IER = 0x0000;
    IFR = 0x0000;

//
// Initialize the PIE vector table with pointers to the shell Interrupt
// Service Routines (ISR).
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in F2837xS_DefaultIsr.c.
// This function is found in F2837xS_PieVect.c.
//
    InitPieVectTable();

//
// Enable global Interrupts and higher priority real-time debug events:
//
    EINT;  // Enable Global interrupt INTM
    ERTM;  // Enable Global realtime interrupt DBGM

// initialize the Blue LED state to reflect the initial value of 'on'
    GPIO_WritePin(BLINKY_LED_BLUE_GPIO, (1 & !on) );

//
// Step 6. IDLE loop. Just sit and loop forever (optional):
//
    for(;;)
    {
        //
        // Turn on LED
        //

        if(test_LED_global || on != last_on) {
            if(test_LED_global) {
                on = (on+1) % 2;
            }

            last_on = on;
            GPIO_WritePin(BLINKY_LED_BLUE_GPIO, (1 & !on) );
            DELAY_US(1000*500);
        }

        //


        //
        // Delay for a bit.
        //
        DELAY_US(1000*500);

    }
}

//
// End of file
//
