/*-------------------------------------------------------------------------
--
--                         LEGAL  NOTICE
--
--                   CODE  IS  PROPRIETARY  TO
--
--                   Ultra Electronics
--                   Undersea Sensor Systems, Inc (USSI)
--                   4578 East Park 30 Drive
--                   Columbia City, IN 46725-8869
--
-- All usage of this code is restricted to USSI Data Processing and
-- installations.  Any use, disclosure, or reproduction of this code for
-- any purpose is prohibited unless written consent is obtained from an
-- officer of the USSI Company.
--
-- Export of this technical data is prohibited by US law, under the
-- International Traffic in Arms (ITAR) Part 125, without prior approval
-- from the department of the US Department of State.
--
--                         LEGAL  NOTICE
---------------------------------------------------------------------------
***********************************************************************//**
*
*  @file          ami_system_cfg.h
*
*  @brief         Main System Configuration Header file.
*
*        This header file has no "C" body file associated with it. This file
*        is intended to establish the main system level configuration
*        settings for the project.
*
*  @author                    Russ Heibel
*
*  Organization:              USSI
*  Project:                   Royale III
*  Creation Date:             September 21, 2016
*  Language:                  "C"
*  Development Environment:   Code Composer 6.x
*  Host Environment:          Microsoft Professional
*  Indent Setting:            3 spaces
*
**************************************************************************/
#ifndef AMI_SYSTEM_CFG_H_
#define AMI_SYSTEM_CFG_H_

/*** Include Files *******************************************************/

/*** Public Constants ****************************************************/

/** Name of program/project so that boot loader can be matched to application image */
#define PROJECT_NAME "GXM350"

/** Whether the application image should be linked at a different address because a 
 * custom boot loader is being used.
 * See boot_loader_config.h for details on how to configure the custom boot loader itself.
 */
#define CUSTOM_BOOT_LOADER_ENABLED  1

/* Enable task profiling.  See fcos.c */
#define FCOS_TASK_PROFILER_ENABLED  1

/* Enable stack monitoring.  See stackmon.c */
#define STACKMON_ENABLED            1

/* Allow the code to be built in SPI Slave mode for testing. 
 * See tiny_spi_protocol.c
 */
#define SPI_SLAVE_MODE_ENABLED      0


/* Flow Monitoring Sensor is present and uses LIN */
#define LIN_ENABLED                 1
#define FMS_ENABLED                 1

/* No CSI Driver */
#define CSI_ENABLED                 0
#define CSI_APU_ENABLED             1

/* Set to 1 if there is an RTC Chip present in this system. */
#define RTC_PRESENT                 0
#define RTC_TIME_MODE               12

/* Set to 1 if there is an EEPROM Chip present in this system. */
#define EEPROM_PRESENT              0

/* Set to 1 if there is an NVM strategy present in this system. */
#define NVM_ENABLED                 0

/* Set to 1 if there is a Hybrid Battery present in this system. */
#define HBATT_PRESENT               0

/* Set to 1 if there is an LCD device in the system. */
#define LCD_PRESENT                 0

/*
 * Define the desired hardware configuration AMIHW_TARGET
 */
//#define AMIHW_TARGET                AMIHW_TARGET_LM3S9B92_EVB
//#define AMIHW_TARGET                AMIHW_TARGET_LM3S2B93_PRODUCTION
//#define AMIHW_TARGET                AMIHW_TARGET_TM4C129
#define AMIHW_TARGET                AMIHW_TARGET_TM4C1290_ALTEX

/* Royale II Keep Alive Pin is PB1 */
#if (AMIHW_TARGET == AMIHW_TARGET_LM3S2B93_PRODUCTION)
   /** Port for the keep-alive digital I/O pin.  Use GPIO_PORTx_BASE.
    * Just don't define these symbols if you want the custom boot loader to not touch an I/O pin.
    */
   #define BOOT_LOADER_ALIVE_GPIO_PERIPH  SYSCTL_PERIPH_GPIOB
   #define BOOT_LOADER_ALIVE_GPIO_PORT    GPIO_PORTB_BASE

   /** Bit mask for the keep-alive digital I/O pin.  Use GPIO_PIN_n. */
   #define BOOT_LOADER_ALIVE_GPIO_MASK    GPIO_PIN_1

   /** Pin level for the keep-alive digital I/O pin to stay alive. Use 0 or 1. */
   #define BOOT_LOADER_ALIVE_GPIO_LEVEL   1 // level to stay alive
#elif ( (AMIHW_TARGET == AMIHW_TARGET_TM4C129) || (AMIHW_TARGET == AMIHW_TARGET_TM4C1290_ALTEX) )
   /* No keep-alive discrete on the Royale III and the Fuel Reformer (ALTEX) platforms. */
#endif

/* Determine which configuration to use for
 * talking with the Piccolo controller. 
 */
#define PICCOLO_DCDC_COMM_TYPE_SPI 1
#define PICCOLO_DCDC_COMM_TYPE_I2C 2

#define PICCOLO_DCDC_COMM_TYPE     0

/* Diag UART configuration */
#define DIAG_UART_BAUD_RATE   115200
#define DIAG_UART_CONFIG      (UART_CONFIG_PAR_NONE | UART_CONFIG_STOP_ONE | UART_CONFIG_WLEN_8)
#define CSI_UART_BAUD_RATE    9600
#define CSI_UART_CONFIG       (UART_CONFIG_PAR_NONE | UART_CONFIG_STOP_ONE | UART_CONFIG_WLEN_8)
/*
 * 
 * This is the memory map used by the linker
 * 
 */
#if CUSTOM_BOOT_LOADER_ENABLED > 0
    /** Where the custom boot loader will reside in flash memory. */
    #define BOOT_LOADER_BASE  0x00000
    #define BOOT_LOADER_SIZE  0x04000 // size in bytes
    /** Where the application will reside in flash memory. */
    #define APP_BASE          0x04000
#else
    /** Where the application will reside in flash memory. */
    #define APP_BASE          0x00000
#endif

// TBD RSH 9/19/16 Tiva Flash is 1MB
#define APP_SIZE              0x60000 // size in bytes


/** What range of memory will be used for saving calibration data. 
 * This is used by the code saving calibrations, and also by the linker
 * to reserve the memory so that when the application code overflows,
 * then a linker error message is generated.
 */
// TBD RSH 9/19/16 #define CALIBRATIONS_BASE 0x32000
// TBD RSH 9/19/16 #define CALIBRATIONS_SIZE 0x0A000 // size in bytes
#define CALIBRATIONS_BASE     0x70000
#define CALIBRATIONS_SIZE     0x10000 // size in bytes

/** Where flash memory ends.  This is used so that the linker will give an error when we overflow. */
// TBD RSH 9/19/16 #define END_OF_FLASH_MEMORY 0x40000
#define END_OF_FLASH_MEMORY   0x80000


/* Set up UART assignment based on the target hardware */
#if (AMIHW_TARGET == AMIHW_TARGET_LM3S9B92_EVB)
    #define DIAG_UART             0
#elif (AMIHW_TARGET == AMIHW_TARGET_LM3S2B93_PRODUCTION)
   #define DIAG_UART             2
   #define CSI_UART              1
   #define LIN_UART              0
#elif (AMIHW_TARGET == AMIHW_TARGET_TM4C129)
    #define LIN_UART             0 //Really port 0 and it is the first index in the uartstdio array
    #define DIAG_UART            1 //Really port 4 but it is the second index in the uartstdio array
    #define CSI_UART             2 //Really port 5 but it is the third index in the uartstdio array
#elif (AMIHW_TARGET == AMIHW_TARGET_TM4C1290_ALTEX)
    #define LIN_UART             0 //Really port 0 and it is the first index in the uartstdio array
    #define DIAG_UART            1 //Really port 4 but it is the second index in the uartstdio array
    #define CSI_UART             2 //Really port 5 but it is the third index in the uartstdio array
#else
    #error "Undefined hardware build.  Please define AMIHW_TARGET to a known value."
#endif

/* Tell the user how to upgrade to the new way of doing things. */
#ifdef PART_LM3S9B92
    #error "PART_LM3S9B92 isn't necessary any more.  You can define PART_LM3S2B93 for both the EVB and the production hardware."
#endif

/* Validate the AMIHW setting ---------------------------------------------- */
#if   (AMIHW_TARGET == AMIHW_TARGET_LM3S9B92_EVB)
#elif (AMIHW_TARGET == AMIHW_TARGET_LM3S2B93_PRODUCTION)
#elif (AMIHW_TARGET == AMIHW_TARGET_TM4C129)
#elif (AMIHW_TARGET == AMIHW_TARGET_TM4C1290_ALTEX)
#else
   /* When adding new microcontroller chips, you need to examine the pin_map.h definitions
    * being used and make sure that they match the old microcontrollers being supported.
    * It may be necessary to define PART_LM3S9B92 style symbols when supporting
    * a new microcontroller.
    */
    #error "Undefined hardware build.  Please define AMIHW_TARGET to a known value."
#endif



/*** Public Typedefs *****************************************************/


/*** Public Function Prototypes ******************************************/


/*** Public Global Variables *********************************************/

#if defined(_C_TEMPLATE_C_) || defined(_DOXYGEN_)

#else
/*** Extern Public Global Variables **************************************/

#endif /* "#endif" for "#if defined(_C_TEMPLATE_C_) || defined(_DOXYGEN_)" */

#endif /* "#endif" for "#ifndef AMI_SYSTEM_CFG_H_" */

