
MEMORY
{
PAGE 0 :
 

   BEGIN            		: origin = 0x082000, length = 0x000002
   RAMM0           			: origin = 0x0000F5, length = 0x00030B
   RAMLS0_2        			: origin = 0x008000, length = 0x001800
   //RAMLS1          			: origin = 0x008800, length = 0x000800
   //RAMLS2      				: origin = 0x009000, length = 0x000800
   RAMLS3      				: origin = 0x009800, length = 0x000800
   RAMLS4      				: origin = 0x00A000, length = 0x000800
   RESET           			: origin = 0x3FFFC0, length = 0x000002

   BOOTLOADERVERSION	    : origin = 0x081FFF, length = 0x000001	
   FLASH_BANK0_SEC2  		: origin = 0x082002, length = 0x000FFE	
   FLASH_BANK0_SEC3  		: origin = 0x083000, length = 0x001000	
   FLASH_BANK0_SEC4  		: origin = 0x084000, length = 0x001000	
   FLASH_BANK0_SEC5  		: origin = 0x085000, length = 0x001000	
   FLASH_BANK0_SEC6  		: origin = 0x086000, length = 0x001000	
   FLASH_BANK0_SEC7  		: origin = 0x087000, length = 0x001000	
   FLASH_BANK0_SEC8  		: origin = 0x088000, length = 0x001000	
   FLASH_BANK0_SEC9  		: origin = 0x089000, length = 0x001000	
   FLASH_BANK0_SEC10 		: origin = 0x08A000, length = 0x001000	
   FLASH_BANK0_SEC11 		: origin = 0x08B000, length = 0x001000	
   FLASH_BANK0_SEC12 		: origin = 0x08C000, length = 0x001000	
   FLASH_BANK0_SEC13 		: origin = 0x08D000, length = 0x001000	
   FLASH_BANK0_SEC14_15 		: origin = 0x08E000, length = 0x002000	
   

   /* BANK 1 */
   PARAMETERS_0		  		: origin = 0x090000, length = 0x001000	
   FLASH_BANK1_SEC1  		: origin = 0x091000, length = 0x001000	
   FLASH_BANK1_SEC2  		: origin = 0x092000, length = 0x001000	
   FLASH_BANK1_SEC3  		: origin = 0x093000, length = 0x001000	
   FLASH_BANK1_SEC4  		: origin = 0x094000, length = 0x001000	
   FLASH_BANK1_SEC5  		: origin = 0x095000, length = 0x001000	
   FLASH_BANK1_SEC6  		: origin = 0x096000, length = 0x001000	
   FLASH_BANK1_SEC7  		: origin = 0x097000, length = 0x001000	
   FLASH_BANK1_SEC8  		: origin = 0x098000, length = 0x001000	
   FLASH_BANK1_SEC9  		: origin = 0x099000, length = 0x001000	
   FLASH_BANK1_SEC10 		: origin = 0x09A000, length = 0x001000	
   FLASH_BANK1_SEC11 		: origin = 0x09B000, length = 0x001000	
   FLASH_BANK1_SEC12 		: origin = 0x09C000, length = 0x001000	
   FLASH_BANK1_SEC13 		: origin = 0x09D000, length = 0x001000	
   FLASH_BANK1_SEC14 		: origin = 0x09E000, length = 0x001000	
   FLASH_BANK1_SEC15 		: origin = 0x09F000, length = 0x000FC0	
   CRC_RSVD			 		: origin = 0x09FFC0, length = 0x000040 

   CHECK                    : origin = 0x100000, length = 0x000010
PAGE 1 :

   BOOT_RSVD        		: origin = 0x000002, length = 0x0000F3     
   RAMM1_AUX_STACK  		: origin = 0x000200, length = 0x000200     
   RAMM1_UNDERFLOW  		: origin = 0x000400, length = 0x0000FC     
   RAMM1_UNDERFLOW_STAMP  	: origin = 0x0004FC, length = 0x000004     
   RAMM1            		: origin = 0x000500, length = 0x000200     
   RAMM1_OVERFLOW   		: origin = 0x000700, length = 0x000100     

   //RAMLS1           		: origin = 0x008800, length = 0x000800

   RAMLS2           		: origin = 0x009000, length = 0x000800
   RAMLS3      				: origin = 0x009800, length = 0x000800
   RAMLS5           		: origin = 0x00A800, length = 0x000800
   RAMLS6           		: origin = 0x00B000, length = 0x000800
   RAMLS7      				: origin = 0x00B800, length = 0x000800

   RAMGS0      				: origin = 0x00C000, length = 0x002000
   RAMGS1     	 			: origin = 0x00E000, length = 0x002000
   RAMGS2      				: origin = 0x010000, length = 0x002000
   RAMGS3      				: origin = 0x012000, length = 0x002000

   CLA1_MSGRAMLOW   		: origin = 0x001480, length = 0x000080
   CLA1_MSGRAMHIGH  		: origin = 0x001500, length = 0x000080

}


SECTIONS
{
   codestart        		: > BEGIN,     PAGE = 0, ALIGN(4)
   .text            		: >> FLASH_BANK0_SEC2 | FLASH_BANK0_SEC3 | FLASH_BANK0_SEC4 | FLASH_BANK0_SEC5 | FLASH_BANK0_SEC6 | FLASH_BANK0_SEC7 | FLASH_BANK0_SEC8 | FLASH_BANK0_SEC9 | FLASH_BANK0_SEC10,   PAGE = 0, ALIGN(4)
   .cinit           		: > FLASH_BANK0_SEC2,     PAGE = 0, ALIGN(4)
   .pinit           		: > FLASH_BANK0_SEC2,     PAGE = 0, ALIGN(4)
   .switch          		: > FLASH_BANK0_SEC2,     PAGE = 0, ALIGN(4)
   .reset           		: > RESET,     PAGE = 0, TYPE = DSECT /* not used, */

   .cio             		: > RAMLS4,    PAGE = 0
   .stack           		: > RAMM1,     PAGE = 1
   .stackBackup        		: > RAMM1_AUX_STACK,     PAGE = 1
   .ebss            		: >> RAMLS5|RAMLS6,    PAGE = 1
   .esysmem         		: > RAMLS5,    PAGE = 1
   .econst          		: >> FLASH_BANK0_SEC11 | FLASH_BANK0_SEC12,    PAGE = 0, ALIGN(4)

   ramgs0           		: > RAMGS0,    PAGE = 1
   ramgs1           		: > RAMGS1,    PAGE = 1

   boot_loader_version		:> BOOTLOADERVERSION,    PAGE = 0


   .TI.ramfunc      		: LOAD = FLASH_BANK0_SEC2,
                         	  RUN = RAMLS4,
                         	  LOAD_START(_RamfuncsLoadStart),
                         	  LOAD_SIZE(_RamfuncsLoadSize),
                         	  LOAD_END(_RamfuncsLoadEnd),
                         	  RUN_START(_RamfuncsRunStart),
                         	  RUN_SIZE(_RamfuncsRunSize),
                         	  RUN_END(_RamfuncsRunEnd),
                         	  PAGE = 0, ALIGN(4)

   /* CLA specific sections */
    Cla1Prog        		: LOAD = FLASH_BANK0_SEC14_15,
                      		  RUN = RAMLS0_2,
                      		  LOAD_START(_Cla1ProgLoadStart),
                      		  RUN_START(_Cla1ProgRunStart),
                      		  LOAD_SIZE(_Cla1ProgLoadSize),
                      		  LOAD_END(_Cla1ProgLoadEnd),
                      		  PAGE = 0, ALIGN(4)


    Cla1ToCpuMsgRAM  		: > CLA1_MSGRAMLOW,   PAGE = 1
    CpuToCla1MsgRAM  		: > CLA1_MSGRAMHIGH,  PAGE = 1

   .scratchpad      		: > RAMLS3,           PAGE = 1
   .bss_cla         		: > RAMLS3,           PAGE = 1

   Cla1DataRam      		: > RAMLS3,           PAGE = 1

   .const_cla       		: LOAD = FLASH_BANK0_SEC13,
                       		  RUN = RAMLS3,
                       		  RUN_START(_Cla1ConstRunStart),
                       		  LOAD_START(_Cla1ConstLoadStart),
                       		  LOAD_SIZE(_Cla1ConstLoadSize),
                       		  LOAD_END(_Cla1ConstLoadEnd),
                       		  PAGE = 0

    CrcExpectedValues 		: > CRC_RSVD,			PAGE = 0
    RamBackupReg		 		: > RAMGS3,			PAGE = 1
    AdcBuffer		 		: > RAMGS2,			PAGE = 1


    UnderFlowStamp			: > RAMM1_UNDERFLOW_STAMP
    OverFlowStamp			: > RAMM1_OVERFLOW
	
	Parameters_0			: > PARAMETERS_0,	PAGE = 0
		checkfile               : > CHECK,          PAGE = 0
}


