/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: HERIC_INV_sine_pwm.c
 *
 * Code generated for Simulink model 'HERIC_INV_sine_pwm'.
 *
 * Model version                  : 1.4
 * Simulink Coder version         : 8.9 (R2015b) 13-Aug-2015
 * C/C++ source code generated on : Fri Jun 16 15:14:51 2017
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Texas Instruments->C2000
 * Code generation objectives:
 *    1. Execution efficiency
 *    2. RAM efficiency
 * Validation result: Not run
 */

#include "HERIC_INV_sine_pwm.h"

/* Private macros used by the generated code to access rtModel */
#ifndef rtmIsMajorTimeStep
# define rtmIsMajorTimeStep(rtm)       (((rtm)->Timing.simTimeStep) == MAJOR_TIME_STEP)
#endif

#ifndef rtmIsMinorTimeStep
# define rtmIsMinorTimeStep(rtm)       (((rtm)->Timing.simTimeStep) == MINOR_TIME_STEP)
#endif

#ifndef rtmGetTPtr
# define rtmGetTPtr(rtm)               ((rtm)->Timing.t)
#endif

#ifndef rtmSetTPtr
# define rtmSetTPtr(rtm, val)          ((rtm)->Timing.t = (val))
#endif

/* Block signals and states (auto storage) */
DW rtDW;

/* Real-time model */
RT_MODEL rtM_;
RT_MODEL *const rtM = &rtM_;
extern real_T look1_binlx(real_T u0, const real_T bp0[], const real_T table[],
  uint32_T maxIndex);
real_T look1_binlx(real_T u0, const real_T bp0[], const real_T table[], uint32_T
                   maxIndex)
{
  real_T frac;
  uint32_T iRght;
  uint32_T iLeft;
  uint32_T bpIdx;

  /* Lookup 1-D
     Search method: 'binary'
     Use previous index: 'off'
     Interpolation method: 'Linear'
     Extrapolation method: 'Linear'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
   */
  /* Prelookup - Index and Fraction
     Index Search method: 'binary'
     Extrapolation method: 'Linear'
     Use previous index: 'off'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
   */
  if (u0 <= bp0[0UL]) {
    iLeft = 0UL;
    frac = (u0 - bp0[0UL]) / (bp0[1UL] - bp0[0UL]);
  } else if (u0 < bp0[maxIndex]) {
    /* Binary Search */
    bpIdx = maxIndex >> 1UL;
    iLeft = 0UL;
    iRght = maxIndex;
    while (iRght - iLeft > 1UL) {
      if (u0 < bp0[bpIdx]) {
        iRght = bpIdx;
      } else {
        iLeft = bpIdx;
      }

      bpIdx = (iRght + iLeft) >> 1UL;
    }

    frac = (u0 - bp0[iLeft]) / (bp0[iLeft + 1UL] - bp0[iLeft]);
  } else {
    iLeft = maxIndex - 1UL;
    frac = (u0 - bp0[maxIndex - 1UL]) / (bp0[maxIndex] - bp0[maxIndex - 1UL]);
  }

  /* Interpolation 1-D
     Interpolation method: 'Linear'
     Use last breakpoint for index at or above upper limit: 'off'
     Overflow mode: 'wrapping'
   */
  return (table[iLeft + 1UL] - table[iLeft]) * frac + table[iLeft];
}

/* Model step function */
void HERIC_INV_sine_pwm_step(void)
{
  /* local block i/o variables */
  real_T rtb_LookUpTable1;
  real_T rtb_SineWave1;

  /* Sin: '<Root>/Sine Wave' */
  rtb_SineWave1 = sin(314.0 * rtM->Timing.t[0]) * 0.8;

  /* Clock: '<S1>/Clock' */
  rtb_LookUpTable1 = rtM->Timing.t[0];

  /* Sum: '<S1>/Sum' incorporates:
   *  S-Function (sfun_tstart): '<S1>/startTime'
   */
  rtb_LookUpTable1 -= (0.0);

  /* Math: '<S1>/Math Function' incorporates:
   *  Constant: '<S1>/Constant'
   */
  rtb_LookUpTable1 = fmod(rtb_LookUpTable1, 0.0001);

  /* Lookup_n-D: '<S1>/Look-Up Table1' */
  rtb_LookUpTable1 = look1_binlx(rtb_LookUpTable1,
    rtConstP.LookUpTable1_bp01Data, rtConstP.LookUpTable1_tableData, 2UL);

  /* RelationalOperator: '<Root>/Relational Operator' */
  rtDW.RelationalOperator = (rtb_SineWave1 >= rtb_LookUpTable1);

  /* S-Function (c280xgpio_do): '<Root>/Digital Output' */
  {
    GpioDataRegs.GPASET.bit.GPIO2 = (rtDW.RelationalOperator != 0);
    GpioDataRegs.GPACLEAR.bit.GPIO2 = !(rtDW.RelationalOperator != 0);
  }

  /* RelationalOperator: '<Root>/Relational Operator1' */
  rtDW.RelationalOperator2 = (rtb_SineWave1 <= rtb_LookUpTable1);

  /* S-Function (c280xgpio_do): '<Root>/Digital Output1' */
  {
    GpioDataRegs.GPASET.bit.GPIO4 = (rtDW.RelationalOperator2 != 0);
    GpioDataRegs.GPACLEAR.bit.GPIO4 = !(rtDW.RelationalOperator2 != 0);
  }

  /* Sin: '<Root>/Sine Wave1' */
  rtb_SineWave1 = sin(314.0 * rtM->Timing.t[0]) * -0.8;

  /* RelationalOperator: '<Root>/Relational Operator2' */
  rtDW.RelationalOperator2 = (rtb_SineWave1 >= rtb_LookUpTable1);

  /* S-Function (c280xgpio_do): '<Root>/Digital Output2' */
  {
    GpioDataRegs.GPASET.bit.GPIO6 = (rtDW.RelationalOperator2 != 0);
    GpioDataRegs.GPACLEAR.bit.GPIO6 = !(rtDW.RelationalOperator2 != 0);
  }

  /* RelationalOperator: '<Root>/Relational Operator3' */
  rtDW.RelationalOperator3 = (rtb_SineWave1 <= rtb_LookUpTable1);

  /* S-Function (c280xgpio_do): '<Root>/Digital Output3' */
  {
    GpioDataRegs.GPASET.bit.GPIO10 = (rtDW.RelationalOperator3 != 0);
    GpioDataRegs.GPACLEAR.bit.GPIO10 = !(rtDW.RelationalOperator3 != 0);
  }

  /* S-Function (c280xgpio_do): '<Root>/Digital Output4' */
  {
    GpioDataRegs.GPASET.bit.GPIO0 = (rtDW.RelationalOperator != 0);
    GpioDataRegs.GPACLEAR.bit.GPIO0 = !(rtDW.RelationalOperator != 0);
  }

  /* S-Function (c280xgpio_do): '<Root>/Digital Output5' */
  {
    GpioDataRegs.GPASET.bit.GPIO8 = (rtDW.RelationalOperator2 != 0);
    GpioDataRegs.GPACLEAR.bit.GPIO8 = !(rtDW.RelationalOperator2 != 0);
  }

  /* Update absolute time for base rate */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   * Timer of this task consists of two 32 bit unsigned integers.
   * The two integers represent the low bits Timing.clockTick0 and the high bits
   * Timing.clockTickH0. When the low bit overflows to 0, the high bits increment.
   */
  if (!(++rtM->Timing.clockTick0)) {
    ++rtM->Timing.clockTickH0;
  }

  rtM->Timing.t[0] = rtM->Timing.clockTick0 * rtM->Timing.stepSize0 +
    rtM->Timing.clockTickH0 * rtM->Timing.stepSize0 * 4294967296.0;

  {
    /* Update absolute timer for sample time: [1.0E-5s, 0.0s] */
    /* The "clockTick1" counts the number of times the code of this task has
     * been executed. The resolution of this integer timer is 1.0E-5, which is the step size
     * of the task. Size of "clockTick1" ensures timer will not overflow during the
     * application lifespan selected.
     * Timer of this task consists of two 32 bit unsigned integers.
     * The two integers represent the low bits Timing.clockTick1 and the high bits
     * Timing.clockTickH1. When the low bit overflows to 0, the high bits increment.
     */
    rtM->Timing.clockTick1++;
    if (!rtM->Timing.clockTick1) {
      rtM->Timing.clockTickH1++;
    }
  }
}

/* Model initialize function */
void HERIC_INV_sine_pwm_initialize(void)
{
  /* Registration code */

  /* initialize real-time model */
  (void) memset((void *)rtM, 0,
                sizeof(RT_MODEL));

  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&rtM->solverInfo, &rtM->Timing.simTimeStep);
    rtsiSetTPtr(&rtM->solverInfo, &rtmGetTPtr(rtM));
    rtsiSetStepSizePtr(&rtM->solverInfo, &rtM->Timing.stepSize0);
    rtsiSetErrorStatusPtr(&rtM->solverInfo, (&rtmGetErrorStatus(rtM)));
    rtsiSetRTModelPtr(&rtM->solverInfo, rtM);
  }

  rtsiSetSimTimeStep(&rtM->solverInfo, MAJOR_TIME_STEP);
  rtsiSetSolverName(&rtM->solverInfo,"FixedStepDiscrete");
  rtmSetTPtr(rtM, &rtM->Timing.tArray[0]);
  rtM->Timing.stepSize0 = 1.0E-5;

  /* states (dwork) */
  (void) memset((void *) &rtDW, 0,
                sizeof(DW));

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output' */
  EALLOW;
  GpioCtrlRegs.GPAMUX1.all &= 0xFFFFFFCF;
  GpioCtrlRegs.GPADIR.all |= 0x4;
  EDIS;

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output1' */
  EALLOW;
  GpioCtrlRegs.GPAMUX1.all &= 0xFFFFFCFF;
  GpioCtrlRegs.GPADIR.all |= 0x10;
  EDIS;

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output2' */
  EALLOW;
  GpioCtrlRegs.GPAMUX1.all &= 0xFFFFCFFF;
  GpioCtrlRegs.GPADIR.all |= 0x40;
  EDIS;

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output3' */
  EALLOW;
  GpioCtrlRegs.GPAMUX1.all &= 0xFFCFFFFF;
  GpioCtrlRegs.GPADIR.all |= 0x400;
  EDIS;

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output4' */
  EALLOW;
  GpioCtrlRegs.GPAMUX1.all &= 0xFFFFFFFC;
  GpioCtrlRegs.GPADIR.all |= 0x1;
  EDIS;

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output5' */
  EALLOW;
  GpioCtrlRegs.GPAMUX1.all &= 0xFFFCFFFF;
  GpioCtrlRegs.GPADIR.all |= 0x100;
  EDIS;
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
