/*
//###########################################################################
// FILE:    28M35H52C1_RAM_lnk_m3.cmd
// TITLE:   Linker Command File for 28M35H52C1 examples that run out of RAM
//          This ONLY includes all SARAM blocks on the 28M35H52C1 device.
//          This does not include flash or OTP.
//          Keep in mind that C0 and C1 are protected by the code
//          security module.
//          What this means is in most cases you will want to move to
//          another memory map file which has more memory defined.
//###########################################################################
// $TI Release: F28M35x Support Library v207 $
// $Release Date: Mon Sep 21 16:49:54 CDT 2015 $
// $Copyright: Copyright (C) 2011-2015 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//###########################################################################
*/

--retain=g_pfnVectors

/* The following command line options are set as part of the CCS project.    */
/* If you are building using the command line, or for some reason want to    */
/* define them here, you can uncomment and modify these lines as needed.     */
/* If you are using CCS for building, it is probably better to make any such */
/* modifications in your CCS project and leave this file alone.              */
/*                                                                           */
/* --heap_size=0                                                             */
/* --stack_size=256                                                          */
/* --library=rtsv7M3_T_le_eabi.lib                                           */


/* System memory map */

MEMORY
{
    C0 (RWX)         : origin = 0x20000000, length = 0x2000
    C1 (RWX)         : origin = 0x20002000, length = 0x2000
    BOOT_RSVD (RX)   : origin = 0x20004000, length = 0x0900
    C2 (RWX)         : origin = 0x20004900, length = 0x06f8
    RESETISR (RWX)   : origin = 0x20004FF8, length = 0x0008
    INTVECS (RWX)    : origin = 0x20005000, length = 0x01B0
    C3 (RWX)         : origin = 0x20006000, length = 0x2000
    S0 (RWX)         : origin = 0x20008000, length = 0x2000
    S1 (RWX)         : origin = 0x2000A000, length = 0x2000
    S2 (RWX)         : origin = 0x2000C000, length = 0x2000
    S3 (RWX)         : origin = 0x2000E000, length = 0x2000
    S4 (RWX)         : origin = 0x20010000, length = 0x2000
    S5 (RWX)         : origin = 0x20012000, length = 0x2000
    S6 (RWX)         : origin = 0x20014000, length = 0x2000
    S7 (RWX)         : origin = 0x20016000, length = 0x2000
    CTOMRAM (RX)     : origin = 0x2007F000, length = 0x0800
    MTOCRAM (RWX)    : origin = 0x2007F800, length = 0x0800
	
	OTPSECLOCK       : origin = 0x00680800, length = 0x0004
    OTP_Reserved1    : origin = 0x00680804, length = 0x0004
    OTP_Reserved2    : origin = 0x00680808, length = 0x0004
    OTP_Z2_FLASH_START_ADDR             : origin = 0x0068080C, length = 0x0004
    OTP_EMACID       : origin = 0x00680810, length = 0x0008
    OTP_Reserved3    : origin = 0x00680818, length = 0x0004
    CUSTOMER_OTP_MAIN_OSC_CLK_FREQ      : origin = 0x0068081C, length = 0x0004
    OTP_Reserved4    : origin = 0x00680820, length = 0x0004
    OTP_BOOT_MODE_GPIO_CONFIGURE        : origin = 0x00680824, length = 0x0004
    OTP_Reserved5    : origin = 0x00680828, length = 0x0004
    OTP_ENTRY_POINT  : origin = 0x0068082C, length = 0x0004
    OTP_Reserved6    : origin = 0x00680830, length = 0x0010
}

/* Section allocation in memory */

SECTIONS
{
    .intvecs:   > INTVECS
    .resetisr:  > RESETISR
    .text   :   > C0
    .const  :   > C2
    .cinit  :   > C2
    .pinit  :   > C2

    .vtable :   > C1
    .data   :   > C1
    .bss    :   > C1
    .sysmem :   > C1
    .stack  :   > C1

#ifdef __TI_COMPILER_VERSION
   #if __TI_COMPILER_VERSION >= 15009000
    .TI.ramfunc : {} > C0 | C1
   #endif
#endif
    
    GROUP : > MTOCRAM
    {
        PUTBUFFER  
        PUTWRITEIDX
        GETREADIDX  
    }

    GROUP : > CTOMRAM 
    {
        GETBUFFER : TYPE = DSECT
        GETWRITEIDX : TYPE = DSECT
        PUTREADIDX : TYPE = DSECT
    }    
}





