/*****************************************************************************
 * File Name : cslr_emif_001.h 
 *
 * Brief	 : Define EMIF register structure
 *
 * Copyright (C) 2009 -2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
******************************************************************************/
#ifndef _CSLR__EMIF_1_H_
#define _CSLR__EMIF_1_H_

#include <cslr.h>

/* Minimum unit = 2 bytes */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint16 REV;
    volatile Uint16 STATUS;
    volatile Uint16 RSVD0[2];
    volatile Uint16 ASYNCCONFIG0;
    volatile Uint16 ASYNCCONFIG1;
    volatile Uint16 RSVD1[2];
    volatile Uint16 SDRAMCONFIG0;
    volatile Uint16 SDRAMCONFIG1;
    volatile Uint16 RSVD2[2];
    volatile Uint16 SDRCREFCTRL0;
    volatile Uint16 SDRCREFCTRL1;
    volatile Uint16 RSVD3[2];
    volatile Uint16 ASYNC1CTRL0;
    volatile Uint16 ASYNC1CTRL1;
    volatile Uint16 RSVD4[2];
    volatile Uint16 ASYNC2CTRL0;
    volatile Uint16 ASYNC2CTRL1;
    volatile Uint16 RSVD5[2];
    volatile Uint16 ASYNC3CTRL0;
    volatile Uint16 ASYNC3CTRL1;
    volatile Uint16 RSVD6[2];
    volatile Uint16 ASYNC4CTRL0;
    volatile Uint16 ASYNC4CTRL1;
    volatile Uint16 RSVD7[2];
    volatile Uint16 SDRAMTIMING0;
    volatile Uint16 SDRAMTIMING1;
    volatile Uint16 RSVD8[2];
    volatile Uint16 SDRAMSTAT;
    volatile Uint16 RSVD9[11];
    volatile Uint16 SDRACCESS0;
    volatile Uint16 SDRACCESS1;
    volatile Uint16 RSVD10[2];
    volatile Uint16 SDRACTIVATE0;
    volatile Uint16 SDRACTIVATE1;
    volatile Uint16 RSVD11[6];
    volatile Uint16 SDRCSRPD;
    volatile Uint16 RSVD12[3];
    volatile Uint16 INTRAW;
    volatile Uint16 RSVD13[3];
    volatile Uint16 INTMASK;
    volatile Uint16 RSVD14[3];
    volatile Uint16 INTMASKSET;
    volatile Uint16 RSVD15[3];
    volatile Uint16 INTMASKCLEAR;
    volatile Uint16 RSVD16[3];
    volatile Uint16 IOCTRL;
    volatile Uint16 RSVD17[3];
    volatile Uint16 IOSTATUS;
    volatile Uint16 RSVD18[11];
    volatile Uint16 NANDCTRL;
    volatile Uint16 RSVD19[3];
    volatile Uint16 NANDSTAT0;
    volatile Uint16 NANDSTAT1;
    volatile Uint16 RSVD20[2];
    volatile Uint16 PAGEMODCTRL0;
    volatile Uint16 PAGEMODCTRL1;
    volatile Uint16 RSVD21[6];
    volatile Uint16 CS2ECC0;
    volatile Uint16 CS2ECC1;
    volatile Uint16 RSVD22[2];
    volatile Uint16 CS3ECC0;
    volatile Uint16 CS3ECC1;
    volatile Uint16 RSVD23[2];
    volatile Uint16 CS4ECC0;
    volatile Uint16 CS4ECC1;
    volatile Uint16 RSVD24[2];
    volatile Uint16 CS5ECC0;
    volatile Uint16 CS5ECC1;
    volatile Uint16 RSVD25[50];
    volatile Uint16 VERSION;
    volatile Uint16 RSVD26[11];
    volatile Uint16 FOURBITECCLD;
    volatile Uint16 RSVD27[3];
    volatile Uint16 FOURBITECC10;
    volatile Uint16 FOURBITECC11;
    volatile Uint16 RSVD28[2];
    volatile Uint16 FOURBITECC20;
    volatile Uint16 FOURBITECC21;
    volatile Uint16 RSVD29[2];
    volatile Uint16 FOURBITECC30;
    volatile Uint16 FOURBITECC31;
    volatile Uint16 RSVD30[2];
    volatile Uint16 FOURBITECC40;
    volatile Uint16 FOURBITECC41;
    volatile Uint16 RSVD31[2];
    volatile Uint16 ERRADRR10;
    volatile Uint16 ERRADRR11;
    volatile Uint16 RSVD32[2];
    volatile Uint16 ERRADRR20;
    volatile Uint16 ERRADRR21;
    volatile Uint16 RSVD33[2];
    volatile Uint16 ERRVAL10;
    volatile Uint16 ERRVAL11;
    volatile Uint16 RSVD34[2];
    volatile Uint16 ERRVAL20;
    volatile Uint16 ERRVAL21;
} CSL_EmifRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REV */

#define CSL_EMIF_REV_REVISION_MASK (0xFFFFu)
#define CSL_EMIF_REV_REVISION_SHIFT (0x0000u)
#define CSL_EMIF_REV_REVISION_RESETVAL (0x0000u)

#define CSL_EMIF_REV_RESETVAL (0x0000u)

/* STATUS */

#define CSL_EMIF_STATUS_BIGENDIAN_MASK (0x8000u)
#define CSL_EMIF_STATUS_BIGENDIAN_SHIFT (0x000Fu)
#define CSL_EMIF_STATUS_BIGENDIAN_RESETVAL (0x0000u)

#define CSL_EMIF_STATUS_FULLRATE_MASK (0x4000u)
#define CSL_EMIF_STATUS_FULLRATE_SHIFT (0x000Eu)
#define CSL_EMIF_STATUS_FULLRATE_RESETVAL (0x000Fu)

#define CSL_EMIF_STATUS_MODID_MASK (0x3FFFu)
#define CSL_EMIF_STATUS_MODID_SHIFT (0x0000u)
#define CSL_EMIF_STATUS_MODID_RESETVAL (0x0000u)

#define CSL_EMIF_STATUS_RESETVAL (0xC003u)

/* ASYNCCONFIG0 */


#define CSL_EMIF_ASYNCCONFIG0_MAX_EXT_WAIT_MASK (0x00FFu)
#define CSL_EMIF_ASYNCCONFIG0_MAX_EXT_WAIT_SHIFT (0x0000u)
#define CSL_EMIF_ASYNCCONFIG0_MAX_EXT_WAIT_RESETVAL (0x0080u)

#define CSL_EMIF_ASYNCCONFIG0_RESETVAL (0x0080u)

/* ASYNCCONFIG1 */

#define CSL_EMIF_ASYNCCONFIG1_WP3_MASK (0x8000u)
#define CSL_EMIF_ASYNCCONFIG1_WP3_SHIFT (0x000Fu)
#define CSL_EMIF_ASYNCCONFIG1_WP3_RESETVAL (0x0001u)

#define CSL_EMIF_ASYNCCONFIG1_WP2_MASK (0x4000u)
#define CSL_EMIF_ASYNCCONFIG1_WP2_SHIFT (0x000Eu)
#define CSL_EMIF_ASYNCCONFIG1_WP2_RESETVAL (0x0001u)

#define CSL_EMIF_ASYNCCONFIG1_WP1_MASK (0x2000u)
#define CSL_EMIF_ASYNCCONFIG1_WP1_SHIFT (0x000Du)
#define CSL_EMIF_ASYNCCONFIG1_WP1_RESETVAL (0x0001u)

#define CSL_EMIF_ASYNCCONFIG1_WP0_MASK (0x1000u)
#define CSL_EMIF_ASYNCCONFIG1_WP0_SHIFT (0x000Cu)
#define CSL_EMIF_ASYNCCONFIG1_WP0_RESETVAL (0x0001u)


#define CSL_EMIF_ASYNCCONFIG1_CS5_WAIT_MASK (0x00C0u)
#define CSL_EMIF_ASYNCCONFIG1_CS5_WAIT_SHIFT (0x0006u)
#define CSL_EMIF_ASYNCCONFIG1_CS5_WAIT_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCONFIG1_CS4_WAIT_MASK (0x0030u)
#define CSL_EMIF_ASYNCCONFIG1_CS4_WAIT_SHIFT (0x0004u)
#define CSL_EMIF_ASYNCCONFIG1_CS4_WAIT_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCONFIG1_CS3_WAIT_MASK (0x000Cu)
#define CSL_EMIF_ASYNCCONFIG1_CS3_WAIT_SHIFT (0x0002u)
#define CSL_EMIF_ASYNCCONFIG1_CS3_WAIT_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCONFIG1_CS2_WAIT_MASK (0x0003u)
#define CSL_EMIF_ASYNCCONFIG1_CS2_WAIT_SHIFT (0x0000u)
#define CSL_EMIF_ASYNCCONFIG1_CS2_WAIT_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCONFIG1_RESETVAL (0xF000u)

/* SDRAMCONFIG0 */


#define CSL_EMIF_SDRAMCONFIG0_NM_MASK (0x4000u)
#define CSL_EMIF_SDRAMCONFIG0_NM_SHIFT (0x000Eu)
#define CSL_EMIF_SDRAMCONFIG0_NM_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG0_DDRDLL_ENABLE_MASK (0x2000u)
#define CSL_EMIF_SDRAMCONFIG0_DDRDLL_ENABLE_SHIFT (0x000Du)
#define CSL_EMIF_SDRAMCONFIG0_DDRDLL_ENABLE_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG0_DDRPLL_LOCK_MASK (0x1000u)
#define CSL_EMIF_SDRAMCONFIG0_DDRPLL_LOCK_SHIFT (0x000Cu)
#define CSL_EMIF_SDRAMCONFIG0_DDRPLL_LOCK_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG0_CASLATENCY_MASK (0x0E00u)
#define CSL_EMIF_SDRAMCONFIG0_CASLATENCY_SHIFT (0x0009u)
#define CSL_EMIF_SDRAMCONFIG0_CASLATENCY_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG0_CASLOCK_MASK (0x0100u)
#define CSL_EMIF_SDRAMCONFIG0_CASLOCK_SHIFT (0x0008u)
#define CSL_EMIF_SDRAMCONFIG0_CASLOCK_RESETVAL (0x0000u)


#define CSL_EMIF_SDRAMCONFIG0_IBANK_MASK (0x0070u)
#define CSL_EMIF_SDRAMCONFIG0_IBANK_SHIFT (0x0004u)
#define CSL_EMIF_SDRAMCONFIG0_IBANK_RESETVAL (0x0002u)

#define CSL_EMIF_SDRAMCONFIG0_EBANK_MASK (0x0008u)
#define CSL_EMIF_SDRAMCONFIG0_EBANK_SHIFT (0x0003u)
#define CSL_EMIF_SDRAMCONFIG0_EBANK_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG0_PAGESIZE_MASK (0x0007u)
#define CSL_EMIF_SDRAMCONFIG0_PAGESIZE_SHIFT (0x0000u)
#define CSL_EMIF_SDRAMCONFIG0_PAGESIZE_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG0_RESETVAL (0x0020u)

/* SDRAMCONFIG1 */

#define CSL_EMIF_SDRAMCONFIG1_SR_MASK (0x8000u)
#define CSL_EMIF_SDRAMCONFIG1_SR_SHIFT (0x000Fu)
#define CSL_EMIF_SDRAMCONFIG1_SR_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG1_PD_MASK (0x4000u)
#define CSL_EMIF_SDRAMCONFIG1_PD_SHIFT (0x000Eu)
#define CSL_EMIF_SDRAMCONFIG1_PD_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG1_PDWR_MASK (0x2000u)
#define CSL_EMIF_SDRAMCONFIG1_PDWR_SHIFT (0x000Du)
#define CSL_EMIF_SDRAMCONFIG1_PDWR_RESETVAL (0x0000u)


#define CSL_EMIF_SDRAMCONFIG1_PASR_MASK (0x0380u)
#define CSL_EMIF_SDRAMCONFIG1_PASR_SHIFT (0x0007u)
#define CSL_EMIF_SDRAMCONFIG1_PASR_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG1_ROWSIZE_MASK (0x0070u)
#define CSL_EMIF_SDRAMCONFIG1_ROWSIZE_SHIFT (0x0004u)
#define CSL_EMIF_SDRAMCONFIG1_ROWSIZE_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG1_IBANK_POS_MASK (0x0008u)
#define CSL_EMIF_SDRAMCONFIG1_IBANK_POS_SHIFT (0x0003u)
#define CSL_EMIF_SDRAMCONFIG1_IBANK_POS_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG1_SDRAM_DRIVE_MASK (0x0006u)
#define CSL_EMIF_SDRAMCONFIG1_SDRAM_DRIVE_SHIFT (0x0001u)
#define CSL_EMIF_SDRAMCONFIG1_SDRAM_DRIVE_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG1_LOCK_17_25_MASK (0x0001u)
#define CSL_EMIF_SDRAMCONFIG1_LOCK_17_25_SHIFT (0x0000u)
#define CSL_EMIF_SDRAMCONFIG1_LOCK_17_25_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMCONFIG1_RESETVAL (0x0000u)

/* SDRCREFCTRL0 */


#define CSL_EMIF_SDRCREFCTRL0_REFRATE_MASK (0x1FFFu)
#define CSL_EMIF_SDRCREFCTRL0_REFRATE_SHIFT (0x0000u)
#define CSL_EMIF_SDRCREFCTRL0_REFRATE_RESETVAL (0x0000u)

#define CSL_EMIF_SDRCREFCTRL0_RESETVAL (0x0000u)

/* SDRCREFCTRL1 */


#define CSL_EMIF_SDRCREFCTRL1_DDR_REF_THR_MASK (0x0007u)
#define CSL_EMIF_SDRCREFCTRL1_DDR_REF_THR_SHIFT (0x0000u)
#define CSL_EMIF_SDRCREFCTRL1_DDR_REF_THR_RESETVAL (0x0000u)

#define CSL_EMIF_SDRCREFCTRL1_RESETVAL (0x0000u)

/* ASYNCCS0CTRL0 */

#define CSL_EMIF_ASYNCCS0CTRL0_RSETUP_MASK (0xE000u)
#define CSL_EMIF_ASYNCCS0CTRL0_RSETUP_SHIFT (0x000Du)
#define CSL_EMIF_ASYNCCS0CTRL0_RSETUP_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS0CTRL0_RSTROBE_MASK (0x1F80u)
#define CSL_EMIF_ASYNCCS0CTRL0_RSTROBE_SHIFT (0x0007u)
#define CSL_EMIF_ASYNCCS0CTRL0_RSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ASYNCCS0CTRL0_RHOLD_MASK (0x0070u)
#define CSL_EMIF_ASYNCCS0CTRL0_RHOLD_SHIFT (0x0004u)
#define CSL_EMIF_ASYNCCS0CTRL0_RHOLD_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS0CTRL0_TA_MASK (0x000Cu)
#define CSL_EMIF_ASYNCCS0CTRL0_TA_SHIFT (0x0002u)
#define CSL_EMIF_ASYNCCS0CTRL0_TA_RESETVAL (0x0003u)

#define CSL_EMIF_ASYNCCS0CTRL0_BUSWIDTH_MASK (0x0003u)
#define CSL_EMIF_ASYNCCS0CTRL0_BUSWIDTH_SHIFT (0x0000u)
#define CSL_EMIF_ASYNCCS0CTRL0_BUSWIDTH_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS0CTRL0_RESETVAL (0xFFFCu)

/* ASYNCCS0CTRL1 */

#define CSL_EMIF_ASYNCCS0CTRL1_SELSTROBE_MASK (0x8000u)
#define CSL_EMIF_ASYNCCS0CTRL1_SELSTROBE_SHIFT (0x000Fu)
#define CSL_EMIF_ASYNCCS0CTRL1_SELSTROBE_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS0CTRL1_EXTWAIT_MASK (0x4000u)
#define CSL_EMIF_ASYNCCS0CTRL1_EXTWAIT_SHIFT (0x000Eu)
#define CSL_EMIF_ASYNCCS0CTRL1_EXTWAIT_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS0CTRL1_WSETUP_MASK (0x3C00u)
#define CSL_EMIF_ASYNCCS0CTRL1_WSETUP_SHIFT (0x000Au)
#define CSL_EMIF_ASYNCCS0CTRL1_WSETUP_RESETVAL (0x000Fu)

#define CSL_EMIF_ASYNCCS0CTRL1_WSTROBE_MASK (0x03F0u)
#define CSL_EMIF_ASYNCCS0CTRL1_WSTROBE_SHIFT (0x0004u)
#define CSL_EMIF_ASYNCCS0CTRL1_WSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ASYNCCS0CTRL1_WHOLD_MASK (0x000Eu)
#define CSL_EMIF_ASYNCCS0CTRL1_WHOLD_SHIFT (0x0001u)
#define CSL_EMIF_ASYNCCS0CTRL1_WHOLD_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS0CTRL1_RSETUP_MASK (0x0001u)
#define CSL_EMIF_ASYNCCS0CTRL1_RSETUP_SHIFT (0x0000u)
#define CSL_EMIF_ASYNCCS0CTRL1_RSETUP_RESETVAL (0x0001u)

#define CSL_EMIF_ASYNCCS0CTRL1_RESETVAL (0x3FFFu)

/* ASYNCCS1CTRL0 */

#define CSL_EMIF_ASYNCCS1CTRL0_RSETUP_MASK (0xE000u)
#define CSL_EMIF_ASYNCCS1CTRL0_RSETUP_SHIFT (0x000Du)
#define CSL_EMIF_ASYNCCS1CTRL0_RSETUP_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS1CTRL0_RSTROBE_MASK (0x1F80u)
#define CSL_EMIF_ASYNCCS1CTRL0_RSTROBE_SHIFT (0x0007u)
#define CSL_EMIF_ASYNCCS1CTRL0_RSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ASYNCCS1CTRL0_RHOLD_MASK (0x0070u)
#define CSL_EMIF_ASYNCCS1CTRL0_RHOLD_SHIFT (0x0004u)
#define CSL_EMIF_ASYNCCS1CTRL0_RHOLD_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS1CTRL0_TA_MASK (0x000Cu)
#define CSL_EMIF_ASYNCCS1CTRL0_TA_SHIFT (0x0002u)
#define CSL_EMIF_ASYNCCS1CTRL0_TA_RESETVAL (0x0003u)

#define CSL_EMIF_ASYNCCS1CTRL0_BUSWIDTH_MASK (0x0003u)
#define CSL_EMIF_ASYNCCS1CTRL0_BUSWIDTH_SHIFT (0x0000u)
#define CSL_EMIF_ASYNCCS1CTRL0_BUSWIDTH_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS1CTRL0_RESETVAL (0xFFFCu)

/* ASYNCCS1CTRL1 */

#define CSL_EMIF_ASYNCCS1CTRL1_SELSTROBE_MASK (0x8000u)
#define CSL_EMIF_ASYNCCS1CTRL1_SELSTROBE_SHIFT (0x000Fu)
#define CSL_EMIF_ASYNCCS1CTRL1_SELSTROBE_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS1CTRL1_EXTWAIT_MASK (0x4000u)
#define CSL_EMIF_ASYNCCS1CTRL1_EXTWAIT_SHIFT (0x000Eu)
#define CSL_EMIF_ASYNCCS1CTRL1_EXTWAIT_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS1CTRL1_WSETUP_MASK (0x3C00u)
#define CSL_EMIF_ASYNCCS1CTRL1_WSETUP_SHIFT (0x000Au)
#define CSL_EMIF_ASYNCCS1CTRL1_WSETUP_RESETVAL (0x000Fu)

#define CSL_EMIF_ASYNCCS1CTRL1_WSTROBE_MASK (0x03F0u)
#define CSL_EMIF_ASYNCCS1CTRL1_WSTROBE_SHIFT (0x0004u)
#define CSL_EMIF_ASYNCCS1CTRL1_WSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ASYNCCS1CTRL1_WHOLD_MASK (0x000Eu)
#define CSL_EMIF_ASYNCCS1CTRL1_WHOLD_SHIFT (0x0001u)
#define CSL_EMIF_ASYNCCS1CTRL1_WHOLD_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS1CTRL1_RSETUP_MASK (0x0001u)
#define CSL_EMIF_ASYNCCS1CTRL1_RSETUP_SHIFT (0x0000u)
#define CSL_EMIF_ASYNCCS1CTRL1_RSETUP_RESETVAL (0x0001u)

#define CSL_EMIF_ASYNCCS1CTRL1_RESETVAL (0x3FFFu)

/* ASYNCCS2CTRL0 */

#define CSL_EMIF_ASYNCCS2CTRL0_RSETUP_MASK (0xE000u)
#define CSL_EMIF_ASYNCCS2CTRL0_RSETUP_SHIFT (0x000Du)
#define CSL_EMIF_ASYNCCS2CTRL0_RSETUP_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS2CTRL0_RSTROBE_MASK (0x1F80u)
#define CSL_EMIF_ASYNCCS2CTRL0_RSTROBE_SHIFT (0x0007u)
#define CSL_EMIF_ASYNCCS2CTRL0_RSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ASYNCCS2CTRL0_RHOLD_MASK (0x0070u)
#define CSL_EMIF_ASYNCCS2CTRL0_RHOLD_SHIFT (0x0004u)
#define CSL_EMIF_ASYNCCS2CTRL0_RHOLD_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS2CTRL0_TA_MASK (0x000Cu)
#define CSL_EMIF_ASYNCCS2CTRL0_TA_SHIFT (0x0002u)
#define CSL_EMIF_ASYNCCS2CTRL0_TA_RESETVAL (0x0003u)

#define CSL_EMIF_ASYNCCS2CTRL0_BUSWIDTH_MASK (0x0003u)
#define CSL_EMIF_ASYNCCS2CTRL0_BUSWIDTH_SHIFT (0x0000u)
#define CSL_EMIF_ASYNCCS2CTRL0_BUSWIDTH_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS2CTRL0_RESETVAL (0xFFFCu)

/* ASYNCCS2CTRL1 */

#define CSL_EMIF_ASYNCCS2CTRL1_SELSTROBE_MASK (0x8000u)
#define CSL_EMIF_ASYNCCS2CTRL1_SELSTROBE_SHIFT (0x000Fu)
#define CSL_EMIF_ASYNCCS2CTRL1_SELSTROBE_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS2CTRL1_EXTWAIT_MASK (0x4000u)
#define CSL_EMIF_ASYNCCS2CTRL1_EXTWAIT_SHIFT (0x000Eu)
#define CSL_EMIF_ASYNCCS2CTRL1_EXTWAIT_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS2CTRL1_WSETUP_MASK (0x3C00u)
#define CSL_EMIF_ASYNCCS2CTRL1_WSETUP_SHIFT (0x000Au)
#define CSL_EMIF_ASYNCCS2CTRL1_WSETUP_RESETVAL (0x000Fu)

#define CSL_EMIF_ASYNCCS2CTRL1_WSTROBE_MASK (0x03F0u)
#define CSL_EMIF_ASYNCCS2CTRL1_WSTROBE_SHIFT (0x0004u)
#define CSL_EMIF_ASYNCCS2CTRL1_WSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ASYNCCS2CTRL1_WHOLD_MASK (0x000Eu)
#define CSL_EMIF_ASYNCCS2CTRL1_WHOLD_SHIFT (0x0001u)
#define CSL_EMIF_ASYNCCS2CTRL1_WHOLD_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS2CTRL1_RSETUP_MASK (0x0001u)
#define CSL_EMIF_ASYNCCS2CTRL1_RSETUP_SHIFT (0x0000u)
#define CSL_EMIF_ASYNCCS2CTRL1_RSETUP_RESETVAL (0x0001u)

#define CSL_EMIF_ASYNCCS2CTRL1_RESETVAL (0x3FFFu)

/* ASYNCCS3CTRL0 */

#define CSL_EMIF_ASYNCCS3CTRL0_RSETUP_MASK (0xE000u)
#define CSL_EMIF_ASYNCCS3CTRL0_RSETUP_SHIFT (0x000Du)
#define CSL_EMIF_ASYNCCS3CTRL0_RSETUP_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS3CTRL0_RSTROBE_MASK (0x1F80u)
#define CSL_EMIF_ASYNCCS3CTRL0_RSTROBE_SHIFT (0x0007u)
#define CSL_EMIF_ASYNCCS3CTRL0_RSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ASYNCCS3CTRL0_RHOLD_MASK (0x0070u)
#define CSL_EMIF_ASYNCCS3CTRL0_RHOLD_SHIFT (0x0004u)
#define CSL_EMIF_ASYNCCS3CTRL0_RHOLD_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS3CTRL0_TA_MASK (0x000Cu)
#define CSL_EMIF_ASYNCCS3CTRL0_TA_SHIFT (0x0002u)
#define CSL_EMIF_ASYNCCS3CTRL0_TA_RESETVAL (0x0003u)

#define CSL_EMIF_ASYNCCS3CTRL0_BUSWIDTH_MASK (0x0003u)
#define CSL_EMIF_ASYNCCS3CTRL0_BUSWIDTH_SHIFT (0x0000u)
#define CSL_EMIF_ASYNCCS3CTRL0_BUSWIDTH_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS3CTRL0_RESETVAL (0xFFFCu)

/* ASYNCCS3CTRL1 */

#define CSL_EMIF_ASYNCCS3CTRL1_SELSTROBE_MASK (0x8000u)
#define CSL_EMIF_ASYNCCS3CTRL1_SELSTROBE_SHIFT (0x000Fu)
#define CSL_EMIF_ASYNCCS3CTRL1_SELSTROBE_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS3CTRL1_EXTWAIT_MASK (0x4000u)
#define CSL_EMIF_ASYNCCS3CTRL1_EXTWAIT_SHIFT (0x000Eu)
#define CSL_EMIF_ASYNCCS3CTRL1_EXTWAIT_RESETVAL (0x0000u)

#define CSL_EMIF_ASYNCCS3CTRL1_WSETUP_MASK (0x3C00u)
#define CSL_EMIF_ASYNCCS3CTRL1_WSETUP_SHIFT (0x000Au)
#define CSL_EMIF_ASYNCCS3CTRL1_WSETUP_RESETVAL (0x000Fu)

#define CSL_EMIF_ASYNCCS3CTRL1_WSTROBE_MASK (0x03F0u)
#define CSL_EMIF_ASYNCCS3CTRL1_WSTROBE_SHIFT (0x0004u)
#define CSL_EMIF_ASYNCCS3CTRL1_WSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ASYNCCS3CTRL1_WHOLD_MASK (0x000Eu)
#define CSL_EMIF_ASYNCCS3CTRL1_WHOLD_SHIFT (0x0001u)
#define CSL_EMIF_ASYNCCS3CTRL1_WHOLD_RESETVAL (0x0007u)

#define CSL_EMIF_ASYNCCS3CTRL1_RSETUP_MASK (0x0001u)
#define CSL_EMIF_ASYNCCS3CTRL1_RSETUP_SHIFT (0x0000u)
#define CSL_EMIF_ASYNCCS3CTRL1_RSETUP_RESETVAL (0x0001u)

#define CSL_EMIF_ASYNCCS3CTRL1_RESETVAL (0x3FFFu)

/* SDRAMTIMING0 */

#define CSL_EMIF_SDRAMTIMING0_TRAS_MASK (0xF000u)
#define CSL_EMIF_SDRAMTIMING0_TRAS_SHIFT (0x000Cu)
#define CSL_EMIF_SDRAMTIMING0_TRAS_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMTIMING0_TRC_MASK (0x0F00u)
#define CSL_EMIF_SDRAMTIMING0_TRC_SHIFT (0x0008u)
#define CSL_EMIF_SDRAMTIMING0_TRC_RESETVAL (0x0000u)


#define CSL_EMIF_SDRAMTIMING0_TRRD_MASK (0x0070u)
#define CSL_EMIF_SDRAMTIMING0_TRRD_SHIFT (0x0004u)
#define CSL_EMIF_SDRAMTIMING0_TRRD_RESETVAL (0x0000u)


#define CSL_EMIF_SDRAMTIMING0_RESETVAL (0x0000u)

/* SDRAMTIMING1 */

#define CSL_EMIF_SDRAMTIMING1_TRFC_MASK (0xF800u)
#define CSL_EMIF_SDRAMTIMING1_TRFC_SHIFT (0x000Bu)
#define CSL_EMIF_SDRAMTIMING1_TRFC_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMTIMING1_TRP_MASK (0x0700u)
#define CSL_EMIF_SDRAMTIMING1_TRP_SHIFT (0x0008u)
#define CSL_EMIF_SDRAMTIMING1_TRP_RESETVAL (0x0000u)


#define CSL_EMIF_SDRAMTIMING1_TRCD_MASK (0x0070u)
#define CSL_EMIF_SDRAMTIMING1_TRCD_SHIFT (0x0004u)
#define CSL_EMIF_SDRAMTIMING1_TRCD_RESETVAL (0x0000u)


#define CSL_EMIF_SDRAMTIMING1_TWR_MASK (0x0007u)
#define CSL_EMIF_SDRAMTIMING1_TWR_SHIFT (0x0000u)
#define CSL_EMIF_SDRAMTIMING1_TWR_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMTIMING1_RESETVAL (0x0000u)

/* SDRAMSTAT */


#define CSL_EMIF_SDRAMSTAT_PHYRDY_MASK (0x0008u)
#define CSL_EMIF_SDRAMSTAT_PHYRDY_SHIFT (0x0003u)
#define CSL_EMIF_SDRAMSTAT_PHYRDY_RESETVAL (0x0000u)


#define CSL_EMIF_SDRAMSTAT_MSDRMODE_MASK (0x0002u)
#define CSL_EMIF_SDRAMSTAT_MSDRMODE_SHIFT (0x0001u)
#define CSL_EMIF_SDRAMSTAT_MSDRMODE_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMSTAT_DOUBLERATE_MASK (0x0001u)
#define CSL_EMIF_SDRAMSTAT_DOUBLERATE_SHIFT (0x0000u)
#define CSL_EMIF_SDRAMSTAT_DOUBLERATE_RESETVAL (0x0000u)

#define CSL_EMIF_SDRAMSTAT_RESETVAL (0x0000u)

/* SDRACCESS0 */

#define CSL_EMIF_SDRACCESS0_TOTACCESS_0_15_MASK (0xFFFFu)
#define CSL_EMIF_SDRACCESS0_TOTACCESS_0_15_SHIFT (0x0000u)
#define CSL_EMIF_SDRACCESS0_TOTACCESS_0_15_RESETVAL (0x0000u)

#define CSL_EMIF_SDRACCESS0_RESETVAL (0x0000u)

/* SDRACCESS1 */

#define CSL_EMIF_SDRACCESS1_TOTACCESS_16_31_MASK (0xFFFFu)
#define CSL_EMIF_SDRACCESS1_TOTACCESS_16_31_SHIFT (0x0000u)
#define CSL_EMIF_SDRACCESS1_TOTACCESS_16_31_RESETVAL (0x0000u)

#define CSL_EMIF_SDRACCESS1_RESETVAL (0x0000u)

/* SDRACTIVATE0 */

#define CSL_EMIF_SDRACTIVATE0_TOTACCESS_0_15_MASK (0xFFFFu)
#define CSL_EMIF_SDRACTIVATE0_TOTACCESS_0_15_SHIFT (0x0000u)
#define CSL_EMIF_SDRACTIVATE0_TOTACCESS_0_15_RESETVAL (0x0000u)

#define CSL_EMIF_SDRACTIVATE0_RESETVAL (0x0000u)

/* SDRACTIVATE1 */

#define CSL_EMIF_SDRACTIVATE1_TOTACCESS_16_31_MASK (0xFFFFu)
#define CSL_EMIF_SDRACTIVATE1_TOTACCESS_16_31_SHIFT (0x0000u)
#define CSL_EMIF_SDRACTIVATE1_TOTACCESS_16_31_RESETVAL (0x0000u)

#define CSL_EMIF_SDRACTIVATE1_RESETVAL (0x0000u)

/* SDRCSRPD */



#define CSL_EMIF_SDRCSRPD_TXS_MASK (0x001Fu)
#define CSL_EMIF_SDRCSRPD_TXS_SHIFT (0x0000u)
#define CSL_EMIF_SDRCSRPD_TXS_RESETVAL (0x0000u)

#define CSL_EMIF_SDRCSRPD_RESETVAL (0x0000u)

/* INTRAW */


#define CSL_EMIF_INTRAW_WAITRISE_MASK (0x007Cu)
#define CSL_EMIF_INTRAW_WAITRISE_SHIFT (0x0002u)
#define CSL_EMIF_INTRAW_WAITRISE_RESETVAL (0x0000u)

#define CSL_EMIF_INTRAW_LINETRAP_MASK (0x0002u)
#define CSL_EMIF_INTRAW_LINETRAP_SHIFT (0x0001u)
#define CSL_EMIF_INTRAW_LINETRAP_RESETVAL (0x0000u)

#define CSL_EMIF_INTRAW_ASYNCTOUT_MASK (0x0001u)
#define CSL_EMIF_INTRAW_ASYNCTOUT_SHIFT (0x0000u)
#define CSL_EMIF_INTRAW_ASYNCTOUT_RESETVAL (0x0000u)

#define CSL_EMIF_INTRAW_RESETVAL (0x0000u)

/* INTMASK */


#define CSL_EMIF_INTMASK_WRMASK_MASK (0x003Cu)
#define CSL_EMIF_INTMASK_WRMASK_SHIFT (0x0002u)
#define CSL_EMIF_INTMASK_WRMASK_RESETVAL (0x0000u)

#define CSL_EMIF_INTMASK_LTMASK_MASK (0x0002u)
#define CSL_EMIF_INTMASK_LTMASK_SHIFT (0x0001u)
#define CSL_EMIF_INTMASK_LTMASK_RESETVAL (0x0000u)

#define CSL_EMIF_INTMASK_ATMASK_MASK (0x0001u)
#define CSL_EMIF_INTMASK_ATMASK_SHIFT (0x0000u)
#define CSL_EMIF_INTMASK_ATMASK_RESETVAL (0x0000u)

#define CSL_EMIF_INTMASK_RESETVAL (0x0000u)

/* INTMASKSET */


#define CSL_EMIF_INTMASKSET_WRMASKSET_MASK (0x003Cu)
#define CSL_EMIF_INTMASKSET_WRMASKSET_SHIFT (0x0002u)
#define CSL_EMIF_INTMASKSET_WRMASKSET_RESETVAL (0x0000u)

#define CSL_EMIF_INTMASKSET_LTMASKSET_MASK (0x0002u)
#define CSL_EMIF_INTMASKSET_LTMASKSET_SHIFT (0x0001u)
#define CSL_EMIF_INTMASKSET_LTMASKSET_RESETVAL (0x0000u)

#define CSL_EMIF_INTMASKSET_ATMASKSET_MASK (0x0001u)
#define CSL_EMIF_INTMASKSET_ATMASKSET_SHIFT (0x0000u)
#define CSL_EMIF_INTMASKSET_ATMASKSET_RESETVAL (0x0000u)

#define CSL_EMIF_INTMASKSET_RESETVAL (0x0000u)

/* INTMASKCLEAR */


#define CSL_EMIF_INTMASKCLEAR_WRMASKSET_MASK (0x003Cu)
#define CSL_EMIF_INTMASKCLEAR_WRMASKSET_SHIFT (0x0002u)
#define CSL_EMIF_INTMASKCLEAR_WRMASKSET_RESETVAL (0x0000u)

#define CSL_EMIF_INTMASKCLEAR_LTMASKSET_MASK (0x0002u)
#define CSL_EMIF_INTMASKCLEAR_LTMASKSET_SHIFT (0x0001u)
#define CSL_EMIF_INTMASKCLEAR_LTMASKSET_RESETVAL (0x0000u)

#define CSL_EMIF_INTMASKCLEAR_ATMASKSET_MASK (0x0001u)
#define CSL_EMIF_INTMASKCLEAR_ATMASKSET_SHIFT (0x0000u)
#define CSL_EMIF_INTMASKCLEAR_ATMASKSET_RESETVAL (0x0000u)

#define CSL_EMIF_INTMASKCLEAR_RESETVAL (0x0000u)

/* IOCTRL */


#define CSL_EMIF_IOCTRL_IOCTRL_MASK (0xFFFFu)
#define CSL_EMIF_IOCTRL_IOCTRL_SHIFT (0x0000u)
#define CSL_EMIF_IOCTRL_IOCTRL_RESETVAL (0x0000u)

#define CSL_EMIF_IOCTRL_RESETVAL (0x0000u)

/* IOSTATUS */


#define CSL_EMIF_IOSTATUS_IOSTAT_MASK (0xFFFFu)
#define CSL_EMIF_IOSTATUS_IOSTAT_SHIFT (0x0000u)
#define CSL_EMIF_IOSTATUS_IOSTAT_RESETVAL (0x0000u)

#define CSL_EMIF_IOSTATUS_RESETVAL (0x0000u)

/* NANDCTRL */


#define CSL_EMIF_NANDCTRL_ADDCAL_MASK (0x2000u)
#define CSL_EMIF_NANDCTRL_ADDCAL_SHIFT (0x000Du)
#define CSL_EMIF_NANDCTRL_ADDCAL_RESETVAL (0x0000u)

#define CSL_EMIF_NANDCTRL_4BITECCSTART_MASK (0x1000u)
#define CSL_EMIF_NANDCTRL_4BITECCSTART_SHIFT (0x000Cu)
#define CSL_EMIF_NANDCTRL_4BITECCSTART_RESETVAL (0x0000u)

#define CSL_EMIF_NANDCTRL_CS5ECCSTART_MASK (0x0800u)
#define CSL_EMIF_NANDCTRL_CS5ECCSTART_SHIFT (0x000Bu)
#define CSL_EMIF_NANDCTRL_CS5ECCSTART_RESETVAL (0x0000u)

#define CSL_EMIF_NANDCTRL_CS4ECCSTART_MASK (0x0400u)
#define CSL_EMIF_NANDCTRL_CS4ECCSTART_SHIFT (0x000Au)
#define CSL_EMIF_NANDCTRL_CS4ECCSTART_RESETVAL (0x0000u)

#define CSL_EMIF_NANDCTRL_CS3ECCSTART_MASK (0x0200u)
#define CSL_EMIF_NANDCTRL_CS3ECCSTART_SHIFT (0x0009u)
#define CSL_EMIF_NANDCTRL_CS3ECCSTART_RESETVAL (0x0000u)

#define CSL_EMIF_NANDCTRL_CS2ECCSTART_MASK (0x0100u)
#define CSL_EMIF_NANDCTRL_CS2ECCSTART_SHIFT (0x0008u)
#define CSL_EMIF_NANDCTRL_CS2ECCSTART_RESETVAL (0x0000u)


#define CSL_EMIF_NANDCTRL_ECCSEL_MASK (0x0030u)
#define CSL_EMIF_NANDCTRL_ECCSEL_SHIFT (0x0004u)
#define CSL_EMIF_NANDCTRL_ECCSEL_RESETVAL (0x0000u)

#define CSL_EMIF_NANDCTRL_CS5SEL_MASK (0x0008u)
#define CSL_EMIF_NANDCTRL_CS5SEL_SHIFT (0x0003u)
#define CSL_EMIF_NANDCTRL_CS5SEL_RESETVAL (0x0000u)

#define CSL_EMIF_NANDCTRL_CS4SEL_MASK (0x0004u)
#define CSL_EMIF_NANDCTRL_CS4SEL_SHIFT (0x0002u)
#define CSL_EMIF_NANDCTRL_CS4SEL_RESETVAL (0x0000u)

#define CSL_EMIF_NANDCTRL_CS3SEL_MASK (0x0002u)
#define CSL_EMIF_NANDCTRL_CS3SEL_SHIFT (0x0001u)
#define CSL_EMIF_NANDCTRL_CS3SEL_RESETVAL (0x0000u)

#define CSL_EMIF_NANDCTRL_CS2SEL_MASK (0x0001u)
#define CSL_EMIF_NANDCTRL_CS2SEL_SHIFT (0x0000u)
#define CSL_EMIF_NANDCTRL_CS2SEL_RESETVAL (0x0000u)

#define CSL_EMIF_NANDCTRL_RESETVAL (0x0000u)

/* NANDSTAT0 */


#define CSL_EMIF_NANDSTAT0_CORRSTATE_MASK (0x0F00u)
#define CSL_EMIF_NANDSTAT0_CORRSTATE_SHIFT (0x0008u)
#define CSL_EMIF_NANDSTAT0_CORRSTATE_RESETVAL (0x0000u)


#define CSL_EMIF_NANDSTAT0_WAITSTAT_MASK (0x000Fu)
#define CSL_EMIF_NANDSTAT0_WAITSTAT_SHIFT (0x0000u)
#define CSL_EMIF_NANDSTAT0_WAITSTAT_RESETVAL (0x0000u)

#define CSL_EMIF_NANDSTAT0_RESETVAL (0x0000u)

/* NANDSTAT1 */


#define CSL_EMIF_NANDSTAT1_ERRNUM_MASK (0x0003u)
#define CSL_EMIF_NANDSTAT1_ERRNUM_SHIFT (0x0000u)
#define CSL_EMIF_NANDSTAT1_ERRNUM_RESETVAL (0x0000u)

#define CSL_EMIF_NANDSTAT1_RESETVAL (0x0000u)

/* PAGEMODCTRL0 */

#define CSL_EMIF_PAGEMODCTRL0_CS3_PAGE_DELAY_MASK (0xFC00u)
#define CSL_EMIF_PAGEMODCTRL0_CS3_PAGE_DELAY_SHIFT (0x000Au)
#define CSL_EMIF_PAGEMODCTRL0_CS3_PAGE_DELAY_RESETVAL (0x003Fu)

#define CSL_EMIF_PAGEMODCTRL0_CS3_PAGE_SIZE_MASK (0x0200u)
#define CSL_EMIF_PAGEMODCTRL0_CS3_PAGE_SIZE_SHIFT (0x0009u)
#define CSL_EMIF_PAGEMODCTRL0_CS3_PAGE_SIZE_RESETVAL (0x0000u)

#define CSL_EMIF_PAGEMODCTRL0_CS3_PAGEMOD_EN_MASK (0x0100u)
#define CSL_EMIF_PAGEMODCTRL0_CS3_PAGEMOD_EN_SHIFT (0x0008u)
#define CSL_EMIF_PAGEMODCTRL0_CS3_PAGEMOD_EN_RESETVAL (0x0000u)

#define CSL_EMIF_PAGEMODCTRL0_CS2_PAGE_DELAY_MASK (0x00FCu)
#define CSL_EMIF_PAGEMODCTRL0_CS2_PAGE_DELAY_SHIFT (0x0002u)
#define CSL_EMIF_PAGEMODCTRL0_CS2_PAGE_DELAY_RESETVAL (0x003Fu)

#define CSL_EMIF_PAGEMODCTRL0_CS2_PAGE_SIZE_MASK (0x0002u)
#define CSL_EMIF_PAGEMODCTRL0_CS2_PAGE_SIZE_SHIFT (0x0001u)
#define CSL_EMIF_PAGEMODCTRL0_CS2_PAGE_SIZE_RESETVAL (0x0000u)

#define CSL_EMIF_PAGEMODCTRL0_CS2_PAGEMOD_EN_MASK (0x0001u)
#define CSL_EMIF_PAGEMODCTRL0_CS2_PAGEMOD_EN_SHIFT (0x0000u)
#define CSL_EMIF_PAGEMODCTRL0_CS2_PAGEMOD_EN_RESETVAL (0x0000u)

#define CSL_EMIF_PAGEMODCTRL0_RESETVAL (0xFCFCu)

/* PAGEMODCTRL1 */

#define CSL_EMIF_PAGEMODCTRL1_CS5_PAGE_DELAY_MASK (0xFC00u)
#define CSL_EMIF_PAGEMODCTRL1_CS5_PAGE_DELAY_SHIFT (0x000Au)
#define CSL_EMIF_PAGEMODCTRL1_CS5_PAGE_DELAY_RESETVAL (0x003Fu)

#define CSL_EMIF_PAGEMODCTRL1_CS5_PAGE_SIZE_MASK (0x0200u)
#define CSL_EMIF_PAGEMODCTRL1_CS5_PAGE_SIZE_SHIFT (0x0009u)
#define CSL_EMIF_PAGEMODCTRL1_CS5_PAGE_SIZE_RESETVAL (0x0000u)

#define CSL_EMIF_PAGEMODCTRL1_CS5_PAGEMOD_EN_MASK (0x0100u)
#define CSL_EMIF_PAGEMODCTRL1_CS5_PAGEMOD_EN_SHIFT (0x0008u)
#define CSL_EMIF_PAGEMODCTRL1_CS5_PAGEMOD_EN_RESETVAL (0x0000u)

#define CSL_EMIF_PAGEMODCTRL1_CS4_PAGE_DELAY_MASK (0x00FCu)
#define CSL_EMIF_PAGEMODCTRL1_CS4_PAGE_DELAY_SHIFT (0x0002u)
#define CSL_EMIF_PAGEMODCTRL1_CS4_PAGE_DELAY_RESETVAL (0x003Fu)

#define CSL_EMIF_PAGEMODCTRL1_CS4_PAGE_SIZE_MASK (0x0002u)
#define CSL_EMIF_PAGEMODCTRL1_CS4_PAGE_SIZE_SHIFT (0x0001u)
#define CSL_EMIF_PAGEMODCTRL1_CS4_PAGE_SIZE_RESETVAL (0x0000u)

#define CSL_EMIF_PAGEMODCTRL1_CS4_PAGEMOD_EN_MASK (0x0001u)
#define CSL_EMIF_PAGEMODCTRL1_CS4_PAGEMOD_EN_SHIFT (0x0000u)
#define CSL_EMIF_PAGEMODCTRL1_CS4_PAGEMOD_EN_RESETVAL (0x0000u)

#define CSL_EMIF_PAGEMODCTRL1_RESETVAL (0xFCFCu)

/* CS2ECC0 */



#define CSL_EMIF_CS2ECC0_P2048E_MASK (0x0800u)
#define CSL_EMIF_CS2ECC0_P2048E_SHIFT (0x000Bu)
#define CSL_EMIF_CS2ECC0_P2048E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_P1024E_MASK (0x0400u)
#define CSL_EMIF_CS2ECC0_P1024E_SHIFT (0x000Au)
#define CSL_EMIF_CS2ECC0_P1024E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_P512E_MASK (0x0200u)
#define CSL_EMIF_CS2ECC0_P512E_SHIFT (0x0009u)
#define CSL_EMIF_CS2ECC0_P512E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_P256E_MASK (0x0100u)
#define CSL_EMIF_CS2ECC0_P256E_SHIFT (0x0008u)
#define CSL_EMIF_CS2ECC0_P256E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_P128E_MASK (0x0080u)
#define CSL_EMIF_CS2ECC0_P128E_SHIFT (0x0007u)
#define CSL_EMIF_CS2ECC0_P128E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_P64E_MASK (0x0040u)
#define CSL_EMIF_CS2ECC0_P64E_SHIFT (0x0006u)
#define CSL_EMIF_CS2ECC0_P64E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_P32E_MASK (0x0020u)
#define CSL_EMIF_CS2ECC0_P32E_SHIFT (0x0005u)
#define CSL_EMIF_CS2ECC0_P32E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_P16E_MASK (0x0010u)
#define CSL_EMIF_CS2ECC0_P16E_SHIFT (0x0004u)
#define CSL_EMIF_CS2ECC0_P16E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_P8E_MASK (0x0008u)
#define CSL_EMIF_CS2ECC0_P8E_SHIFT (0x0003u)
#define CSL_EMIF_CS2ECC0_P8E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_P4E_MASK (0x0004u)
#define CSL_EMIF_CS2ECC0_P4E_SHIFT (0x0002u)
#define CSL_EMIF_CS2ECC0_P4E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_P2E_MASK (0x0002u)
#define CSL_EMIF_CS2ECC0_P2E_SHIFT (0x0001u)
#define CSL_EMIF_CS2ECC0_P2E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_P1E_MASK (0x0001u)
#define CSL_EMIF_CS2ECC0_P1E_SHIFT (0x0000u)
#define CSL_EMIF_CS2ECC0_P1E_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC0_RESETVAL (0x0000u)

/* CS2ECC1 */


#define CSL_EMIF_CS2ECC1_P2048O_MASK (0x0800u)
#define CSL_EMIF_CS2ECC1_P2048O_SHIFT (0x000Bu)
#define CSL_EMIF_CS2ECC1_P2048O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_P1024O_MASK (0x0400u)
#define CSL_EMIF_CS2ECC1_P1024O_SHIFT (0x000Au)
#define CSL_EMIF_CS2ECC1_P1024O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_P512O_MASK (0x0200u)
#define CSL_EMIF_CS2ECC1_P512O_SHIFT (0x0009u)
#define CSL_EMIF_CS2ECC1_P512O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_P256O_MASK (0x0100u)
#define CSL_EMIF_CS2ECC1_P256O_SHIFT (0x0008u)
#define CSL_EMIF_CS2ECC1_P256O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_P128O_MASK (0x0080u)
#define CSL_EMIF_CS2ECC1_P128O_SHIFT (0x0007u)
#define CSL_EMIF_CS2ECC1_P128O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_P64O_MASK (0x0040u)
#define CSL_EMIF_CS2ECC1_P64O_SHIFT (0x0006u)
#define CSL_EMIF_CS2ECC1_P64O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_P32O_MASK (0x0020u)
#define CSL_EMIF_CS2ECC1_P32O_SHIFT (0x0005u)
#define CSL_EMIF_CS2ECC1_P32O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_P16O_MASK (0x0010u)
#define CSL_EMIF_CS2ECC1_P16O_SHIFT (0x0004u)
#define CSL_EMIF_CS2ECC1_P16O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_P8O_MASK (0x0008u)
#define CSL_EMIF_CS2ECC1_P8O_SHIFT (0x0003u)
#define CSL_EMIF_CS2ECC1_P8O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_P4O_MASK (0x0004u)
#define CSL_EMIF_CS2ECC1_P4O_SHIFT (0x0002u)
#define CSL_EMIF_CS2ECC1_P4O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_P2O_MASK (0x0002u)
#define CSL_EMIF_CS2ECC1_P2O_SHIFT (0x0001u)
#define CSL_EMIF_CS2ECC1_P2O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_P1O_MASK (0x0001u)
#define CSL_EMIF_CS2ECC1_P1O_SHIFT (0x0000u)
#define CSL_EMIF_CS2ECC1_P1O_RESETVAL (0x0000u)

#define CSL_EMIF_CS2ECC1_RESETVAL (0x0000u)

/* CS3ECC0 */



#define CSL_EMIF_CS3ECC0_P2048E_MASK (0x0800u)
#define CSL_EMIF_CS3ECC0_P2048E_SHIFT (0x000Bu)
#define CSL_EMIF_CS3ECC0_P2048E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_P1024E_MASK (0x0400u)
#define CSL_EMIF_CS3ECC0_P1024E_SHIFT (0x000Au)
#define CSL_EMIF_CS3ECC0_P1024E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_P512E_MASK (0x0200u)
#define CSL_EMIF_CS3ECC0_P512E_SHIFT (0x0009u)
#define CSL_EMIF_CS3ECC0_P512E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_P256E_MASK (0x0100u)
#define CSL_EMIF_CS3ECC0_P256E_SHIFT (0x0008u)
#define CSL_EMIF_CS3ECC0_P256E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_P128E_MASK (0x0080u)
#define CSL_EMIF_CS3ECC0_P128E_SHIFT (0x0007u)
#define CSL_EMIF_CS3ECC0_P128E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_P64E_MASK (0x0040u)
#define CSL_EMIF_CS3ECC0_P64E_SHIFT (0x0006u)
#define CSL_EMIF_CS3ECC0_P64E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_P32E_MASK (0x0020u)
#define CSL_EMIF_CS3ECC0_P32E_SHIFT (0x0005u)
#define CSL_EMIF_CS3ECC0_P32E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_P16E_MASK (0x0010u)
#define CSL_EMIF_CS3ECC0_P16E_SHIFT (0x0004u)
#define CSL_EMIF_CS3ECC0_P16E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_P8E_MASK (0x0008u)
#define CSL_EMIF_CS3ECC0_P8E_SHIFT (0x0003u)
#define CSL_EMIF_CS3ECC0_P8E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_P4E_MASK (0x0004u)
#define CSL_EMIF_CS3ECC0_P4E_SHIFT (0x0002u)
#define CSL_EMIF_CS3ECC0_P4E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_P2E_MASK (0x0002u)
#define CSL_EMIF_CS3ECC0_P2E_SHIFT (0x0001u)
#define CSL_EMIF_CS3ECC0_P2E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_P1E_MASK (0x0001u)
#define CSL_EMIF_CS3ECC0_P1E_SHIFT (0x0000u)
#define CSL_EMIF_CS3ECC0_P1E_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC0_RESETVAL (0x0000u)

/* CS3ECC1 */


#define CSL_EMIF_CS3ECC1_P2048O_MASK (0x0800u)
#define CSL_EMIF_CS3ECC1_P2048O_SHIFT (0x000Bu)
#define CSL_EMIF_CS3ECC1_P2048O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_P1024O_MASK (0x0400u)
#define CSL_EMIF_CS3ECC1_P1024O_SHIFT (0x000Au)
#define CSL_EMIF_CS3ECC1_P1024O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_P512O_MASK (0x0200u)
#define CSL_EMIF_CS3ECC1_P512O_SHIFT (0x0009u)
#define CSL_EMIF_CS3ECC1_P512O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_P256O_MASK (0x0100u)
#define CSL_EMIF_CS3ECC1_P256O_SHIFT (0x0008u)
#define CSL_EMIF_CS3ECC1_P256O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_P128O_MASK (0x0080u)
#define CSL_EMIF_CS3ECC1_P128O_SHIFT (0x0007u)
#define CSL_EMIF_CS3ECC1_P128O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_P64O_MASK (0x0040u)
#define CSL_EMIF_CS3ECC1_P64O_SHIFT (0x0006u)
#define CSL_EMIF_CS3ECC1_P64O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_P32O_MASK (0x0020u)
#define CSL_EMIF_CS3ECC1_P32O_SHIFT (0x0005u)
#define CSL_EMIF_CS3ECC1_P32O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_P16O_MASK (0x0010u)
#define CSL_EMIF_CS3ECC1_P16O_SHIFT (0x0004u)
#define CSL_EMIF_CS3ECC1_P16O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_P8O_MASK (0x0008u)
#define CSL_EMIF_CS3ECC1_P8O_SHIFT (0x0003u)
#define CSL_EMIF_CS3ECC1_P8O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_P4O_MASK (0x0004u)
#define CSL_EMIF_CS3ECC1_P4O_SHIFT (0x0002u)
#define CSL_EMIF_CS3ECC1_P4O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_P2O_MASK (0x0002u)
#define CSL_EMIF_CS3ECC1_P2O_SHIFT (0x0001u)
#define CSL_EMIF_CS3ECC1_P2O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_P1O_MASK (0x0001u)
#define CSL_EMIF_CS3ECC1_P1O_SHIFT (0x0000u)
#define CSL_EMIF_CS3ECC1_P1O_RESETVAL (0x0000u)

#define CSL_EMIF_CS3ECC1_RESETVAL (0x0000u)

/* CS4ECC0 */



#define CSL_EMIF_CS4ECC0_P2048E_MASK (0x0800u)
#define CSL_EMIF_CS4ECC0_P2048E_SHIFT (0x000Bu)
#define CSL_EMIF_CS4ECC0_P2048E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_P1024E_MASK (0x0400u)
#define CSL_EMIF_CS4ECC0_P1024E_SHIFT (0x000Au)
#define CSL_EMIF_CS4ECC0_P1024E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_P512E_MASK (0x0200u)
#define CSL_EMIF_CS4ECC0_P512E_SHIFT (0x0009u)
#define CSL_EMIF_CS4ECC0_P512E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_P256E_MASK (0x0100u)
#define CSL_EMIF_CS4ECC0_P256E_SHIFT (0x0008u)
#define CSL_EMIF_CS4ECC0_P256E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_P128E_MASK (0x0080u)
#define CSL_EMIF_CS4ECC0_P128E_SHIFT (0x0007u)
#define CSL_EMIF_CS4ECC0_P128E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_P64E_MASK (0x0040u)
#define CSL_EMIF_CS4ECC0_P64E_SHIFT (0x0006u)
#define CSL_EMIF_CS4ECC0_P64E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_P32E_MASK (0x0020u)
#define CSL_EMIF_CS4ECC0_P32E_SHIFT (0x0005u)
#define CSL_EMIF_CS4ECC0_P32E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_P16E_MASK (0x0010u)
#define CSL_EMIF_CS4ECC0_P16E_SHIFT (0x0004u)
#define CSL_EMIF_CS4ECC0_P16E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_P8E_MASK (0x0008u)
#define CSL_EMIF_CS4ECC0_P8E_SHIFT (0x0003u)
#define CSL_EMIF_CS4ECC0_P8E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_P4E_MASK (0x0004u)
#define CSL_EMIF_CS4ECC0_P4E_SHIFT (0x0002u)
#define CSL_EMIF_CS4ECC0_P4E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_P2E_MASK (0x0002u)
#define CSL_EMIF_CS4ECC0_P2E_SHIFT (0x0001u)
#define CSL_EMIF_CS4ECC0_P2E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_P1E_MASK (0x0001u)
#define CSL_EMIF_CS4ECC0_P1E_SHIFT (0x0000u)
#define CSL_EMIF_CS4ECC0_P1E_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC0_RESETVAL (0x0000u)

/* CS4ECC1 */


#define CSL_EMIF_CS4ECC1_P2048O_MASK (0x0800u)
#define CSL_EMIF_CS4ECC1_P2048O_SHIFT (0x000Bu)
#define CSL_EMIF_CS4ECC1_P2048O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_P1024O_MASK (0x0400u)
#define CSL_EMIF_CS4ECC1_P1024O_SHIFT (0x000Au)
#define CSL_EMIF_CS4ECC1_P1024O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_P512O_MASK (0x0200u)
#define CSL_EMIF_CS4ECC1_P512O_SHIFT (0x0009u)
#define CSL_EMIF_CS4ECC1_P512O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_P256O_MASK (0x0100u)
#define CSL_EMIF_CS4ECC1_P256O_SHIFT (0x0008u)
#define CSL_EMIF_CS4ECC1_P256O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_P128O_MASK (0x0080u)
#define CSL_EMIF_CS4ECC1_P128O_SHIFT (0x0007u)
#define CSL_EMIF_CS4ECC1_P128O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_P64O_MASK (0x0040u)
#define CSL_EMIF_CS4ECC1_P64O_SHIFT (0x0006u)
#define CSL_EMIF_CS4ECC1_P64O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_P32O_MASK (0x0020u)
#define CSL_EMIF_CS4ECC1_P32O_SHIFT (0x0005u)
#define CSL_EMIF_CS4ECC1_P32O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_P16O_MASK (0x0010u)
#define CSL_EMIF_CS4ECC1_P16O_SHIFT (0x0004u)
#define CSL_EMIF_CS4ECC1_P16O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_P8O_MASK (0x0008u)
#define CSL_EMIF_CS4ECC1_P8O_SHIFT (0x0003u)
#define CSL_EMIF_CS4ECC1_P8O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_P4O_MASK (0x0004u)
#define CSL_EMIF_CS4ECC1_P4O_SHIFT (0x0002u)
#define CSL_EMIF_CS4ECC1_P4O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_P2O_MASK (0x0002u)
#define CSL_EMIF_CS4ECC1_P2O_SHIFT (0x0001u)
#define CSL_EMIF_CS4ECC1_P2O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_P1O_MASK (0x0001u)
#define CSL_EMIF_CS4ECC1_P1O_SHIFT (0x0000u)
#define CSL_EMIF_CS4ECC1_P1O_RESETVAL (0x0000u)

#define CSL_EMIF_CS4ECC1_RESETVAL (0x0000u)

/* CS5ECC0 */



#define CSL_EMIF_CS5ECC0_P2048E_MASK (0x0800u)
#define CSL_EMIF_CS5ECC0_P2048E_SHIFT (0x000Bu)
#define CSL_EMIF_CS5ECC0_P2048E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_P1024E_MASK (0x0400u)
#define CSL_EMIF_CS5ECC0_P1024E_SHIFT (0x000Au)
#define CSL_EMIF_CS5ECC0_P1024E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_P512E_MASK (0x0200u)
#define CSL_EMIF_CS5ECC0_P512E_SHIFT (0x0009u)
#define CSL_EMIF_CS5ECC0_P512E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_P256E_MASK (0x0100u)
#define CSL_EMIF_CS5ECC0_P256E_SHIFT (0x0008u)
#define CSL_EMIF_CS5ECC0_P256E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_P128E_MASK (0x0080u)
#define CSL_EMIF_CS5ECC0_P128E_SHIFT (0x0007u)
#define CSL_EMIF_CS5ECC0_P128E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_P64E_MASK (0x0040u)
#define CSL_EMIF_CS5ECC0_P64E_SHIFT (0x0006u)
#define CSL_EMIF_CS5ECC0_P64E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_P32E_MASK (0x0020u)
#define CSL_EMIF_CS5ECC0_P32E_SHIFT (0x0005u)
#define CSL_EMIF_CS5ECC0_P32E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_P16E_MASK (0x0010u)
#define CSL_EMIF_CS5ECC0_P16E_SHIFT (0x0004u)
#define CSL_EMIF_CS5ECC0_P16E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_P8E_MASK (0x0008u)
#define CSL_EMIF_CS5ECC0_P8E_SHIFT (0x0003u)
#define CSL_EMIF_CS5ECC0_P8E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_P4E_MASK (0x0004u)
#define CSL_EMIF_CS5ECC0_P4E_SHIFT (0x0002u)
#define CSL_EMIF_CS5ECC0_P4E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_P2E_MASK (0x0002u)
#define CSL_EMIF_CS5ECC0_P2E_SHIFT (0x0001u)
#define CSL_EMIF_CS5ECC0_P2E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_P1E_MASK (0x0001u)
#define CSL_EMIF_CS5ECC0_P1E_SHIFT (0x0000u)
#define CSL_EMIF_CS5ECC0_P1E_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC0_RESETVAL (0x0000u)

/* CS5ECC1 */


#define CSL_EMIF_CS5ECC1_P2048O_MASK (0x0800u)
#define CSL_EMIF_CS5ECC1_P2048O_SHIFT (0x000Bu)
#define CSL_EMIF_CS5ECC1_P2048O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_P1024O_MASK (0x0400u)
#define CSL_EMIF_CS5ECC1_P1024O_SHIFT (0x000Au)
#define CSL_EMIF_CS5ECC1_P1024O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_P512O_MASK (0x0200u)
#define CSL_EMIF_CS5ECC1_P512O_SHIFT (0x0009u)
#define CSL_EMIF_CS5ECC1_P512O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_P256O_MASK (0x0100u)
#define CSL_EMIF_CS5ECC1_P256O_SHIFT (0x0008u)
#define CSL_EMIF_CS5ECC1_P256O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_P128O_MASK (0x0080u)
#define CSL_EMIF_CS5ECC1_P128O_SHIFT (0x0007u)
#define CSL_EMIF_CS5ECC1_P128O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_P64O_MASK (0x0040u)
#define CSL_EMIF_CS5ECC1_P64O_SHIFT (0x0006u)
#define CSL_EMIF_CS5ECC1_P64O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_P32O_MASK (0x0020u)
#define CSL_EMIF_CS5ECC1_P32O_SHIFT (0x0005u)
#define CSL_EMIF_CS5ECC1_P32O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_P16O_MASK (0x0010u)
#define CSL_EMIF_CS5ECC1_P16O_SHIFT (0x0004u)
#define CSL_EMIF_CS5ECC1_P16O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_P8O_MASK (0x0008u)
#define CSL_EMIF_CS5ECC1_P8O_SHIFT (0x0003u)
#define CSL_EMIF_CS5ECC1_P8O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_P4O_MASK (0x0004u)
#define CSL_EMIF_CS5ECC1_P4O_SHIFT (0x0002u)
#define CSL_EMIF_CS5ECC1_P4O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_P2O_MASK (0x0002u)
#define CSL_EMIF_CS5ECC1_P2O_SHIFT (0x0001u)
#define CSL_EMIF_CS5ECC1_P2O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_P1O_MASK (0x0001u)
#define CSL_EMIF_CS5ECC1_P1O_SHIFT (0x0000u)
#define CSL_EMIF_CS5ECC1_P1O_RESETVAL (0x0000u)

#define CSL_EMIF_CS5ECC1_RESETVAL (0x0000u)

/* VERSION */


#define CSL_EMIF_VERSION_RELNUM_MASK (0x00FFu)
#define CSL_EMIF_VERSION_RELNUM_SHIFT (0x0000u)
#define CSL_EMIF_VERSION_RELNUM_RESETVAL (0x0000u)

#define CSL_EMIF_VERSION_RESETVAL (0x0000u)

/* FOURBITECCLD */


#define CSL_EMIF_FOURBITECCLD_4BITECC_LOAD_MASK (0x03FFu)
#define CSL_EMIF_FOURBITECCLD_4BITECC_LOAD_SHIFT (0x0000u)
#define CSL_EMIF_FOURBITECCLD_4BITECC_LOAD_RESETVAL (0x0000u)

#define CSL_EMIF_FOURBITECCLD_RESETVAL (0x0000u)

/* FOURBITECC10 */


#define CSL_EMIF_FOURBITECC10_VAL1_MASK (0x03FFu)
#define CSL_EMIF_FOURBITECC10_VAL1_SHIFT (0x0000u)
#define CSL_EMIF_FOURBITECC10_VAL1_RESETVAL (0x0000u)

#define CSL_EMIF_FOURBITECC10_RESETVAL (0x0000u)

/* FOURBITECC11 */


#define CSL_EMIF_FOURBITECC11_VAL2_MASK (0x03FFu)
#define CSL_EMIF_FOURBITECC11_VAL2_SHIFT (0x0000u)
#define CSL_EMIF_FOURBITECC11_VAL2_RESETVAL (0x0000u)

#define CSL_EMIF_FOURBITECC11_RESETVAL (0x0000u)

/* FOURBITECC20 */


#define CSL_EMIF_FOURBITECC20_VAL1_MASK (0x03FFu)
#define CSL_EMIF_FOURBITECC20_VAL1_SHIFT (0x0000u)
#define CSL_EMIF_FOURBITECC20_VAL1_RESETVAL (0x0000u)

#define CSL_EMIF_FOURBITECC20_RESETVAL (0x0000u)

/* FOURBITECC21 */


#define CSL_EMIF_FOURBITECC21_VAL2_MASK (0x03FFu)
#define CSL_EMIF_FOURBITECC21_VAL2_SHIFT (0x0000u)
#define CSL_EMIF_FOURBITECC21_VAL2_RESETVAL (0x0000u)

#define CSL_EMIF_FOURBITECC21_RESETVAL (0x0000u)

/* FOURBITECC30 */


#define CSL_EMIF_FOURBITECC30_VAL1_MASK (0x03FFu)
#define CSL_EMIF_FOURBITECC30_VAL1_SHIFT (0x0000u)
#define CSL_EMIF_FOURBITECC30_VAL1_RESETVAL (0x0000u)

#define CSL_EMIF_FOURBITECC30_RESETVAL (0x0000u)

/* FOURBITECC31 */


#define CSL_EMIF_FOURBITECC31_VAL2_MASK (0x03FFu)
#define CSL_EMIF_FOURBITECC31_VAL2_SHIFT (0x0000u)
#define CSL_EMIF_FOURBITECC31_VAL2_RESETVAL (0x0000u)

#define CSL_EMIF_FOURBITECC31_RESETVAL (0x0000u)

/* FOURBITECC40 */


#define CSL_EMIF_FOURBITECC40_VAL1_MASK (0x03FFu)
#define CSL_EMIF_FOURBITECC40_VAL1_SHIFT (0x0000u)
#define CSL_EMIF_FOURBITECC40_VAL1_RESETVAL (0x0000u)

#define CSL_EMIF_FOURBITECC40_RESETVAL (0x0000u)

/* FOURBITECC41 */


#define CSL_EMIF_FOURBITECC41_VAL2_MASK (0x03FFu)
#define CSL_EMIF_FOURBITECC41_VAL2_SHIFT (0x0000u)
#define CSL_EMIF_FOURBITECC41_VAL2_RESETVAL (0x0000u)

#define CSL_EMIF_FOURBITECC41_RESETVAL (0x0000u)

/* ERRADRR10 */


#define CSL_EMIF_ERRADRR10_ERRADDR1_MASK (0x03FFu)
#define CSL_EMIF_ERRADRR10_ERRADDR1_SHIFT (0x0000u)
#define CSL_EMIF_ERRADRR10_ERRADDR1_RESETVAL (0x0000u)

#define CSL_EMIF_ERRADRR10_RESETVAL (0x0000u)

/* ERRADRR11 */


#define CSL_EMIF_ERRADRR11_ERRADDR2_MASK (0x03FFu)
#define CSL_EMIF_ERRADRR11_ERRADDR2_SHIFT (0x0000u)
#define CSL_EMIF_ERRADRR11_ERRADDR2_RESETVAL (0x0000u)

#define CSL_EMIF_ERRADRR11_RESETVAL (0x0000u)

/* ERRADRR20 */


#define CSL_EMIF_ERRADRR20_ERRADDR1_MASK (0x03FFu)
#define CSL_EMIF_ERRADRR20_ERRADDR1_SHIFT (0x0000u)
#define CSL_EMIF_ERRADRR20_ERRADDR1_RESETVAL (0x0000u)

#define CSL_EMIF_ERRADRR20_RESETVAL (0x0000u)

/* ERRADRR21 */


#define CSL_EMIF_ERRADRR21_ERRADDR2_MASK (0x03FFu)
#define CSL_EMIF_ERRADRR21_ERRADDR2_SHIFT (0x0000u)
#define CSL_EMIF_ERRADRR21_ERRADDR2_RESETVAL (0x0000u)

#define CSL_EMIF_ERRADRR21_RESETVAL (0x0000u)

/* ERRVAL10 */


#define CSL_EMIF_ERRVAL10_ERRVAL1_MASK (0x03FFu)
#define CSL_EMIF_ERRVAL10_ERRVAL1_SHIFT (0x0000u)
#define CSL_EMIF_ERRVAL10_ERRVAL1_RESETVAL (0x0000u)

#define CSL_EMIF_ERRVAL10_RESETVAL (0x0000u)

/* ERRVAL11 */


#define CSL_EMIF_ERRVAL11_ERRVAL2_MASK (0x03FFu)
#define CSL_EMIF_ERRVAL11_ERRVAL2_SHIFT (0x0000u)
#define CSL_EMIF_ERRVAL11_ERRVAL2_RESETVAL (0x0000u)

#define CSL_EMIF_ERRVAL11_RESETVAL (0x0000u)

/* ERRVAL20 */


#define CSL_EMIF_ERRVAL20_ERRVAL1_MASK (0x03FFu)
#define CSL_EMIF_ERRVAL20_ERRVAL1_SHIFT (0x0000u)
#define CSL_EMIF_ERRVAL20_ERRVAL1_RESETVAL (0x0000u)

#define CSL_EMIF_ERRVAL20_RESETVAL (0x0000u)

/* ERRVAL21 */


#define CSL_EMIF_ERRVAL21_ERRVAL2_MASK (0x03FFu)
#define CSL_EMIF_ERRVAL21_ERRVAL2_SHIFT (0x0000u)
#define CSL_EMIF_ERRVAL21_ERRVAL2_RESETVAL (0x0000u)

#define CSL_EMIF_ERRVAL21_RESETVAL (0x0000u)

#endif
