/*****************************************************************************
 * File Name : cslr_usb_001.h 
 *
 * Brief	 : Define UART register structure
 *
 * Copyright (C) 2009 -2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
******************************************************************************/
#ifndef _CSLR__USB_1_H_
#define _CSLR__USB_1_H_

//#include <cslr.h>



#include <tistdtypes.h>

//#define CSL_USB_REGS                    ((CSL_UsbRegsOvly)0x8000)


/* Minimum unit = 2 bytes */

/**************************************************************************\
* Register Overlay Structure for EPTRG
\**************************************************************************/
typedef struct  {
    volatile Uint16 TXFUNCADDR;
    volatile Uint16 TXHUBADDR_PORT;
    volatile Uint16 RSVD0[2];
    volatile Uint16 RXFUNCADDR;
    volatile Uint16 RXHUBADDR_PORT;
    volatile Uint16 RSVD35[2];
} CSL_UsbEptrgRegs;

/**************************************************************************\
* Register Overlay Structure for EPCSR
\**************************************************************************/
typedef struct  {
    volatile Uint16 TXMAXP;
    volatile Uint16 PERI_CSR0;
    volatile Uint16 RSVD0[2];
    volatile Uint16 RXMAXP;
    volatile Uint16 PERI_RXCSR;
    volatile Uint16 RSVD1[2];
    volatile Uint16 COUNT0;
    volatile Uint16 RSVD2[4];
    volatile Uint16 CONFIGDATA_FIFOSIZE;
    volatile Uint16 RSVD37[2];
} CSL_UsbEpcsrRegs;

/**************************************************************************\
* Register Overlay Structure for CHANNEL
\**************************************************************************/
typedef struct  {
    volatile Uint16 TXCHGCFGRL;
    volatile Uint16 TXCHGCFGRH;
    volatile Uint16 RSVD0[6];
    volatile Uint16 RXCHGCRL;
    volatile Uint16 RXCHGCRH;
    volatile Uint16 RSVD1[2];
    volatile Uint16 RXCHHPCRAL;
    volatile Uint16 RXCHHPCRAH;
    volatile Uint16 RSVD2[2];
    volatile Uint16 RXCHHPCRBL;
    volatile Uint16 RXCHHPCRBH;
    volatile Uint16 RSVD39[14];
} CSL_UsbChannelRegs;

/**************************************************************************\
* Register Overlay Structure for CdmaScheTblWord
\**************************************************************************/
typedef struct  {
    volatile Uint16 SCHETBLWNL;
    volatile Uint16 SCHETBLWNH;
    volatile Uint16 RSVD42[2];
} CSL_UsbCdmaschetblwordRegs;

/**************************************************************************\
* Register Overlay Structure for QMMemRegR
\**************************************************************************/
typedef struct  {
    volatile Uint16 QMMRRBARL;
    volatile Uint16 QMMRRBARH;
    volatile Uint16 RSVD0[2];
    volatile Uint16 QMMRRCRL;
    volatile Uint16 QMMRRCRH;
    volatile Uint16 RSVD59[10];
} CSL_UsbQmmemregrRegs;

/**************************************************************************\
* Register Overlay Structure for QMQN
\**************************************************************************/
typedef struct  {
    volatile Uint16 QMMQNRAL;
    volatile Uint16 QMMQNRAH;
    volatile Uint16 RSVD0[2];
    volatile Uint16 QMMQNRBL;
    volatile Uint16 QMMQNRBH;
    volatile Uint16 RSVD1[2];
    volatile Uint16 QMMQNRCL;
    volatile Uint16 QMMQNRCH;
    volatile Uint16 RSVD2[2];
    volatile Uint16 QMMQNRDL;
    volatile Uint16 QMMQNRDH;
    volatile Uint16 RSVD61[2];
} CSL_UsbQmqnRegs;

/**************************************************************************\
* Register Overlay Structure for QMQNS
\**************************************************************************/
typedef struct  {
    volatile Uint16 QMMQNSRAL;
    volatile Uint16 QMMQNSRAH;
    volatile Uint16 RSVD0[2];
    volatile Uint16 QMMQNSRBL;
    volatile Uint16 QMMQNSRBH;
    volatile Uint16 RSVD1[2];
    volatile Uint16 QMMQNSRC;
    volatile Uint16 RSVD63[7];
} CSL_UsbQmqnsRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint16 REVRL;
    volatile Uint16 REVRH;
    volatile Uint16 RSVD0[2];
    volatile Uint16 CTRLRL;
    volatile Uint16 CTRLRH;
    volatile Uint16 RSVD1[2];
    volatile Uint16 STATR;
    volatile Uint16 RSVD2[3];
    volatile Uint16 EMUR;
    volatile Uint16 RSVD3[3];
    volatile Uint16 MODERL;
    volatile Uint16 MODERH;
    volatile Uint16 RSVD4[2];
    volatile Uint16 AUTOREQ;
    volatile Uint16 RSVD5[3];
    volatile Uint16 SRPFIXL;
    volatile Uint16 SRPFIXH;
    volatile Uint16 RSVD6[2];
    volatile Uint16 RXTDOWNL;
    volatile Uint16 RXTDOWNH;
    volatile Uint16 RSVD7[2];
    volatile Uint16 INTSRCRL;
    volatile Uint16 INTSRCRH;
    volatile Uint16 RSVD8[2];
    volatile Uint16 INTSETRL;
    volatile Uint16 INTSETRH;
    volatile Uint16 RSVD9[2];
    volatile Uint16 INTCLRRL;
    volatile Uint16 INTCLRRH;
    volatile Uint16 RSVD10[2];
    volatile Uint16 INTMSKRL;
    volatile Uint16 INTMSKRH;
    volatile Uint16 RSVD11[2];
    volatile Uint16 INTMSKSETRL;
    volatile Uint16 INTMSKSETRH;
    volatile Uint16 RSVD12[2];
    volatile Uint16 INTMSKCLRRL;
    volatile Uint16 INTMSKCLRRH;
    volatile Uint16 RSVD13[2];
    volatile Uint16 INTMASKEDRL;
    volatile Uint16 INTMASKEDRH;
    volatile Uint16 RSVD14[2];
    volatile Uint16 EOIR;
    volatile Uint16 RSVD15[3];
    volatile Uint16 INTVECTRL;
    volatile Uint16 INTVECTRH;
    volatile Uint16 RSVD16[14];
    volatile Uint16 GRNDISEP1L;
    volatile Uint16 GRNDISEP1H;
    volatile Uint16 RSVD17[2];
    volatile Uint16 GRNDISEP2L;
    volatile Uint16 GRNDISEP2H;
    volatile Uint16 RSVD18[2];
    volatile Uint16 GRNDISEP3L;
    volatile Uint16 GRNDISEP3H;
    volatile Uint16 RSVD19[2];
    volatile Uint16 GRNDISEP4L;
    volatile Uint16 GRNDISEP4H;
    volatile Uint16 RSVD20[930];
    volatile Uint16 FADDR_POWER;
    volatile Uint16 INTRTX;
    volatile Uint16 RSVD21[2];
    volatile Uint16 INTRRX;
    volatile Uint16 INTRTXE;
    volatile Uint16 RSVD22[2];
    volatile Uint16 INTRRXE;
    volatile Uint16 INTRUSB_INTRUSBE;
    volatile Uint16 RSVD23[2];
    volatile Uint16 FRAME;
    volatile Uint16 INDEX_TESTMODE;
    volatile Uint16 RSVD24[2];
    volatile Uint16 TXMAXP;
    volatile Uint16 PERI_CSR0;
    volatile Uint16 RSVD25[2];
    volatile Uint16 RXMAXP;
    volatile Uint16 PERI_RXCSR;
    volatile Uint16 RSVD26[2];
    volatile Uint16 COUNT0;
    volatile Uint16 HOST_TYPE0_HOST_NAKLIMIT0;
    volatile Uint16 RSVD27[2];
    volatile Uint16 HOST_RXTYPE_HOST_RXINTERVAL;
    volatile Uint16 CONFIGDATA;
    volatile Uint16 RSVD28[2];
    volatile Uint16 FIFO0L;
    volatile Uint16 FIFO0H;
    volatile Uint16 RSVD29[2];
    volatile Uint16 FIFO1L;
    volatile Uint16 FIFO1H;
    volatile Uint16 RSVD30[2];
    volatile Uint16 FIFO2L;
    volatile Uint16 FIFO2H;
    volatile Uint16 RSVD31[2];
    volatile Uint16 FIFO3L;
    volatile Uint16 FIFO3H;
    volatile Uint16 RSVD32[2];
    volatile Uint16 FIFO4L;
    volatile Uint16 FIFO4H;
    volatile Uint16 RSVD33[46];
    volatile Uint16 DEVCTL;
    volatile Uint16 TXRXFIFOSZ;
    volatile Uint16 RSVD34[2];
    volatile Uint16 TXFIFOADDR;
    volatile Uint16 RXFIFOADDR;
    volatile Uint16 RSVD36[26];
    CSL_UsbEptrgRegs EPTRG[5];
    volatile Uint16 RSVD38[88];
    CSL_UsbEpcsrRegs EPCSR[5];
    volatile Uint16 RSVD40[4784];
    CSL_UsbChannelRegs CHANNEL[4];
    volatile Uint16 RSVD41[1920];
    volatile Uint16 SCHECTRLL;
    volatile Uint16 SCHECTRLH;
    volatile Uint16 RSVD43[2046];
    CSL_UsbCdmaschetblwordRegs CDMASCHETBLWORD[64];
    volatile Uint16 RSVD44[1792];
    volatile Uint16 INTDRL;
    volatile Uint16 INTDRH;
    volatile Uint16 RSVD45[14];
    volatile Uint16 INTDEOIR;
    volatile Uint16 RSVD46[495];
    volatile Uint16 INTDSTATUSR0;
    volatile Uint16 RSVD47[3];
    volatile Uint16 INTDSTATUSR1L;
    volatile Uint16 INTDSTATUSR1H;
    volatile Uint16 RSVD48[3578];
    volatile Uint16 QMRRL;
    volatile Uint16 RSVD49[7];
    volatile Uint16 QMQRRL;
    volatile Uint16 QMQRRH;
    volatile Uint16 RSVD50[22];
    volatile Uint16 QMFDBSCR0L;
    volatile Uint16 QMFDBSCR0H;
    volatile Uint16 RSVD51[2];
    volatile Uint16 QMFDBSCR1L;
    volatile Uint16 QMFDBSCR1H;
    volatile Uint16 RSVD52[2];
    volatile Uint16 QMFDBSCR2L;
    volatile Uint16 QMFDBSCR2H;
    volatile Uint16 RSVD53[2];
    volatile Uint16 QMFDBSCR3L;
    volatile Uint16 QMFDBSCR3H;
    volatile Uint16 RSVD54[82];
    volatile Uint16 QMLRR0BARL;
    volatile Uint16 QMLRR0BARH;
    volatile Uint16 RSVD55[2];
    volatile Uint16 QMLRR0SRL;
    volatile Uint16 QMLRR0SRH;
    volatile Uint16 RSVD56[2];
    volatile Uint16 QMLRR1BARL;
    volatile Uint16 QMLRR1BARH;
    volatile Uint16 RSVD57[6];
    volatile Uint16 QMQPR0L;
    volatile Uint16 QMQPR0H;
    volatile Uint16 RSVD58[2];
    volatile Uint16 QMQPR1L;
    volatile Uint16 QMQPR1H;
    volatile Uint16 RSVD60[3946];
    CSL_UsbQmmemregrRegs QMMEMREGR[16];
    volatile Uint16 RSVD62[3840];
    CSL_UsbQmqnRegs QMQN[24];
    volatile Uint16 RSVD64[1664];
    CSL_UsbQmqnsRegs QMQNS[24];
} CSL_UsbRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* TXFUNCADDR */


#define CSL_USB_TXFUNCADDR_FUNCADDR_MASK (0x007Fu)
#define CSL_USB_TXFUNCADDR_FUNCADDR_SHIFT (0x0000u)
#define CSL_USB_TXFUNCADDR_FUNCADDR_RESETVAL (0x0000u)

#define CSL_USB_TXFUNCADDR_RESETVAL (0x0000u)

/* TXHUBADDR_PORT */



#define CSL_USB_TXHUBADDR_PORT_MULT_TRANS_MASK (0x0080u)
#define CSL_USB_TXHUBADDR_PORT_MULT_TRANS_SHIFT (0x0007u)
#define CSL_USB_TXHUBADDR_PORT_MULT_TRANS_RESETVAL (0x0000u)

#define CSL_USB_TXHUBADDR_PORT_HUBPORT_MASK (0x007Fu)
#define CSL_USB_TXHUBADDR_PORT_HUBPORT_SHIFT (0x0000u)
#define CSL_USB_TXHUBADDR_PORT_HUBPORT_RESETVAL (0x0000u)

#define CSL_USB_TXHUBADDR_PORT_HUBADDR_MASK (0x007Fu)
#define CSL_USB_TXHUBADDR_PORT_HUBADDR_SHIFT (0x0000u)
#define CSL_USB_TXHUBADDR_PORT_HUBADDR_RESETVAL (0x0000u)

#define CSL_USB_TXHUBADDR_PORT_RESETVAL (0x0000u)

/* RXFUNCADDR */


#define CSL_USB_RXFUNCADDR_FUNCADDR_MASK (0x007Fu)
#define CSL_USB_RXFUNCADDR_FUNCADDR_SHIFT (0x0000u)
#define CSL_USB_RXFUNCADDR_FUNCADDR_RESETVAL (0x0000u)

#define CSL_USB_RXFUNCADDR_RESETVAL (0x0000u)

/* RXHUBADDR_PORT */


#define CSL_USB_RXHUBADDR_PORT_HUBPORT_MASK (0x7F00u)
#define CSL_USB_RXHUBADDR_PORT_HUBPORT_SHIFT (0x0008u)
#define CSL_USB_RXHUBADDR_PORT_HUBPORT_RESETVAL (0x0000u)

#define CSL_USB_RXHUBADDR_PORT_MULT_TRANS_MASK (0x0080u)
#define CSL_USB_RXHUBADDR_PORT_MULT_TRANS_SHIFT (0x0007u)
#define CSL_USB_RXHUBADDR_PORT_MULT_TRANS_RESETVAL (0x0000u)

#define CSL_USB_RXHUBADDR_PORT_HUBADDR_MASK (0x007Fu)
#define CSL_USB_RXHUBADDR_PORT_HUBADDR_SHIFT (0x0000u)
#define CSL_USB_RXHUBADDR_PORT_HUBADDR_RESETVAL (0x0000u)

#define CSL_USB_RXHUBADDR_PORT_RESETVAL (0x0000u)

/* TXMAXP */


#define CSL_USB_TXMAXP_MAXPAYLOAD_MASK (0x07FFu)
#define CSL_USB_TXMAXP_MAXPAYLOAD_SHIFT (0x0000u)
#define CSL_USB_TXMAXP_MAXPAYLOAD_RESETVAL (0x0000u)

#define CSL_USB_TXMAXP_RESETVAL (0x0000u)

/* PERI_CSR0 */


#define CSL_USB_PERI_CSR0_FLUSHFIFO_MASK (0x0100u)
#define CSL_USB_PERI_CSR0_FLUSHFIFO_SHIFT (0x0008u)
#define CSL_USB_PERI_CSR0_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_SERV_SETUPEND_MASK (0x0080u)
#define CSL_USB_PERI_CSR0_SERV_SETUPEND_SHIFT (0x0007u)
#define CSL_USB_PERI_CSR0_SERV_SETUPEND_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_SERV_RXPKTRDY_MASK (0x0040u)
#define CSL_USB_PERI_CSR0_SERV_RXPKTRDY_SHIFT (0x0006u)
#define CSL_USB_PERI_CSR0_SERV_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_SENDSTALL_MASK (0x0020u)
#define CSL_USB_PERI_CSR0_SENDSTALL_SHIFT (0x0005u)
#define CSL_USB_PERI_CSR0_SENDSTALL_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_SETUPEND_MASK (0x0010u)
#define CSL_USB_PERI_CSR0_SETUPEND_SHIFT (0x0004u)
#define CSL_USB_PERI_CSR0_SETUPEND_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_DATAEND_MASK (0x0008u)
#define CSL_USB_PERI_CSR0_DATAEND_SHIFT (0x0003u)
#define CSL_USB_PERI_CSR0_DATAEND_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_SENTSTALL_MASK (0x0004u)
#define CSL_USB_PERI_CSR0_SENTSTALL_SHIFT (0x0002u)
#define CSL_USB_PERI_CSR0_SENTSTALL_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_TXPKTRDY_MASK (0x0002u)
#define CSL_USB_PERI_CSR0_TXPKTRDY_SHIFT (0x0001u)
#define CSL_USB_PERI_CSR0_TXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_RXPKTRDY_MASK (0x0001u)
#define CSL_USB_PERI_CSR0_RXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_PERI_CSR0_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_RESETVAL (0x0000u)

/* RXMAXP */


#define CSL_USB_RXMAXP_MAXPAYLOAD_MASK (0x07FFu)
#define CSL_USB_RXMAXP_MAXPAYLOAD_SHIFT (0x0000u)
#define CSL_USB_RXMAXP_MAXPAYLOAD_RESETVAL (0x0000u)

#define CSL_USB_RXMAXP_RESETVAL (0x0000u)

/* PERI_RXCSR */

#define CSL_USB_PERI_RXCSR_AUTOCLEAR_MASK (0x8000u)
#define CSL_USB_PERI_RXCSR_AUTOCLEAR_SHIFT (0x000Fu)
#define CSL_USB_PERI_RXCSR_AUTOCLEAR_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_ISO_MASK (0x4000u)
#define CSL_USB_PERI_RXCSR_ISO_SHIFT (0x000Eu)
#define CSL_USB_PERI_RXCSR_ISO_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_DMAEN_MASK (0x2000u)
#define CSL_USB_PERI_RXCSR_DMAEN_SHIFT (0x000Du)
#define CSL_USB_PERI_RXCSR_DMAEN_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_DISNYET_MASK (0x1000u)
#define CSL_USB_PERI_RXCSR_DISNYET_SHIFT (0x000Cu)
#define CSL_USB_PERI_RXCSR_DISNYET_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_DMAMODE_MASK (0x0800u)
#define CSL_USB_PERI_RXCSR_DMAMODE_SHIFT (0x000Bu)
#define CSL_USB_PERI_RXCSR_DMAMODE_RESETVAL (0x0000u)


#define CSL_USB_PERI_RXCSR_CLRDATATOG_MASK (0x0080u)
#define CSL_USB_PERI_RXCSR_CLRDATATOG_SHIFT (0x0007u)
#define CSL_USB_PERI_RXCSR_CLRDATATOG_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_SENTSTALL_MASK (0x0040u)
#define CSL_USB_PERI_RXCSR_SENTSTALL_SHIFT (0x0006u)
#define CSL_USB_PERI_RXCSR_SENTSTALL_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_SENDSTALL_MASK (0x0020u)
#define CSL_USB_PERI_RXCSR_SENDSTALL_SHIFT (0x0005u)
#define CSL_USB_PERI_RXCSR_SENDSTALL_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_FLUSHFIFO_MASK (0x0010u)
#define CSL_USB_PERI_RXCSR_FLUSHFIFO_SHIFT (0x0004u)
#define CSL_USB_PERI_RXCSR_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_DATAERROR_MASK (0x0008u)
#define CSL_USB_PERI_RXCSR_DATAERROR_SHIFT (0x0003u)
#define CSL_USB_PERI_RXCSR_DATAERROR_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_OVERRUN_MASK (0x0004u)
#define CSL_USB_PERI_RXCSR_OVERRUN_SHIFT (0x0002u)
#define CSL_USB_PERI_RXCSR_OVERRUN_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_FIFOFULL_MASK (0x0002u)
#define CSL_USB_PERI_RXCSR_FIFOFULL_SHIFT (0x0001u)
#define CSL_USB_PERI_RXCSR_FIFOFULL_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_RXPKTRDY_MASK (0x0001u)
#define CSL_USB_PERI_RXCSR_RXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_PERI_RXCSR_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_RESETVAL (0x0000u)

/* COUNT0 */


#define CSL_USB_COUNT0_EP0RXCOUNT_MASK (0x007Fu)
#define CSL_USB_COUNT0_EP0RXCOUNT_SHIFT (0x0000u)
#define CSL_USB_COUNT0_EP0RXCOUNT_RESETVAL (0x0000u)

#define CSL_USB_COUNT0_RESETVAL (0x0000u)

/* CONFIGDATA_FIFOSIZE */

#define CSL_USB_CONFIGDATA_FIFOSIZE_RXFIFOSZ_MASK (0xF000u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_RXFIFOSZ_SHIFT (0x000Cu)
#define CSL_USB_CONFIGDATA_FIFOSIZE_RXFIFOSZ_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_FIFOSIZE_TXFIFOSZ_MASK (0x0F00u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_TXFIFOSZ_SHIFT (0x0008u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_TXFIFOSZ_RESETVAL (0x0000u)


#define CSL_USB_CONFIGDATA_FIFOSIZE_MPTXE_MASK (0x0040u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_MPTXE_SHIFT (0x0006u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_MPTXE_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_FIFOSIZE_BIGENDIAN_MASK (0x0020u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_BIGENDIAN_SHIFT (0x0005u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_BIGENDIAN_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_FIFOSIZE_HBRXE_MASK (0x0010u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_HBRXE_SHIFT (0x0004u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_HBRXE_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_FIFOSIZE_HBTXE_MASK (0x0008u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_HBTXE_SHIFT (0x0003u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_HBTXE_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_FIFOSIZE_DYNFIFO_MASK (0x0004u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_DYNFIFO_SHIFT (0x0002u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_DYNFIFO_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_FIFOSIZE_SOFTCONE_MASK (0x0002u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_SOFTCONE_SHIFT (0x0001u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_SOFTCONE_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_FIFOSIZE_UTMIDATAWIDTH_MASK (0x0001u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_UTMIDATAWIDTH_SHIFT (0x0000u)
#define CSL_USB_CONFIGDATA_FIFOSIZE_UTMIDATAWIDTH_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_FIFOSIZE_RESETVAL (0x0000u)

/* TXCHGCFGRL */


#define CSL_USB_TXCHGCFGRL_TXDEFTQMGR_MASK (0x3000u)
#define CSL_USB_TXCHGCFGRL_TXDEFTQMGR_SHIFT (0x000Cu)
#define CSL_USB_TXCHGCFGRL_TXDEFTQMGR_RESETVAL (0x0000u)

#define CSL_USB_TXCHGCFGRL_TXDEFTQNUM_MASK (0x0FFFu)
#define CSL_USB_TXCHGCFGRL_TXDEFTQNUM_SHIFT (0x0000u)
#define CSL_USB_TXCHGCFGRL_TXDEFTQNUM_RESETVAL (0x0000u)

#define CSL_USB_TXCHGCFGRL_RESETVAL (0x0000u)

/* TXCHGCFGRH */

#define CSL_USB_TXCHGCFGRH_TXENABLE_MASK (0x8000u)
#define CSL_USB_TXCHGCFGRH_TXENABLE_SHIFT (0x000Fu)
#define CSL_USB_TXCHGCFGRH_TXENABLE_RESETVAL (0x0000u)

#define CSL_USB_TXCHGCFGRH_TXTEARDOWN_MASK (0x4000u)
#define CSL_USB_TXCHGCFGRH_TXTEARDOWN_SHIFT (0x000Eu)
#define CSL_USB_TXCHGCFGRH_TXTEARDOWN_RESETVAL (0x0000u)


#define CSL_USB_TXCHGCFGRH_RESETVAL (0x0000u)

/* RXCHGCRL */



#define CSL_USB_RXCHGCRL_RXDEFTRQQNUM_MASK (0x0FFFu)
#define CSL_USB_RXCHGCRL_RXDEFTRQQNUM_SHIFT (0x0000u)
#define CSL_USB_RXCHGCRL_RXDEFTRQQNUM_RESETVAL (0x0000u)

#define CSL_USB_RXCHGCRL_RESETVAL (0x0000u)

/* RXCHGCRH */

#define CSL_USB_RXCHGCRH_RXENABLE_MASK (0x8000u)
#define CSL_USB_RXCHGCRH_RXENABLE_SHIFT (0x000Fu)
#define CSL_USB_RXCHGCRH_RXENABLE_RESETVAL (0x0000u)

#define CSL_USB_RXCHGCRH_RXTEARDOWN_MASK (0x4000u)
#define CSL_USB_RXCHGCRH_RXTEARDOWN_SHIFT (0x000Eu)
#define CSL_USB_RXCHGCRH_RXTEARDOWN_RESETVAL (0x0000u)


#define CSL_USB_RXCHGCRH_RXERRHANDLING_MASK (0x0100u)
#define CSL_USB_RXCHGCRH_RXERRHANDLING_SHIFT (0x0008u)
#define CSL_USB_RXCHGCRH_RXERRHANDLING_RESETVAL (0x0000u)

#define CSL_USB_RXCHGCRH_RXSOPOFFSET_MASK (0x00FFu)
#define CSL_USB_RXCHGCRH_RXSOPOFFSET_SHIFT (0x0000u)
#define CSL_USB_RXCHGCRH_RXSOPOFFSET_RESETVAL (0x0000u)

#define CSL_USB_RXCHGCRH_RESETVAL (0x0000u)

/* RXCHHPCRAL */



#define CSL_USB_RXCHHPCRAL_RXHOSTFDQ0QNUM_MASK (0x0FFFu)
#define CSL_USB_RXCHHPCRAL_RXHOSTFDQ0QNUM_SHIFT (0x0000u)
#define CSL_USB_RXCHHPCRAL_RXHOSTFDQ0QNUM_RESETVAL (0x0000u)

#define CSL_USB_RXCHHPCRAL_RESETVAL (0x0000u)

/* RXCHHPCRAH */



#define CSL_USB_RXCHHPCRAH_RXHOSTFDQ1QNUM_MASK (0x0FFFu)
#define CSL_USB_RXCHHPCRAH_RXHOSTFDQ1QNUM_SHIFT (0x0000u)
#define CSL_USB_RXCHHPCRAH_RXHOSTFDQ1QNUM_RESETVAL (0x0000u)

#define CSL_USB_RXCHHPCRAH_RESETVAL (0x0000u)

/* RXCHHPCRBL */



#define CSL_USB_RXCHHPCRBL_RXHOSTFDQ2QNUM_MASK (0x0FFFu)
#define CSL_USB_RXCHHPCRBL_RXHOSTFDQ2QNUM_SHIFT (0x0000u)
#define CSL_USB_RXCHHPCRBL_RXHOSTFDQ2QNUM_RESETVAL (0x0000u)

#define CSL_USB_RXCHHPCRBL_RESETVAL (0x0000u)

/* RXCHHPCRBH */



#define CSL_USB_RXCHHPCRBH_RXHOSTFDQ3QNUM_MASK (0x0FFFu)
#define CSL_USB_RXCHHPCRBH_RXHOSTFDQ3QNUM_SHIFT (0x0000u)
#define CSL_USB_RXCHHPCRBH_RXHOSTFDQ3QNUM_RESETVAL (0x0000u)

#define CSL_USB_RXCHHPCRBH_RESETVAL (0x0000u)

/* SCHETBLWNL */

#define CSL_USB_SCHETBLWNL_ENTRY1_RXTX_MASK (0xFFE0u)
#define CSL_USB_SCHETBLWNL_ENTRY1_RXTX_SHIFT (0x0005u)
#define CSL_USB_SCHETBLWNL_ENTRY1_RXTX_RESETVAL (0x0000u)


#define CSL_USB_SCHETBLWNL_ENTRY1_CHAN_MASK (0x1F00u)
#define CSL_USB_SCHETBLWNL_ENTRY1_CHAN_SHIFT (0x0008u)
#define CSL_USB_SCHETBLWNL_ENTRY1_CHAN_RESETVAL (0x0000u)

#define CSL_USB_SCHETBLWNL_ENTRY0_RXTX_MASK (0x0080u)
#define CSL_USB_SCHETBLWNL_ENTRY0_RXTX_SHIFT (0x0007u)
#define CSL_USB_SCHETBLWNL_ENTRY0_RXTX_RESETVAL (0x0000u)


#define CSL_USB_SCHETBLWNL_ENTRY0_CHAN_MASK (0x001Fu)
#define CSL_USB_SCHETBLWNL_ENTRY0_CHAN_SHIFT (0x0000u)
#define CSL_USB_SCHETBLWNL_ENTRY0_CHAN_RESETVAL (0x0000u)

#define CSL_USB_SCHETBLWNL_RESETVAL (0x0000u)

/* SCHETBLWNH */

#define CSL_USB_SCHETBLWNH_ENTRY3_RXTX_MASK (0xFFE0u)
#define CSL_USB_SCHETBLWNH_ENTRY3_RXTX_SHIFT (0x0005u)
#define CSL_USB_SCHETBLWNH_ENTRY3_RXTX_RESETVAL (0x0000u)


#define CSL_USB_SCHETBLWNH_ENTRY3_CHAN_MASK (0x1F00u)
#define CSL_USB_SCHETBLWNH_ENTRY3_CHAN_SHIFT (0x0008u)
#define CSL_USB_SCHETBLWNH_ENTRY3_CHAN_RESETVAL (0x0000u)

#define CSL_USB_SCHETBLWNH_ENTRY2_RXTX_MASK (0x0080u)
#define CSL_USB_SCHETBLWNH_ENTRY2_RXTX_SHIFT (0x0007u)
#define CSL_USB_SCHETBLWNH_ENTRY2_RXTX_RESETVAL (0x0000u)


#define CSL_USB_SCHETBLWNH_ENTRY2_CHAN_MASK (0x001Fu)
#define CSL_USB_SCHETBLWNH_ENTRY2_CHAN_SHIFT (0x0000u)
#define CSL_USB_SCHETBLWNH_ENTRY2_CHAN_RESETVAL (0x0000u)

#define CSL_USB_SCHETBLWNH_RESETVAL (0x0000u)

/* QMMRRBARL */

#define CSL_USB_QMMRRBARL_BASE_MASK (0xFFFFu)
#define CSL_USB_QMMRRBARL_BASE_SHIFT (0x0000u)
#define CSL_USB_QMMRRBARL_BASE_RESETVAL (0x0000u)

#define CSL_USB_QMMRRBARL_RESETVAL (0x0000u)

/* QMMRRBARH */

#define CSL_USB_QMMRRBARH_BASE_MASK (0xFFFFu)
#define CSL_USB_QMMRRBARH_BASE_SHIFT (0x0000u)
#define CSL_USB_QMMRRBARH_BASE_RESETVAL (0x0000u)

#define CSL_USB_QMMRRBARH_RESETVAL (0x0000u)

/* QMMRRCRL */


#define CSL_USB_QMMRRCRL_DESC_SIZE_MASK (0x0F00u)
#define CSL_USB_QMMRRCRL_DESC_SIZE_SHIFT (0x0008u)
#define CSL_USB_QMMRRCRL_DESC_SIZE_RESETVAL (0x0000u)


#define CSL_USB_QMMRRCRL_REG_SIZE_MASK (0x0007u)
#define CSL_USB_QMMRRCRL_REG_SIZE_SHIFT (0x0000u)
#define CSL_USB_QMMRRCRL_REG_SIZE_RESETVAL (0x0000u)

#define CSL_USB_QMMRRCRL_RESETVAL (0x0000u)

/* QMMRRCRH */


#define CSL_USB_QMMRRCRH_START_INDEX_MASK (0x3FFFu)
#define CSL_USB_QMMRRCRH_START_INDEX_SHIFT (0x0000u)
#define CSL_USB_QMMRRCRH_START_INDEX_RESETVAL (0x0000u)

#define CSL_USB_QMMRRCRH_RESETVAL (0x0000u)

/* QMMQNRAL */


#define CSL_USB_QMMQNRAL_Q_ENTRY_COUNT_MASK (0x3FFFu)
#define CSL_USB_QMMQNRAL_Q_ENTRY_COUNT_SHIFT (0x0000u)
#define CSL_USB_QMMQNRAL_Q_ENTRY_COUNT_RESETVAL (0x0000u)

#define CSL_USB_QMMQNRAL_RESETVAL (0x0000u)

/* QMMQNRAH */


#define CSL_USB_QMMQNRAH_RESETVAL (0x0000u)

/* QMMQNRBL */

#define CSL_USB_QMMQNRBL_Q_BYTE_COUNT_MASK (0xFFFFu)
#define CSL_USB_QMMQNRBL_Q_BYTE_COUNT_SHIFT (0x0000u)
#define CSL_USB_QMMQNRBL_Q_BYTE_COUNT_RESETVAL (0x0000u)

#define CSL_USB_QMMQNRBL_RESETVAL (0x0000u)

/* QMMQNRBH */


#define CSL_USB_QMMQNRBH_Q_BYTE_COUNT_MASK (0x0FFFu)
#define CSL_USB_QMMQNRBH_Q_BYTE_COUNT_SHIFT (0x0000u)
#define CSL_USB_QMMQNRBH_Q_BYTE_COUNT_RESETVAL (0x0000u)

#define CSL_USB_QMMQNRBH_RESETVAL (0x0000u)

/* QMMQNRCL */


#define CSL_USB_QMMQNRCL_PACKET_SIZE_MASK (0x3FFFu)
#define CSL_USB_QMMQNRCL_PACKET_SIZE_SHIFT (0x0000u)
#define CSL_USB_QMMQNRCL_PACKET_SIZE_RESETVAL (0x0000u)

#define CSL_USB_QMMQNRCL_RESETVAL (0x0000u)

/* QMMQNRCH */

#define CSL_USB_QMMQNRCH_HEAD_TAIL_MASK (0x8000u)
#define CSL_USB_QMMQNRCH_HEAD_TAIL_SHIFT (0x000Fu)
#define CSL_USB_QMMQNRCH_HEAD_TAIL_RESETVAL (0x0000u)


#define CSL_USB_QMMQNRCH_RESETVAL (0x0000u)

/* QMMQNRDL */

#define CSL_USB_QMMQNRDL_DESC_PTR_MASK (0xFFE0u)
#define CSL_USB_QMMQNRDL_DESC_PTR_SHIFT (0x0005u)
#define CSL_USB_QMMQNRDL_DESC_PTR_RESETVAL (0x0000u)

#define CSL_USB_QMMQNRDL_DESC_SIZE_MASK (0x001Fu)
#define CSL_USB_QMMQNRDL_DESC_SIZE_SHIFT (0x0000u)
#define CSL_USB_QMMQNRDL_DESC_SIZE_RESETVAL (0x0000u)

#define CSL_USB_QMMQNRDL_RESETVAL (0x0000u)

/* QMMQNRDH */

#define CSL_USB_QMMQNRDH_DESC_PTR_MASK (0xFFFFu)
#define CSL_USB_QMMQNRDH_DESC_PTR_SHIFT (0x0000u)
#define CSL_USB_QMMQNRDH_DESC_PTR_RESETVAL (0x0000u)

#define CSL_USB_QMMQNRDH_RESETVAL (0x0000u)

/* QMMQNSRAL */


#define CSL_USB_QMMQNSRAL_Q_ENTRY_COUNT_MASK (0x3FFFu)
#define CSL_USB_QMMQNSRAL_Q_ENTRY_COUNT_SHIFT (0x0000u)
#define CSL_USB_QMMQNSRAL_Q_ENTRY_COUNT_RESETVAL (0x0000u)

#define CSL_USB_QMMQNSRAL_RESETVAL (0x0000u)

/* QMMQNSRAH */


#define CSL_USB_QMMQNSRAH_RESETVAL (0x0000u)

/* QMMQNSRBL */

#define CSL_USB_QMMQNSRBL_Q_BYTE_COUNT_MASK (0xFFFFu)
#define CSL_USB_QMMQNSRBL_Q_BYTE_COUNT_SHIFT (0x0000u)
#define CSL_USB_QMMQNSRBL_Q_BYTE_COUNT_RESETVAL (0x0000u)

#define CSL_USB_QMMQNSRBL_RESETVAL (0x0000u)

/* QMMQNSRBH */


#define CSL_USB_QMMQNSRBH_Q_BYTE_COUNT_MASK (0x0FFFu)
#define CSL_USB_QMMQNSRBH_Q_BYTE_COUNT_SHIFT (0x0000u)
#define CSL_USB_QMMQNSRBH_Q_BYTE_COUNT_RESETVAL (0x0000u)

#define CSL_USB_QMMQNSRBH_RESETVAL (0x0000u)

/* QMMQNSRC */


#define CSL_USB_QMMQNSRC_PACKET_SIZE_MASK (0x3FFFu)
#define CSL_USB_QMMQNSRC_PACKET_SIZE_SHIFT (0x0000u)
#define CSL_USB_QMMQNSRC_PACKET_SIZE_RESETVAL (0x0000u)

#define CSL_USB_QMMQNSRC_RESETVAL (0x0000u)

/* REVRL */

#define CSL_USB_REVRL_REVRTL_MASK (0xF800u)
#define CSL_USB_REVRL_REVRTL_SHIFT (0x000Bu)
#define CSL_USB_REVRL_REVRTL_RESETVAL (0x0001u)

#define CSL_USB_REVRL_REVMAJ_MASK (0x0700u)
#define CSL_USB_REVRL_REVMAJ_SHIFT (0x0008u)
#define CSL_USB_REVRL_REVMAJ_RESETVAL (0x0000u)

#define CSL_USB_REVRL_REVMIN_MASK (0x00FFu)
#define CSL_USB_REVRL_REVMIN_SHIFT (0x0000u)
#define CSL_USB_REVRL_REVMIN_RESETVAL (0x0000u)

#define CSL_USB_REVRL_RESETVAL (0x0800u)

/* REVRH */


#define CSL_USB_REVRH_MODID_MASK (0x0FFFu)
#define CSL_USB_REVRH_MODID_SHIFT (0x0000u)
#define CSL_USB_REVRH_MODID_RESETVAL (0x0EA0u)

#define CSL_USB_REVRH_RESETVAL (0x4EA0u)

/* CTRLRL */


#define CSL_USB_CTRLRL_RNDIS_MASK (0x0010u)
#define CSL_USB_CTRLRL_RNDIS_SHIFT (0x0004u)
#define CSL_USB_CTRLRL_RNDIS_RESETVAL (0x0000u)

#define CSL_USB_CTRLRL_UINT_MASK (0x0008u)
#define CSL_USB_CTRLRL_UINT_SHIFT (0x0003u)
#define CSL_USB_CTRLRL_UINT_RESETVAL (0x0000u)


#define CSL_USB_CTRLRL_CLKFACK_MASK (0x0002u)
#define CSL_USB_CTRLRL_CLKFACK_SHIFT (0x0001u)
#define CSL_USB_CTRLRL_CLKFACK_RESETVAL (0x0000u)

#define CSL_USB_CTRLRL_RESET_MASK (0x0001u)
#define CSL_USB_CTRLRL_RESET_SHIFT (0x0000u)
#define CSL_USB_CTRLRL_RESET_RESETVAL (0x0000u)

#define CSL_USB_CTRLRL_RESETVAL (0x0000u)

/* CTRLRH */

#define CSL_USB_CTRLRH_DISDEB_MASK (0x8000u)
#define CSL_USB_CTRLRH_DISDEB_SHIFT (0x000Fu)
#define CSL_USB_CTRLRH_DISDEB_RESETVAL (0x0000u)

#define CSL_USB_CTRLRH_DISSRP_MASK (0x4000u)
#define CSL_USB_CTRLRH_DISSRP_SHIFT (0x000Eu)
#define CSL_USB_CTRLRH_DISSRP_RESETVAL (0x0000u)


#define CSL_USB_CTRLRH_RESETVAL (0x0000u)

/* STATR */


#define CSL_USB_STATR_DRVVBUS_MASK (0x0001u)
#define CSL_USB_STATR_DRVVBUS_SHIFT (0x0000u)
#define CSL_USB_STATR_DRVVBUS_RESETVAL (0x0000u)

#define CSL_USB_STATR_RESETVAL (0x0000u)

/* EMUR */


#define CSL_USB_EMUR_RTSEL_MASK (0x0004u)
#define CSL_USB_EMUR_RTSEL_SHIFT (0x0002u)
#define CSL_USB_EMUR_RTSEL_RESETVAL (0x0000u)

#define CSL_USB_EMUR_SOFT_MASK (0x0002u)
#define CSL_USB_EMUR_SOFT_SHIFT (0x0001u)
#define CSL_USB_EMUR_SOFT_RESETVAL (0x0001u)

#define CSL_USB_EMUR_FREERUN_MASK (0x0001u)
#define CSL_USB_EMUR_FREERUN_SHIFT (0x0000u)
#define CSL_USB_EMUR_FREERUN_RESETVAL (0x0001u)

#define CSL_USB_EMUR_RESETVAL (0x0003u)

/* MODERL */


#define CSL_USB_MODERL_TX4MODE_MASK (0x3000u)
#define CSL_USB_MODERL_TX4MODE_SHIFT (0x000Cu)
#define CSL_USB_MODERL_TX4MODE_RESETVAL (0x0000u)


#define CSL_USB_MODERL_TX3MODE_MASK (0x0300u)
#define CSL_USB_MODERL_TX3MODE_SHIFT (0x0008u)
#define CSL_USB_MODERL_TX3MODE_RESETVAL (0x0000u)


#define CSL_USB_MODERL_TX2MODE_MASK (0x0030u)
#define CSL_USB_MODERL_TX2MODE_SHIFT (0x0004u)
#define CSL_USB_MODERL_TX2MODE_RESETVAL (0x0000u)


#define CSL_USB_MODERL_TX1MODE_MASK (0x0003u)
#define CSL_USB_MODERL_TX1MODE_SHIFT (0x0000u)
#define CSL_USB_MODERL_TX1MODE_RESETVAL (0x0000u)

#define CSL_USB_MODERL_RESETVAL (0x0000u)

/* MODERH */


#define CSL_USB_MODERH_RX4MODE_MASK (0x3000u)
#define CSL_USB_MODERH_RX4MODE_SHIFT (0x000Cu)
#define CSL_USB_MODERH_RX4MODE_RESETVAL (0x0000u)


#define CSL_USB_MODERH_RX3MODE_MASK (0x0300u)
#define CSL_USB_MODERH_RX3MODE_SHIFT (0x0008u)
#define CSL_USB_MODERH_RX3MODE_RESETVAL (0x0000u)


#define CSL_USB_MODERH_RX2MODE_MASK (0x0030u)
#define CSL_USB_MODERH_RX2MODE_SHIFT (0x0004u)
#define CSL_USB_MODERH_RX2MODE_RESETVAL (0x0000u)


#define CSL_USB_MODERH_RX1MODE_MASK (0x0003u)
#define CSL_USB_MODERH_RX1MODE_SHIFT (0x0000u)
#define CSL_USB_MODERH_RX1MODE_RESETVAL (0x0000u)

#define CSL_USB_MODERH_RESETVAL (0x0000u)

/* AUTOREQ */


#define CSL_USB_AUTOREQ_RX4_AUTOREQ_MASK (0x00C0u)
#define CSL_USB_AUTOREQ_RX4_AUTOREQ_SHIFT (0x0006u)
#define CSL_USB_AUTOREQ_RX4_AUTOREQ_RESETVAL (0x0000u)

#define CSL_USB_AUTOREQ_RX3_AUTOREQ_MASK (0x0030u)
#define CSL_USB_AUTOREQ_RX3_AUTOREQ_SHIFT (0x0004u)
#define CSL_USB_AUTOREQ_RX3_AUTOREQ_RESETVAL (0x0000u)

#define CSL_USB_AUTOREQ_RX2_AUTOREQ_MASK (0x000Cu)
#define CSL_USB_AUTOREQ_RX2_AUTOREQ_SHIFT (0x0002u)
#define CSL_USB_AUTOREQ_RX2_AUTOREQ_RESETVAL (0x0000u)

#define CSL_USB_AUTOREQ_RX1_AUTOREQ_MASK (0x0003u)
#define CSL_USB_AUTOREQ_RX1_AUTOREQ_SHIFT (0x0000u)
#define CSL_USB_AUTOREQ_RX1_AUTOREQ_RESETVAL (0x0000u)

#define CSL_USB_AUTOREQ_RESETVAL (0x0000u)

/* SRPFIXL */

#define CSL_USB_SRPFIXL_SRPFIXTIME_MASK (0xFFFFu)
#define CSL_USB_SRPFIXL_SRPFIXTIME_SHIFT (0x0000u)
#define CSL_USB_SRPFIXL_SRPFIXTIME_RESETVAL (0xDE80u)

#define CSL_USB_SRPFIXL_RESETVAL (0xDE80u)

/* SRPFIXH */

#define CSL_USB_SRPFIXH_SRPFIXTIME_MASK (0xFFFFu)
#define CSL_USB_SRPFIXH_SRPFIXTIME_SHIFT (0x0000u)
#define CSL_USB_SRPFIXH_SRPFIXTIME_RESETVAL (0x0280u)

#define CSL_USB_SRPFIXH_RESETVAL (0x0280u)

/* RXTDOWNL */


#define CSL_USB_RXTDOWNL_RX_TDOWN_MASK (0x001Eu)
#define CSL_USB_RXTDOWNL_RX_TDOWN_SHIFT (0x0001u)
#define CSL_USB_RXTDOWNL_RX_TDOWN_RESETVAL (0x0000u)


#define CSL_USB_RXTDOWNL_RESETVAL (0x0000u)

/* RXTDOWNH */


#define CSL_USB_RXTDOWNH_TX_TDOWN_MASK (0x001Eu)
#define CSL_USB_RXTDOWNH_TX_TDOWN_SHIFT (0x0001u)
#define CSL_USB_RXTDOWNH_TX_TDOWN_RESETVAL (0x0000u)


#define CSL_USB_RXTDOWNH_RESETVAL (0x0000u)

/* INTSRCRL */


#define CSL_USB_INTSRCRL_RX_MASK (0x1E00u)
#define CSL_USB_INTSRCRL_RX_SHIFT (0x0009u)
#define CSL_USB_INTSRCRL_RX_RESETVAL (0x0000u)


#define CSL_USB_INTSRCRL_TX_MASK (0x001Fu)
#define CSL_USB_INTSRCRL_TX_SHIFT (0x0000u)
#define CSL_USB_INTSRCRL_TX_RESETVAL (0x0000u)

#define CSL_USB_INTSRCRL_RESETVAL (0x0000u)

/* INTSRCRH */


#define CSL_USB_INTSRCRH_USB_MASK (0x01FFu)
#define CSL_USB_INTSRCRH_USB_SHIFT (0x0000u)
#define CSL_USB_INTSRCRH_USB_RESETVAL (0x0000u)

#define CSL_USB_INTSRCRH_RESETVAL (0x0000u)

/* INTSETRL */


#define CSL_USB_INTSETRL_RX_MASK (0x1F00u)
#define CSL_USB_INTSETRL_RX_SHIFT (0x0008u)
#define CSL_USB_INTSETRL_RX_RESETVAL (0x0000u)


#define CSL_USB_INTSETRL_TX_MASK (0x001Fu)
#define CSL_USB_INTSETRL_TX_SHIFT (0x0000u)
#define CSL_USB_INTSETRL_TX_RESETVAL (0x0000u)

#define CSL_USB_INTSETRL_RESETVAL (0x0000u)

/* INTSETRH */


#define CSL_USB_INTSETRH_USB_MASK (0x01FFu)
#define CSL_USB_INTSETRH_USB_SHIFT (0x0000u)
#define CSL_USB_INTSETRH_USB_RESETVAL (0x0000u)

#define CSL_USB_INTSETRH_RESETVAL (0x0000u)

/* INTCLRRL */


#define CSL_USB_INTCLRRL_RX_MASK (0x1F00u)
#define CSL_USB_INTCLRRL_RX_SHIFT (0x0008u)
#define CSL_USB_INTCLRRL_RX_RESETVAL (0x0000u)


#define CSL_USB_INTCLRRL_TX_MASK (0x001Fu)
#define CSL_USB_INTCLRRL_TX_SHIFT (0x0000u)
#define CSL_USB_INTCLRRL_TX_RESETVAL (0x0000u)

#define CSL_USB_INTCLRRL_RESETVAL (0x0000u)

/* INTCLRRH */


#define CSL_USB_INTCLRRH_USB_MASK (0x01FFu)
#define CSL_USB_INTCLRRH_USB_SHIFT (0x0000u)
#define CSL_USB_INTCLRRH_USB_RESETVAL (0x0000u)

#define CSL_USB_INTCLRRH_RESETVAL (0x0000u)

/* INTMSKRL */


#define CSL_USB_INTMSKRL_RX_MASK (0x1F00u)
#define CSL_USB_INTMSKRL_RX_SHIFT (0x0008u)
#define CSL_USB_INTMSKRL_RX_RESETVAL (0x0000u)


#define CSL_USB_INTMSKRL_TX_MASK (0x001Fu)
#define CSL_USB_INTMSKRL_TX_SHIFT (0x0000u)
#define CSL_USB_INTMSKRL_TX_RESETVAL (0x0000u)

#define CSL_USB_INTMSKRL_RESETVAL (0x0000u)

/* INTMSKRH */


#define CSL_USB_INTMSKRH_USB_MASK (0x01FFu)
#define CSL_USB_INTMSKRH_USB_SHIFT (0x0000u)
#define CSL_USB_INTMSKRH_USB_RESETVAL (0x0000u)

#define CSL_USB_INTMSKRH_RESETVAL (0x0000u)

/* INTMSKSETRL */


#define CSL_USB_INTMSKSETRL_RX_MASK (0x1F00u)
#define CSL_USB_INTMSKSETRL_RX_SHIFT (0x0008u)
#define CSL_USB_INTMSKSETRL_RX_RESETVAL (0x0000u)


#define CSL_USB_INTMSKSETRL_TX_MASK (0x001Fu)
#define CSL_USB_INTMSKSETRL_TX_SHIFT (0x0000u)
#define CSL_USB_INTMSKSETRL_TX_RESETVAL (0x0000u)

#define CSL_USB_INTMSKSETRL_RESETVAL (0x0000u)

/* INTMSKSETRH */


#define CSL_USB_INTMSKSETRH_USB_MASK (0x01FFu)
#define CSL_USB_INTMSKSETRH_USB_SHIFT (0x0000u)
#define CSL_USB_INTMSKSETRH_USB_RESETVAL (0x0000u)

#define CSL_USB_INTMSKSETRH_RESETVAL (0x0000u)

/* INTMSKCLRRL */


#define CSL_USB_INTMSKCLRRL_RX_MASK (0x1F00u)
#define CSL_USB_INTMSKCLRRL_RX_SHIFT (0x0008u)
#define CSL_USB_INTMSKCLRRL_RX_RESETVAL (0x0000u)


#define CSL_USB_INTMSKCLRRL_TX_MASK (0x001Fu)
#define CSL_USB_INTMSKCLRRL_TX_SHIFT (0x0000u)
#define CSL_USB_INTMSKCLRRL_TX_RESETVAL (0x0000u)

#define CSL_USB_INTMSKCLRRL_RESETVAL (0x0000u)

/* INTMSKCLRRH */


#define CSL_USB_INTMSKCLRRH_USB_MASK (0x01FFu)
#define CSL_USB_INTMSKCLRRH_USB_SHIFT (0x0000u)
#define CSL_USB_INTMSKCLRRH_USB_RESETVAL (0x0000u)

#define CSL_USB_INTMSKCLRRH_RESETVAL (0x0000u)

/* INTMASKEDRL */


#define CSL_USB_INTMASKEDRL_RX_MASK (0x1F00u)
#define CSL_USB_INTMASKEDRL_RX_SHIFT (0x0008u)
#define CSL_USB_INTMASKEDRL_RX_RESETVAL (0x0000u)


#define CSL_USB_INTMASKEDRL_TX_MASK (0x001Fu)
#define CSL_USB_INTMASKEDRL_TX_SHIFT (0x0000u)
#define CSL_USB_INTMASKEDRL_TX_RESETVAL (0x0000u)

#define CSL_USB_INTMASKEDRL_RESETVAL (0x0000u)

/* INTMASKEDRH */


#define CSL_USB_INTMASKEDRH_USB_MASK (0x01FFu)
#define CSL_USB_INTMASKEDRH_USB_SHIFT (0x0000u)
#define CSL_USB_INTMASKEDRH_USB_RESETVAL (0x0000u)

#define CSL_USB_INTMASKEDRH_RESETVAL (0x0000u)

/* EOIR */


#define CSL_USB_EOIR_VECTOR_MASK (0x00FFu)
#define CSL_USB_EOIR_VECTOR_SHIFT (0x0000u)
#define CSL_USB_EOIR_VECTOR_RESETVAL (0x0000u)

#define CSL_USB_EOIR_RESETVAL (0x0000u)

/* INTVECTRL */

#define CSL_USB_INTVECTRL_VECTOR_MASK (0xFFFFu)
#define CSL_USB_INTVECTRL_VECTOR_SHIFT (0x0000u)
#define CSL_USB_INTVECTRL_VECTOR_RESETVAL (0x0000u)

#define CSL_USB_INTVECTRL_RESETVAL (0x0000u)

/* INTVECTRH */

#define CSL_USB_INTVECTRH_VECTOR_MASK (0xFFFFu)
#define CSL_USB_INTVECTRH_VECTOR_SHIFT (0x0000u)
#define CSL_USB_INTVECTRH_VECTOR_RESETVAL (0x0000u)

#define CSL_USB_INTVECTRH_RESETVAL (0x0000u)

/* GRNDISEP1L */

#define CSL_USB_GRNDISEP1L_SIZE_MASK (0xFFFFu)
#define CSL_USB_GRNDISEP1L_SIZE_SHIFT (0x0000u)
#define CSL_USB_GRNDISEP1L_SIZE_RESETVAL (0x0000u)

#define CSL_USB_GRNDISEP1L_RESETVAL (0x0000u)

/* GRNDISEP1H */


#define CSL_USB_GRNDISEP1H_SIZE_MASK (0x0001u)
#define CSL_USB_GRNDISEP1H_SIZE_SHIFT (0x0000u)
#define CSL_USB_GRNDISEP1H_SIZE_RESETVAL (0x0000u)

#define CSL_USB_GRNDISEP1H_RESETVAL (0x0000u)

/* GRNDISEP2L */

#define CSL_USB_GRNDISEP2L_SIZE_MASK (0xFFFFu)
#define CSL_USB_GRNDISEP2L_SIZE_SHIFT (0x0000u)
#define CSL_USB_GRNDISEP2L_SIZE_RESETVAL (0x0000u)

#define CSL_USB_GRNDISEP2L_RESETVAL (0x0000u)

/* GRNDISEP2H */


#define CSL_USB_GRNDISEP2H_SIZE_MASK (0x0001u)
#define CSL_USB_GRNDISEP2H_SIZE_SHIFT (0x0000u)
#define CSL_USB_GRNDISEP2H_SIZE_RESETVAL (0x0000u)

#define CSL_USB_GRNDISEP2H_RESETVAL (0x0000u)

/* GRNDISEP3L */

#define CSL_USB_GRNDISEP3L_SIZE_MASK (0xFFFFu)
#define CSL_USB_GRNDISEP3L_SIZE_SHIFT (0x0000u)
#define CSL_USB_GRNDISEP3L_SIZE_RESETVAL (0x0000u)

#define CSL_USB_GRNDISEP3L_RESETVAL (0x0000u)

/* GRNDISEP3H */


#define CSL_USB_GRNDISEP3H_SIZE_MASK (0x0001u)
#define CSL_USB_GRNDISEP3H_SIZE_SHIFT (0x0000u)
#define CSL_USB_GRNDISEP3H_SIZE_RESETVAL (0x0000u)

#define CSL_USB_GRNDISEP3H_RESETVAL (0x0000u)

/* GRNDISEP4L */

#define CSL_USB_GRNDISEP4L_SIZE_MASK (0xFFFFu)
#define CSL_USB_GRNDISEP4L_SIZE_SHIFT (0x0000u)
#define CSL_USB_GRNDISEP4L_SIZE_RESETVAL (0x0000u)

#define CSL_USB_GRNDISEP4L_RESETVAL (0x0000u)

/* GRNDISEP4H */


#define CSL_USB_GRNDISEP4H_SIZE_MASK (0x0001u)
#define CSL_USB_GRNDISEP4H_SIZE_SHIFT (0x0000u)
#define CSL_USB_GRNDISEP4H_SIZE_RESETVAL (0x0000u)

#define CSL_USB_GRNDISEP4H_RESETVAL (0x0000u)

/* FADDR_POWER */

#define CSL_USB_FADDR_POWER_ISOUPDATE_MASK (0x8000u)
#define CSL_USB_FADDR_POWER_ISOUPDATE_SHIFT (0x000Fu)
#define CSL_USB_FADDR_POWER_ISOUPDATE_RESETVAL (0x0000u)

#define CSL_USB_FADDR_POWER_SOFTCONN_MASK (0x4000u)
#define CSL_USB_FADDR_POWER_SOFTCONN_SHIFT (0x000Eu)
#define CSL_USB_FADDR_POWER_SOFTCONN_RESETVAL (0x0000u)

#define CSL_USB_FADDR_POWER_HSEN_MASK (0x2000u)
#define CSL_USB_FADDR_POWER_HSEN_SHIFT (0x000Du)
#define CSL_USB_FADDR_POWER_HSEN_RESETVAL (0x0001u)

#define CSL_USB_FADDR_POWER_HSMODE_MASK (0x1000u)
#define CSL_USB_FADDR_POWER_HSMODE_SHIFT (0x000Cu)
#define CSL_USB_FADDR_POWER_HSMODE_RESETVAL (0x0000u)

#define CSL_USB_FADDR_POWER_RESET_MASK (0x0800u)
#define CSL_USB_FADDR_POWER_RESET_SHIFT (0x000Bu)
#define CSL_USB_FADDR_POWER_RESET_RESETVAL (0x0000u)

#define CSL_USB_FADDR_POWER_RESUME_MASK (0x0C00u)
#define CSL_USB_FADDR_POWER_RESUME_SHIFT (0x000Au)
#define CSL_USB_FADDR_POWER_RESUME_RESETVAL (0x0000u)

#define CSL_USB_FADDR_POWER_SUSPENDM_MASK (0x0200u)
#define CSL_USB_FADDR_POWER_SUSPENDM_SHIFT (0x0009u)
#define CSL_USB_FADDR_POWER_SUSPENDM_RESETVAL (0x0000u)

#define CSL_USB_FADDR_POWER_ENSUSPM_MASK (0x0100u)
#define CSL_USB_FADDR_POWER_ENSUSPM_SHIFT (0x0008u)
#define CSL_USB_FADDR_POWER_ENSUSPM_RESETVAL (0x0000u)


#define CSL_USB_FADDR_POWER_FUNCADDR_MASK (0x007Fu)
#define CSL_USB_FADDR_POWER_FUNCADDR_SHIFT (0x0000u)
#define CSL_USB_FADDR_POWER_FUNCADDR_RESETVAL (0x0000u)

#define CSL_USB_FADDR_POWER_RESETVAL (0x2000u)

/* INTRTX */


#define CSL_USB_INTRTX_EP4TX_MASK (0x0010u)
#define CSL_USB_INTRTX_EP4TX_SHIFT (0x0004u)
#define CSL_USB_INTRTX_EP4TX_RESETVAL (0x0000u)

#define CSL_USB_INTRTX_EP3TX_MASK (0x0008u)
#define CSL_USB_INTRTX_EP3TX_SHIFT (0x0003u)
#define CSL_USB_INTRTX_EP3TX_RESETVAL (0x0000u)

#define CSL_USB_INTRTX_EP2TX_MASK (0x0004u)
#define CSL_USB_INTRTX_EP2TX_SHIFT (0x0002u)
#define CSL_USB_INTRTX_EP2TX_RESETVAL (0x0000u)

#define CSL_USB_INTRTX_EP1TX_MASK (0x0002u)
#define CSL_USB_INTRTX_EP1TX_SHIFT (0x0001u)
#define CSL_USB_INTRTX_EP1TX_RESETVAL (0x0000u)

#define CSL_USB_INTRTX_EP0_MASK (0x0001u)
#define CSL_USB_INTRTX_EP0_SHIFT (0x0000u)
#define CSL_USB_INTRTX_EP0_RESETVAL (0x0000u)

#define CSL_USB_INTRTX_RESETVAL (0x0000u)

/* INTRRX */


#define CSL_USB_INTRRX_EP4RX_MASK (0x0010u)
#define CSL_USB_INTRRX_EP4RX_SHIFT (0x0004u)
#define CSL_USB_INTRRX_EP4RX_RESETVAL (0x0000u)

#define CSL_USB_INTRRX_EP3RX_MASK (0x0008u)
#define CSL_USB_INTRRX_EP3RX_SHIFT (0x0003u)
#define CSL_USB_INTRRX_EP3RX_RESETVAL (0x0000u)

#define CSL_USB_INTRRX_EP2RX_MASK (0x0004u)
#define CSL_USB_INTRRX_EP2RX_SHIFT (0x0002u)
#define CSL_USB_INTRRX_EP2RX_RESETVAL (0x0000u)

#define CSL_USB_INTRRX_EP1RX_MASK (0x0002u)
#define CSL_USB_INTRRX_EP1RX_SHIFT (0x0001u)
#define CSL_USB_INTRRX_EP1RX_RESETVAL (0x0000u)


#define CSL_USB_INTRRX_RESETVAL (0x0000u)

/* INTRTXE */


#define CSL_USB_INTRTXE_EP4TX_MASK (0x0010u)
#define CSL_USB_INTRTXE_EP4TX_SHIFT (0x0004u)
#define CSL_USB_INTRTXE_EP4TX_RESETVAL (0x0001u)

#define CSL_USB_INTRTXE_EP3TX_MASK (0x0008u)
#define CSL_USB_INTRTXE_EP3TX_SHIFT (0x0003u)
#define CSL_USB_INTRTXE_EP3TX_RESETVAL (0x0001u)

#define CSL_USB_INTRTXE_EP2TX_MASK (0x0004u)
#define CSL_USB_INTRTXE_EP2TX_SHIFT (0x0002u)
#define CSL_USB_INTRTXE_EP2TX_RESETVAL (0x0001u)

#define CSL_USB_INTRTXE_EP1TX_MASK (0x0002u)
#define CSL_USB_INTRTXE_EP1TX_SHIFT (0x0001u)
#define CSL_USB_INTRTXE_EP1TX_RESETVAL (0x0001u)

#define CSL_USB_INTRTXE_EP0_MASK (0x0001u)
#define CSL_USB_INTRTXE_EP0_SHIFT (0x0000u)
#define CSL_USB_INTRTXE_EP0_RESETVAL (0x0001u)

#define CSL_USB_INTRTXE_RESETVAL (0x001Fu)

/* INTRRXE */


#define CSL_USB_INTRRXE_EP4RX_MASK (0x0010u)
#define CSL_USB_INTRRXE_EP4RX_SHIFT (0x0004u)
#define CSL_USB_INTRRXE_EP4RX_RESETVAL (0x0001u)

#define CSL_USB_INTRRXE_EP3RX_MASK (0x0008u)
#define CSL_USB_INTRRXE_EP3RX_SHIFT (0x0003u)
#define CSL_USB_INTRRXE_EP3RX_RESETVAL (0x0001u)

#define CSL_USB_INTRRXE_EP2RX_MASK (0x0004u)
#define CSL_USB_INTRRXE_EP2RX_SHIFT (0x0002u)
#define CSL_USB_INTRRXE_EP2RX_RESETVAL (0x0001u)

#define CSL_USB_INTRRXE_EP1RX_MASK (0x0002u)
#define CSL_USB_INTRRXE_EP1RX_SHIFT (0x0001u)
#define CSL_USB_INTRRXE_EP1RX_RESETVAL (0x0001u)


#define CSL_USB_INTRRXE_RESETVAL (0x001Eu)

/* INTRUSB_INTRUSBE */

#define CSL_USB_INTRUSB_INTRUSBE_VBUSERR_E_MASK (0x8000u)
#define CSL_USB_INTRUSB_INTRUSBE_VBUSERR_E_SHIFT (0x000Fu)
#define CSL_USB_INTRUSB_INTRUSBE_VBUSERR_E_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_SESSREQ_E_MASK (0x4000u)
#define CSL_USB_INTRUSB_INTRUSBE_SESSREQ_E_SHIFT (0x000Eu)
#define CSL_USB_INTRUSB_INTRUSBE_SESSREQ_E_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_DISCON_E_MASK (0x2000u)
#define CSL_USB_INTRUSB_INTRUSBE_DISCON_E_SHIFT (0x000Du)
#define CSL_USB_INTRUSB_INTRUSBE_DISCON_E_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_CONN_E_MASK (0x1000u)
#define CSL_USB_INTRUSB_INTRUSBE_CONN_E_SHIFT (0x000Cu)
#define CSL_USB_INTRUSB_INTRUSBE_CONN_E_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_SOF_E_MASK (0x0800u)
#define CSL_USB_INTRUSB_INTRUSBE_SOF_E_SHIFT (0x000Bu)
#define CSL_USB_INTRUSB_INTRUSBE_SOF_E_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_RESET_BABBLE_E_MASK (0x0400u)
#define CSL_USB_INTRUSB_INTRUSBE_RESET_BABBLE_E_SHIFT (0x000Au)
#define CSL_USB_INTRUSB_INTRUSBE_RESET_BABBLE_E_RESETVAL (0x0001u)

#define CSL_USB_INTRUSB_INTRUSBE_RESUME_E_MASK (0x0200u)
#define CSL_USB_INTRUSB_INTRUSBE_RESUME_E_SHIFT (0x0009u)
#define CSL_USB_INTRUSB_INTRUSBE_RESUME_E_RESETVAL (0x0001u)

#define CSL_USB_INTRUSB_INTRUSBE_SUSPEND_E_MASK (0x0100u)
#define CSL_USB_INTRUSB_INTRUSBE_SUSPEND_E_SHIFT (0x0008u)
#define CSL_USB_INTRUSB_INTRUSBE_SUSPEND_E_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_VBUSERR_MASK (0x0080u)
#define CSL_USB_INTRUSB_INTRUSBE_VBUSERR_SHIFT (0x0007u)
#define CSL_USB_INTRUSB_INTRUSBE_VBUSERR_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_SESSREQ_MASK (0x0040u)
#define CSL_USB_INTRUSB_INTRUSBE_SESSREQ_SHIFT (0x0006u)
#define CSL_USB_INTRUSB_INTRUSBE_SESSREQ_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_DISCON_MASK (0x0020u)
#define CSL_USB_INTRUSB_INTRUSBE_DISCON_SHIFT (0x0005u)
#define CSL_USB_INTRUSB_INTRUSBE_DISCON_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_CONN_MASK (0x0010u)
#define CSL_USB_INTRUSB_INTRUSBE_CONN_SHIFT (0x0004u)
#define CSL_USB_INTRUSB_INTRUSBE_CONN_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_SOF_MASK (0x0008u)
#define CSL_USB_INTRUSB_INTRUSBE_SOF_SHIFT (0x0003u)
#define CSL_USB_INTRUSB_INTRUSBE_SOF_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_RESET_BABBLE_MASK (0x0004u)
#define CSL_USB_INTRUSB_INTRUSBE_RESET_BABBLE_SHIFT (0x0002u)
#define CSL_USB_INTRUSB_INTRUSBE_RESET_BABBLE_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_RESUME_MASK (0x0002u)
#define CSL_USB_INTRUSB_INTRUSBE_RESUME_SHIFT (0x0001u)
#define CSL_USB_INTRUSB_INTRUSBE_RESUME_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_SUSPEND_MASK (0x0001u)
#define CSL_USB_INTRUSB_INTRUSBE_SUSPEND_SHIFT (0x0000u)
#define CSL_USB_INTRUSB_INTRUSBE_SUSPEND_RESETVAL (0x0000u)

#define CSL_USB_INTRUSB_INTRUSBE_RESETVAL (0x0600u)

/* FRAME */


#define CSL_USB_FRAME_FRAMENUMBER_MASK (0x07FFu)
#define CSL_USB_FRAME_FRAMENUMBER_SHIFT (0x0000u)
#define CSL_USB_FRAME_FRAMENUMBER_RESETVAL (0x0000u)

#define CSL_USB_FRAME_RESETVAL (0x0000u)

/* INDEX_TESTMODE */

#define CSL_USB_INDEX_TESTMODE_FORCE_HOST_MASK (0x8000u)
#define CSL_USB_INDEX_TESTMODE_FORCE_HOST_SHIFT (0x000Fu)
#define CSL_USB_INDEX_TESTMODE_FORCE_HOST_RESETVAL (0x0000u)

#define CSL_USB_INDEX_TESTMODE_FIFO_ACCESS_MASK (0x4000u)
#define CSL_USB_INDEX_TESTMODE_FIFO_ACCESS_SHIFT (0x000Eu)
#define CSL_USB_INDEX_TESTMODE_FIFO_ACCESS_RESETVAL (0x0000u)

#define CSL_USB_INDEX_TESTMODE_FORCE_FS_MASK (0x2000u)
#define CSL_USB_INDEX_TESTMODE_FORCE_FS_SHIFT (0x000Du)
#define CSL_USB_INDEX_TESTMODE_FORCE_FS_RESETVAL (0x0000u)

#define CSL_USB_INDEX_TESTMODE_FORCE_HS_MASK (0x1000u)
#define CSL_USB_INDEX_TESTMODE_FORCE_HS_SHIFT (0x000Cu)
#define CSL_USB_INDEX_TESTMODE_FORCE_HS_RESETVAL (0x0000u)

#define CSL_USB_INDEX_TESTMODE_TEST_PACKET_MASK (0x0800u)
#define CSL_USB_INDEX_TESTMODE_TEST_PACKET_SHIFT (0x000Bu)
#define CSL_USB_INDEX_TESTMODE_TEST_PACKET_RESETVAL (0x0000u)

#define CSL_USB_INDEX_TESTMODE_TEST_K_MASK (0x0400u)
#define CSL_USB_INDEX_TESTMODE_TEST_K_SHIFT (0x000Au)
#define CSL_USB_INDEX_TESTMODE_TEST_K_RESETVAL (0x0000u)

#define CSL_USB_INDEX_TESTMODE_TEST_J_MASK (0x0200u)
#define CSL_USB_INDEX_TESTMODE_TEST_J_SHIFT (0x0009u)
#define CSL_USB_INDEX_TESTMODE_TEST_J_RESETVAL (0x0000u)

#define CSL_USB_INDEX_TESTMODE_TEST_SE0_NAK_MASK (0x0100u)
#define CSL_USB_INDEX_TESTMODE_TEST_SE0_NAK_SHIFT (0x0008u)
#define CSL_USB_INDEX_TESTMODE_TEST_SE0_NAK_RESETVAL (0x0000u)


#define CSL_USB_INDEX_TESTMODE_EPSEL_MASK (0x000Fu)
#define CSL_USB_INDEX_TESTMODE_EPSEL_SHIFT (0x0000u)
#define CSL_USB_INDEX_TESTMODE_EPSEL_RESETVAL (0x0000u)

#define CSL_USB_INDEX_TESTMODE_RESETVAL (0x0000u)

/* TXMAXP */


#define CSL_USB_TXMAXP_MAXPAYLOAD_MASK (0x07FFu)
#define CSL_USB_TXMAXP_MAXPAYLOAD_SHIFT (0x0000u)
#define CSL_USB_TXMAXP_MAXPAYLOAD_RESETVAL (0x0000u)

#define CSL_USB_TXMAXP_RESETVAL (0x0000u)

/* PERI_CSR0 */


#define CSL_USB_PERI_CSR0_FLUSHFIFO_MASK (0x0100u)
#define CSL_USB_PERI_CSR0_FLUSHFIFO_SHIFT (0x0008u)
#define CSL_USB_PERI_CSR0_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_SERV_SETUPEND_MASK (0x0080u)
#define CSL_USB_PERI_CSR0_SERV_SETUPEND_SHIFT (0x0007u)
#define CSL_USB_PERI_CSR0_SERV_SETUPEND_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_SERV_RXPKTRDY_MASK (0x0040u)
#define CSL_USB_PERI_CSR0_SERV_RXPKTRDY_SHIFT (0x0006u)
#define CSL_USB_PERI_CSR0_SERV_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_SENDSTALL_MASK (0x0020u)
#define CSL_USB_PERI_CSR0_SENDSTALL_SHIFT (0x0005u)
#define CSL_USB_PERI_CSR0_SENDSTALL_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_SETUPEND_MASK (0x0010u)
#define CSL_USB_PERI_CSR0_SETUPEND_SHIFT (0x0004u)
#define CSL_USB_PERI_CSR0_SETUPEND_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_DATAEND_MASK (0x0008u)
#define CSL_USB_PERI_CSR0_DATAEND_SHIFT (0x0003u)
#define CSL_USB_PERI_CSR0_DATAEND_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_SENTSTALL_MASK (0x0004u)
#define CSL_USB_PERI_CSR0_SENTSTALL_SHIFT (0x0002u)
#define CSL_USB_PERI_CSR0_SENTSTALL_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_TXPKTRDY_MASK (0x0002u)
#define CSL_USB_PERI_CSR0_TXPKTRDY_SHIFT (0x0001u)
#define CSL_USB_PERI_CSR0_TXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_RXPKTRDY_MASK (0x0001u)
#define CSL_USB_PERI_CSR0_RXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_PERI_CSR0_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_PERI_CSR0_RESETVAL (0x0000u)

/* HOST_CSR0 */


#define CSL_USB_HOST_CSR0_DATATOGWREN_MASK (0x0400u)
#define CSL_USB_HOST_CSR0_DATATOGWREN_SHIFT (0x000Au)
#define CSL_USB_HOST_CSR0_DATATOGWREN_RESETVAL (0x0000u)

#define CSL_USB_HOST_CSR0_DATATOG_MASK (0x0200u)
#define CSL_USB_HOST_CSR0_DATATOG_SHIFT (0x0009u)
#define CSL_USB_HOST_CSR0_DATATOG_RESETVAL (0x0000u)

#define CSL_USB_HOST_CSR0_FLUSHFIFO_MASK (0x0100u)
#define CSL_USB_HOST_CSR0_FLUSHFIFO_SHIFT (0x0008u)
#define CSL_USB_HOST_CSR0_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_HOST_CSR0_NAK_TIMEOUT_MASK (0x0080u)
#define CSL_USB_HOST_CSR0_NAK_TIMEOUT_SHIFT (0x0007u)
#define CSL_USB_HOST_CSR0_NAK_TIMEOUT_RESETVAL (0x0000u)

#define CSL_USB_HOST_CSR0_STATUSPKT_MASK (0x0040u)
#define CSL_USB_HOST_CSR0_STATUSPKT_SHIFT (0x0006u)
#define CSL_USB_HOST_CSR0_STATUSPKT_RESETVAL (0x0000u)

#define CSL_USB_HOST_CSR0_REQPKT_MASK (0x0020u)
#define CSL_USB_HOST_CSR0_REQPKT_SHIFT (0x0005u)
#define CSL_USB_HOST_CSR0_REQPKT_RESETVAL (0x0000u)

#define CSL_USB_HOST_CSR0_ERROR_MASK (0x0010u)
#define CSL_USB_HOST_CSR0_ERROR_SHIFT (0x0004u)
#define CSL_USB_HOST_CSR0_ERROR_RESETVAL (0x0000u)

#define CSL_USB_HOST_CSR0_SETUPPKT_MASK (0x0008u)
#define CSL_USB_HOST_CSR0_SETUPPKT_SHIFT (0x0003u)
#define CSL_USB_HOST_CSR0_SETUPPKT_RESETVAL (0x0000u)

#define CSL_USB_HOST_CSR0_RXSTALL_MASK (0x0004u)
#define CSL_USB_HOST_CSR0_RXSTALL_SHIFT (0x0002u)
#define CSL_USB_HOST_CSR0_RXSTALL_RESETVAL (0x0000u)

#define CSL_USB_HOST_CSR0_TXPKTRDY_MASK (0x0002u)
#define CSL_USB_HOST_CSR0_TXPKTRDY_SHIFT (0x0001u)
#define CSL_USB_HOST_CSR0_TXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_HOST_CSR0_RXPKTRDY_MASK (0x0001u)
#define CSL_USB_HOST_CSR0_RXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_HOST_CSR0_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_HOST_CSR0_RESETVAL (0x0000u)

/* PERI_TXCSR */

#define CSL_USB_PERI_TXCSR_AUTOSET_MASK (0x8000u)
#define CSL_USB_PERI_TXCSR_AUTOSET_SHIFT (0x000Fu)
#define CSL_USB_PERI_TXCSR_AUTOSET_RESETVAL (0x0000u)

#define CSL_USB_PERI_TXCSR_ISO_MASK (0x4000u)
#define CSL_USB_PERI_TXCSR_ISO_SHIFT (0x000Eu)
#define CSL_USB_PERI_TXCSR_ISO_RESETVAL (0x0000u)

#define CSL_USB_PERI_TXCSR_MODE_MASK (0x2000u)
#define CSL_USB_PERI_TXCSR_MODE_SHIFT (0x000Du)
#define CSL_USB_PERI_TXCSR_MODE_RESETVAL (0x0001u)

#define CSL_USB_PERI_TXCSR_DMAEN_MASK (0x1000u)
#define CSL_USB_PERI_TXCSR_DMAEN_SHIFT (0x000Cu)
#define CSL_USB_PERI_TXCSR_DMAEN_RESETVAL (0x0000u)

#define CSL_USB_PERI_TXCSR_FRCDATATOG_MASK (0x0800u)
#define CSL_USB_PERI_TXCSR_FRCDATATOG_SHIFT (0x000Bu)
#define CSL_USB_PERI_TXCSR_FRCDATATOG_RESETVAL (0x0000u)

#define CSL_USB_PERI_TXCSR_DMAMODE_MASK (0x0400u)
#define CSL_USB_PERI_TXCSR_DMAMODE_SHIFT (0x000Au)
#define CSL_USB_PERI_TXCSR_DMAMODE_RESETVAL (0x0000u)


#define CSL_USB_PERI_TXCSR_CLRDATATOG_MASK (0x0040u)
#define CSL_USB_PERI_TXCSR_CLRDATATOG_SHIFT (0x0006u)
#define CSL_USB_PERI_TXCSR_CLRDATATOG_RESETVAL (0x0000u)

#define CSL_USB_PERI_TXCSR_SENTSTALL_MASK (0x0020u)
#define CSL_USB_PERI_TXCSR_SENTSTALL_SHIFT (0x0005u)
#define CSL_USB_PERI_TXCSR_SENTSTALL_RESETVAL (0x0000u)

#define CSL_USB_PERI_TXCSR_SENDSTALL_MASK (0x0010u)
#define CSL_USB_PERI_TXCSR_SENDSTALL_SHIFT (0x0004u)
#define CSL_USB_PERI_TXCSR_SENDSTALL_RESETVAL (0x0000u)

#define CSL_USB_PERI_TXCSR_FLUSHFIFO_MASK (0x0008u)
#define CSL_USB_PERI_TXCSR_FLUSHFIFO_SHIFT (0x0003u)
#define CSL_USB_PERI_TXCSR_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_PERI_TXCSR_UNDERRUN_MASK (0x0004u)
#define CSL_USB_PERI_TXCSR_UNDERRUN_SHIFT (0x0002u)
#define CSL_USB_PERI_TXCSR_UNDERRUN_RESETVAL (0x0000u)

#define CSL_USB_PERI_TXCSR_FIFONOTEMPTY_MASK (0x0002u)
#define CSL_USB_PERI_TXCSR_FIFONOTEMPTY_SHIFT (0x0001u)
#define CSL_USB_PERI_TXCSR_FIFONOTEMPTY_RESETVAL (0x0000u)

#define CSL_USB_PERI_TXCSR_TXPKTRDY_MASK (0x0001u)
#define CSL_USB_PERI_TXCSR_TXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_PERI_TXCSR_TXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_PERI_TXCSR_RESETVAL (0x2000u)

/* HOST_TXCSR */

#define CSL_USB_HOST_TXCSR_AUTOSET_MASK (0x8000u)
#define CSL_USB_HOST_TXCSR_AUTOSET_SHIFT (0x000Fu)
#define CSL_USB_HOST_TXCSR_AUTOSET_RESETVAL (0x0000u)


#define CSL_USB_HOST_TXCSR_MODE_MASK (0x2000u)
#define CSL_USB_HOST_TXCSR_MODE_SHIFT (0x000Du)
#define CSL_USB_HOST_TXCSR_MODE_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_DMAEN_MASK (0x1000u)
#define CSL_USB_HOST_TXCSR_DMAEN_SHIFT (0x000Cu)
#define CSL_USB_HOST_TXCSR_DMAEN_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_FRCDATATOG_MASK (0x0800u)
#define CSL_USB_HOST_TXCSR_FRCDATATOG_SHIFT (0x000Bu)
#define CSL_USB_HOST_TXCSR_FRCDATATOG_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_DMAMODE_MASK (0x0400u)
#define CSL_USB_HOST_TXCSR_DMAMODE_SHIFT (0x000Au)
#define CSL_USB_HOST_TXCSR_DMAMODE_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_DATATOGWREN_MASK (0x0200u)
#define CSL_USB_HOST_TXCSR_DATATOGWREN_SHIFT (0x0009u)
#define CSL_USB_HOST_TXCSR_DATATOGWREN_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_DATATOG_MASK (0x0100u)
#define CSL_USB_HOST_TXCSR_DATATOG_SHIFT (0x0008u)
#define CSL_USB_HOST_TXCSR_DATATOG_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_NAK_TIMEOUT_MASK (0x0080u)
#define CSL_USB_HOST_TXCSR_NAK_TIMEOUT_SHIFT (0x0007u)
#define CSL_USB_HOST_TXCSR_NAK_TIMEOUT_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_CLRDATATOG_MASK (0x0040u)
#define CSL_USB_HOST_TXCSR_CLRDATATOG_SHIFT (0x0006u)
#define CSL_USB_HOST_TXCSR_CLRDATATOG_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_RXSTALL_MASK (0x0020u)
#define CSL_USB_HOST_TXCSR_RXSTALL_SHIFT (0x0005u)
#define CSL_USB_HOST_TXCSR_RXSTALL_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_SETUPPKT_MASK (0x0010u)
#define CSL_USB_HOST_TXCSR_SETUPPKT_SHIFT (0x0004u)
#define CSL_USB_HOST_TXCSR_SETUPPKT_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_FLUSHFIFO_MASK (0x0008u)
#define CSL_USB_HOST_TXCSR_FLUSHFIFO_SHIFT (0x0003u)
#define CSL_USB_HOST_TXCSR_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_ERROR_MASK (0x0004u)
#define CSL_USB_HOST_TXCSR_ERROR_SHIFT (0x0002u)
#define CSL_USB_HOST_TXCSR_ERROR_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_FIFONOTEMPTY_MASK (0x0002u)
#define CSL_USB_HOST_TXCSR_FIFONOTEMPTY_SHIFT (0x0001u)
#define CSL_USB_HOST_TXCSR_FIFONOTEMPTY_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_TXPKTRDY_MASK (0x0001u)
#define CSL_USB_HOST_TXCSR_TXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_HOST_TXCSR_TXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXCSR_RESETVAL (0x0000u)

/* RXMAXP */


#define CSL_USB_RXMAXP_MAXPAYLOAD_MASK (0x07FFu)
#define CSL_USB_RXMAXP_MAXPAYLOAD_SHIFT (0x0000u)
#define CSL_USB_RXMAXP_MAXPAYLOAD_RESETVAL (0x0000u)

#define CSL_USB_RXMAXP_RESETVAL (0x0000u)

/* PERI_RXCSR */

#define CSL_USB_PERI_RXCSR_AUTOCLEAR_MASK (0x8000u)
#define CSL_USB_PERI_RXCSR_AUTOCLEAR_SHIFT (0x000Fu)
#define CSL_USB_PERI_RXCSR_AUTOCLEAR_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_ISO_MASK (0x4000u)
#define CSL_USB_PERI_RXCSR_ISO_SHIFT (0x000Eu)
#define CSL_USB_PERI_RXCSR_ISO_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_DMAEN_MASK (0x2000u)
#define CSL_USB_PERI_RXCSR_DMAEN_SHIFT (0x000Du)
#define CSL_USB_PERI_RXCSR_DMAEN_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_DISNYET_MASK (0x1000u)
#define CSL_USB_PERI_RXCSR_DISNYET_SHIFT (0x000Cu)
#define CSL_USB_PERI_RXCSR_DISNYET_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_DMAMODE_MASK (0x0800u)
#define CSL_USB_PERI_RXCSR_DMAMODE_SHIFT (0x000Bu)
#define CSL_USB_PERI_RXCSR_DMAMODE_RESETVAL (0x0000u)


#define CSL_USB_PERI_RXCSR_CLRDATATOG_MASK (0x0080u)
#define CSL_USB_PERI_RXCSR_CLRDATATOG_SHIFT (0x0007u)
#define CSL_USB_PERI_RXCSR_CLRDATATOG_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_SENTSTALL_MASK (0x0040u)
#define CSL_USB_PERI_RXCSR_SENTSTALL_SHIFT (0x0006u)
#define CSL_USB_PERI_RXCSR_SENTSTALL_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_SENDSTALL_MASK (0x0020u)
#define CSL_USB_PERI_RXCSR_SENDSTALL_SHIFT (0x0005u)
#define CSL_USB_PERI_RXCSR_SENDSTALL_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_FLUSHFIFO_MASK (0x0010u)
#define CSL_USB_PERI_RXCSR_FLUSHFIFO_SHIFT (0x0004u)
#define CSL_USB_PERI_RXCSR_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_DATAERROR_MASK (0x0008u)
#define CSL_USB_PERI_RXCSR_DATAERROR_SHIFT (0x0003u)
#define CSL_USB_PERI_RXCSR_DATAERROR_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_OVERRUN_MASK (0x0004u)
#define CSL_USB_PERI_RXCSR_OVERRUN_SHIFT (0x0002u)
#define CSL_USB_PERI_RXCSR_OVERRUN_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_FIFOFULL_MASK (0x0002u)
#define CSL_USB_PERI_RXCSR_FIFOFULL_SHIFT (0x0001u)
#define CSL_USB_PERI_RXCSR_FIFOFULL_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_RXPKTRDY_MASK (0x0001u)
#define CSL_USB_PERI_RXCSR_RXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_PERI_RXCSR_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_PERI_RXCSR_RESETVAL (0x0000u)

/* HOST_RXCSR */

#define CSL_USB_HOST_RXCSR_AUTOCLEAR_MASK (0x8000u)
#define CSL_USB_HOST_RXCSR_AUTOCLEAR_SHIFT (0x000Fu)
#define CSL_USB_HOST_RXCSR_AUTOCLEAR_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_AUTOREQ_MASK (0x4000u)
#define CSL_USB_HOST_RXCSR_AUTOREQ_SHIFT (0x000Eu)
#define CSL_USB_HOST_RXCSR_AUTOREQ_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_DMAEN_MASK (0x2000u)
#define CSL_USB_HOST_RXCSR_DMAEN_SHIFT (0x000Du)
#define CSL_USB_HOST_RXCSR_DMAEN_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_DISNYET_MASK (0x1000u)
#define CSL_USB_HOST_RXCSR_DISNYET_SHIFT (0x000Cu)
#define CSL_USB_HOST_RXCSR_DISNYET_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_DMAMODE_MASK (0x0800u)
#define CSL_USB_HOST_RXCSR_DMAMODE_SHIFT (0x000Bu)
#define CSL_USB_HOST_RXCSR_DMAMODE_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_DATATOGWREN_MASK (0x0400u)
#define CSL_USB_HOST_RXCSR_DATATOGWREN_SHIFT (0x000Au)
#define CSL_USB_HOST_RXCSR_DATATOGWREN_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_DATATOG_MASK (0x0200u)
#define CSL_USB_HOST_RXCSR_DATATOG_SHIFT (0x0009u)
#define CSL_USB_HOST_RXCSR_DATATOG_RESETVAL (0x0000u)


#define CSL_USB_HOST_RXCSR_CLRDATATOG_MASK (0x0080u)
#define CSL_USB_HOST_RXCSR_CLRDATATOG_SHIFT (0x0007u)
#define CSL_USB_HOST_RXCSR_CLRDATATOG_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_RXSTALL_MASK (0x0040u)
#define CSL_USB_HOST_RXCSR_RXSTALL_SHIFT (0x0006u)
#define CSL_USB_HOST_RXCSR_RXSTALL_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_REQPKT_MASK (0x0020u)
#define CSL_USB_HOST_RXCSR_REQPKT_SHIFT (0x0005u)
#define CSL_USB_HOST_RXCSR_REQPKT_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_FLUSHFIFO_MASK (0x0010u)
#define CSL_USB_HOST_RXCSR_FLUSHFIFO_SHIFT (0x0004u)
#define CSL_USB_HOST_RXCSR_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_DATAERR_NAKTIMEOUT_MASK (0x0008u)
#define CSL_USB_HOST_RXCSR_DATAERR_NAKTIMEOUT_SHIFT (0x0003u)
#define CSL_USB_HOST_RXCSR_DATAERR_NAKTIMEOUT_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_ERROR_MASK (0x0004u)
#define CSL_USB_HOST_RXCSR_ERROR_SHIFT (0x0002u)
#define CSL_USB_HOST_RXCSR_ERROR_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_FIFOFULL_MASK (0x0002u)
#define CSL_USB_HOST_RXCSR_FIFOFULL_SHIFT (0x0001u)
#define CSL_USB_HOST_RXCSR_FIFOFULL_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_RXPKTRDY_MASK (0x0001u)
#define CSL_USB_HOST_RXCSR_RXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_HOST_RXCSR_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXCSR_RESETVAL (0x0000u)

/* COUNT0 */


#define CSL_USB_COUNT0_EP0RXCOUNT_MASK (0x007Fu)
#define CSL_USB_COUNT0_EP0RXCOUNT_SHIFT (0x0000u)
#define CSL_USB_COUNT0_EP0RXCOUNT_RESETVAL (0x0000u)

#define CSL_USB_COUNT0_RESETVAL (0x0000u)

/* RXCOUNT */


#define CSL_USB_RXCOUNT_EPRXCOUNT_MASK (0x1FFFu)
#define CSL_USB_RXCOUNT_EPRXCOUNT_SHIFT (0x0000u)
#define CSL_USB_RXCOUNT_EPRXCOUNT_RESETVAL (0x0000u)

#define CSL_USB_RXCOUNT_RESETVAL (0x0000u)

/* HOST_TYPE0_HOST_NAKLIMIT0 */


#define CSL_USB_HOST_TYPE0_HOST_NAKLIMIT0_EP0NAKLIMIT_MASK (0x1F00u)
#define CSL_USB_HOST_TYPE0_HOST_NAKLIMIT0_EP0NAKLIMIT_SHIFT (0x0008u)
#define CSL_USB_HOST_TYPE0_HOST_NAKLIMIT0_EP0NAKLIMIT_RESETVAL (0x0000u)

#define CSL_USB_HOST_TYPE0_HOST_NAKLIMIT0_SPEED_MASK (0x00C0u)
#define CSL_USB_HOST_TYPE0_HOST_NAKLIMIT0_SPEED_SHIFT (0x0006u)
#define CSL_USB_HOST_TYPE0_HOST_NAKLIMIT0_SPEED_RESETVAL (0x0000u)


#define CSL_USB_HOST_TYPE0_HOST_NAKLIMIT0_RESETVAL (0x0000u)

/* HOST_TXTYPE_HOST_TXINTERVAL */

#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_POLINTVL_NAKLIMIT_MASK (0xFF00u)
#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_POLINTVL_NAKLIMIT_SHIFT (0x0008u)
#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_POLINTVL_NAKLIMIT_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_SPEED_MASK (0x00C0u)
#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_SPEED_SHIFT (0x0006u)
#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_SPEED_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_PROT_MASK (0x0030u)
#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_PROT_SHIFT (0x0004u)
#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_PROT_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_TENDPN_MASK (0x000Fu)
#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_TENDPN_SHIFT (0x0000u)
#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_TENDPN_RESETVAL (0x0000u)

#define CSL_USB_HOST_TXTYPE_HOST_TXINTERVAL_RESETVAL (0x0000u)

/* HOST_RXTYPE_HOST_RXINTERVAL */

#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_POLINTVL_NAKLIMIT_MASK (0xFF00u)
#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_POLINTVL_NAKLIMIT_SHIFT (0x0008u)
#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_POLINTVL_NAKLIMIT_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_SPEED_MASK (0x00C0u)
#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_SPEED_SHIFT (0x0006u)
#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_SPEED_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_PROT_MASK (0x0030u)
#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_PROT_SHIFT (0x0004u)
#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_PROT_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_RENDPN_MASK (0x000Fu)
#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_RENDPN_SHIFT (0x0000u)
#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_RENDPN_RESETVAL (0x0000u)

#define CSL_USB_HOST_RXTYPE_HOST_RXINTERVAL_RESETVAL (0x0000u)

/* CONFIGDATA */



#define CSL_USB_CONFIGDATA_MPTXE_MASK (0x0040u)
#define CSL_USB_CONFIGDATA_MPTXE_SHIFT (0x0006u)
#define CSL_USB_CONFIGDATA_MPTXE_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_BIGENDIAN_MASK (0x0020u)
#define CSL_USB_CONFIGDATA_BIGENDIAN_SHIFT (0x0005u)
#define CSL_USB_CONFIGDATA_BIGENDIAN_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_HBRXE_MASK (0x0010u)
#define CSL_USB_CONFIGDATA_HBRXE_SHIFT (0x0004u)
#define CSL_USB_CONFIGDATA_HBRXE_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_HBTXE_MASK (0x0008u)
#define CSL_USB_CONFIGDATA_HBTXE_SHIFT (0x0003u)
#define CSL_USB_CONFIGDATA_HBTXE_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_DYNFIFO_MASK (0x0004u)
#define CSL_USB_CONFIGDATA_DYNFIFO_SHIFT (0x0002u)
#define CSL_USB_CONFIGDATA_DYNFIFO_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_SOFTCONE_MASK (0x0002u)
#define CSL_USB_CONFIGDATA_SOFTCONE_SHIFT (0x0001u)
#define CSL_USB_CONFIGDATA_SOFTCONE_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_UTMIDATAWIDTH_MASK (0x0001u)
#define CSL_USB_CONFIGDATA_UTMIDATAWIDTH_SHIFT (0x0000u)
#define CSL_USB_CONFIGDATA_UTMIDATAWIDTH_RESETVAL (0x0000u)

#define CSL_USB_CONFIGDATA_RESETVAL (0x0000u)

/* FIFOSIZE */


#define CSL_USB_FIFOSIZE_RXFIFOSZ_MASK (0x00F0u)
#define CSL_USB_FIFOSIZE_RXFIFOSZ_SHIFT (0x0004u)
#define CSL_USB_FIFOSIZE_RXFIFOSZ_RESETVAL (0x0000u)

#define CSL_USB_FIFOSIZE_TXFIFOSZ_MASK (0x000Fu)
#define CSL_USB_FIFOSIZE_TXFIFOSZ_SHIFT (0x0000u)
#define CSL_USB_FIFOSIZE_TXFIFOSZ_RESETVAL (0x0000u)

#define CSL_USB_FIFOSIZE_RESETVAL (0x0000u)

/* FIFO0L */

#define CSL_USB_FIFO0L_DATA_MASK (0xFFFFu)
#define CSL_USB_FIFO0L_DATA_SHIFT (0x0000u)
#define CSL_USB_FIFO0L_DATA_RESETVAL (0x0000u)

#define CSL_USB_FIFO0L_RESETVAL (0x0000u)

/* FIFO0H */

#define CSL_USB_FIFO0H_DATA_MASK (0xFFFFu)
#define CSL_USB_FIFO0H_DATA_SHIFT (0x0000u)
#define CSL_USB_FIFO0H_DATA_RESETVAL (0x0000u)

#define CSL_USB_FIFO0H_RESETVAL (0x0000u)

/* FIFO1L */

#define CSL_USB_FIFO1L_DATA_MASK (0xFFFFu)
#define CSL_USB_FIFO1L_DATA_SHIFT (0x0000u)
#define CSL_USB_FIFO1L_DATA_RESETVAL (0x0000u)

#define CSL_USB_FIFO1L_RESETVAL (0x0000u)

/* FIFO1H */

#define CSL_USB_FIFO1H_DATA_MASK (0xFFFFu)
#define CSL_USB_FIFO1H_DATA_SHIFT (0x0000u)
#define CSL_USB_FIFO1H_DATA_RESETVAL (0x0000u)

#define CSL_USB_FIFO1H_RESETVAL (0x0000u)

/* FIFO2L */

#define CSL_USB_FIFO2L_DATA_MASK (0xFFFFu)
#define CSL_USB_FIFO2L_DATA_SHIFT (0x0000u)
#define CSL_USB_FIFO2L_DATA_RESETVAL (0x0000u)

#define CSL_USB_FIFO2L_RESETVAL (0x0000u)

/* FIFO2H */

#define CSL_USB_FIFO2H_DATA_MASK (0xFFFFu)
#define CSL_USB_FIFO2H_DATA_SHIFT (0x0000u)
#define CSL_USB_FIFO2H_DATA_RESETVAL (0x0000u)

#define CSL_USB_FIFO2H_RESETVAL (0x0000u)

/* FIFO3L */

#define CSL_USB_FIFO3L_DATA_MASK (0xFFFFu)
#define CSL_USB_FIFO3L_DATA_SHIFT (0x0000u)
#define CSL_USB_FIFO3L_DATA_RESETVAL (0x0000u)

#define CSL_USB_FIFO3L_RESETVAL (0x0000u)

/* FIFO3H */

#define CSL_USB_FIFO3H_DATA_MASK (0xFFFFu)
#define CSL_USB_FIFO3H_DATA_SHIFT (0x0000u)
#define CSL_USB_FIFO3H_DATA_RESETVAL (0x0000u)

#define CSL_USB_FIFO3H_RESETVAL (0x0000u)

/* FIFO4L */

#define CSL_USB_FIFO4L_DATA_MASK (0xFFFFu)
#define CSL_USB_FIFO4L_DATA_SHIFT (0x0000u)
#define CSL_USB_FIFO4L_DATA_RESETVAL (0x0000u)

#define CSL_USB_FIFO4L_RESETVAL (0x0000u)

/* FIFO4H */

#define CSL_USB_FIFO4H_DATA_MASK (0xFFFFu)
#define CSL_USB_FIFO4H_DATA_SHIFT (0x0000u)
#define CSL_USB_FIFO4H_DATA_RESETVAL (0x0000u)

#define CSL_USB_FIFO4H_RESETVAL (0x0000u)

/* DEVCTL */


#define CSL_USB_DEVCTL_BDEVICE_MASK (0x0080u)
#define CSL_USB_DEVCTL_BDEVICE_SHIFT (0x0007u)
#define CSL_USB_DEVCTL_BDEVICE_RESETVAL (0x0001u)

#define CSL_USB_DEVCTL_FSDEV_MASK (0x0040u)
#define CSL_USB_DEVCTL_FSDEV_SHIFT (0x0006u)
#define CSL_USB_DEVCTL_FSDEV_RESETVAL (0x0000u)

#define CSL_USB_DEVCTL_LSDEV_MASK (0x0020u)
#define CSL_USB_DEVCTL_LSDEV_SHIFT (0x0005u)
#define CSL_USB_DEVCTL_LSDEV_RESETVAL (0x0000u)

#define CSL_USB_DEVCTL_VBUS_MASK (0x0018u)
#define CSL_USB_DEVCTL_VBUS_SHIFT (0x0003u)
#define CSL_USB_DEVCTL_VBUS_RESETVAL (0x0000u)

#define CSL_USB_DEVCTL_HOSTMODE_MASK (0x0004u)
#define CSL_USB_DEVCTL_HOSTMODE_SHIFT (0x0002u)
#define CSL_USB_DEVCTL_HOSTMODE_RESETVAL (0x0000u)

#define CSL_USB_DEVCTL_HOSTREQ_MASK (0x0002u)
#define CSL_USB_DEVCTL_HOSTREQ_SHIFT (0x0001u)
#define CSL_USB_DEVCTL_HOSTREQ_RESETVAL (0x0000u)

#define CSL_USB_DEVCTL_SESSION_MASK (0x0001u)
#define CSL_USB_DEVCTL_SESSION_SHIFT (0x0000u)
#define CSL_USB_DEVCTL_SESSION_RESETVAL (0x0000u)

#define CSL_USB_DEVCTL_RESETVAL (0x0080u)

/* TXRXFIFOSZ */




#define CSL_USB_TXRXFIFOSZ_DPB_MASK (0x0010u)
#define CSL_USB_TXRXFIFOSZ_DPB_SHIFT (0x0004u)
#define CSL_USB_TXRXFIFOSZ_DPB_RESETVAL (0x0000u)

#define CSL_USB_TXRXFIFOSZ_DPB_MASK (0x0010u)
#define CSL_USB_TXRXFIFOSZ_DPB_SHIFT (0x0004u)
#define CSL_USB_TXRXFIFOSZ_DPB_RESETVAL (0x0000u)

#define CSL_USB_TXRXFIFOSZ_SZ_MASK (0x000Fu)
#define CSL_USB_TXRXFIFOSZ_SZ_SHIFT (0x0000u)
#define CSL_USB_TXRXFIFOSZ_SZ_RESETVAL (0x0000u)

#define CSL_USB_TXRXFIFOSZ_SZ_MASK (0x000Fu)
#define CSL_USB_TXRXFIFOSZ_SZ_SHIFT (0x0000u)
#define CSL_USB_TXRXFIFOSZ_SZ_RESETVAL (0x0000u)

#define CSL_USB_TXRXFIFOSZ_RESETVAL (0x0000u)

/* TXFIFOADDR */


#define CSL_USB_TXFIFOADDR_ADDR_MASK (0x1FFFu)
#define CSL_USB_TXFIFOADDR_ADDR_SHIFT (0x0000u)
#define CSL_USB_TXFIFOADDR_ADDR_RESETVAL (0x0000u)

#define CSL_USB_TXFIFOADDR_RESETVAL (0x0000u)

/* RXFIFOADDR */


#define CSL_USB_RXFIFOADDR_ADDR_MASK (0x1FFFu)
#define CSL_USB_RXFIFOADDR_ADDR_SHIFT (0x0000u)
#define CSL_USB_RXFIFOADDR_ADDR_RESETVAL (0x0000u)

#define CSL_USB_RXFIFOADDR_RESETVAL (0x0000u)

/* SCHECTRLL */


#define CSL_USB_SCHECTRLL_LASTENTRY_MASK (0x00FFu)
#define CSL_USB_SCHECTRLL_LASTENTRY_SHIFT (0x0000u)
#define CSL_USB_SCHECTRLL_LASTENTRY_RESETVAL (0x0000u)

#define CSL_USB_SCHECTRLL_RESETVAL (0x0000u)

/* SCHECTRLH */

#define CSL_USB_SCHECTRLH_ENABLE_MASK (0x8000u)
#define CSL_USB_SCHECTRLH_ENABLE_SHIFT (0x000Fu)
#define CSL_USB_SCHECTRLH_ENABLE_RESETVAL (0x0000u)


#define CSL_USB_SCHECTRLH_RESETVAL (0x0000u)

/* INTDRL */

#define CSL_USB_INTDRL_REVRTL_MASK (0xF800u)
#define CSL_USB_INTDRL_REVRTL_SHIFT (0x000Bu)
#define CSL_USB_INTDRL_REVRTL_RESETVAL (0x000Du)

#define CSL_USB_INTDRL_REVMAJ_MASK (0x0700u)
#define CSL_USB_INTDRL_REVMAJ_SHIFT (0x0008u)
#define CSL_USB_INTDRL_REVMAJ_RESETVAL (0x0001u)

#define CSL_USB_INTDRL_REVMIN_MASK (0x01FFu)
#define CSL_USB_INTDRL_REVMIN_SHIFT (0x0000u)
#define CSL_USB_INTDRL_REVMIN_RESETVAL (0x0000u)

#define CSL_USB_INTDRL_RESETVAL (0x6900u)

/* INTDRH */

#define CSL_USB_INTDRH_SCHEME_MASK (0xC000u)
#define CSL_USB_INTDRH_SCHEME_SHIFT (0x000Eu)
#define CSL_USB_INTDRH_SCHEME_RESETVAL (0x0001u)

#define CSL_USB_INTDRH_MODID_MASK (0x3FFFu)
#define CSL_USB_INTDRH_MODID_SHIFT (0x0000u)
#define CSL_USB_INTDRH_MODID_RESETVAL (0x0E83u)

#define CSL_USB_INTDRH_RESETVAL (0x4E83u)

/* INTDEOIR */


#define CSL_USB_INTDEOIR_EOI_VECTOR_MASK (0x00FFu)
#define CSL_USB_INTDEOIR_EOI_VECTOR_SHIFT (0x0000u)
#define CSL_USB_INTDEOIR_EOI_VECTOR_RESETVAL (0x0000u)

#define CSL_USB_INTDEOIR_RESETVAL (0x0000u)

/* INTDSTATUSR0 */



#define CSL_USB_INTDSTATUSR0_RX_SBUF_MASK (0x0001u)
#define CSL_USB_INTDSTATUSR0_RX_SBUF_SHIFT (0x0000u)
#define CSL_USB_INTDSTATUSR0_RX_SBUF_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR0_RX_SDES_MASK (0x0001u)
#define CSL_USB_INTDSTATUSR0_RX_SDES_SHIFT (0x0000u)
#define CSL_USB_INTDSTATUSR0_RX_SDES_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR0_RESETVAL (0x0000u)

/* INTDSTATUSR1L */

#define CSL_USB_INTDSTATUSR1L_RX_EP1_MASK (0x8000u)
#define CSL_USB_INTDSTATUSR1L_RX_EP1_SHIFT (0x000Fu)
#define CSL_USB_INTDSTATUSR1L_RX_EP1_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_RX_EP0_MASK (0x4000u)
#define CSL_USB_INTDSTATUSR1L_RX_EP0_SHIFT (0x000Eu)
#define CSL_USB_INTDSTATUSR1L_RX_EP0_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_TX_EP4_MASK (0x2000u)
#define CSL_USB_INTDSTATUSR1L_TX_EP4_SHIFT (0x000Du)
#define CSL_USB_INTDSTATUSR1L_TX_EP4_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_TX_EP3_MASK (0x1000u)
#define CSL_USB_INTDSTATUSR1L_TX_EP3_SHIFT (0x000Cu)
#define CSL_USB_INTDSTATUSR1L_TX_EP3_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_TX_EP2_MASK (0x0800u)
#define CSL_USB_INTDSTATUSR1L_TX_EP2_SHIFT (0x000Bu)
#define CSL_USB_INTDSTATUSR1L_TX_EP2_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_TX_EP1_MASK (0x0400u)
#define CSL_USB_INTDSTATUSR1L_TX_EP1_SHIFT (0x000Au)
#define CSL_USB_INTDSTATUSR1L_TX_EP1_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_TX_EP0_MASK (0x0200u)
#define CSL_USB_INTDSTATUSR1L_TX_EP0_SHIFT (0x0009u)
#define CSL_USB_INTDSTATUSR1L_TX_EP0_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_USB_INT8_MASK (0x0100u)
#define CSL_USB_INTDSTATUSR1L_USB_INT8_SHIFT (0x0008u)
#define CSL_USB_INTDSTATUSR1L_USB_INT8_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_USB_INT7_MASK (0x0080u)
#define CSL_USB_INTDSTATUSR1L_USB_INT7_SHIFT (0x0007u)
#define CSL_USB_INTDSTATUSR1L_USB_INT7_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_USB_INT6_MASK (0x0040u)
#define CSL_USB_INTDSTATUSR1L_USB_INT6_SHIFT (0x0006u)
#define CSL_USB_INTDSTATUSR1L_USB_INT6_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_USB_INT5_MASK (0x0020u)
#define CSL_USB_INTDSTATUSR1L_USB_INT5_SHIFT (0x0005u)
#define CSL_USB_INTDSTATUSR1L_USB_INT5_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_USB_INT4_MASK (0x0010u)
#define CSL_USB_INTDSTATUSR1L_USB_INT4_SHIFT (0x0004u)
#define CSL_USB_INTDSTATUSR1L_USB_INT4_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_USB_INT3_MASK (0x0008u)
#define CSL_USB_INTDSTATUSR1L_USB_INT3_SHIFT (0x0003u)
#define CSL_USB_INTDSTATUSR1L_USB_INT3_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_USB_INT2_MASK (0x0004u)
#define CSL_USB_INTDSTATUSR1L_USB_INT2_SHIFT (0x0002u)
#define CSL_USB_INTDSTATUSR1L_USB_INT2_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_USB_INT1_MASK (0x0002u)
#define CSL_USB_INTDSTATUSR1L_USB_INT1_SHIFT (0x0001u)
#define CSL_USB_INTDSTATUSR1L_USB_INT1_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_USB_INT0_MASK (0x0001u)
#define CSL_USB_INTDSTATUSR1L_USB_INT0_SHIFT (0x0000u)
#define CSL_USB_INTDSTATUSR1L_USB_INT0_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1L_RESETVAL (0x0000u)

/* INTDSTATUSR1H */


#define CSL_USB_INTDSTATUSR1H_USB_MASK (0x0008u)
#define CSL_USB_INTDSTATUSR1H_USB_SHIFT (0x0003u)
#define CSL_USB_INTDSTATUSR1H_USB_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1H_RX_EP4_MASK (0x0004u)
#define CSL_USB_INTDSTATUSR1H_RX_EP4_SHIFT (0x0002u)
#define CSL_USB_INTDSTATUSR1H_RX_EP4_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1H_RX_EP3_MASK (0x0002u)
#define CSL_USB_INTDSTATUSR1H_RX_EP3_SHIFT (0x0001u)
#define CSL_USB_INTDSTATUSR1H_RX_EP3_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1H_RX_EP2_MASK (0x0001u)
#define CSL_USB_INTDSTATUSR1H_RX_EP2_SHIFT (0x0000u)
#define CSL_USB_INTDSTATUSR1H_RX_EP2_RESETVAL (0x0000u)

#define CSL_USB_INTDSTATUSR1H_RESETVAL (0x0000u)

/* QMRRL */

#define CSL_USB_QMRRL_REVRTL_MASK (0xF800u)
#define CSL_USB_QMRRL_REVRTL_SHIFT (0x000Bu)
#define CSL_USB_QMRRL_REVRTL_RESETVAL (0x0000u)

#define CSL_USB_QMRRL_REVMAJ_MASK (0x0700u)
#define CSL_USB_QMRRL_REVMAJ_SHIFT (0x0008u)
#define CSL_USB_QMRRL_REVMAJ_RESETVAL (0x0000u)

#define CSL_USB_QMRRL_REVCUSTOM_MASK (0x00C0u)
#define CSL_USB_QMRRL_REVCUSTOM_SHIFT (0x0006u)
#define CSL_USB_QMRRL_REVCUSTOM_RESETVAL (0x0000u)

#define CSL_USB_QMRRL_REVMIN_MASK (0x003Fu)
#define CSL_USB_QMRRL_REVMIN_SHIFT (0x0000u)
#define CSL_USB_QMRRL_REVMIN_RESETVAL (0x0000u)

#define CSL_USB_QMRRL_RESETVAL (0x0000u)

/* QMRRH */

#define CSL_USB_QMRRH_SCHEME_MASK (0xC000u)
#define CSL_USB_QMRRH_SCHEME_SHIFT (0x000Eu)
#define CSL_USB_QMRRH_SCHEME_RESETVAL (0x0000u)

#define CSL_USB_QMRRH_FUNCTION_MASK (0x3FFFu)
#define CSL_USB_QMRRH_FUNCTION_SHIFT (0x0000u)
#define CSL_USB_QMRRH_FUNCTION_RESETVAL (0x0000u)

#define CSL_USB_QMRRH_RESETVAL (0x0000u)

/* QMQRRL */



#define CSL_USB_QMQRRL_SRC_QNUM_MASK (0x003Fu)
#define CSL_USB_QMQRRL_SRC_QNUM_SHIFT (0x0000u)
#define CSL_USB_QMQRRL_SRC_QNUM_RESETVAL (0x0000u)

#define CSL_USB_QMQRRL_RESETVAL (0x0000u)

/* QMQRRH */

#define CSL_USB_QMQRRH_HEAD_TAIL_MASK (0x8000u)
#define CSL_USB_QMQRRH_HEAD_TAIL_SHIFT (0x000Fu)
#define CSL_USB_QMQRRH_HEAD_TAIL_RESETVAL (0x0000u)



#define CSL_USB_QMQRRH_DST_QNUM_MASK (0x003Fu)
#define CSL_USB_QMQRRH_DST_QNUM_SHIFT (0x0000u)
#define CSL_USB_QMQRRH_DST_QNUM_RESETVAL (0x0000u)

#define CSL_USB_QMQRRH_RESETVAL (0x0000u)

/* QMFDBSCR0L */

#define CSL_USB_QMFDBSCR0L_FDBQ1_STARVE_CNT_MASK (0xFF00u)
#define CSL_USB_QMFDBSCR0L_FDBQ1_STARVE_CNT_SHIFT (0x0008u)
#define CSL_USB_QMFDBSCR0L_FDBQ1_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR0L_FDBQ0_STARVE_CNT_MASK (0x00FFu)
#define CSL_USB_QMFDBSCR0L_FDBQ0_STARVE_CNT_SHIFT (0x0000u)
#define CSL_USB_QMFDBSCR0L_FDBQ0_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR0L_RESETVAL (0x0000u)

/* QMFDBSCR0H */

#define CSL_USB_QMFDBSCR0H_FDBQ3_STARVE_CNT_MASK (0xFF00u)
#define CSL_USB_QMFDBSCR0H_FDBQ3_STARVE_CNT_SHIFT (0x0008u)
#define CSL_USB_QMFDBSCR0H_FDBQ3_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR0H_FDBQ2_STARVE_CNT_MASK (0x00FFu)
#define CSL_USB_QMFDBSCR0H_FDBQ2_STARVE_CNT_SHIFT (0x0000u)
#define CSL_USB_QMFDBSCR0H_FDBQ2_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR0H_RESETVAL (0x0000u)

/* QMFDBSCR1L */

#define CSL_USB_QMFDBSCR1L_FDBQ5_STARVE_CNT_MASK (0xFF00u)
#define CSL_USB_QMFDBSCR1L_FDBQ5_STARVE_CNT_SHIFT (0x0008u)
#define CSL_USB_QMFDBSCR1L_FDBQ5_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR1L_FDBQ4_STARVE_CNT_MASK (0x00FFu)
#define CSL_USB_QMFDBSCR1L_FDBQ4_STARVE_CNT_SHIFT (0x0000u)
#define CSL_USB_QMFDBSCR1L_FDBQ4_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR1L_RESETVAL (0x0000u)

/* QMFDBSCR1H */

#define CSL_USB_QMFDBSCR1H_FDBQ7_STARVE_CNT_MASK (0xFF00u)
#define CSL_USB_QMFDBSCR1H_FDBQ7_STARVE_CNT_SHIFT (0x0008u)
#define CSL_USB_QMFDBSCR1H_FDBQ7_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR1H_FDBQ6_STARVE_CNT_MASK (0x00FFu)
#define CSL_USB_QMFDBSCR1H_FDBQ6_STARVE_CNT_SHIFT (0x0000u)
#define CSL_USB_QMFDBSCR1H_FDBQ6_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR1H_RESETVAL (0x0000u)

/* QMFDBSCR2L */

#define CSL_USB_QMFDBSCR2L_FDBQ9_STARVE_CNT_MASK (0xFF00u)
#define CSL_USB_QMFDBSCR2L_FDBQ9_STARVE_CNT_SHIFT (0x0008u)
#define CSL_USB_QMFDBSCR2L_FDBQ9_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR2L_FDBQ8_STARVE_CNT_MASK (0x00FFu)
#define CSL_USB_QMFDBSCR2L_FDBQ8_STARVE_CNT_SHIFT (0x0000u)
#define CSL_USB_QMFDBSCR2L_FDBQ8_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR2L_RESETVAL (0x0000u)

/* QMFDBSCR2H */

#define CSL_USB_QMFDBSCR2H_FDBQ11_STARVE_CNT_MASK (0xFF00u)
#define CSL_USB_QMFDBSCR2H_FDBQ11_STARVE_CNT_SHIFT (0x0008u)
#define CSL_USB_QMFDBSCR2H_FDBQ11_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR2H_FDBQ10_STARVE_CNT_MASK (0x00FFu)
#define CSL_USB_QMFDBSCR2H_FDBQ10_STARVE_CNT_SHIFT (0x0000u)
#define CSL_USB_QMFDBSCR2H_FDBQ10_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR2H_RESETVAL (0x0000u)

/* QMFDBSCR3L */

#define CSL_USB_QMFDBSCR3L_FDBQ13_STARVE_CNT_MASK (0xFF00u)
#define CSL_USB_QMFDBSCR3L_FDBQ13_STARVE_CNT_SHIFT (0x0008u)
#define CSL_USB_QMFDBSCR3L_FDBQ13_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR3L_FDBQ12_STARVE_CNT_MASK (0x00FFu)
#define CSL_USB_QMFDBSCR3L_FDBQ12_STARVE_CNT_SHIFT (0x0000u)
#define CSL_USB_QMFDBSCR3L_FDBQ12_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR3L_RESETVAL (0x0000u)

/* QMFDBSCR3H */

#define CSL_USB_QMFDBSCR3H_FDBQ15_STARVE_CNT_MASK (0xFF00u)
#define CSL_USB_QMFDBSCR3H_FDBQ15_STARVE_CNT_SHIFT (0x0008u)
#define CSL_USB_QMFDBSCR3H_FDBQ15_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR3H_FDBQ14_STARVE_CNT_MASK (0x00FFu)
#define CSL_USB_QMFDBSCR3H_FDBQ14_STARVE_CNT_SHIFT (0x0000u)
#define CSL_USB_QMFDBSCR3H_FDBQ14_STARVE_CNT_RESETVAL (0x0000u)

#define CSL_USB_QMFDBSCR3H_RESETVAL (0x0000u)

/* QMLRR0BARL */

#define CSL_USB_QMLRR0BARL_BASE_MASK (0xFFFFu)
#define CSL_USB_QMLRR0BARL_BASE_SHIFT (0x0000u)
#define CSL_USB_QMLRR0BARL_BASE_RESETVAL (0x0000u)

#define CSL_USB_QMLRR0BARL_RESETVAL (0x0000u)

/* QMLRR0BARH */

#define CSL_USB_QMLRR0BARH_BASE_MASK (0xFFFFu)
#define CSL_USB_QMLRR0BARH_BASE_SHIFT (0x0000u)
#define CSL_USB_QMLRR0BARH_BASE_RESETVAL (0x0000u)

#define CSL_USB_QMLRR0BARH_RESETVAL (0x0000u)

/* QMLRR0SRL */


#define CSL_USB_QMLRR0SRL_SIZE_MASK (0x3FFFu)
#define CSL_USB_QMLRR0SRL_SIZE_SHIFT (0x0000u)
#define CSL_USB_QMLRR0SRL_SIZE_RESETVAL (0x0000u)

#define CSL_USB_QMLRR0SRL_RESETVAL (0x0000u)

/* QMLRR0SRH */


#define CSL_USB_QMLRR0SRH_RESETVAL (0x0000u)

/* QMLRR1BARL */

#define CSL_USB_QMLRR1BARL_BASE_MASK (0xFFFFu)
#define CSL_USB_QMLRR1BARL_BASE_SHIFT (0x0000u)
#define CSL_USB_QMLRR1BARL_BASE_RESETVAL (0x0000u)

#define CSL_USB_QMLRR1BARL_RESETVAL (0x0000u)

/* QMLRR1BARH */

#define CSL_USB_QMLRR1BARH_BASE_MASK (0xFFFFu)
#define CSL_USB_QMLRR1BARH_BASE_SHIFT (0x0000u)
#define CSL_USB_QMLRR1BARH_BASE_RESETVAL (0x0000u)

#define CSL_USB_QMLRR1BARH_RESETVAL (0x0000u)

/* QMQPR0L */

#define CSL_USB_QMQPR0L_QPEND_MASK (0xFFFFu)
#define CSL_USB_QMQPR0L_QPEND_SHIFT (0x0000u)
#define CSL_USB_QMQPR0L_QPEND_RESETVAL (0x0000u)

#define CSL_USB_QMQPR0L_RESETVAL (0x0000u)

/* QMQPR0H */

#define CSL_USB_QMQPR0H_QPEND_MASK (0xFFFFu)
#define CSL_USB_QMQPR0H_QPEND_SHIFT (0x0000u)
#define CSL_USB_QMQPR0H_QPEND_RESETVAL (0x0000u)

#define CSL_USB_QMQPR0H_RESETVAL (0x0000u)

/* QMQPR1L */

#define CSL_USB_QMQPR1L_QPEND_MASK (0xFFFFu)
#define CSL_USB_QMQPR1L_QPEND_SHIFT (0x0000u)
#define CSL_USB_QMQPR1L_QPEND_RESETVAL (0x0000u)

#define CSL_USB_QMQPR1L_RESETVAL (0x0000u)

/* QMQPR1H */

#define CSL_USB_QMQPR1H_QPEND_MASK (0xFFFFu)
#define CSL_USB_QMQPR1H_QPEND_SHIFT (0x0000u)
#define CSL_USB_QMQPR1H_QPEND_RESETVAL (0x0000u)

#define CSL_USB_QMQPR1H_RESETVAL (0x0000u)

#endif
