/*****************************************************************************
 * File Name : lcdFontTable.h 
 *
 * Brief	 : LCD Driver Font table defnition API header file
 *
 * Copyright (C) 2009 -2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
******************************************************************************/


#ifndef _LCDFONTTABLE_H
#define _LCDFONTTABLE_H

/***********************************************************************
 *                       #define SECTION                               *
 ***********************************************************************/

#define FONT_BITMAP_SIZE    8
/**< hash define value for font bimap size */
#define FONT_TABLE_SIZE      sizeof(lcdFontTable)
/**< size of complete font table */

#define LCD_CHAR_HEIGHT 				8
/**< no of bytes to diplay one character  */
#define LCD_CHAR_WIDTH                   8
/**< total no of bits taken by one character */

/***********************************************************************
 *                    ERROR & WARNING CODES                            *
 ***********************************************************************/

/***********************************************************************
 *                    CONSTANTS DECLARATION SECTION                    *
 ***********************************************************************/

static unsigned char lcdFontTable[] = 
	{
    		/* 32 0x20 ' ' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    
	/* 33 0x21 '!' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x3c, /* 00111100 */
    0x3c, /* 00111100 */
    0x3c, /* 00111100 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    
	/* 34 0x22 '"' */
    0x00, /* 00000000 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x24, /* 00100100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    

	/* 35 0x23 '#' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x6c, /* 01101100 */
    0x6c, /* 01101100 */
    0xfe, /* 11111110 */
    0x6c, /* 01101100 */
    0x6c, /* 01101100 */
    

	/* 36 0x24 '$' */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x7c, /* 01111100 */
    0xc6, /* 11000110 */
    0xc2, /* 11000010 */
    0xc0, /* 11000000 */
    0x7c, /* 01111100 */
    0x06, /* 00000110 */
    

	/* 37 0x25 '%' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0xc2, /* 11000010 */
    0xc6, /* 11000110 */
    0x0c, /* 00001100 */
    0x18, /* 00011000 */
    
	/* 38 0x26 '&' */
   
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0xFE, /* 11111110 */
    0xFE, /* 11111110 */
    0xFE, /* 11111110 */
    0xFE, /* 11111110 */
    0xFE, /* 11111110 */
    0x7c, /* 01111100 */
    

	/* 39 0x27 ''' */
    0x00, /* 00000000 */
    0x30, /* 00110000 */
    0x30, /* 00110000 */
    0x30, /* 00110000 */
    0x60, /* 01100000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    

	/* 40 0x28 '(' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x0c, /* 00001100 */
    0x18, /* 00011000 */
    0x30, /* 00110000 */
    0x30, /* 00110000 */
    0x30, /* 00110000 */
    0x30, /* 00110000 */
    

	/* 41 0x29 ')' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x30, /* 00110000 */
    0x18, /* 00011000 */
    0x0c, /* 00001100 */
    0x0c, /* 00001100 */
    0x0c, /* 00001100 */
    0x0c, /* 00001100 */
    

	/* 42 0x2a '*' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x66, /* 01100110 */
    0x3c, /* 00111100 */
    0xff, /* 11111111 */
    

	/* 43 0x2b '+' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x7e, /* 01111110 */
    

	/* 44 0x2c ',' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    

	/* 45 0x2d '-' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    
	/* 46 0x2e '.' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

	/* 47 0x2f '/' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x02, /* 00000010 */
    0x06, /* 00000110 */
    0x0c, /* 00001100 */
    0x18, /* 00011000 */
    


	/* 48 0x30 '0' */
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x7c, /* 01111100 */
    

	/* 49 0x31 '1' */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x38, /* 00111000 */
    0x08, /* 00001000 */
    0x08, /* 00001000 */
    0x08, /* 00001000 */
    0x08, /* 00001000 */
    0x3e, /* 00111110 */
    

        /* 50 0x32 '2' */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    0x02, /* 00000010 */
    0x04, /* 00000100 */
    0x10, /* 00010000 */
    0x40, /* 01000000 */
    0x80, /* 10000000 */
    0xfe, /* 11111110 */
    

	/* 51 0x33 '3' */
    0x00, /* 00000000 */
    0xfc, /* 11111100 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0xfc, /* 11111100 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0xfc, /* 11111100 */
    

	/* 52 0x34 '4' */
    0x00, /* 00000000 */
    0x0c, /* 00001100 */
    0x14, /* 00010100 */
    0x24, /* 00100100 */
    0x44, /* 01000100 */
    0xfe, /* 11111110 */
    0x04, /* 00000100 */
    0x04, /* 00000100 */
    

	/* 53 0x35 '5' */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0xfc, /* 11111100 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0xfe, /* 11111110 */
    

	/* 54 0x36 '6' */
    0x00, /* 00000000 */
    0x78, /* 01111000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0xfe, /* 11111110 */
    0x82, /* 10000010 */
    0x7c, /* 01111100 */
    

	/* 55 0x37 '7' */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    0x02, /* 00000010 */
    0x04, /* 00000100 */
    0x08, /* 00001000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    

	/* 56 0x38 '8' */
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x7c, /* 01111100 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x7c, /* 01111100 */
    

	/* 57 0x39 '9' */
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x7e, /* 01111110 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0x7c, /* 01111100 */
    

	/* 58 0x3a ':' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    

	/* 59 0x3b ';' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x30, /* 00110000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    
	/* 60 0x3c '<' */
    0x00, /* 00000000 */
    0x08, /* 00001000 */
    0x10, /* 00010000 */
    0x20, /* 00100000 */
    0xc0, /* 11000000 */
    0x20, /* 00100000 */
    0x10, /* 00010000 */
    0x08, /* 00001000 */
    

	/* 61 0x3d '=' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    

	/* 62 0x3e '>' */
   
    0x00, /* 00000000 */
    0x10, /* 00010000 */
    0x08, /* 00001000 */
    0x04, /* 00000100 */
    0x02, /* 00000010 */
    0x04, /* 00000100 */
    0x08, /* 00001000 */
    0x10, /* 00010000 */
   

	/* 63 0x3f '?' */
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0x1c, /* 00011100 */
    0x10, /* 00010000 */
    0x00, /* 00000000 */
    0x10, /* 00010000 */
    

	/* 64 0x40 '@' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0xc6, /* 11000110 */
    0xc6, /* 11000110 */
    0xde, /* 11011110 */
    0xde, /* 11011110 */
    

/* 65 0x41 'A' */
    
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0xfe, /* 11111110 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */

 	/* 66 0x42 B  */
    0x00, /* 00000000 */
    0xfc, /* 11111100 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0x7c, /* 01111100 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0xfc, /* 11111100 */
    
    
 /* 67 0x43 'C' */
    
    0x00, /* 00000000 */
    0x3c, /* 00111100 */
    0x42, /* 01000010 */
    0x40, /* 01000000 */
    0x40, /* 01000000 */
    0x40, /* 01000000 */
    0x42, /* 01000010 */
    0x3c, /* 00111100 */
     
	/* 68 0x44 'D' */
    0x00, /* 00000000 */
    0xfc, /* 11111100 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0xfc, /* 11111100 */
    

	/* 69 0x45 'E' */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0xf8, /* 11111000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0xfe, /* 11111110 */
    

	/* 70 0x46 'F' */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    0x42, /* 01000010 */
    0x40, /* 01000000 */
    0x7c, /* 01111100 */
    0x40, /* 01000000 */
    0x40, /* 01000000 */
    0xe0, /* 11100000 */
  

	/* 71 0x47 'G' */
    0x00, /* 00000000 */
    0x7e, /* 01111110 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x9e, /* 10011110 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x7c, /* 01111100 */
   
 
	/* 72 0x48 'H' */
    0x00, /* 00000000 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0xfe, /* 11111110 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    

	/* 73 0x49 'I' */
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x7c, /* 01111100 */
    

	/* 74 0x4a 'J' */
    0x00, /* 00000000 */
    0x3e, /* 00111110 */
    0x04, /* 00000100 */
    0x04, /* 00000100 */
    0x04, /* 00000100 */
    0x84, /* 10000100 */
    0x84, /* 10000100 */
    0x78, /* 01111000 */

	/* 75 0x4b 'K' */
    0x00, /* 00000000 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x84, /* 10000100 */
    0xf8, /* 11111000 */
    0xf4, /* 10000100 */
    0xf2, /* 10000010 */
    0xf2, /* 10000010 */
    

	/*76 0x4c 'L' */
    0x00, /* 00000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x82, /* 10000010 */
    0xfe, /* 11111110 */
    

	/* 77 0x4d 'M' */
   
    0x00, /* 00000000 */
    0xc6, /* 11000110 */
    0xaa, /* 10101010 */
    0x92, /* 10010010 */
    0x80, /* 10000000 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    
    /* 78  0x4e 'N' */
    
    0x00, /* 00000000 */
    0xc2, /* 11000010 */
    0xa2, /* 10100010 */
    0x92, /* 10010010 */
    0x8a, /* 10001010 */
    0x86, /* 10000110 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
   
    

	/* 79 0x4f 'O' */
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x7c, /* 01111100 */
    

	/* 80 0x50 'P' */
    0x00, /* 00000000 */
    0xfc, /* 11111100 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0x7c, /* 01111100 */
    0x40, /* 01000000 */
    0x40, /* 01000000 */
    0xe0, /* 11100000 */
    

	/* 81 0x51 'Q' */
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x8a, /* 10001010 */
    0x7c, /* 01111100 */
    0x07, /* 00000111 */
    

	/* 82 0x52 'R' */
    0x00, /* 00000000 */
    0xfc, /* 11111100 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0x7c, /* 01111100 */
    0x50, /* 01010000 */
    0x48, /* 01001000 */
    0x46, /* 01000110 */
    

	/* 83 0x53 'S' */
    0x00, /* 00000000 */
    0x7e, /* 01111110 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0xfc, /* 11111100 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0xfc, /* 11111100 */
    

	/* 84 0x54 'T' */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    

	/* 85 0x55 'U' */
    0x00, /* 00000000 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x7c, /* 01111100 */
    

	/* 86 0x56 'V' */
    0x00, /* 00000000 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x44, /* 01000100 */
    0x28, /* 00101000 */
    0x10, /* 00010000 */
    

	/* 87 0x57 'W' */
    0x00, /* 00000000 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x92, /* 10010010 */
    0xaa, /* 10101010 */
    0xc6, /* 11000110 */
    

	/* 88 0x58 'X' */
    0x00, /* 00000000 */
    0x82, /* 10000010 */
    0x44, /* 01000100 */
    0x28, /* 00101000 */
    0x10, /* 00010000 */
    0x28, /* 00101000 */
    0x44, /* 01000100 */
    0x82, /* 10000010 */
    

	/* 89 0x59 'Y' */
    0x00, /* 00000000 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x44, /* 01000100 */
    0x38, /* 00111000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    

	/* 90 0x5a 'Z' */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    0x02, /* 00000010 */
    0x04, /* 00000100 */
    0x10, /* 00010000 */
    0x40, /* 01000000 */
    0x80, /* 10000000 */
    0xfe, /* 11111110 */
    
	
    /* 91 0x5b '[' */
    0x00, /* 00000000 */
    0xf8, /* 11111000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0xf8, /* 11111000 */
    
	/* 92 0x5c '\' */
    0x00, /* 00000000 */
    0x80, /* 10000000 */
    0x40, /* 01000000 */
    0x20, /* 00100000 */
    0x10, /* 00010000 */
    0x08, /* 00001000 */
    0x04, /* 00000100 */
    0x02, /* 00000010 */
    

	/* 93 0x5d ']' */
    0x00, /* 00000000 */
    0x1e, /* 00011110 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0x1e, /* 00011110 */
    

	/* 94 0x5e '^' */
    0x00, /* 00000000 */
    0x10, /* 00010000 */
    0x28, /* 00101000 */
    0x44, /* 01000100 */
    0x82, /* 10000010 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    
	/* 95 0x5f '_' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    
	/* 96 0x60 '`' */
    0x00, /* 00000000 */
    0x30, /* 00110000 */
    0x18, /* 00011000 */
    0x0c, /* 00001100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    

	/* 97 0x61 'a' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x78, /* 01111000 */
    0x04, /* 00000100 */
    0x3c, /* 00111100 */
    0x44, /* 01000100 */
    0x7e, /* 01111110 */
    

	/* 98 0x62 'b' */
    0x00, /* 00000000 */
    0x40, /* 01000000 */
    0x40, /* 01000000 */
    0x40, /* 01000000 */
    0x7c, /* 01111100 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0x7c, /* 01111100 */
    

	/* 99 0x63 'c' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x7e, /* 01111110 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x7e, /* 01111110 */
    

	/* 100 0x64 'd' */
    0x00, /* 00000000 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0x3e, /* 00111110 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0x7e, /* 01111110 */
    

	/* 101 0x65 'e' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x7e, /* 01111110 */
    0x82, /* 10000010 */
    0xfe, /* 11111110 */
    0x80, /* 10000000 */
    0x7e, /* 01111110 */
    

	/* 102 0x66 'f' */
    0x00, /* 00000000 */
    0x1c, /* 00011100 */
    0x12, /* 00010010 */
    0x10, /* 00010000 */
    0x7c, /* 01111100 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    
	/* 103 0x67 'g' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0x82, /* 10000010 */
    0xfe, /* 11111110 */
    0x02, /* 00000010 */
    0xfc, /* 11111100 */
    
	/* 104 0x68 'h' */
    0x00, /* 00000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0xf8, /* 11111000 */
    0x84, /* 10000100 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    

	/* 105 0x69 'i' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x10, /* 00010000 */
    0x00, /* 00000000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    

	/* 106 0x6a 'j' */
    0x00, /* 00000000 */
    0x02, /* 00000010 */
    0x00, /* 00000000 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0x3c, /* 00111100 */
    
	/* 107 0x6b 'k' */
    0x00, /* 00000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x82, /* 10000010 */
    0x84, /* 10000100 */
    0xf8, /* 11111000 */
    0x84, /* 10000100 */
    0x82, /* 10000010 */
    

	/* 108 0x6c 'l' */
    0x00, /* 00000000 */
    0x70, /* 01110000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x38, /* 00111000 */
    

	/* 109 0x6d 'm' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x80, /* 10000000 */
    0xee, /* 11101110 */
    0x92, /* 10010010 */
    0x92, /* 10010010 */
    0x92, /* 10010010 */
    

	/* 110 0x6e 'n' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0xb8, /* 10111000 */
    0x44, /* 01000100 */
    0x44, /* 01000100 */
    0x44, /* 01000100 */
    0x44, /* 01000100 */
    
	/* 111 0x6f 'o' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x3c, /* 00111100 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0x42, /* 01000010 */
    0x3c, /* 00111100 */
    
	/* 112 0x70 'p' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0xfc, /* 11111100 */
    0x82, /* 10000010 */
    0xfc, /* 11111100 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    0x80, /* 10000000 */
    
	/* 113 0x71 'q' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x7c, /* 01111100 */
    0x82, /* 10000010 */
    0xfe, /* 11111110 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    0x02, /* 00000010 */
    
	/* 114 0x72 'r' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x2e, /* 00101110 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    0x10, /* 00010000 */
    
	/* 115 0x73 's' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x7e, /* 01111110 */
    0x80, /* 10000000 */
    0x7c, /* 01111100 */
    0x02, /* 00000010 */
    0xfc, /* 11111100 */
    

	/* 116 0x74 't' */
    0x00, /* 00000000 */
    0x20, /* 00100000 */
    0xf8, /* 11111000 */
    0x20, /* 00100000 */
    0x20, /* 00100000 */
    0x24, /* 00100100 */
    0x24, /* 00100100 */
    0x18, /* 00011000 */
    
	/* 117 0x75 'u' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x84, /* 10000100 */
    0x84, /* 10000100 */
    0x84, /* 10000100 */
    0x84, /* 10000100 */
    0x7a, /* 01111010 */
    
	/* 118 0x76 'v' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x44, /* 01000100 */
    0x28, /* 00101000 */
    0x10, /* 00010000 */
    

	/* 119 0x77 'w' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x82, /* 10000010 */
    0x82, /* 10000010 */
    0x92, /* 10010010 */
    0xaa, /* 10101010 */
    0xc6, /* 11000110 */
    
	/* 120 0x78 'x' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x82, /* 10000010 */
    0x28, /* 00101000 */
    0x10, /* 00010000 */
    0x28, /* 00101000 */
    0xc6, /* 11000110 */
    
	/* 121 0x79 'y' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x22, /* 00100010 */
    0x22, /* 00100010 */
    0x1e, /* 00011110 */
    0x02, /* 00000010 */
    0x7c, /* 01111100 */
    

	/* 122 0x7a 'z' */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0xfe, /* 11111110 */
    0x02, /* 00000010 */
    0x7c, /* 01111100 */
    0x80, /* 10000000 */
    0xfe, /* 11111110 */
    

    };	
/**< lcd Font table declaration variable  */

#endif  /* #ifndef LCDFONTTABLE_H */

