/*****************************************************************************
 * File Name : ADS1298Init.c 
 *
 * Brief	 : ADS1298 Initialization functions
 *                                                                      
 *
 * Copyright (C) 2009 -2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
******************************************************************************/

#define NEW_PG_BOARD    1
#define INIT_SPI_FREQ 1000000;
#define READ_SPI_FREQ 25000000;
#define SW_CLK_SEL 1

#include "ECGSystemInit.h"
//#include "typedef.h"
extern ECG_System_Info ECG_Info;

#if (NEW_PG_BOARD ==1)
/* ADS1298 Register values*/
// new configuration
Uint32 	ADS1298RegVal[28] = {

    //Write register opcode1
	0x0041,
	//Write register opcode2
	0x0018,
   	//CONFIG1 0x0001
	 0x0082,
    //CONFIG2
     0x0010,
    //CONFIG3
     0x00DC,
	 //LOFF
     0x0003,
	 //CH1SET (PGA gain = 6)
     0x0000,
	 //CH2SET (PGA gain = 6)
     0x0000,
	 //CH3SET (PGA gain = 6)
     0x0000,
	 //CH4SET (PGA gain = 6)
     0x0000,
	 //CH5SET (PGA gain = 6)
     0x0000,
	 //CH6SET (PGA gain = 6)
     0x0000,
	 //CH7SET (PGA gain = 6)
     0x0000,
	 //CH8SET (PGA gain = 6)
     0x0000,
	 //RLDSENSP (default)
	 0x0006,
	 //RLDSENSM (default)
	 0x0002,    
    //LOFF_SENSP
     0x00FF,
    //LOFF_SENSM
     0x0002,
	//LOFF_FLIP (default)
	 0x0000,
	//LOFF_STATP (Read only)
     0x0000, 
	//LOFF_STATM (Read only)
     0x0003, 
   //GPIO
	 0x0000,
	//PACE (default) 
	 0x0000,
	//RESP (default)
	 0x0000,
	//CONFIG4
     0x0002,
    //WCT1
     0x000A,
    //WCT2
     0x00E3,

};	
#else
/* ADS1298 Register values*/

Uint32 	ADS1298RegVal[25] = {

    //Write register opcode1
	0x0041,
	//Write register opcode2
	0x0016,
   	//CONFIG1
	 0x0082,
    //CONFIG2
     0x00A0,
    //CONFIG3
     0x00CC,
	 //LOFF
     0x0003,
	 //CH1SET (PGA gain = 6)
     0x0000,
	 //CH2SET (PGA gain = 6)
     0x0000,
	 //CH3SET (PGA gain = 6)
     0x0000,
	 //CH4SET (PGA gain = 6)
     0x0000,
	 //CH5SET (PGA gain = 6)
     0x0000,
	 //CH6SET (PGA gain = 6)
     0x0000,
	 //CH7SET (PGA gain = 6)
     0x0000,
	 //CH8SET (PGA gain = 6)
     0x0000,
	 //RLDSENSP (default)
	 0x0003,
	 //RLDSENSM (default)
	 0x0001,    
    //LOFF_SENSP
     0x00FF,
    //LOFF_SENSM
     0x00FF,
	//LOFF_FLIP (default)
	 0x0000,
	//LOFF_STATP (Read only)
     0x0000, 
	//LOFF_STATM (Read only)
     0x0003, 
   //GPIO
	 0x0000,
	//PACE (default) 
	 0x0000,
	//RESP (default)
	 0x0000,
	//CONFIG4
     0x0003

};		
#endif

/* structure which stores the UART configuration values*/
extern PSP_UartConfig uartCfg;
/* Instance no used for UART */
extern Uint8 instNum;
/* Handle for UART driver*/
extern PSP_Handle hUart;



/*--------------------------------------------------------------------------------------------**
** 	Function Name: ECG_ADS1298_INIT                                                           **
** 	Description : 	- The function initializes the ADS1298 registers with the                 **
** 					  required values. ADS1298 is configured as follows:-                     **
** 					                                                                          **
** 					  Set pin CLKSEL to high (GPIO11 of C5505 EVM to send high)               **
** 					  CONFIG1 - 0xC2 for data rate = 8000 SPS PER Channel                     **
** 					  CONFIG2 - 0xE0 for setting test source,test amplitude & test freq.      **
** 					  CONFIG3 - 0xC0 for VREFP set to 2.4, internal power down ref buffer     **
** 					  CONFIG4 - 0x02 for pulse mode selected; DC lead off turned on           **
** 					  LOFF - 0x03 for lead off                                                **
** 					  LOFF_SENSP -0xFF to turn on P-side of all channels for lead off sensing **                        
** 					  LOFF_SENSM -0xFF turn on M-side of all channels for lead off sensing    **
** 					  GPIO - 0x00 configuring as output pins as GPIO is not used.             **
**                                                                                            **                   
** 	Parameter : None						   		                                          **
** 	Return	:	- ECG_Status - Output : return the status ECG_OK on                           **
** 										successful Init                                       **
**--------------------------------------------------------------------------------------------*/


ECG_Status ECG_ADS1298_INIT()
{
	PSP_Result Status = 0;	       	
	Uint32 SPIBuf[32] = {0};	
	Uint16 wLen = 0;
	Uint16 fLen = 0;
	Uint32 Command[2] = {0};
	Uint16 comWLen = 0;
	Uint16 comFLen = 0;


	/*Reset ADS1298*/
	//Setting RESETB pin to high
	 *GPIO_DOUT0_ADDR = *GPIO_DOUT0_ADDR | 0x0002; 
	 //Delay 
	 wait(1000);

    //Setting RESETB pin to low
	 *GPIO_DOUT0_ADDR = *GPIO_DOUT0_ADDR & 0xFFFD; 

	 //Delay 
	 wait(1000);

	 //Setting RESETB pin to high
	 *GPIO_DOUT0_ADDR = *GPIO_DOUT0_ADDR | 0x0002; 

	 // Wait for power on reset. Delay approx >32msec
     wait(74000);

#if SW_CLK_SEL
	/*Selecting external clock*/

	*GPIO_DOUT0_ADDR = *GPIO_DOUT0_ADDR | 0x0800; 

	wait(10000);
	//Setting CLKSEL of ADS1298 to low 
	*GPIO_DOUT0_ADDR = *GPIO_DOUT0_ADDR & 0xF7FF;
#endif    
	//delay for internal oscillator to start up
	wait(74000);

	//Setting START pin to low
	 *GPIO_DOUT0_ADDR = *GPIO_DOUT0_ADDR & 0xFFEF; 
	 //Delay 
	 wait(10);
	wait(74000);

	//Setting START pin to high
	 *GPIO_DOUT0_ADDR = *GPIO_DOUT0_ADDR | 0x0010; 

	 wait(100000);

	 /* Stop read continuous mode command */
	SPIBuf[0] = CMD_SDATAC;			/* SPI Tx Buffer*/	      
	wLen = 8;                        /*No. of bits per word to be transmitted*/
	fLen = 2;

	/*Sending the SDATAC command to ADS1298 in order to write into registers*/
     Status = LLC_SPI_WordLengthWrite(SPIBuf, wLen, fLen);	 
     if(Status != PSP_SOK)
	 {
        return (Status);
     }

	 wait(74000);

	/* ADS1298 Register Initialization Values */

	/*Register write command for 23 registers from address 01h */    
	wLen = 8;                        /*No. of bits per word to be transmitted*/
#if (NEW_PG_BOARD ==1)	
    fLen = 28;
#else	
	fLen = 26;
#endif
	/*Sending write register command and data to ADS1298 */
     Status = LLC_SPI_WordLengthWrite(ADS1298RegVal, wLen, fLen);	 
     if(Status != PSP_SOK)
	 {
        return (Status);
     }

	wait(1);

    
	 /* Register Read Command for 23 registers from address 01h */	 

	/* Get ADS1298 registers Values back to verify */
    Command[0] = CMD_RREG1-1;
#if (NEW_PG_BOARD ==1)	
    Command[1] = CMD_RREG2+3;
#else    
    Command[1] = CMD_RREG2+1;
#endif    
	comWLen = 8;
	comFLen = 2;
	wLen = 8;
#if (NEW_PG_BOARD ==1)	
    fLen = 27; 
#else
	fLen = 25; 
#endif
	SPIBuf[0] = 0;
	
	Status = LLC_SPI_WordLengthWriteRead(SPIBuf, Command, wLen, fLen, comWLen, comFLen); 
	 if(Status != PSP_SOK)
	 {
        return (Status);
     }

	wait(100);	

 /* Read data continuous mode command */
	SPIBuf[0] = CMD_RDATAC;			/* SPI Tx Buffer*/	      
	wLen = 8;                        /*No. of bits per word to be transmitted*/
	fLen = 2;

	/*Sending the RDATAC command to ADS1298 in order to write into registers*/
     Status = LLC_SPI_WordLengthWrite(SPIBuf, wLen, fLen);	 
     if(Status != PSP_SOK)
	 {
        return (Status);
     }
 	 return Status;
}
