/*****************************************************************************
 * File Name : ADS1298_Pacer.c 
 *
 * Brief	 : ADS1298 Pacer functions
 *                                                                      
 *
 * Copyright (C) 2009 -2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
******************************************************************************/


#include "stdio.h"
#include "ADS1298_Pacer.h"

void ECG_Pacer_filter(Word16 CurSample, Word16 *Filt_CurSample)
{

	*Filt_CurSample = CurSample;
	return;
}

short Pacer_detection(Word16 *CurSample, ADS1298_ECGSystem_Pacer_Info *Pacer_Info)
{

	Word16 Filt_CurSample, pacer = 0;
	Word16 i;
	for ( i = 0; i < 8; i++)
	{
		ECG_Pacer_filter(CurSample[i], &Filt_CurSample);
		
		switch(Pacer_Info[i].PacerState)
		{

		case 0:

			if ( abs(Filt_CurSample - Pacer_Info[i].Prev_Sample) > PACER_SLEW_RATE) 
			{
				Pacer_Info[i].PacerState = 1;
				Pacer_Info[i].PacerWidth = 0;
			}
			else
			{
				Pacer_Info[i].PrevPrev_Sample = Pacer_Info[i].Prev_Sample;
			}
			break;

		case 1:

			if ( abs(Pacer_Info[i].Prev_Sample - Filt_CurSample) > PACER_SLEW_RATE) 
			{
				Pacer_Info[i].PacerState = 2;
				Pacer_Info[i].PacerDelay = 0;
				pacer = 1;
			}
			else 
			{
				Pacer_Info[i].PacerWidth++;
				if (Pacer_Info[i].PacerWidth > MAX_WIDTH)
				{
					Pacer_Info[i].PacerState = 0;
					Pacer_Info[i].PacerWidth = 0;
				}
			}
			break;

		case 2:
			Pacer_Info[i].PacerDelay++;
			if ( Pacer_Info[i].PacerDelay > PACER_DELAY_WIDTH)
			{
				Pacer_Info[i].PacerState = 0;
			}
			if ( Pacer_Info[i].PacerDelay > 20)
			{
				Pacer_Info[i].PrevPrev_Sample = Pacer_Info[i].Prev_Sample;
			}
			break;

		default:


			break;
		}
/*
		if ( Pacer_Info[i].PacerState != 1 )
		{
			Pacer_Info[i].PrevPrev_Sample = Pacer_Info[i].Prev_Sample;
		}
		Pacer_Info[i].Prev_Sample = Filt_CurSample;
*/
		Pacer_Info[i].Prev_Sample = Filt_CurSample;
		Pacer_Info[i].Pacer_pulse |= pacer;
		pacer = 0;
	}

	return pacer;

}

short Pacer_detection_W(Word16 *CurSample, ADS1298_ECGSystem_Pacer_Info *Pacer_Info)
{

	Word16 Filt_CurSample, pacer = 0;
	Word16 i;
	for ( i = 0; i < 8; i++)
	{
		ECG_Pacer_filter(CurSample[i], &Filt_CurSample);
		
		switch(Pacer_Info[i].PacerState)
		{

		case 0:

			if ( abs(Filt_CurSample - Pacer_Info[i].Prev_Sample) > PACER_SLEW_RATE) 
			{
				Pacer_Info[i].PacerState = 1;
				Pacer_Info[i].PacerWidth = 0;
				Pacer_Info[i].Prev_Sample = Filt_CurSample;
			}
			else
			{
				Pacer_Info[i].PrevPrev_Sample = Pacer_Info[i].Prev_Sample;
				Pacer_Info[i].Prev_Sample = Filt_CurSample;
			}
			break;

		case 1:

			if ( abs(Pacer_Info[i].Prev_Sample - Filt_CurSample) > PACER_SLEW_RATE) 
			{
				Pacer_Info[i].PacerState = 2;
				Pacer_Info[i].PacerDelay = 0;
				pacer = 1;
				Pacer_Info[i].Prev_Sample = Filt_CurSample;
			}
			else 
			{
				Pacer_Info[i].PacerWidth++;
				if (Pacer_Info[i].PacerWidth > MAX_WIDTH)
				{
					Pacer_Info[i].PacerState = 0;
					Pacer_Info[i].PacerWidth = 0;
				}
				Pacer_Info[i].Prev_Sample = Filt_CurSample;
			}
			break;

		case 2:
			Pacer_Info[i].PacerDelay++;
			if ( Pacer_Info[i].PacerDelay > PACER_DELAY_WIDTH)
			{
				Pacer_Info[i].PacerState = 0;
			}
			if ( Pacer_Info[i].PacerDelay < 20)
			{
				Pacer_Info[i].Prev_Sample = Filt_CurSample;
			}
			else
			{
				Pacer_Info[i].PrevPrev_Sample = Pacer_Info[i].Prev_Sample;
				Pacer_Info[i].Prev_Sample = Filt_CurSample;
			}
			break;

		default:


			break;
		}
/*
		if ( Pacer_Info[i].PacerState != 1 )
		{
			Pacer_Info[i].PrevPrev_Sample = Pacer_Info[i].Prev_Sample;
		}
		Pacer_Info[i].Prev_Sample = Filt_CurSample;
*/
		Pacer_Info[i].Pacer_pulse |= pacer;
		pacer = 0;
	}

	return pacer;

}
