/*****************************************************************************
 * File Name : ECGSystem_main.c 
 *
 * Brief	 : This file implements the ECG System for 8 Channel continus Channel      
 *  aquisition and a display of 6 Leads(1 Lead at a time) in the LCD with   
 *  option to change the leads as well as zooming of the display.
 *                                                                      
 *
 * Copyright (C) 2009 -2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
******************************************************************************/

#include "ECGDemoNonBios.h"     
#include "lcd.h"
#include "SAR.h"
#include "string.h"

/* Global variables used in this file */


/* System Information structure*/								
ECG_System_Info ECG_Info;			
/* Leadoffstatus variable*/
Uint16 LeadOffStatus = 0x01FF;	

extern Uint8 FE_Active;

/* Handle for UART driver*/
extern PSP_Handle hUart;
/* structure which stores the UART configuration values*/
extern PSP_UartConfig uartCfg;	
Uint8 Initial_HR_Flag = 0;
Uint8 HR_flag = 0;
Uint8 LeadOff_Flag = 0;
Uint8 HR_display_count = 1;	
Uint8 lead_digit_count = 0;
static Uint8 digit1,digit2,digit3;
		
extern Uint8 LCDDataReady;
extern Uint8 UARTDataReady;
extern Uint8 QRSDataReady;

/*-------------------------------------------------------------------------**
**    Function name : ECG_SubSystem()                                         **
**    Description : The function does the following:-                      **
**                                                                         **
**                                                                         **
**                                                                         **
**                     - Call the Process function                         **
**                                                                         **
**                     - Call the QRS Algorithm                            **
**                                                                         **
**                     - Call the LCD plot function for the current sample **
**                                                                         **
**                                                                         **
**     Parameters  : None                                                  **
** 	  Return	   : ECG system status                                     **
**-------------------------------------------------------------------------*/
#define NEW_PG_BOARD    1

#if (NEW_PG_BOARD ==1)
#define ADS1298_V6      0x001000
#define ADS1298_V1      0x080000
#define ADS1298_V5432   0x078000
#define ADS1298_LL_LA   0x006000
#define ADS1298_RA      0x000020
#else
#define ADS1298_V6 0x100000
#define ADS1298_V1 0x80000
#define ADS1298_V5432 0x78000
#define ADS1298_LL_LA 0x6000
#define ADS1298_RA 0x20
#endif

extern Int16 ECGData[];
extern Uint32 LeadStatus;
extern 	Uint8 UARTPacket[256];

extern	unsigned char UARTstart;
extern	unsigned char UARTend;
extern	unsigned UARTdataRdy;

extern Int8 intCount;
extern Uint16 LeadSelect;   
extern Uint8 col;
extern Uint16 KeyPressed;

extern Uint16 QRS_Heart_Rate;
extern Uint16 ChannelNo;
extern Uint8 Zoom_Flag;

void ProcessKey(Uint16 AdCVal)
{
	static Uint16 Key =0, PrevKey=0, FirstTime=1, PrevADCval ;

	if ( FirstTime == 1 )
	{
		PrevADCval = AdCVal;
		FirstTime = 0;
	}
	if ( PrevADCval != AdCVal)
	{
		if ( AdCVal < SW8 -10)
		{
			Key = 7;
			if ( PrevKey != Key)
			{
	          	LeadSelect ++;
				ChannelNo++;
				if(ChannelNo >= 8) ChannelNo =0;
				
				if(LeadSelect >= 12)
				{
					LeadSelect = 0;
				}

				KeyPressed = 1;
				PrevKey = Key;
			}
		}
	    else if((AdCVal >= SW8) && (AdCVal <= SW9))
	    {
			Key = 8;
			if ( PrevKey != Key)
			{
				if(Zoom_Flag==0)
				{
					Zoom_Flag = 1;
				}
				else
				if(Zoom_Flag==1)
				{
					Zoom_Flag = 2;
				}
				else
				if(Zoom_Flag==2)
				{
					Zoom_Flag = 0;
				}
				PrevKey = Key;

			}
	    }
	    else
	    {
			Key = 0;
	    }

		PrevKey = Key;
		PrevADCval = AdCVal;
	}
}
void KeyDetect(void)
{

	static Uint16 Count=0,AdCVal, debounce = 0;

		Count++;
		if ( debounce > 0) debounce--;
		if (Count > 5 && debounce==0)
		{
			AdCVal = Get_Sar_Key();
			Count =0;
		} 
		else if ( Count > 4)
		{
			ProcessKey(AdCVal);
			if (KeyPressed)
			{
				debounce = 25;
			}
		}

}
void ECG_LCD_LeadDisplay(LeadSelect)	
{

	static Uint16 digit_count = 0;
	char fontArr[4] ={" II"};  
	switch(LeadSelect )
	{
		case 0 :
    	strcpy((char*)fontArr,"  I");
		break;

		case 1 :
    	strcpy((char*)fontArr," II");

		break;
		case 2 :
    	strcpy((char*)fontArr,"III");

		break;
		case 3 :
    	strcpy((char*)fontArr,"aVR");

		break;
		case 4 :
    	strcpy((char*)fontArr,"aVL");

		break;
		case 5 :
    	strcpy((char*)fontArr,"aVF");

		break;
		case 6 :
    	strcpy((char*)fontArr," V1");

		break;
		case 7 :
    	strcpy((char*)fontArr," V2");

		break;
		case 8 :
    	strcpy((char*)fontArr," V3");

		break;
		case 9 :
    	strcpy((char*)fontArr," V4");

		break;
		case 10 :
    	strcpy((char*)fontArr," V5");

		break;
		case 11 :
    	strcpy((char*)fontArr," V6");

		break;
    }

    // diplay lead name  Peter
#if 0    
    /*Displaying 1st Digit of Lead value */	
	draw_font_Lead(4,13,fontArr[0],BLUE);
	/*Displaying 2nd Digit of Lead value */	
	draw_font_Lead(12,13,fontArr[1],BLUE);
	/*Displaying 3rd Digit of Lead value */	
	draw_font_Lead(20,13,fontArr[2],BLUE);

	digit_count = 0;
	KeyPressed = 0;

#else
	if(digit_count<8)
	{	
			/*Displaying 1st Digit of Lead value */	
			draw_font_Lead(4,13,fontArr[0],BLUE);
	}

		if((digit_count >= 8)&&(digit_count <= 15))
	{	
			/*Displaying 2nd Digit of Lead value */	
			draw_font_Lead(12,13,fontArr[1],BLUE);
	}
	if((digit_count >15)&&(digit_count <= 23))
	{							
			/*Displaying 3rd Digit of Lead value */	
		draw_font_Lead(20,13,fontArr[2],BLUE);
	}

		
	digit_count++;	
	if(digit_count >= 24)
	{
		digit_count = 0;
		KeyPressed = 0;
	}	
#endif

}

Uint8 ReadKey = 0;
ECG_Status ECG_SubSystem()
{
     
      /* Declare all the variables used in the function*/
	ECG_Status Status = ECG_OK; /* Status Variable */

	/* Count used to measure number of Frames*/  
	static Uint16 frameCnt =0, LeadSts = 0;

	static Uint16 Debaunce = 0;

	Uint32 LeadFail;
	Int16 Filterd_Out[8], PrevLeadSts;

	frameCnt++;
	if(frameCnt % 4 ==0)
	{
		frameCnt = 0;
		LCDDataReady = 1;
	}
#if (NEW_PG_BOARD ==1)
    if ( LeadStatus & 0x0FF060)
#else	
	if ( LeadStatus & 0x1FE060)
#endif

	{
		LeadOff_Flag = 1;
		PrevLeadSts = ~LeadOffStatus;
		PrevLeadSts &= 0x1FF;
#if (NEW_PG_BOARD ==1)		
	    LeadFail = (LeadStatus & ADS1298_V6) >> 4;
		LeadFail |= (LeadStatus & ADS1298_V1) >> 16;
		LeadFail |= (LeadStatus & ADS1298_V5432) >> 11;
		LeadFail |= (LeadStatus & ADS1298_LL_LA) >> 12;
		LeadFail |= (LeadStatus & ADS1298_RA) >> 5;
#else				
		LeadFail = (LeadStatus & ADS1298_V6) >> 12;
		LeadFail |= (LeadStatus & ADS1298_V1) >> 16;
		LeadFail |= (LeadStatus & ADS1298_V5432) >> 11;
		LeadFail |= (LeadStatus & ADS1298_LL_LA) >> 12;
		LeadFail |= (LeadStatus & ADS1298_RA) >> 5;
#endif
		LeadOffStatus = (Uint16) ~LeadFail;
		LeadSts = (Uint16) LeadFail;
		LeadSts &= 0x1FF;
		LeadOffStatus &= 0x1FF;
		Debaunce = 1500;

	}
	else
	{ 
		if ( Debaunce == 0 && LeadOffStatus != 0x1FF)
		{
			LeadOff_Flag = 1;
			LeadOffStatus = 0x1FF;
			LeadSts = 0;
		}
		else Debaunce--;
	}

	/* Filter the data*/
	ECG_ProcessCurrSample(ECGData, Filterd_Out);

	if ( LeadSts & 0x01)
	{
		Filterd_Out[0] =0;
		Filterd_Out[1] =0;
	}
	else if ( LeadSts & 0x02)
	{

		Filterd_Out[0] =0;

	}
	else if ( LeadSts & 0x04)
	{

		Filterd_Out[1] =0;

	}

	if ( LeadSts & 0x08)
	{
		Filterd_Out[2] =0;
	}
	if ( LeadSts & 0x10)
	{
		Filterd_Out[3] =0;
	}
	if ( LeadSts & 0x20)
	{
		Filterd_Out[4] =0;
	}
	if ( LeadSts & 0x40)
	{
		Filterd_Out[5] =0;
	}
	if ( LeadSts & 0x80)
	{
		Filterd_Out[6] =0;
	}

	if ( LeadSts & 0x100)
	{
		Filterd_Out[7] =0;
	}

#if DISP_LCD

	/*  Display the HR in LCD*/
	ECG_LCD_HRDisplay();	

	if(LeadOff_Flag  )
	{
		ECG_LCD_LeadOffDisplay();		 
//		PrevLeadOffStatus = LeadOffStatus;
	}
#endif

	if ( (LeadSts & 0x04 ) == 0)
	{
		if ( (LeadSts & 0x01 ) == 0)
		{
	/* Call QRS algorithm interface */
			QRS_Algorithm_Interface(Filterd_Out[1]);
		}
		else if ( (LeadSts & 0x02 ) == 0)
		{
	/* Call QRS algorithm interface */
			QRS_Algorithm_Interface(Filterd_Out[0]);
		}
		else
		{
			QRS_Heart_Rate = 0;
			ECG_Info.ECG_HeartRate = 0;
		}
	}

#if RAW_DATA
	/* Tx the current sample through UART */
	ECG_UARTTxCurrSamples_debug(ECGData);
	 
#else
#if 0
	/* Tx the current sample through UART */
	/* Enable this code to get 250 SPS raw data displayed on PC app.*/	
	ECG_UARTTxCurrSamples(ECGData); 
#else

	/* Tx the current sample through UART */
	ECG_UARTTxCurrSamples(Filterd_Out); 

#endif
#endif

#if DISP_LCD

	if(LCDDataReady == 1)
	{
		LCDDataReady = 0; 
		/* Plot the current processed sample in the LCD */
		ECG_LCDPlotCurrSample(Filterd_Out, LeadSelect);      
	}

	if(frameCnt == 2)
	{
	
		if ( KeyPressed == 1)
		{
			ECG_LCD_LeadDisplay(LeadSelect);
		}
		ReadKey =1;
	}
#endif
	return Status;
}

void ECG_StartTimer0()
{
	/* Start the Timer 0*/
	*CPU_TIM0_CTRL = *CPU_TIM0_CTRL | 0x0001; 
}

/*-------------------------------------------------------------------------**
**     Function Name	: main()                                           **
**     Description 	: The main function does the following:-               **
**                                                                         **
**                     - Clears all the global buffers                     **
**                                                                         **
**                     - Call the C5505 Initialization function            **
**                                                                         **
**                     - Clear the LCD and display the startup screen      **
**                                                                         **
**                     - Call the ECG System function in an infinite while **
**                     loop                                                **
**                                                                         **
**  Parameters  : None	                                                   **
** 	Returns		: void                                                     **
**-------------------------------------------------------------------------*/

void main()
{
    ECG_Status Status;				

	/* Call  Initialization function for the ECG system */
    Status = ECG_C5505Init();
    if(Status != ECG_OK)
    {
		//printf("ECG System Initialization FAIL\n");
		while(1);
	}
	else
	{
		//printf("ECG System Initialization PASS\n");
	
	}
    
	wait(1000);

	/* Display the ECG startup screen in LCD */
#if DISP_LCD
    ECG_DisplayLCDStartUpScreen();
#endif
	asm("\tBIT (ST1, #ST1_INTM) = #0");	  		/*Enable GLobal Int.Mask*/   

	/* Start the Timer0*/
	ECG_StartTimer0();
    	/*Enable SAR and INT1 interrupt */
	*CPU_IER0_ADDR = *CPU_IER0_ADDR | 0x1008;
	/* Infinite loop - the ECG processing will be done according to timer*/
	KeyPressed = 0;
	while(1)
	{
	
		if(QRSDataReady == 1)
		{
			QRSDataReady =0;
			ECG_SubSystem();
		}
		else if ( ReadKey )
		{
			KeyDetect();
			ReadKey = 0;
		}

	}
	    
}
   
void ECG_LCD_HRDisplay(void)	
{

	extern Uint16 QRS_Heart_Rate; 
   	Uint16 HR;
	Uint16 new_val; 
	static Uint16 PrevHr = 0;
	static Uint16 digit1_count = 0;  

	if(HR_flag)
	{
		if(PrevHr != QRS_Heart_Rate)
		{
		if(Initial_HR_Flag)
		{
			HR = QRS_Heart_Rate;
			digit1 = HR/100;
			new_val = HR % 100;
 			digit2 = new_val / 10;
			digit3 = new_val % 10;
			Initial_HR_Flag = 0;
		}
		if(digit1_count<8)
		{	
		//	digit1 = HR/100;				/*getting the first digit of HR value*/
 			draw_font_HR(82,13,(digit1+48),BLUE);/*displaying it by adding ASCII value*/
		}

 		if((digit1_count >= 8)&&(digit1_count <= 15))
		{	
		//	new_val = HR % 100;
 		//	digit2 = new_val / 10;				/*getting the second digit of HR value*/
 			draw_font_HR(90,13,(digit2+48),BLUE);/*displaying it by adding ASCII value*/
		}
		if((digit1_count >15)&&(digit1_count <= 23))
		{							
 		//	digit3 = new_val % 10;				/*getting the third digit of HR value*/
			draw_font_HR(98,13,(digit3+48),BLUE);/*displaying it by adding ASCII value*/
		}
		
		digit1_count++;	
		if(digit1_count >= 24)
		{
			digit1_count = 0;
			HR_flag = 0;	
			PrevHr = QRS_Heart_Rate;	
		}	
	}
	}



}



void ECG_LCD_LeadOffDisplay(void)	
{
	if(LeadOffStatus != 0x01FF)
 		{
			if(LeadOffStatus == ELECTRODE_RA)
				{
					/*Electrode  RA is OFF*/
					if(lead_digit_count<8)
					{
						draw_font_HR(45,13,82,RED);
						lead_digit_count++;
					}
					if(lead_digit_count >= 8)
					{
						draw_font_HR(53,13,65,RED);
						lead_digit_count++;
						if(lead_digit_count >= 16)
						{
							lead_digit_count = 0;
							LeadOff_Flag = 0;
						}
					}
				}
			else if(LeadOffStatus == ELECTRODE_LA)
				{
					/*Electrode  LA is OFF*/
					if(lead_digit_count<8)
					{
						draw_font_HR(45,13,76,RED);
						lead_digit_count++;
					}
					if(lead_digit_count >= 8)
					{
						draw_font_HR(53,13,65,RED);
						lead_digit_count++;
						if(lead_digit_count >= 16)
						{
							lead_digit_count = 0;
							LeadOff_Flag = 0;
						}
					}
				}
			else if(LeadOffStatus == ELECTRODE_LL)
				{
					/*Electrode  LL is OFF*/
				if(lead_digit_count<8)
					{
						draw_font_HR(45,13,76,RED);
						lead_digit_count++;
					}
					if(lead_digit_count >= 8)
					{
						draw_font_HR(53,13,76,RED);
						lead_digit_count++;
						if(lead_digit_count >= 16)
						{
							lead_digit_count = 0;
							LeadOff_Flag = 0;
						}
					}	
				}
			
			else if(LeadOffStatus == ELECTRODE_V1)
				{
					/*Electrode  V1 is OFF*/
					if(lead_digit_count < 8)
					{
						draw_font_HR(45,13,86,RED);
						lead_digit_count++;
					}
					if(lead_digit_count >= 8)
					{
						draw_font_HR(53,13,49,RED);
						lead_digit_count++;
						if(lead_digit_count >= 16)
						{
							lead_digit_count = 0;
							LeadOff_Flag = 0;
						}
					}	
				}
			else if(LeadOffStatus == ELECTRODE_V2)
				{
					/*Electrode  V2 is OFF*/
					if(lead_digit_count < 8)
					{
						draw_font_HR(45,13,86,RED);
						lead_digit_count++;
					}
					if(lead_digit_count >= 8)
					{
						draw_font_HR(53,13,50,RED);
						lead_digit_count++;
						if(lead_digit_count >= 16)
						{
							lead_digit_count = 0;
							LeadOff_Flag = 0;
						}
					}		
				}
			else if(LeadOffStatus == ELECTRODE_V3)
				{
					/*Electrode  V3 is OFF*/
					if(lead_digit_count < 8)
					{
						draw_font_HR(45,13,86,RED);
						lead_digit_count++;
					}
					if(lead_digit_count >= 8)
					{
						draw_font_HR(53,13,51,RED);
						lead_digit_count++;
						if(lead_digit_count >= 16)
						{
							lead_digit_count = 0;
							LeadOff_Flag = 0;
						}
					}	
				}
			else if(LeadOffStatus == ELECTRODE_V4)
				{
					/*Electrode  V4 is OFF*/
					if(lead_digit_count < 8)
					{
						draw_font_HR(45,13,86,RED);
						lead_digit_count++;
					}
					if(lead_digit_count >= 8)
					{
						draw_font_HR(53,13,52,RED);
						lead_digit_count++;
						if(lead_digit_count >= 16)
						{
							lead_digit_count = 0;
							LeadOff_Flag = 0;
						}
					}		
				}
			else if(LeadOffStatus == ELECTRODE_V5)
				{
					/*Electrode  V5 is OFF*/
					if(lead_digit_count < 8)
					{
						draw_font_HR(45,13,86,RED);
						lead_digit_count++;
					}
					if(lead_digit_count >= 8)
					{
						draw_font_HR(53,13,53,RED);
						lead_digit_count++;
						if(lead_digit_count >= 16)
						{
							lead_digit_count = 0;
							LeadOff_Flag = 0;
						}
					}	
				}
			else if(LeadOffStatus == ELECTRODE_V6)
				{
					/*Electrode  V6 is OFF*/
					if(lead_digit_count < 8)
					{
						draw_font_HR(45,13,86,RED);
						lead_digit_count++;
					}
					if(lead_digit_count >= 8)
					{
						draw_font_HR(53,13,54,RED);
						lead_digit_count++;
						if(lead_digit_count >= 16)
						{
							lead_digit_count = 0;
							LeadOff_Flag = 0;
						}
					}	
				}
			

			else 
				/*Red circle indicating 2 or more leads are off*/
				{
					if(lead_digit_count < 8)
					{
						draw_font_HR(45,13,38,RED);
						LCD_clear_window(53,13,61,21);
						lead_digit_count++;
					}
					if(lead_digit_count >= 8)
					{
						lead_digit_count = 0;
						LeadOff_Flag = 0;
					}
				}	
 		}
	else
		/*Green circle indicating all the leads are connected*/
		{
			//LCD_clear_window(45,13,60,20);
			if(lead_digit_count < 8)
			{
	/*Green Circle indicating Lead_Off Status*/
				draw_font_HR(45,13,38,GREEN);
				LCD_clear_window(53,13,61,21);
				lead_digit_count++;
			}
			if(lead_digit_count >= 8)
			{
				lead_digit_count = 0;
				LeadOff_Flag = 0;
			}
		}
}
