/*****************************************************************************
 * File Name : ECG_Filter_Co-efficients.c 
 *
 * Brief	 : The file contains the coefficients for Multi  band FIR LPF
 *             used for filtering the DC Removed samples	                                                         
 *
 * Copyright (C) 2009 -2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
******************************************************************************/


#include "ECGGlobals.h"
#include "tistdtypes.h"

#define SPS 500

Int16 CoeffBuf[FILTERORDER] = {             

#if NOTCHFILTERSEL
/* Coeff for Notch @ 60Hz for 500SPS/60Hz Notch coeff13102008*/
       28,     23,      2,    -25,    -43,    -38,     -9,     29,     56,
       54,     20,    -29,    -68,    -71,    -34,     26,     76,     87,
       50,    -18,    -81,   -102,    -68,      7,     82,    115,     86,
        8,    -78,   -124,   -103,    -24,     71,    130,    119,     42,
      -59,   -131,   -132,    -61,     44,    127,    141,     78,    -27,
     -118,   -145,    -93,      9,    105,    144,    104,      9,    -89,
     -138,   -111,    -25,     71,    126,    112,     39,    -52,   -111,
     -107,    -48,     33,     91,     97,     51,    -17,    -69,    -80,
      -48,      4,     47,     59,     38,      3,    -25,    -33,    -21,
       -4,      6,      4,     -3,     -3,      8,     25,     33,     18,
      -16,    -53,    -67,    -42,     16,     79,    106,     74,     -8,
      -99,   -145,   -113,    -10,    112,    184,    159,     39,   -116,
     -220,   -209,    -77,    110,    251,    261,    124,    -93,   -274,
     -314,   -179,     65,    288,    364,    240,    -24,   -290,   -409,
     -306,    -27,    280,    446,    372,     88,   -257,   -474,   -437,
     -157,    220,    490,    498,    232,   -171,   -493,   -553,   -310,
      110,    481,    597,    389,    -39,   -455,   -631,   -464,    -40,
      414,    650,    535,    125,   -360,   -655,   -597,   -212,    293,
      644,    648,    298,   -217,   -618,   -686,   -381,    133,    577,
      709,    456,    -45,   -523,  32051,   -523,    -45,    456,    709,
      577,    133,   -381,   -686,   -618,   -217,    298,    648,    644,
      293,   -212,   -597,   -655,   -360,    125,    535,    650,    414,
      -40,   -464,   -631,   -455,    -39,    389,    597,    481,    110,
     -310,   -553,   -493,   -171,    232,    498,    490,    220,   -157,
     -437,   -474,   -257,     88,    372,    446,    280,    -27,   -306,
     -409,   -290,    -24,    240,    364,    288,     65,   -179,   -314,
     -274,    -93,    124,    261,    251,    110,    -77,   -209,   -220,
     -116,     39,    159,    184,    112,    -10,   -113,   -145,    -99,
       -8,     74,    106,     79,     16,    -42,    -67,    -53,    -16,
       18,     33,     25,      8,     -3,     -3,      4,      6,     -4,
      -21,    -33,    -25,      3,     38,     59,     47,      4,    -48,
      -80,    -69,    -17,     51,     97,     91,     33,    -48,   -107,
     -111,    -52,     39,    112,    126,     71,    -25,   -111,   -138,
      -89,      9,    104,    144,    105,      9,    -93,   -145,   -118,
      -27,     78,    141,    127,     44,    -61,   -132,   -131,    -59,
       42,    119,    130,     71,    -24,   -103,   -124,    -78,      8,
       86,    115,     82,      7,    -68,   -102,    -81,    -18,     50,
       87,     76,     26,    -34,    -71,    -68,    -29,     20,     54,
       56,     29,     -9,    -38,    -43,    -25,      2,     23,     28

#else
/* Coeff for Notch @ 50Hz @ 500 SPS*/
      -28,    -26,    -11,     12,     35,     47,     41,     17,    -18,
      -50,    -65,    -56,    -22,     24,     65,     83,     70,     28,
      -29,    -78,   -100,    -84,    -33,     34,     91,    115,     95,
       37,    -38,   -101,   -128,   -105,    -41,     41,    110,    137,
      112,     43,    -44,   -115,   -144,   -117,    -45,     45,    118,
      146,    118,     45,    -45,   -117,   -144,   -116,    -44,     43,
      112,    137,    109,     41,    -40,   -103,   -125,    -99,    -37,
       36,     91,    108,     84,     31,    -29,    -73,    -86,    -65,
      -23,     22,     52,     59,     42,     14,    -12,    -27,    -26,
      -16,     -4,      1,     -2,    -11,    -15,     -8,     11,     35,
       52,     49,     22,    -24,    -71,    -97,    -86,    -36,     39,
      110,    145,    126,     51,    -54,   -150,   -196,   -167,    -67,
       70,    193,    249,    210,     83,    -87,   -236,   -302,   -253,
     -100,    103,    279,    356,    297,    117,   -120,   -322,   -409,
     -339,   -133,    136,    364,    460,    380,    148,   -151,   -404,
     -508,   -419,   -163,    166,    441,    554,    455,    176,   -179,
     -475,   -595,   -487,   -188,    191,    505,    631,    515,    199,
     -201,   -530,   -661,   -539,   -208,    209,    551,    685,    558,
      214,   -215,   -566,   -703,   -571,   -219,    219,    576,    714,
      578,    221,   -221,   -580,  32051,   -580,   -221,    221,    578,
      714,    576,    219,   -219,   -571,   -703,   -566,   -215,    214,
      558,    685,    551,    209,   -208,   -539,   -661,   -530,   -201,
      199,    515,    631,    505,    191,   -188,   -487,   -595,   -475,
     -179,    176,    455,    554,    441,    166,   -163,   -419,   -508,
     -404,   -151,    148,    380,    460,    364,    136,   -133,   -339,
     -409,   -322,   -120,    117,    297,    356,    279,    103,   -100,
     -253,   -302,   -236,    -87,     83,    210,    249,    193,     70,
      -67,   -167,   -196,   -150,    -54,     51,    126,    145,    110,
       39,    -36,    -86,    -97,    -71,    -24,     22,     49,     52,
       35,     11,     -8,    -15,    -11,     -2,      1,     -4,    -16,
      -26,    -27,    -12,     14,     42,     59,     52,     22,    -23,
      -65,    -86,    -73,    -29,     31,     84,    108,     91,     36,
      -37,    -99,   -125,   -103,    -40,     41,    109,    137,    112,
       43,    -44,   -116,   -144,   -117,    -45,     45,    118,    146,
      118,     45,    -45,   -117,   -144,   -115,    -44,     43,    112,
      137,    110,     41,    -41,   -105,   -128,   -101,    -38,     37,
       95,    115,     91,     34,    -33,    -84,   -100,    -78,    -29,
       28,     70,     83,     65,     24,    -22,    -56,    -65,    -50,
      -18,     17,     41,     47,     35,     12,    -11,    -26,    -28

#endif
};

/*   Q15 Multiplication Format  */
const Int16 AlisnCoeffBuf[51] = {
        6,      7,      8,      9,     10,     10,     11,     12,     13,
       14,     14,     15,     16,     17,     17,     18,     18,     19,
       19,     20,     20,     20,     21,     21,     21,     21,     21,
       21,     21,     20,     20,     20,     19,     19,     18,     18,
       17,     17,     16,     15,     14,     14,     13,     12,     11,
       10,     10,      9,      8,      7,      6
};

#if RAW_DATA
Int16 Sample_Data[100000] ;
#endif










