;/*****************************************************************************
; * File Name : ECG_FIR_Filter.asm
; *
; * Brief	 : Code for 351 ORDER FIR filter.
; *                                                                      
; *
; * Copyright (C) 2009 -2010 Texas Instruments Incorporated - http://www.ti.com/ 
; * 
; * 
; *  Redistribution and use in source and binary forms, with or without 
; *  modification, are permitted provided that the following conditions 
; *  are met:
; *
; *    Redistributions of source code must retain the above copyright 
; *    notice, this list of conditions and the following disclaimer.
; *
; *    Redistributions in binary form must reproduce the above copyright
; *    notice, this list of conditions and the following disclaimer in the 
; *    documentation and/or other materials provided with the   
; *    distribution.
; *
; *    Neither the name of Texas Instruments Incorporated nor the names of
; *    its contributors may be used to endorse or promote products derived
; *    from this software without specific prior written permission.
; *
; *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
; *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
; *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
; *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
; *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
; *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
; *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
; *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
; *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
; *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
; *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
; *
;******************************************************************************/

		.global _ECG_FilterProcess
		.global _ECG_AntiAlising_FilterProcess

		.global _ECG_AntiAlising_FilterProcess1

        .mmregs

        .include "lpva200.inc"

        .text
        ;.copy    "setup_da200.inc"                            ; setup code

      .ARMS_off                     ;enable assembler for ARMS=0
      .CPL_on                       ;enable assembler for CPL=1
      .mmregs                       ;enable mem mapped register names

;****************************************************************************************
;   Global Definations
;****************************************************************************************

;****************************************************************************************
;   Define constants
;****************************************************************************************
;.set ASSEMBLY_IMP 1

;****************************************************************************************
        .text 
;****************************************************************************************
;****************************************************************************************
;   351 Order FIR filter
;****************************************************************************************

;.if 0	;ASSEMBLY_IMP

_ECG_FilterProcess:

		AC0 = 0;
		
		repeat (#351)
		AC0 = AC0 + ((*AR0-)* (*AR1+));

;		repeat (#351)
;		AC0 = AC0 + ((*AR0-)* (*CDP+)) || AC1 = AC1 + ((*AR1-)* (*CDP+));
		
		(*AR2+) = HI(AC0);
		(*AR2) = AC0;
		
		return


_ECG_AntiAlising_FilterProcess:

		AC0 = 0;
		
		repeat (#51)
		AC0 = AC0 + ((*AR0-)* (*AR1+));


		(*AR2+) = HI(AC0);
		(*AR2) = AC0;
		
		return

_ECG_AntiAlising_FilterProcess1:

		AC0 = 0;
		
		repeat (#46)
		AC0 = AC0 + ((*AR0-)* (*AR1+));

		
		(*AR2+) = HI(AC0);
		(*AR2) = AC0;
		
	

		return


_ECG_DUAL_FilterProcess:

		AC0 = 0;
		
		repeat (#351)
		AC0 = AC0 + ((*AR0-)* (*AR1+));

;		repeat (#351)
;		AC0 = AC0 + ((*AR0-)* (*CDP+)) || AC1 = AC1 + ((*AR1-)* (*CDP+));
		
		(*AR2+) = HI(AC0);
		(*AR2) = AC0;
		
		return



;.endif
;****************************************************************************************
