/*****************************************************************************
 * File Name : InterruptHandler.c 
 *
 * Brief	 : The file includes interrupt service routine for the ECG system
 *                                                                      
 *
 * Copyright (C) 2009 -2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
******************************************************************************/


#include "InterruptHandlers.h"
#include "llc_spi.h"
#include "ADS1298.h"
#include "ADS1298_Pacer.h"

#define BLUE 0x03
#define QRSSAMP 1 // to be changed to 16 later
#define UARTSAMP 32
#define LCDSAMP 100
#define RESETVAL 800
#define TWENTY_FOUR_BIT_IMPLEMENTATION 

#define ECG_DECIMATOR 16

#define NEW_PG_BOARD    1

/* function to process samples for 1 sec*/	
extern Int16 ECG_SubSystem();	

extern void	ECG_AntiAlising_FilterProcess(Int16 *, Int16 *,Int16 *);

Uint8 LCDDataReady = 0;
Uint8 UARTDataReady = 0;
Uint8 QRSDataReady = 0;
Int8 intCount = 0;

//Global buffer to hold converted data
Int16 ECGData[8] = {0};
Uint32 LeadStatus = 0;
interrupt void i2c_isr()
{
	return;	
}

interrupt void spi_isr()
{
	return;		
}

interrupt void lcd_isr()
{
	return;		
}

interrupt void uart_isr()
{
	return;		
}

interrupt void int0_isr()
{
	return;		
}

/*-----------------------------------------------------------------------**
** 	FunctionName: int1_isr                                               **
** 	Description : - The INT1 ISR is used to read the 8 channel ADC data  **
** 					and the lead off status of all the channels.         **
**-----------------------------------------------------------------------*/

Uint16 count = 0;

Uint16 Pacer_detected;
Int16 bank_flag = 0;
Int16 even_flag = 0;
Int32 ptr =0;
Uint16 ChannelNo =1;
extern Int16 Sample_Data[];
extern Int16 AlisnCoeffBuf[51];
#define ALSIN_FILTERORDER 51
Int16 AlisnWorkingBuff[MAXCHAN][2 * ALSIN_FILTERORDER]={0};

interrupt void int1_isr()
{
	Uint32 SPIBuf[MAXCHAN+2] = {0};			/* SPI Rx Buffer*/

	Uint16 wLen = 0; 				/* No. of bits per word to read*/
    Uint16 fLen = 0;				/* No. words to be read*/   
	Uint8 col = 0;	
 	static Uint16 QRSDataReady1 = 0;
	Uint32 ECGDataSample[MAXCHAN];
	short ECG_DataSample[MAXCHAN];
	static Int32 Pvev_Sample[MAXCHAN], Pvev_DC_Sample[MAXCHAN] ;

//	static Int16 PrevPrevPrevECGData[MAXCHAN]={0},PrevPrevECGData[MAXCHAN]={0},PrevECGData[MAXCHAN]={0};
	
	static ADS1298_ECGSystem_Pacer_Info Pacer_Info[MAXCHAN];
	
#if (NEW_PG_BOARD ==1)
    static Int16 LeadAray[8] = {2,3,8,4,5,6,7,1};		// PG 2.0	
#else	
	static Int16 LeadAray[8] = {1,2,4,5,6,7,3,8};
#endif	
	static Uint16 bufStart=0, bufCur = ALSIN_FILTERORDER-1;

	Int16 FiltOut;
	Int32 FilterOut[2], temp1, temp2;

    intCount++;
   *GPIO_DOUT0_ADDR = *GPIO_DOUT0_ADDR | 0x0400; 

 	/* Read data- continuous mode */
	wLen = 24;
	fLen = 9;	
	if (QRSDataReady1)
	{
		QRSDataReady = 1;
		QRSDataReady1 = 0;

	}
	/*Reading data from ADS1298 */

	LLC_SPI_WordLengthRead(SPIBuf, wLen, fLen);
	
	even_flag++;

	for ( col =0; col < MAXCHAN; col++)
	{
		ECGDataSample[col] = SPIBuf[LeadAray[col]];
		ECGDataSample[col] = ECGDataSample[col] >> 4;
		ECG_DataSample[col] = (short) ECGDataSample[col];

#if RAW_DATA

		if ( col == ChannelNo && bank_flag == 0)
		{

			Sample_Data[ptr++] = ECGDataSample[col];

			if(ptr == 80000)
			{
				bank_flag = 1;
				ptr =0;
			}
		}
#endif

	}
	
	Pacer_detection(ECG_DataSample, Pacer_Info);


	for ( col =0; col < MAXCHAN; col++)
	{
		ECG_DataSample[col] = Pacer_Info[col].PrevPrev_Sample;

		AlisnWorkingBuff[col][bufCur] = ECG_DataSample[col];

		ECG_AntiAlising_FilterProcess(&AlisnWorkingBuff[col][bufCur],AlisnCoeffBuf,(Int16*)&FilterOut);
		AlisnWorkingBuff[col][bufStart] = ECG_DataSample[col];

		FiltOut = (Int16)(((FilterOut[0] >> 10) & (0x0000FFFF)));
		/* Store the filtered out sample to the LeadInfo buffer*/

		ECG_DataSample[col] = FiltOut ;//(CurrOut);

	}

	bufCur++;
	bufStart++;
	if ( bufStart  == (ALSIN_FILTERORDER-1))
	{
		bufStart=0; 
		bufCur = ALSIN_FILTERORDER-1;
	}

	if ( intCount == ECG_DECIMATOR)
	{
		intCount = 0;
		QRSDataReady1 = 1;
	    LeadStatus = SPIBuf[0];

	    for(col = 0; col < MAXCHAN; col++)
	    {
			temp1 = NRCOEFF * Pvev_DC_Sample[col];
			Pvev_DC_Sample[col] = (ECG_DataSample[col]  - Pvev_Sample[col]) + temp1;
			Pvev_Sample[col] = ECG_DataSample[col];
			temp2 = Pvev_DC_Sample[col] >> 2;
			ECGData[col] = (Int16) temp2;
	    }

		Pacer_detected |= Pacer_Info[1].Pacer_pulse;
		Pacer_Info[0].Pacer_pulse =0;
		Pacer_Info[1].Pacer_pulse =0;
		Pacer_Info[2].Pacer_pulse =0;
		Pacer_Info[3].Pacer_pulse =0;
		Pacer_Info[4].Pacer_pulse =0;
		Pacer_Info[5].Pacer_pulse =0;
		Pacer_Info[6].Pacer_pulse =0;
		Pacer_Info[7].Pacer_pulse =0;
	}
   *GPIO_DOUT0_ADDR = *GPIO_DOUT0_ADDR & 0xFBFF;
	return;

}
interrupt void tim0_isr()
{	

//	ECG_System();


	*CPU_TIMINT_AGGR = *CPU_TIMINT_AGGR | 0x0001;
}

/*----------------------------------------------------------------------**
** 	Function Name : saradc_isr                                          **
** 	Description : 	-   The SARADC ISR is used to identify the switch   **
** 						Detection whenever a switch is pressed by user. **
** 						The ISR sets the KeyCount and Zoom Flag         **
** 						according to the switches  selected by the user **
** 	                                                                    **
**----------------------------------------------------------------------*/
Uint16 LeadSelect = 1;
Uint16 KeyPressed = 0;
   
interrupt void saradc_isr()
{
	return;		
}
