;***********************************************************
; Version 2.40.00                                           
;***********************************************************
; Function:    fir2
; Processor:   C55xx
; Description: Implements finite impulse response filter using
;              dual-MAC approach.  C-callable.
;
; Useage: ushort oflag = firs(DATA *x,
;                             DATA *h,
;                             DATA *r,
;                             DATA *dbuffer,
;                             ushort nx,
;                             ushort nh)
;
; Copyright Texas instruments Inc, 2000
; History:
; 2.10	Rishi  08/03/2001 - optimized the code for benchmark.
;****************************************************************

      .ARMS_off                     ;enable assembler for ARMS=0
      .CPL_on                       ;enable assembler for CPL=1
      .mmregs                       ;enable mem mapped register names

;End of file
	.global ECG_Dual_fir_filter

_ECG_Dual_fir_filter:

;Set registers with arguments

	MOV *AR0+, AR2
	MOV *AR0+, CDP
	MOV *AR0+, AR0


;1st iteration
	MPY	*AR1-, *CDP+, AC0			;part 1 of dual-MPY
	::MPY	*AR2-, *CDP+, AC1		;part 2 of dual-MPY
	||	RPT	#351					; reapet instruction 

;Reapet loop for filter tab 351 

	MAC	*AR1-, *CDP+, AC0			;part 1 of dual-MAC
	::MAC	*AR2-, *CDP+, AC1		;part 2 of dual-MAC

;store results to memory
	
	MOV HI(AC0), *AR0+    			;store 1st Q15 result to memory
	MOV AC0, *AR0+    				;store 1st Q15 result to memory

	MOV HI(AC1), *AR0+    			;store 2nd Q15 result to memory
	MOV AC1, *AR0+    				;store 2nd Q15 result to memory

; Return to calling function
;----------------------------------------------------------------
	RET