/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.webserver.internal;

import com.ti.gui.composer.webserver.adapter.internal.IClientInfo;
import com.ti.gui.composer.webserver.adapter.internal.IClientInfoProvider;
import com.ti.gui.composer.webserver.adapter.internal.IClientListener;
import com.ti.gui.composer.webserver.adapter.internal.IGroupChangeListener;
import com.ti.gui.composer.webserver.adapter.internal.IWidgetValueChange;
import com.ti.gui.composer.webserver.internal.ClientInfo;
import com.ti.gui.composer.webserver.internal.GuiComposerHelper;
import com.ti.gui.composer.webserver.internal.GuiComposerWebServer;
import com.ti.gui.composer.webserver.internal.GuiComposerWebServerPlugin;
import com.ti.gui.composer.webserver.internal.GuiComposerWebSocket;
import com.ti.gui.composer.webserver.internal.IDebugFilter;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.eclipse.jetty.websocket.WebSocket;

class GuiComposerClientListener
implements IClientListener,
IGroupChangeListener,
IClientInfoProvider {
    WebSocket.Connection connection;
    GuiComposerWebSocket socket;
    ClientInfo clientInfo;

    GuiComposerClientListener(GuiComposerWebSocket socket, WebSocket.Connection connection) {
        this.connection = connection;
        this.socket = socket;
        this.clientInfo = new ClientInfo(this);
    }

    public void onValueChanged(String widgetId, String propertyName, Object newValue) {
        String msg = String.valueOf(this.generateChangeMessageStart(widgetId, propertyName, newValue)) + " }";
        this.sendMessage(msg);
    }

    public void onOperationCompleted(String requestId, Object result) {
        String jsonResult = GuiComposerHelper.object2Jason(result);
        String jsonMessage = "{\"requestName\" : \"operationCompleted\" , \"requestId\" : \"" + requestId + "\" , \"result\" : " + jsonResult + "}";
        this.sendMessage(jsonMessage);
    }

    public void onStatusChanged(String widgetId, String propertyName, String statusType, String statusMessage) {
        String typeString = GuiComposerHelper.object2Jason(statusType);
        String newStatusMsg = String.valueOf(propertyName) + ": " + statusMessage;
        String messageString = GuiComposerHelper.object2Jason(newStatusMsg);
        String jsonMessage = "{\"requestName\" : \"propertyStatusChange\" , \"widgetId\" : \"" + widgetId + "\" , \"propertyName\" : \"" + propertyName + "\" ,\"statusType\" : " + typeString + " ,\"message\" : " + messageString + "}";
        this.sendMessage(jsonMessage);
    }

    public void requestWidgetConnect(String widgetId, String propertyName) {
        String jsonMessage = "{\"requestName\" : \"connectWidget\" , \"widgetId\" : \"" + widgetId + "\" , \"propertyName\" : \"" + propertyName + "\" }";
        this.sendMessage(jsonMessage);
    }

    private void sendMessage(String jsonMessage) {
        block6: {
            try {
                if (GuiComposerWebServerPlugin.DEBUG) {
                    GuiComposerWebServerPlugin.debug("sendMessage:" + jsonMessage, IDebugFilter.WEB_SOCKET);
                }
                if (this.connection.isOpen()) {
                    this.connection.sendMessage(jsonMessage);
                } else if (GuiComposerWebServerPlugin.DEBUG) {
                    GuiComposerWebServerPlugin.debug("sendMessage: Connection is Closed.", IDebugFilter.WEB_SOCKET);
                }
            }
            catch (IOException e) {
                if (!GuiComposerWebServerPlugin.DEBUG) break block6;
                GuiComposerWebServerPlugin.debug(e, IDebugFilter.WEB_SOCKET);
            }
        }
    }

    public String resolveAppPath(String appPath) {
        return this.socket.getServer().resolveAppPath(appPath);
    }

    public void onMultipleValuesChanged(IWidgetValueChange[] changes) {
        String jsonMessage = "{\"requestName\" : \"groupRequest\" ,  \"requests\" : [ ";
        int i = 0;
        while (i < changes.length) {
            IWidgetValueChange change = changes[i];
            String currentChange = String.valueOf(this.generateChangeMessageStart(change.getWidgetId(), change.getPropertyId(), change.getValue())) + " }";
            if (i < changes.length - 1) {
                currentChange = String.valueOf(currentChange) + " , ";
            }
            jsonMessage = String.valueOf(jsonMessage) + currentChange;
            ++i;
        }
        jsonMessage = String.valueOf(jsonMessage) + " ]}";
        this.sendMessage(jsonMessage);
    }

    public void onValueChanged(String widgetId, String propertyName, Object newValue, Map<String, Object> attributes) {
        String msg = this.generateChangeMessageStart(widgetId, propertyName, newValue);
        for (Map.Entry<String, Object> c : attributes.entrySet()) {
            String key = c.getKey();
            Object value = c.getValue();
            String valueString = GuiComposerHelper.object2Jason(value);
            msg = String.valueOf(msg) + " , \"" + key + "\" : " + valueString;
        }
        msg = String.valueOf(msg) + " } ";
        this.sendMessage(msg);
    }

    String generateChangeMessageStart(String widgetId, String propertyName, Object newValue) {
        String timeSent = new Long(new Date().getTime()).toString();
        String newValue2Json = GuiComposerHelper.object2Jason(newValue);
        String jsonMessage = "{\"requestName\" : \"propertyChange\" , \"widgetId\" : \"" + widgetId + "\" , " + "\"propertyName\" : \"" + propertyName + "\" , " + "\"timeSent\" : " + timeSent + " , " + "\"newValue\" : " + newValue2Json;
        return jsonMessage;
    }

    public IClientInfo getClientInfo() {
        return this.clientInfo;
    }

    boolean isLocalAddress() {
        return GuiComposerWebServer.isAddressLocalHost(this.socket.getRemoveAddress());
    }
}

