/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.webserver.internal;

import com.ti.gui.composer.webserver.adapter.internal.IBindingRegistry;
import com.ti.gui.composer.webserver.adapter.internal.IServerFileOperations;
import com.ti.gui.composer.webserver.adapter.internal.IStartupInfo;
import com.ti.gui.composer.webserver.internal.GuiComposerWebServerPlugin;
import com.ti.gui.composer.webserver.internal.GuiComposerWebSocketHandler;
import com.ti.gui.composer.webserver.internal.IAccessiblePrompter;
import com.ti.gui.composer.webserver.internal.IDebugFilter;
import com.ti.gui.composer.webserver.internal.IResourceMapper;
import com.ti.gui.composer.webserver.internal.ResourceMapInfo;
import com.ti.gui.composer.webserver.internal.WebAppInfo;
import com.ti.gui.composer.webserver.internal.WebLibInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;

public class GuiComposerWebServer {
    private static GuiComposerWebServer instance = null;
    private Apps apps = new Apps();
    private Libs libs = new Libs();
    private IStartupInfo startupInfo;
    private IServerFileOperations serverFileOperations;
    private static Set<String> accessibleIPs = new HashSet<String>();
    private static String ACCESSIBLE_FILENAME = ".accessible";
    private static String NEW_LINE = System.getProperty("line.separator");
    private static String DOWNLOAD_AREA = "download_area";
    private static String[] LOCAL_HOST_IP = new String[]{"localhost", "127.0.0.1", "0:0:0:0:0:0:0:0", "0:0:0:0:0:0:0:1"};

    public GuiComposerWebServer() {
        String[] stringArray = LOCAL_HOST_IP;
        int n = LOCAL_HOST_IP.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            accessibleIPs.add(s);
            ++n2;
        }
        File file = GuiComposerWebServer.getAccessibleFile();
        if (file.exists()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    accessibleIPs.add(line);
                }
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static File getAccessibleFile() {
        IPath location = GuiComposerWebServerPlugin.getDefault().getStateLocation();
        File file = location.append(ACCESSIBLE_FILENAME).toFile();
        return file;
    }

    public void start(IStartupInfo startupInfo, ArrayList<WebAppInfo> webAppInfoList, ArrayList<WebLibInfo> webLibInfoList, IBindingRegistry webBindingRegistry) {
        block13: {
            try {
                if (GuiComposerWebServerPlugin.DEBUG) {
                    GuiComposerWebServerPlugin.debug("GuiComposerWebServer.start(0)", IDebugFilter.HTTP);
                }
                this.startupInfo = startupInfo;
                this.serverFileOperations = webBindingRegistry.getServerFileOperations();
                Server server = new Server(startupInfo.getPort());
                MyHandlerCollection handlerList = new MyHandlerCollection();
                String severStoragePath = this.serverFileOperations.getRootFolder();
                if (severStoragePath != null) {
                    this.addApp(new WebAppInfo(severStoragePath, DOWNLOAD_AREA));
                }
                if (webAppInfoList != null) {
                    for (WebAppInfo appInfo : webAppInfoList) {
                        this.addApp(appInfo);
                    }
                }
                if (webLibInfoList != null) {
                    for (WebLibInfo libInfo : webLibInfoList) {
                        this.addLib(libInfo);
                    }
                }
                if (GuiComposerWebServerPlugin.DEBUG) {
                    GuiComposerWebServerPlugin.debug("GuiComposerWebServer.start(1)", IDebugFilter.HTTP);
                }
                MyServletHandler cntx = new MyServletHandler();
                cntx.addServlet(new ServletHolder((Servlet)new MyServlet()), "/" + startupInfo.getTopContext() + "/*");
                cntx.getSessionHandler().getSessionManager().setMaxInactiveInterval(60);
                handlerList.addHandler((Handler)cntx);
                if (GuiComposerWebServerPlugin.DEBUG) {
                    GuiComposerWebServerPlugin.debug("GuiComposerWebServer.start(2)", IDebugFilter.HTTP);
                }
                GuiComposerWebSocketHandler guiComposerWebSocketHandler = new GuiComposerWebSocketHandler(webBindingRegistry, this);
                ContextHandler webSocketsContextHandler = new ContextHandler("/ws");
                guiComposerWebSocketHandler.getWebSocketFactory().setMaxTextMessageSize(Integer.MAX_VALUE);
                webSocketsContextHandler.setHandler((Handler)guiComposerWebSocketHandler);
                handlerList.addHandler((Handler)webSocketsContextHandler);
                if (GuiComposerWebServerPlugin.DEBUG) {
                    GuiComposerWebServerPlugin.debug("GuiComposerWebServer.start(3)", IDebugFilter.HTTP);
                }
                server.setHandler((Handler)handlerList);
                if (GuiComposerWebServerPlugin.DEBUG) {
                    GuiComposerWebServerPlugin.debug("GuiComposerWebServer.start(4)", IDebugFilter.HTTP);
                }
                server.start();
                if (GuiComposerWebServerPlugin.DEBUG) {
                    GuiComposerWebServerPlugin.debug("GuiComposerWebServer.start(5)", IDebugFilter.HTTP);
                }
            }
            catch (Throwable e) {
                if (!GuiComposerWebServerPlugin.DEBUG) break block13;
                GuiComposerWebServerPlugin.debug(e, IDebugFilter.HTTP);
            }
        }
    }

    public void addApp(WebAppInfo appInfo) {
        this.apps.add(appInfo);
    }

    public void addLib(WebLibInfo libInfo) {
        this.libs.add(libInfo);
    }

    public void removeApp(WebAppInfo appInfo) {
        this.apps.remove(appInfo.getContextPath());
    }

    public void removeLib(WebLibInfo libInfo) {
        this.libs.remove(libInfo);
    }

    public void addResourceMapper(IResourceMapper mapper) {
        this.apps.addResourceMapper(mapper);
    }

    public void removeResourceMapper(IResourceMapper mapper) {
        this.apps.removeResourceMapper(mapper);
    }

    public static synchronized GuiComposerWebServer getInstance() {
        if (instance == null) {
            instance = new GuiComposerWebServer();
        }
        return instance;
    }

    public String resolveAppPath(String appPath) {
        Resource res = this.apps.getResource(appPath, null);
        if (res == null) {
            return null;
        }
        try {
            String appFolder = res.getFile().getParentFile().toString();
            return appFolder;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean isAddressLocalHost(String address) {
        String[] stringArray = LOCAL_HOST_IP;
        int n = LOCAL_HOST_IP.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(address)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static class AppInfo {
        private WebAppInfo appInfo;
        private MyAppResourceHandler resourceHandler;

        private AppInfo(WebAppInfo appInfo) {
            this.appInfo = appInfo;
            this.resourceHandler = new MyAppResourceHandler();
            this.resourceHandler.setResourceBase(appInfo.getWebAppDirectory());
        }

        public Resource getResource(String uri, Apps apps, IResourceFinder next) throws MalformedURLException {
            if (!uri.startsWith(this.appInfo.getContextPath())) {
                return null;
            }
            String newUri = uri.substring(this.appInfo.getContextPath().length());
            Resource result = this.resourceHandler.getResource(newUri);
            if (result == null || !result.exists()) {
                result = next != null ? next.getResource(newUri, null) : null;
            }
            return result;
        }
    }

    public class Apps
    implements IResourceFinder {
        private Map<String, AppInfo> apps = new HashMap<String, AppInfo>();
        ArrayList<IResourceMapper> mappers = null;

        @Override
        public synchronized Resource getResource(String uri, IResourceFinder next) {
            String prefix = "/" + GuiComposerWebServer.this.startupInfo.getTopContext() + "/";
            if (!uri.startsWith(prefix)) {
                return null;
            }
            uri = uri.substring(prefix.length());
            if (this.mappers != null) {
                for (IResourceMapper mapper : this.mappers) {
                    ResourceMapInfo resourceMapInfo = mapper.getResourceMapInfo(uri);
                    if (resourceMapInfo == null) continue;
                    if (resourceMapInfo.getWebAppInfo() != null) {
                        this.add(resourceMapInfo.getWebAppInfo());
                    }
                    if (resourceMapInfo.getURI() == null) break;
                    uri = resourceMapInfo.getURI();
                    break;
                }
            }
            for (AppInfo info : this.apps.values()) {
                Resource res = null;
                try {
                    res = info.getResource(uri, this, next);
                    if (res == null) continue;
                    return res;
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return null;
        }

        private synchronized void add(WebAppInfo appInfo) {
            if (this.apps.containsKey(appInfo.getContextPath())) {
                return;
            }
            AppInfo info = new AppInfo(appInfo);
            this.apps.put(appInfo.getContextPath(), info);
        }

        private synchronized void remove(String contextApp) {
            this.apps.remove(contextApp);
        }

        private synchronized void addResourceMapper(IResourceMapper resourceMapper) {
            if (this.mappers == null) {
                this.mappers = new ArrayList(2);
                this.mappers.add(resourceMapper);
            } else if (!this.mappers.contains(resourceMapper)) {
                this.mappers.add(resourceMapper);
            }
        }

        private synchronized void removeResourceMapper(IResourceMapper resourceMapper) {
            if (this.mappers != null) {
                this.mappers.remove(resourceMapper);
            }
        }
    }

    private static interface IResourceFinder {
        public Resource getResource(String var1, IResourceFinder var2) throws MalformedURLException;
    }

    private static class LibInfo {
        private WebLibInfo webLibInfo;
        private MyLibResourceHandler resourceHandler;

        private LibInfo(WebLibInfo webLibInfo) {
            this.webLibInfo = webLibInfo;
            this.resourceHandler = new MyLibResourceHandler();
            this.resourceHandler.setResourceBase(webLibInfo.getWebLibDirectory());
        }
    }

    private static class Libs
    implements IResourceFinder {
        private Map<String, LibInfo> libs = new HashMap<String, LibInfo>();

        private Libs() {
        }

        private synchronized void add(WebLibInfo libInfo) {
            if (this.libs.containsKey(libInfo.getPluginName())) {
                return;
            }
            LibInfo info = new LibInfo(libInfo);
            this.libs.put(libInfo.getPluginName(), info);
        }

        private synchronized void remove(WebLibInfo libInfo) {
            this.libs.remove(libInfo.getPluginName());
        }

        @Override
        public synchronized Resource getResource(String uri, IResourceFinder next) throws MalformedURLException {
            if (uri.endsWith(".gz")) {
                return null;
            }
            Path path = new Path(uri);
            int i = 0;
            while (i < path.segmentCount() - 1) {
                if (path.segment(i).equals("lib")) {
                    for (LibInfo info : this.libs.values()) {
                        if (!info.webLibInfo.getPluginName().equals(path.segment(i + 1))) continue;
                        Resource res = null;
                        try {
                            String relativePath = "/" + path.removeFirstSegments(i + 2).toString();
                            res = info.resourceHandler.getResource(relativePath);
                            if (res == null || !res.exists()) continue;
                            return res;
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
                ++i;
            }
            return next == null ? null : next.getResource(uri, null);
        }
    }

    private static class MyAppResourceHandler
    extends ResourceHandler {
        MyAppResourceHandler() {
        }

        public Resource getResource(String path) throws MalformedURLException {
            return super.getResource(path);
        }
    }

    private static class MyHandlerCollection
    extends HandlerCollection {
        private MyHandlerCollection() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            IAccessiblePrompter prompter;
            boolean handleRequest;
            String name;
            if (GuiComposerWebServerPlugin.DEBUG) {
                GuiComposerWebServerPlugin.debug("MyHandlerCollection.handle:(B)" + baseRequest.toString(), IDebugFilter.HTTP);
            }
            if (!GuiComposerWebServer.isAddressLocalHost(name = baseRequest.getRemoteAddr()) && System.getProperty("allowRemoteConnections") == null) {
                return;
            }
            boolean bl = handleRequest = System.getProperty("ignoreIPValidation") != null ? true : accessibleIPs.contains(name);
            if (!handleRequest && (prompter = GuiComposerWebServerPlugin.getAccessiblePrompter()) != null) {
                IAccessiblePrompter.Result result = prompter.prompt(name, baseRequest.getLocalPort());
                switch (result) {
                    case allow: {
                        handleRequest = true;
                        accessibleIPs.add(name);
                        break;
                    }
                    case remember: {
                        handleRequest = true;
                        accessibleIPs.add(name);
                        try {
                            File file = GuiComposerWebServer.getAccessibleFile();
                            BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));
                            writer.write(String.valueOf(name) + NEW_LINE);
                            writer.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            }
            if (handleRequest) {
                if (baseRequest.getRequestURI().startsWith("/gc/maqetta_preview")) {
                    response.setHeader("Cache-Control", "no-cache");
                }
                super.handle(target, baseRequest, request, response);
            }
            if (GuiComposerWebServerPlugin.DEBUG) {
                GuiComposerWebServerPlugin.debug("MyHandlerCollection.handle:(E)" + baseRequest.toString(), IDebugFilter.HTTP);
            }
        }
    }

    private static class MyLibResourceHandler
    extends ResourceHandler {
        MyLibResourceHandler() {
        }

        public Resource getResource(String path) throws MalformedURLException {
            return super.getResource(path);
        }
    }

    public class MyServlet
    extends DefaultServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Part part = request.getPart("userfile1");
            if (part != null) {
                String fileName = this.getFileNameFromMultipartHeader(part.getHeader("content-disposition"));
                InputStream inputStream = part.getInputStream();
                PrintWriter outp = response.getWriter();
                if (inputStream != null && outp != null && GuiComposerWebServer.this.serverFileOperations != null) {
                    String[] error = new String[1];
                    String name = GuiComposerWebServer.this.serverFileOperations.uploadFile(inputStream, fileName, 0, error);
                    if (error[0] == null) {
                        outp.write("name=" + name);
                    } else {
                        outp.write("error=" + error[0]);
                    }
                    return;
                }
            }
            super.doGet(request, response);
        }

        public Resource getResource(String pathInContext) {
            Resource ret = super.getResource(pathInContext);
            if (ret == null) {
                ret = GuiComposerWebServer.this.apps.getResource(pathInContext, GuiComposerWebServer.this.libs);
            }
            return ret;
        }

        private String getFileNameFromMultipartHeader(String header) {
            if (header == null) {
                return null;
            }
            String paramName = "filename=";
            int i = header.indexOf(paramName);
            if (i == -1) {
                return null;
            }
            String token = header.substring(i + paramName.length());
            if ((i = token.indexOf("\"")) == -1) {
                return null;
            }
            if ((i = (token = token.substring(i + 1)).indexOf("\"")) == -1) {
                return null;
            }
            if ((token = token.substring(0, i)).length() <= 0) {
                return null;
            }
            return token;
        }
    }

    private static class MyServletHandler
    extends ServletContextHandler {
        private MyServletHandler() {
            super(3);
        }

        public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            super.doHandle(target, baseRequest, request, response);
        }

        public Resource getResource(String path) throws MalformedURLException {
            return super.getResource(path);
        }
    }
}

