/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.webserver.internal;

import com.ti.gui.composer.webserver.internal.IAccessiblePrompter;
import com.ti.gui.composer.webserver.internal.IDebugFilter;
import java.io.PrintStream;
import java.util.Calendar;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class GuiComposerWebServerPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.ti.gui.composer.webserver";
    public static boolean DEBUG = false;
    public static boolean[] debugComponent = new boolean[IDebugFilter.values().length];
    private static GuiComposerWebServerPlugin plugin;
    private static IAccessiblePrompter accessiblePrompter;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.initTraceFlags();
    }

    public static GuiComposerWebServerPlugin getDefault() {
        return plugin;
    }

    static synchronized IAccessiblePrompter getAccessiblePrompter() {
        IExtension[] es;
        IExtensionPoint ep;
        if (accessiblePrompter == null && (ep = Platform.getExtensionRegistry().getExtensionPoint("com.ti.gui.composer.webserver.accessiblePrompter")) != null && (es = ep.getExtensions()).length > 0) {
            IConfigurationElement[] elements = es[0].getConfigurationElements();
            int extentionElement = 0;
            while (extentionElement < elements.length) {
                IConfigurationElement delegateElement = elements[extentionElement];
                try {
                    accessiblePrompter = (IAccessiblePrompter)delegateElement.createExecutableExtension("class");
                    break;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    ++extentionElement;
                }
            }
        }
        return accessiblePrompter;
    }

    private void initTraceFlags() {
        DEBUG = "true".equals(Platform.getDebugOption((String)"com.ti.gui.composer.webserver/debug"));
        int i = 0;
        while (i < debugComponent.length) {
            String name = IDebugFilter.values()[i].toString().toLowerCase();
            GuiComposerWebServerPlugin.debugComponent[i] = "true".equals(Platform.getDebugOption((String)("com.ti.gui.composer.webserver/debug/" + name)));
            ++i;
        }
    }

    public static void debug(String debugString, IDebugFilter filterType) {
        GuiComposerWebServerPlugin.printMessage(debugString, filterType, false);
    }

    public static void debug(Throwable t, IDebugFilter filterType) {
        GuiComposerWebServerPlugin.debug(t.getMessage(), filterType);
    }

    private static void printMessage(String debugString, IDebugFilter filterType, boolean error) {
        if (DEBUG) {
            int index;
            debugString = "(" + Calendar.getInstance().getTimeInMillis() + ") " + debugString;
            PrintStream stream = System.out;
            if (error) {
                debugString = "E: " + debugString;
            }
            if (debugComponent[index = filterType.ordinal()]) {
                stream.println(String.valueOf(filterType.toString()) + ": " + debugString);
            }
        }
    }
}

