/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.webserver.internal;

import com.ti.gui.composer.webserver.adapter.internal.IBindingInfo;
import com.ti.gui.composer.webserver.adapter.internal.IBindingRegistry;
import com.ti.gui.composer.webserver.adapter.internal.IClientListener;
import com.ti.gui.composer.webserver.internal.GuiComposerClientListener;
import com.ti.gui.composer.webserver.internal.GuiComposerWebServer;
import com.ti.gui.composer.webserver.internal.GuiComposerWebServerPlugin;
import com.ti.gui.composer.webserver.internal.GuiComposerWebSocketData;
import com.ti.gui.composer.webserver.internal.IDebugFilter;
import com.ti.gui.composer.webserver.internal.WebBindingInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.jetty.websocket.WebSocket;

public class GuiComposerWebSocket
implements WebSocket.OnTextMessage {
    GuiComposerWebServer server;
    String remoteAddress;
    GuiComposerWebSocketData webSocketData = new GuiComposerWebSocketData(new ArrayList<IBindingInfo>(), true);

    public GuiComposerWebSocket(IBindingRegistry bindingRegistry, GuiComposerWebServer server, String remoteAddress) {
        this.webSocketData.bindingRegistry = bindingRegistry;
        this.server = server;
        this.remoteAddress = remoteAddress;
    }

    public void onOpen(WebSocket.Connection connection) {
        this.webSocketData.start = System.currentTimeMillis();
        if (GuiComposerWebServerPlugin.DEBUG) {
            GuiComposerWebServerPlugin.debug("onOpen : connection = " + connection.toString(), IDebugFilter.WEB_SOCKET);
        }
        this.webSocketData.connection = connection;
        this.webSocketData.guiComposerClientListener = new GuiComposerClientListener(this, this.webSocketData.connection);
        this.keepAlive();
    }

    public void onMessage(String data) {
        block15: {
            try {
                ObjectMapper mapper = new ObjectMapper();
                Map rootNode = (Map)mapper.readValue(data, Map.class);
                Object widgetRequestNameNode = rootNode.get("requestName");
                if (GuiComposerWebServerPlugin.DEBUG) {
                    GuiComposerWebServerPlugin.debug("onMessage : data = " + data, IDebugFilter.WEB_SOCKET);
                }
                if (widgetRequestNameNode != null) {
                    String requestName = (String)widgetRequestNameNode;
                    if ("addWidgetBindings".equals(requestName)) {
                        this.processRequest_addWidgetBindings(rootNode);
                    } else if ("propertyChange".equals(requestName)) {
                        this.processRequest_propertyChanged(rootNode);
                    } else if ("pingReply".equals(requestName)) {
                        this.processRequest_pingReply();
                    } else if ("executeOperation".equals(requestName)) {
                        this.processRequest_executeOperation(rootNode);
                    } else if ("enableWidgetBindings".equals(requestName)) {
                        this.processRequest_enableWidgetBindings(rootNode);
                    } else if ("setInitInfo".equals(requestName)) {
                        this.processRequest_setInitInfo(rootNode);
                    }
                }
            }
            catch (Exception e) {
                if (!GuiComposerWebServerPlugin.DEBUG) break block15;
                GuiComposerWebServerPlugin.debug(e, IDebugFilter.WEB_SOCKET);
            }
        }
    }

    private void processRequest_propertyChanged(Map<String, Object> rootNode) {
        String widgetId = (String)rootNode.get("widgetId");
        String propertyName = (String)rootNode.get("propertyName");
        Object newValue = rootNode.get("newValue");
        if (this.webSocketData.serverListener != null) {
            this.webSocketData.serverListener.onValueChanged(widgetId, propertyName, newValue);
        }
    }

    private void processRequest_executeOperation(Map<String, Object> rootNode) {
        if (this.webSocketData.serverListener != null) {
            String operationName = (String)rootNode.get("operationName");
            String requestId = (String)rootNode.get("requestId");
            Object arguments = rootNode.get("arguments");
            this.webSocketData.serverListener.executeOperation(operationName, arguments, requestId);
        }
    }

    private void processRequest_addWidgetBindings(Map<String, Object> rootNode) {
        Object widgetBindingsNode = rootNode.get("widgetBindings");
        if (widgetBindingsNode != null && widgetBindingsNode instanceof ArrayList) {
            ArrayList widgetBindingArrayNode = (ArrayList)widgetBindingsNode;
            for (Object widgetBindingNode1 : widgetBindingArrayNode) {
                Map widgetBindingNode = (Map)widgetBindingNode1;
                String widgetId = (String)widgetBindingNode.get("widgetId");
                String propertyName = (String)widgetBindingNode.get("propertyName");
                String serverBindName = (String)widgetBindingNode.get("serverBindName");
                Map options = (Map)widgetBindingNode.get("options");
                WebBindingInfo bindingInfo = new WebBindingInfo(widgetId, propertyName, serverBindName, options);
                this.webSocketData.bindingInfoList.add(bindingInfo);
            }
            if (this.webSocketData.sessionId == null) {
                this.webSocketData.sessionId = this.webSocketData.bindingRegistry.getUniqueSessionId();
                this.webSocketData.serverListener = this.webSocketData.bindingRegistry.createSession(this.webSocketData.sessionId, this.webSocketData.bindingInfoList, (IClientListener)this.webSocketData.guiComposerClientListener);
                this.webSocketData.bindingInfoList.clear();
            } else {
                this.webSocketData.bindingRegistry.addBindings(this.webSocketData.sessionId, this.webSocketData.bindingInfoList);
                this.webSocketData.bindingInfoList.clear();
            }
        }
    }

    private void processRequest_enableWidgetBindings(Map<String, Object> rootNode) {
        Object enableValue = rootNode.get("enable");
        if (!(enableValue instanceof Boolean)) {
            if (GuiComposerWebServerPlugin.DEBUG) {
                GuiComposerWebServerPlugin.debug("Error enableWidgetBindings : enable is not boolean.", IDebugFilter.WEB_SOCKET);
            }
            return;
        }
        boolean enable = (Boolean)enableValue;
        Object widgetBindingsNode = rootNode.get("widgetBindings");
        if (!(widgetBindingsNode instanceof ArrayList)) {
            if (GuiComposerWebServerPlugin.DEBUG) {
                GuiComposerWebServerPlugin.debug("Error enableWidgetBindings : widgetBindings is not an array.", IDebugFilter.WEB_SOCKET);
            }
            return;
        }
        ArrayList widgetBindingArrayNode = (ArrayList)widgetBindingsNode;
        ArrayList<WebBindingInfo> bindInfoList = new ArrayList<WebBindingInfo>();
        for (Object widgetBindingNode1 : widgetBindingArrayNode) {
            Map widgetBindingNode = (Map)widgetBindingNode1;
            String widgetId = (String)widgetBindingNode.get("widgetId");
            String propertyName = (String)widgetBindingNode.get("propertyName");
            Map options = (Map)widgetBindingNode.get("options");
            if (GuiComposerWebServerPlugin.DEBUG) {
                String s = "Received enable bindings for widgetId =" + widgetId + " propertyName=" + propertyName + " enable=" + enable;
                GuiComposerWebServerPlugin.debug("enableWidgetBindings " + s, IDebugFilter.WEB_SOCKET);
            }
            WebBindingInfo bindingInfo = new WebBindingInfo(widgetId, propertyName, null, options);
            bindInfoList.add(bindingInfo);
        }
        if (this.webSocketData.sessionId != null) {
            this.webSocketData.bindingRegistry.enableBindings(this.webSocketData.sessionId, enable, bindInfoList);
        }
    }

    private void processRequest_setInitInfo(Map<String, Object> rootNode) {
        if (this.webSocketData.sessionId == null) {
            this.webSocketData.sessionId = this.webSocketData.bindingRegistry.getUniqueSessionId();
            this.webSocketData.serverListener = this.webSocketData.bindingRegistry.createSession(this.webSocketData.sessionId, (IClientListener)this.webSocketData.guiComposerClientListener);
        }
        this.webSocketData.bindingRegistry.setInitInfo(this.webSocketData.sessionId, rootNode);
    }

    public void onClose(int closeCode, String message) {
        this.webSocketData.end = System.currentTimeMillis();
        long duration = (this.webSocketData.end - this.webSocketData.start) / 1000L;
        if (GuiComposerWebServerPlugin.DEBUG) {
            String s = this.webSocketData.connection + " closed after " + duration + " seconds.";
            GuiComposerWebServerPlugin.debug("onClose : " + s, IDebugFilter.WEB_SOCKET);
        }
        if (this.webSocketData.sessionId != null) {
            this.webSocketData.bindingRegistry.removeSession(this.webSocketData.sessionId);
            this.webSocketData.sessionId = null;
        }
    }

    private void keepAlive() {
        Thread periodicPing = new Thread(new Runnable(){

            @Override
            public void run() {
                while (GuiComposerWebSocket.this.webSocketData.connection.isOpen() && GuiComposerWebSocket.this.webSocketData.pingReplyReceived) {
                    try {
                        if (GuiComposerWebServerPlugin.DEBUG) {
                            GuiComposerWebServerPlugin.debug("sending ping", IDebugFilter.WEB_SOCKET);
                        }
                        String jsonMessage = "{\"requestName\" : \"ping\"}";
                        GuiComposerWebSocket.this.webSocketData.pingReplyReceived = false;
                        GuiComposerWebSocket.this.webSocketData.connection.sendMessage(jsonMessage);
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        periodicPing.start();
    }

    private void processRequest_pingReply() {
        this.webSocketData.pingReplyReceived = true;
    }

    GuiComposerWebServer getServer() {
        return this.server;
    }

    String getRemoveAddress() {
        return this.remoteAddress;
    }
}

