/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.davinci.ajaxLibrary.ILibInfo;
import org.davinci.ajaxLibrary.ILibraryFinder;
import org.davinci.ajaxLibrary.LibInfo;
import org.eclipse.core.runtime.Path;

public class DojoLibraryFinder
implements ILibraryFinder {
    private URI projectBase;
    private final String DOJO_CONFIG_FILE = "com.ibm.etools.webtools.dojo.core.prefs";
    private final String DOJO_VALIDATION_CONFIG_FILE = "org.eclipse.wst.validation.prefs";
    private final String[] simpleVersion = new String[]{"1,4", "1.5", "1.6", "1.7"};
    Properties dojoProps;
    Properties dojoValidationProps;
    private String project;

    public DojoLibraryFinder() {
    }

    private DojoLibraryFinder(URI projectBase, String project) {
        this.projectBase = projectBase;
        this.project = project;
    }

    @Override
    public ILibraryFinder getInstance(URI baseResource, String project) {
        Path p = new Path(baseResource.getPath());
        p.segment(p.segmentCount() - 1);
        return new DojoLibraryFinder(baseResource, project);
    }

    private static URI appendPath(URI u, String piece) {
        try {
            return new URI(u.getScheme(), u.getAuthority(), String.valueOf(u.getPath()) + piece, u.getQuery(), u.getFragment());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Properties getPropertiesFromSettingsDirectory(String fileName) {
        URI settings = DojoLibraryFinder.appendPath(this.projectBase, "/.settings");
        URI dojoConfig = DojoLibraryFinder.appendPath(settings, "/" + fileName);
        OrderedProperties props = new OrderedProperties();
        try {
            props.load(dojoConfig.toURL().openStream());
        }
        catch (IOException iOException) {
            return null;
        }
        return props;
    }

    private Properties getDojoProperties() {
        if (this.dojoProps == null) {
            this.dojoProps = this.getPropertiesFromSettingsDirectory("com.ibm.etools.webtools.dojo.core.prefs");
        }
        return this.dojoProps;
    }

    private Properties getDojoValidationProperties() {
        if (this.dojoValidationProps == null) {
            this.dojoValidationProps = this.getPropertiesFromSettingsDirectory("org.eclipse.wst.validation.prefs");
        }
        return this.dojoValidationProps;
    }

    @Override
    public ILibInfo[] getLibInfo() {
        Properties dojoProps = this.getDojoProperties();
        if (dojoProps == null) {
            return new ILibInfo[0];
        }
        String version = dojoProps.getProperty("dojo-version-attribute-name");
        String path = dojoProps.getProperty("dojo-root");
        Path fullPath = new Path(path);
        String simplePath = fullPath.removeFirstSegments(1).toString();
        int i = 0;
        while (i < this.simpleVersion.length) {
            if (version.indexOf(this.simpleVersion[i]) > -1) {
                version = this.simpleVersion[i];
                break;
            }
            ++i;
        }
        ILibInfo[] result = new ILibInfo[]{new LibInfo("dojo", "dojo", version, simplePath, null)};
        return result;
    }

    private static String readFile(URI path) {
        String result = "";
        try {
            String str;
            BufferedReader in = new BufferedReader(new InputStreamReader(path.toURL().openStream()));
            while ((str = in.readLine()) != null) {
                result = String.valueOf(result) + str + "\n";
            }
            in.close();
        }
        catch (IOException iOException) {}
        return result;
    }

    @Override
    public void librarySettingsChanged(ILibInfo[] newSettings) {
        this.fixDojoPreferences(newSettings);
        this.fixDojoValidationPreferences(newSettings);
    }

    private File getSettingsFile(String fileName) {
        URI settings = DojoLibraryFinder.appendPath(this.projectBase, "/.settings");
        URI dojoConfig = DojoLibraryFinder.appendPath(settings, "/" + fileName);
        File settingsFile = new File(dojoConfig);
        return settingsFile;
    }

    private void fixDojoPreferences(ILibInfo[] newSettings) {
        File settingsFile = this.getSettingsFile("com.ibm.etools.webtools.dojo.core.prefs");
        if (!settingsFile.exists()) {
            return;
        }
        int i = 0;
        while (i < newSettings.length) {
            if (newSettings[i].getId().equalsIgnoreCase("dojo")) {
                Properties dojoProps = this.getDojoProperties();
                String fullPath = "/" + this.project + "/" + newSettings[i].getVirtualRoot();
                dojoProps.setProperty("dojo-root", fullPath);
                dojoProps.setProperty("dojo-source-metadata-root", fullPath);
                try {
                    dojoProps.store(new FileOutputStream(settingsFile), null);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            ++i;
        }
    }

    private void fixDojoValidationPreferences(ILibInfo[] newSettings) {
        File settingsFile = this.getSettingsFile("org.eclipse.wst.validation.prefs");
        if (!settingsFile.exists()) {
            return;
        }
        int i = 0;
        while (i < newSettings.length) {
            if (newSettings[i].getId().equalsIgnoreCase("dojo")) {
                Properties dojoValidationProps = this.getDojoValidationProperties();
                String path = newSettings[i].getVirtualRoot();
                Set<Object> keySet = dojoValidationProps.keySet();
                Iterator<Object> itr = keySet.iterator();
                String[] regexes = new String[]{"file128\\S+/ibm_soapF0204file125\\S+/dijitF0204file124\\S+/dojoF0204file124\\S+/utilF0204file125\\S+/dojoxF02", "file128\\S+/ibm_soapF02113projectNature134org.eclipse.jst.j2ee.ejb.EJBNature04file125\\S+/dijitF0207pattern124.*/META-INF/ibmconfig/.*F04file124\\S+/dojoF0204file08.projectT01113projectNature130org.eclipse.jst.j2ee.EARNature04file124\\S+/utilF0204file125\\S+/dojoxF0204"};
                String[] replacements = new String[]{"file128" + path + "/ibm_soap" + "F0204file125" + path + "/dijit" + "F0204file124" + path + "/dojo" + "F0204file124" + path + "/util" + "F0204file125" + path + "/dojox" + "F02", "file128" + path + "/ibm_soap" + "F02113projectNature134org.eclipse.jst.j2ee.ejb.EJBNature04file125" + path + "/dijit" + "F0207pattern124.*/META-INF/ibmconfig/.*F04file124" + path + "/dojo" + "F0204file08.projectT01113projectNature130org.eclipse.jst.j2ee.EARNature04file124" + path + "/util" + "F0204file125" + path + "/dojoxF0204"};
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    if (!key.endsWith("groups")) continue;
                    String value = dojoValidationProps.getProperty(key);
                    int j = 0;
                    while (j < regexes.length) {
                        value = value.replaceAll(regexes[j], replacements[j]);
                        ++j;
                    }
                    dojoValidationProps.setProperty(key, value);
                }
                try {
                    dojoValidationProps.store(new FileOutputStream(settingsFile), null);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            ++i;
        }
    }

    private class OrderedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private final LinkedHashSet<Object> keys = new LinkedHashSet();

        @Override
        public Set<Object> keySet() {
            return this.keys;
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }

        @Override
        public Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }

        @Override
        public void store(OutputStream out, String comments) throws IOException {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
            if (comments != null) {
                writer.write("# " + comments);
                writer.newLine();
            }
            writer.write("#" + new Date().toString());
            writer.newLine();
            Set<Object> keySet = this.keySet();
            for (String string : keySet) {
                String value = this.getProperty(string);
                writer.write(String.valueOf(string) + "=" + value);
                writer.newLine();
            }
            writer.flush();
        }
    }
}

