/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.command;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.davinci.server.user.IUser;
import org.json.JSONException;
import org.json.JSONObject;
import org.maqetta.server.Command;
import org.maqetta.server.IStorage;
import org.maqetta.server.ServerManager;

public class GetInitializationInfo
extends Command {
    private String siteConfigJson = null;

    @Override
    public void handleCommand(HttpServletRequest req, HttpServletResponse resp, IUser user) throws IOException {
        int i;
        IStorage userSettings = user.getWorkbenchSettings();
        IStorage settingsFile = userSettings.newInstance(userSettings, "workbenchState.settings");
        StringBuffer buffer = new StringBuffer();
        InputStream inputStream = settingsFile.exists() ? settingsFile.getInputStream() : new ByteArrayInputStream("{}".getBytes());
        do {
            if ((i = inputStream.read()) == -1) continue;
            buffer.append((char)i);
        } while (i != -1);
        try {
            String c = this.getSiteJson();
            this.responseString = "{\n\t\"workbenchState\":" + buffer + ",\n" + "\t\"userInfo\":{\"userId\": \"" + user.getUserID() + "\"," + "\t\t\"isLocalInstall\": \"" + String.valueOf(ServerManager.LOCAL_INSTALL) + "\"," + "\t\t\"userDisplayName\": \"" + String.valueOf(user.getPerson().getDisplayName()) + "\"," + "\t\t\"email\": \"" + user.getPerson().getEmail() + "\"\n" + "\t}" + "\t" + c + "\n" + "}";
            resp.setContentType("application/json;charset=UTF-8");
        }
        catch (MaqettaConfigException e) {
            System.err.println("Maqetta Configuration Exception: " + e.getMessage());
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    private String getSiteJson() throws MaqettaConfigException {
        if (this.siteConfigJson != null) {
            return this.siteConfigJson;
        }
        String ret = "";
        String siteConfigDir = ServerManager.getServerManager().getDavinciProperty("maqetta.siteConfigDirectory");
        if (siteConfigDir == null) {
            throw new MaqettaConfigException("maqetta.server.orion.command.GetInitializationInfo maqetta.siteConfigDirectory :  Is not set in Config file");
        }
        File folder = new File(siteConfigDir);
        if (folder.exists()) {
            File[] listOfFiles = folder.listFiles();
            int i = 0;
            while (i < listOfFiles.length) {
                String file;
                if (listOfFiles[i].isFile() && ((file = listOfFiles[i].getName()).endsWith(".json") || file.endsWith(".JSON"))) {
                    try {
                        String fileNameWithOutExt = file.replaceFirst("[.][^.]+$", "");
                        String output = this.readFile(String.valueOf(siteConfigDir) + "/" + file);
                        new JSONObject(output);
                        ret = String.valueOf(ret) + ",\n\t'" + fileNameWithOutExt + "': " + output;
                    }
                    catch (JSONException e) {
                        throw new MaqettaConfigException("maqetta.server.orion.command.GetInitializationInfo " + siteConfigDir + "/" + file + " not valid json", e);
                    }
                    catch (IOException e) {
                        throw new MaqettaConfigException("maqetta.server.orion.command.GetInitializationInfo " + siteConfigDir + "/" + file + " error reading file", e);
                    }
                }
                ++i;
            }
        } else {
            throw new MaqettaConfigException("maqetta.server.orion.command.GetInitializationInfo maqetta.siteConfigDirectory : " + siteConfigDir + " Does not exist");
        }
        this.siteConfigJson = ret;
        return this.siteConfigJson;
    }

    private String readFile(String path) throws IOException {
        FileInputStream stream = new FileInputStream(new File(path));
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    private class MaqettaConfigException
    extends Exception {
        public MaqettaConfigException(String message) {
            super(message);
        }

        public MaqettaConfigException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

