/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.command;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.davinci.ajaxLibrary.ILibInfo;
import org.davinci.ajaxLibrary.ILibraryManager;
import org.davinci.ajaxLibrary.Library;
import org.davinci.server.user.IUser;
import org.davinci.server.util.JSONWriter;
import org.maqetta.server.Command;
import org.maqetta.server.ServerManager;

public class GetUserLibs
extends Command {
    @Override
    public void handleCommand(HttpServletRequest req, HttpServletResponse resp, IUser user) throws IOException {
        String base = req.getParameter("base");
        ILibInfo[] installedLibs = user.getLibs(base);
        JSONWriter jsonWriter = new JSONWriter(true);
        jsonWriter.startObject().addFieldName("userLibs").startArray();
        ILibraryManager libMan = ServerManager.getServerManager().getLibraryManager();
        int i = 0;
        while (i < installedLibs.length) {
            String version;
            String id = installedLibs[i].getId();
            Library lib = libMan.getLibrary(id, version = installedLibs[i].getVersion());
            if (lib != null) {
                jsonWriter.startObject().addField("id", id);
                jsonWriter.addField("version", version);
                jsonWriter.addField("metaRoot", lib.getMetadataPath());
                String required = installedLibs[i].getRequired();
                jsonWriter.addField("required", required != null && Boolean.parseBoolean(required));
                jsonWriter.addField("hasSource", lib.getSourcePath() != null);
                if (installedLibs[i].getVirtualRoot() != null) {
                    jsonWriter.addField("root", installedLibs[i].getVirtualRoot());
                }
                jsonWriter.endObject();
            }
            ++i;
        }
        jsonWriter.endArray().endObject();
        this.responseString = jsonWriter.getJSON();
        resp.setContentType("application/json;charset=UTF-8");
    }
}

