/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.command;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SimpleTimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import maqetta.core.server.user.DavinciProject;
import maqetta.core.server.user.ReviewManager;
import org.davinci.server.review.ReviewerVersion;
import org.davinci.server.review.Utils;
import org.davinci.server.review.Version;
import org.davinci.server.review.cache.ReviewCacheManager;
import org.davinci.server.review.user.IDesignerUser;
import org.davinci.server.review.user.Reviewer;
import org.davinci.server.user.IUser;
import org.davinci.server.util.JSONWriter;
import org.maqetta.server.Command;
import org.maqetta.server.ServerManager;

public class Publish
extends Command {
    @Override
    public void handleCommand(HttpServletRequest req, HttpServletResponse resp, IUser user) throws IOException {
        Version version = null;
        Boolean isUpdate = req.getParameter("isUpdate") != null ? req.getParameter("isUpdate").equals("true") : false;
        String vTime = req.getParameter("vTime");
        Boolean isRestart = req.getParameter("isRestart") != null ? req.getParameter("isRestart").equals("true") : false;
        String emailsStr = req.getParameter("emails");
        String message = req.getParameter("message");
        String versionTitle = req.getParameter("versionTitle");
        String[] resources = req.getParameterValues("resources");
        String desireWidth = req.getParameter("desireWidth");
        String desireHeight = req.getParameter("desireHeight");
        Boolean savingDraft = req.getParameter("savingDraft") != null;
        String dueDate = req.getParameter("dueDate");
        Boolean receiveEmail = req.getParameter("receiveEmail") != null ? req.getParameter("receiveEmail").equals("true") : false;
        Boolean zazl = req.getParameter("zazl") != null;
        String[] emails = emailsStr.split(",");
        ArrayList<Reviewer> reviewers = new ArrayList<Reviewer>();
        IDesignerUser du = ReviewManager.getReviewManager().getDesignerUser(user);
        if (!isUpdate.booleanValue()) {
            Date currentTime = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            formatter.setCalendar(Calendar.getInstance(new SimpleTimeZone(0, "GMT")));
            String timeVersion = formatter.format(currentTime);
            String id = null;
            int latestVersionID = 1;
            if (du.getLatestVersion() == null || du.getVersion(du.getLatestVersion().getTime()) == null) {
                List<Version> versions = du.getVersions();
                for (Version temp : versions) {
                    int i = Integer.parseInt(temp.getVersionID());
                    if (i <= latestVersionID) continue;
                    latestVersionID = i;
                }
                id = String.valueOf(latestVersionID);
            } else {
                int latestID = Integer.parseInt(du.getLatestVersion().getVersionID());
                id = String.valueOf(latestID + 1);
            }
            version = new Version(id, timeVersion, savingDraft, dueDate, desireWidth, desireHeight);
            du.addVersion(version);
            du.setLatestVersion(version);
        } else {
            version = du.getVersion(vTime);
        }
        ReviewerVersion reviewerVersion = new ReviewerVersion(user.getUserID(), version.getTime());
        Reviewer tmpReviewer = null;
        int i = 0;
        while (i < emails.length) {
            String email = emails[i];
            if (!email.equals(user.getPerson().getEmail())) {
                tmpReviewer = ReviewManager.getReviewManager().getReviewer("", email);
                tmpReviewer.addReviewerVersion(reviewerVersion);
                reviewers.add(tmpReviewer);
            }
            ++i;
        }
        tmpReviewer = ReviewManager.getReviewManager().getReviewer(user.getUserID(), user.getPerson().getEmail());
        tmpReviewer.addReviewerVersion(reviewerVersion);
        reviewers.add(tmpReviewer);
        String fakeReviewer = ServerManager.getServerManager().getDavinciProperty("davinci.review.fakeReviewer");
        if (fakeReviewer != null) {
            tmpReviewer = ReviewManager.getReviewManager().getReviewer("fakeReviewer", fakeReviewer);
            tmpReviewer.addReviewerVersion(reviewerVersion);
            reviewers.add(tmpReviewer);
        }
        version.setDraft(savingDraft);
        version.setDueDate(dueDate);
        version.setDesireWidth(desireWidth);
        version.setDesireHeight(desireHeight);
        version.setReviewers(reviewers);
        version.setVersionTitle(versionTitle);
        if (resources != null) {
            version.setResource(resources);
        }
        version.setHasClosedManually(false);
        version.setDescription(message);
        version.setReceiveEmail(receiveEmail);
        if (isRestart.booleanValue()) {
            version.setRestartFrom(vTime);
            du.getVersion(vTime).setHasRestarted(true);
            DavinciProject project = new DavinciProject();
            project.setOwnerId(du.getName());
            ReviewCacheManager.$.republish(project, vTime, version);
        }
        JSONWriter writer = new JSONWriter(true);
        writer.startObject();
        writer.addField("result", "OK");
        writer.addField("version", version.getTime());
        writer.addField("designer", du.getName());
        if (savingDraft.booleanValue()) {
            ReviewManager.getReviewManager().saveDraft(du, version);
        } else {
            ReviewManager.getReviewManager().publish(du, version);
            String requestUrl = req.getRequestURL().toString();
            HashSet<String> set = new HashSet<String>();
            String emailResult = null;
            for (Reviewer reviewer : reviewers) {
                String mail = reviewer.getEmail();
                if (mail == null || mail.equals("") || !set.add(mail)) continue;
                String url = ReviewManager.getReviewManager().getReviewUrl(user.getUserID(), version.getTime(), requestUrl, zazl);
                String htmlContent = this.getHtmlContent(user, message, url);
                String subject = String.valueOf(Utils.getTemplates().getProperty("maqetta.review.invitationSubject")) + " " + versionTitle;
                emailResult = this.notifyRelatedPersons(mail, subject, htmlContent);
            }
            if (emailResult != null) {
                writer.addField("emailResult", emailResult);
            }
        }
        writer.endObject();
        this.responseString = writer.getJSON();
        resp.setContentType("application/json;charset=UTF-8");
    }

    private String notifyRelatedPersons(String to, String subject, String htmlContent) {
        return "OK";
    }

    private String getHtmlContent(IUser user, String message, String url) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("displayName", user.getPerson().getDisplayName());
        props.put("message", message);
        props.put("url", url);
        return Utils.substitute(Utils.getTemplates().getProperty("maqetta.review.invitationTemplate"), props);
    }
}

