/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.davinci.server.review.Version;
import org.davinci.server.review.user.IDesignerUser;
import org.davinci.server.user.IUser;
import org.maqetta.server.IStorage;

public class DesignerUser
implements IDesignerUser {
    private final String name;
    private IStorage commentingDirectory;
    private final List<Version> versions = new ArrayList<Version>();
    private Version latestVersion;
    private IStorage userDirectory;
    public IUser rawUser;

    public DesignerUser(IUser user) {
        this.name = user.getUserID();
        this.rawUser = user;
        this.getUserDirectory();
    }

    @Override
    public IUser getRawUser() {
        return this.rawUser;
    }

    @Override
    public void setRawUser(IUser user) {
        this.rawUser = user;
    }

    @Override
    public void rebuildWorkspace() {
        this.rawUser.rebuildWorkspace();
    }

    @Override
    public Version getVersion(String time) {
        for (Version version : this.versions) {
            if (!time.equals(version.getTime())) continue;
            return version;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public void setLatestVersion(Version latestVersion) {
        this.latestVersion = latestVersion;
    }

    @Override
    public void addVersion(Version version) {
        this.versions.add(version);
    }

    @Override
    public List<Version> getVersions() {
        return this.versions;
    }

    @Override
    public void deleteVersion(String versionTime) throws IOException {
        Version version = this.getVersion(versionTime);
        this.versions.remove(version);
        IStorage versionDir = this.userDirectory.newInstance(this.getCommentingDirectory(), "snapshot/" + versionTime);
        if (versionDir.exists()) {
            DesignerUser.deleteDir(versionDir);
        }
    }

    private static boolean deleteDir(IStorage dir) throws IOException {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = DesignerUser.deleteDir(dir.newInstance(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    @Override
    public IStorage getCommentingDirectory() {
        if (this.commentingDirectory == null) {
            this.commentingDirectory = this.userDirectory.create(".review");
        }
        return this.commentingDirectory;
    }

    @Override
    public IStorage getUserDirectory() {
        if (this.userDirectory == null) {
            this.userDirectory = this.getRawUser().getUserDirectory();
        }
        return this.userDirectory;
    }
}

