/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.user;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import maqetta.core.server.util.VResourceUtils;
import org.davinci.ajaxLibrary.ILibInfo;
import org.davinci.ajaxLibrary.ILibraryFinder;
import org.davinci.ajaxLibrary.Library;
import org.davinci.server.internal.Activator;
import org.davinci.server.user.IPerson;
import org.davinci.server.user.IUser;
import org.davinci.server.user.LibrarySettings;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.maqetta.project.util.EclipseProjectUtil;
import org.maqetta.server.IProjectTemplatesManager;
import org.maqetta.server.IStorage;
import org.maqetta.server.IVResource;
import org.maqetta.server.ServerManager;
import org.maqetta.server.StorageFileSystem;
import org.maqetta.server.VFile;
import org.maqetta.server.VLibraryResource;
import org.maqetta.server.VStorageDirectory;
import org.maqetta.server.VWorkspaceRoot;
import org.osgi.framework.Bundle;

public class User
implements IUser {
    protected IStorage userDirectory;
    protected IStorage projectTemplatesDirectory;
    protected IPerson person;
    protected IVResource workspace;

    public User(IPerson person) {
        this.person = person;
    }

    public User(IPerson person, IStorage userDirectory) throws IOException {
        this(person);
        this.userDirectory = userDirectory;
        userDirectory.mkdirs();
        this.rebuildWorkspace();
    }

    @Override
    public IVResource newWorkspaceRoot() {
        return new VWorkspaceRoot();
    }

    @Override
    public void rebuildWorkspace() {
        this.workspace = this.newWorkspaceRoot();
        IStorage[] userFiles = this.userDirectory.listFiles();
        int j = 0;
        while (j < userFiles.length) {
            if (!this.isConfig(userFiles[j].getName()) && userFiles[j].isDirectory()) {
                IVResource workspace = this.workspace;
                VStorageDirectory firstFolder = new VStorageDirectory(userFiles[j], workspace, userFiles[j].getName());
                this.workspace.add(firstFolder);
            }
            ++j;
        }
    }

    private boolean isConfig(String folderName) {
        if (folderName == null) {
            return true;
        }
        return folderName.equals(".settings");
    }

    public ILibraryFinder[] getFinders(String base) {
        ILibraryFinder[] finders = ServerManager.getServerManager().getLibraryManager().getLibraryFinders();
        IStorage baseFile = this.userDirectory.newInstance(this.userDirectory, base);
        Vector<ILibraryFinder> allLibs = new Vector<ILibraryFinder>();
        int i = 0;
        while (i < finders.length) {
            ILibraryFinder finder = finders[i].getInstance(baseFile.toURI(), baseFile.getName());
            allLibs.add(finder);
            ++i;
        }
        return allLibs.toArray(new ILibraryFinder[allLibs.size()]);
    }

    public ILibInfo[] getExtendedSettings(String base) {
        ILibraryFinder[] finders = ServerManager.getServerManager().getLibraryManager().getLibraryFinders();
        IStorage baseFile = this.userDirectory.newInstance(this.userDirectory, base);
        Vector<ILibInfo> allLibs = new Vector<ILibInfo>();
        int i = 0;
        while (i < finders.length) {
            ILibraryFinder finder = finders[i].getInstance(baseFile.toURI(), baseFile.getName());
            ILibInfo[] libs = finder.getLibInfo();
            allLibs.addAll(Arrays.asList(libs));
            ++i;
        }
        return allLibs.toArray(new ILibInfo[allLibs.size()]);
    }

    @Override
    public IVResource createEclipseProject(String projectName) throws IOException {
        return this.createEclipseProject(projectName, "", "");
    }

    @Override
    public IVResource createEclipseProject(String projectName, String projectToClone, String projectTemplateDirectoryName) throws IOException {
        IVResource project = this.createProject(projectName, projectToClone, projectTemplateDirectoryName, "WebContent", true);
        Hashtable<String, String> eclipseConfig = EclipseProjectUtil.getEclipseConfig(projectName);
        Iterator<String> keys = eclipseConfig.keySet().iterator();
        while (keys.hasNext()) {
            String key;
            String filePath = key = keys.next();
            String xml = eclipseConfig.get(key);
            IPath resourcePath = new Path(project.getPath()).append(filePath);
            IVResource resource = this.createResource(resourcePath.toString(), false);
            VResourceUtils.setText(resource, xml);
        }
        Library[] allLibs = ServerManager.getServerManager().getLibraryManager().getAllLibraries();
        int i = 0;
        while (i < allLibs.length) {
            Library lib = allLibs[i];
            String root = lib.getDefaultRoot();
            if (root != null) {
                String id = lib.getID();
                String version = lib.getVersion();
                String required = lib.getRequired();
                String libPath = "./WebContent" + root;
                this.modifyLibrary(id, version, libPath, project.getPath(), required == null ? false : Boolean.parseBoolean(required));
            }
            ++i;
        }
        this.rebuildWorkspace();
        return project;
    }

    @Override
    public IVResource createProject(String projectName) throws IOException {
        return this.createProject(projectName, "", "", "", true);
    }

    @Override
    public IVResource createProject(String projectName, String projectToClone, String projectTemplateDirectoryName) throws IOException {
        return this.createProject(projectName, projectToClone, projectTemplateDirectoryName, "", true);
    }

    @Override
    public IVResource createProject(String projectName, String projectToClone, String projectTemplateName, String basePath, boolean initFiles) throws IOException {
        IVResource project = this.createResource(String.valueOf(projectName) + "/", true);
        try {
            if (!this.isValid(String.valueOf(new File(project.getURI()).getAbsolutePath()) + "/" + basePath)) {
                return null;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        if (basePath != null && !basePath.equals("")) {
            project.create(String.valueOf(basePath) + "/");
        }
        StorageFileSystem file = null;
        if (initFiles) {
            List<IConfigurationElement> extensions = ServerManager.getServerManager().getExtensions("initialUserFiles", "initalUserFile");
            for (IConfigurationElement libraryElement : extensions) {
                String path = libraryElement.getAttribute("path");
                String name = libraryElement.getDeclaringExtension().getContributor().getName();
                Bundle bundle = Activator.getActivator().getOtherBundle(name);
                try {
                    file = new StorageFileSystem(String.valueOf(project.getURI().getPath()) + "/" + basePath);
                    if (!this.isValid(file.getAbsolutePath())) {
                        return null;
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                VResourceUtils.copyDirectory(file, path, bundle);
            }
        }
        if (projectTemplateName != null && projectTemplateName.length() > 0) {
            IProjectTemplatesManager projectTemplatesManager = ServerManager.getServerManager().getProjectTemplatesManager();
            Bundle bundle = projectTemplatesManager.getProjectTemplatesContributionBundle();
            String path = projectTemplatesManager.getProjectTemplateContributionPath();
            VResourceUtils.copyDirectory(file, String.valueOf(path) + "/" + projectTemplateName, bundle);
        }
        this.addBaseSettings(projectName);
        this.rebuildWorkspace();
        return project;
    }

    @Override
    public void addBaseSettings(String base) throws IOException {
        IStorage baseFile = this.userDirectory.newInstance(this.userDirectory, base);
        if (!this.isValid(baseFile.getAbsolutePath())) {
            return;
        }
        IStorage settings = this.userDirectory.newInstance(baseFile, ".settings");
        settings.mkdirs();
        LibrarySettings ls = this.getLibSettings(base);
        ls.save();
        ILibraryFinder[] finders = this.getFinders(base);
        int i = 0;
        while (i < finders.length) {
            finders[i].librarySettingsChanged(ls.allLibs());
            ++i;
        }
        this.rebuildWorkspace();
    }

    @Override
    public void deleteBaseSettings(String base) {
    }

    private LibrarySettings getLibSettings(String base) {
        return this.getLibSettings(this.userDirectory.newInstance(this.userDirectory, base));
    }

    protected LibrarySettings getLibSettings(IStorage baseFile) {
        if (!this.isValid(baseFile.getAbsolutePath())) {
            return null;
        }
        return new LibrarySettings(this.userDirectory.newInstance(baseFile, ".settings"));
    }

    @Override
    public IStorage getUserDirectory() {
        return this.userDirectory;
    }

    @Override
    public void modifyLibrary(String id, String version, String base, boolean installed, boolean required) throws IOException {
        LibrarySettings libs = this.getLibSettings(base);
        if (!installed) {
            libs.removeLibrary(id, version, base);
        } else {
            String defaultRoot = ServerManager.getServerManager().getLibraryManager().getDefaultRoot(id, version);
            libs.addLibrary(id, version, id, defaultRoot, required ? "true" : "false");
        }
        ILibraryFinder[] finders = this.getFinders(base);
        int i = 0;
        while (i < finders.length) {
            finders[i].librarySettingsChanged(libs.allLibs());
            ++i;
        }
        this.rebuildWorkspace();
    }

    @Override
    public void modifyLibrary(String id, String version, String virtualRoot, String base, boolean required) throws IOException {
        LibrarySettings libs = this.getLibSettings(base);
        libs.modifyLibrary(id, version, virtualRoot, base, required ? "true" : "false");
        ILibraryFinder[] finders = this.getFinders(base);
        int i = 0;
        while (i < finders.length) {
            finders[i].librarySettingsChanged(libs.allLibs());
            ++i;
        }
        this.rebuildWorkspace();
    }

    @Override
    public IVResource[] listFiles(String path) {
        IVResource r1;
        IVResource[] found = new IVResource[]{};
        if (path == null || path.equals(".")) {
            path = "";
        }
        if ((r1 = this.getUserFile(path)) != null && r1.isDirectory()) {
            found = r1.listFiles();
        }
        if ((r1 = this.getLibFile(path)) != null && r1.isDirectory()) {
            IVResource[] list = r1.listFiles();
            found = VResourceUtils.merge(found, list);
        }
        return found;
    }

    protected void findLibFiles(IPath path, ArrayList results) {
        IVResource[] result = this.workspace.find(path.toString());
        int i = 0;
        while (i < result.length) {
            boolean existing = false;
            int z = 0;
            while (z < results.size() && !existing) {
                if (((IVResource)results.get(z)).getPath().equals(result[i].getPath())) {
                    existing = true;
                }
                ++z;
            }
            if (!existing) {
                results.add(result[i]);
            }
            ++i;
        }
    }

    @Override
    public IVResource getResource(String path) {
        IVResource r1 = this.getUserFile(path);
        if (r1 != null) {
            return r1;
        }
        return this.getLibFile(path);
    }

    protected IVResource getLibFile(String p1) {
        Path path = new Path(p1);
        IVResource root = this.workspace;
        int i = 0;
        while (i < path.segmentCount() && root != null) {
            root = root.get(path.segment(i));
            ++i;
        }
        return root;
    }

    @Override
    public boolean isValid(String path) {
        Path a = new Path(path);
        Path workspaceRoot = new Path(this.userDirectory.getAbsolutePath());
        return a.matchingFirstSegments((IPath)workspaceRoot) == workspaceRoot.segmentCount();
    }

    protected IVResource getUserFile(String p1) {
        IPath a2;
        File workingCopy;
        Path workspaceRoot;
        String path = p1;
        while (path.length() > 0 && (path.indexOf(".//") == 0 || path.charAt(0) == '/' || path.charAt(0) == '\\')) {
            path = path.substring(1);
        }
        IPath a = new Path(this.userDirectory.getAbsolutePath()).append(path);
        if (a.matchingFirstSegments((IPath)(workspaceRoot = new Path(this.userDirectory.getAbsolutePath()))) != workspaceRoot.segmentCount()) {
            return null;
        }
        File f1 = new File(a.toOSString());
        if (!f1.exists() && !(workingCopy = new File((a2 = new Path(this.userDirectory.getAbsolutePath()).append(String.valueOf(path) + ".workingcopy")).toOSString())).exists()) {
            return null;
        }
        String[] segments = a.segments();
        Path me = new Path(this.userDirectory.getAbsolutePath());
        IVResource parent = this.workspace;
        int i = me.matchingFirstSegments(a);
        while (i < segments.length) {
            int segsToEnd = segments.length - i - 1;
            String s = a.removeLastSegments(segsToEnd).toOSString();
            IStorage f = this.userDirectory.newInstance(s);
            parent = new VFile(f, parent, segments[i]);
            ++i;
        }
        if (parent == this.workspace) {
            parent = new VFile(this.userDirectory, this.workspace);
        }
        return parent;
    }

    @Override
    public IVResource createResource(String path, boolean isFolder) throws IOException {
        String path1 = path;
        if (path1.startsWith("./")) {
            path1 = path.substring(2);
        } else if (path.length() > 0 && path.charAt(0) == '.') {
            path1 = path.substring(1);
        }
        if (!this.isValid(String.valueOf(this.userDirectory.getAbsolutePath()) + "/" + path1)) {
            return null;
        }
        VFile directory = new VFile(this.userDirectory, this.workspace);
        IVResource userFile = directory.create(path);
        return userFile;
    }

    @Override
    public IStorage getWorkbenchSettings() throws IOException {
        return this.getWorkbenchSettings("");
    }

    @Override
    public IStorage getWorkbenchSettings(String base) throws IOException {
        IStorage baseFile = this.userDirectory.newInstance(this.userDirectory, base);
        IStorage settingsDirectory = this.userDirectory.newInstance(baseFile, ".settings");
        if (!this.isValid(settingsDirectory.getAbsolutePath())) {
            return null;
        }
        if (!settingsDirectory.exists()) {
            settingsDirectory.mkdirs();
        }
        return settingsDirectory;
    }

    @Override
    public IVResource[] findFiles(String pathStr, boolean ignoreCase, boolean workspaceOnly) {
        return this.findFiles(pathStr, ".", ignoreCase, workspaceOnly);
    }

    @Override
    public IVResource[] findFiles(String pathStr, String startFolder, boolean ignoreCase, boolean workspaceOnly) {
        boolean isWildcard = pathStr.indexOf(42) >= 0;
        new Path(pathStr);
        ArrayList<IVResource> results = new ArrayList<IVResource>();
        if (isWildcard) {
            IVResource start = null;
            start = startFolder == null || startFolder.equals(".") ? this.workspace : this.getResource(startFolder);
            results.addAll(Arrays.asList(start.find(pathStr)));
        } else {
            IVResource file = this.getResource(pathStr);
            if (file != null && file.exists()) {
                results.add(file);
            }
        }
        if (!workspaceOnly) {
            IPath fullPath = new Path(startFolder).append(pathStr);
            this.findLibFiles(fullPath, results);
        }
        ArrayList filtered = new ArrayList();
        if (workspaceOnly) {
            int z = 0;
            while (z < results.size()) {
                if (!(results.get(z) instanceof VLibraryResource)) {
                    filtered.add(results.get(z));
                }
                ++z;
            }
            results = filtered;
        }
        return results.toArray(new IVResource[results.size()]);
    }

    @Override
    public ILibInfo[] getLibs(String base) {
        Vector<ILibInfo> allLibs = new Vector<ILibInfo>();
        allLibs.addAll(Arrays.asList(this.getLibSettings(base).allLibs()));
        ILibInfo[] extendLibs = this.getExtendedSettings(base);
        int z = 0;
        while (z < allLibs.size()) {
            ILibInfo library = (ILibInfo)allLibs.get(z);
            int f = 0;
            while (f < extendLibs.length) {
                if (library.getId().equals(extendLibs[f].getId()) && library.getVersion().equals(extendLibs[f].getVersion())) {
                    allLibs.remove(z);
                }
                ++f;
            }
            ++z;
        }
        allLibs.addAll(Arrays.asList(extendLibs));
        return allLibs.toArray(new ILibInfo[allLibs.size()]);
    }

    @Override
    public String getLibPath(String id, String version, String base) {
        ILibInfo[] mappedLibs = this.getLibs(base);
        int i = 0;
        while (i < mappedLibs.length) {
            ILibInfo library = mappedLibs[i];
            if (library.getId().equals(id) && library.getVersion().equals(version)) {
                return library.getVirtualRoot();
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getUserID() {
        return this.person.getUserID();
    }

    @Override
    public IPerson getPerson() {
        return this.person;
    }

    @Override
    public void copyDirectory(IStorage sourceDir, IStorage destinationDir) throws IOException {
        destinationDir.mkdirs();
        IStorage[] file = sourceDir.listFiles();
        int i = 0;
        while (i < file.length) {
            if (file[i].isFile()) {
                IStorage sourceFile = file[i];
                IStorage targetFile = destinationDir.newInstance(destinationDir, file[i].getName());
                this.copyFile(sourceFile, targetFile);
            }
            if (file[i].isDirectory()) {
                IStorage destination = destinationDir.newInstance(destinationDir, file[i].getName());
                this.copyDirectory(file[i], destination);
            }
            ++i;
        }
    }

    @Override
    public void copyFile(IStorage source, IStorage destination) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            destination.getParentFile().mkdirs();
            in = source.getInputStream();
            out = destination.getOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

