/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.user.manager;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.davinci.server.user.IPerson;
import org.davinci.server.user.IPersonManager;
import org.davinci.server.user.UserException;
import org.davinci.server.util.XMLFile;
import org.maqetta.server.IStorage;
import org.maqetta.server.ServerManager;
import org.w3c.dom.Element;

public class PersonManagerImpl
implements IPersonManager {
    protected HashMap<String, IPerson> persons = new HashMap();
    protected static final String USERS_TAG = "users";
    protected static final String USER_TAG = "user";
    protected static final String NAME_TAG = "name";
    protected static final String PASSWORD_TAG = "password";
    protected static final String EMAIL_TAG = "email";
    IStorage baseDirectory;

    protected IStorage getBaseDirectory() {
        if (this.baseDirectory == null) {
            this.baseDirectory = ServerManager.getServerManager().getBaseDirectory();
        }
        return this.baseDirectory;
    }

    public PersonManagerImpl() {
        this.loadUsers();
    }

    @Override
    public boolean hasPermisions(IPerson owner, IPerson requester, String resource) {
        return resource != "";
    }

    @Override
    public IPerson addPerson(String userName, String password, String email) throws UserException, IOException {
        IPerson person = this.persons.get(userName);
        if (person != null) {
            throw new UserException("User already exists");
        }
        this.checkValidUserName(userName);
        person = new PersonImpl(userName, password, email);
        this.persons.put(userName, person);
        this.savePersons();
        return person;
    }

    @Override
    public IPerson login(String userName, String password) {
        PersonImpl person = (PersonImpl)this.persons.get(userName);
        if (person != null && person.password.equals(password)) {
            return person;
        }
        return null;
    }

    private void checkValidUserName(String userName) throws UserException {
        if (userName.indexOf(32) >= 0) {
            throw new UserException("Invalid User Name");
        }
    }

    @Override
    public boolean isValidPassword(String userName, String password) {
        PersonImpl person = (PersonImpl)this.persons.get(userName);
        if (person == null) {
            return false;
        }
        return password.equals(person.password);
    }

    protected void loadUsers() {
        IStorage baseDirectory = this.getBaseDirectory();
        IStorage userFile = baseDirectory.newInstance(baseDirectory, "users.xml");
        if (userFile.exists()) {
            new UsersFile().load(userFile);
        }
    }

    protected void savePersons() throws IOException {
        IStorage baseDirectory = this.getBaseDirectory();
        IStorage userFile = baseDirectory.newInstance(baseDirectory, "users.xml");
        new UsersFile().save(userFile, this.persons.values());
    }

    @Override
    public IPerson getPerson(String userName) {
        IPerson person = this.persons.get(userName);
        return person;
    }

    @Override
    public IPerson getPersonByEmail(String email) {
        IPerson match = null;
        Iterator<IPerson> peopleIterator = this.persons.values().iterator();
        while (peopleIterator.hasNext() && match == null) {
            IPerson person = peopleIterator.next();
            if (!person.getEmail().equals(email)) continue;
            match = person;
        }
        return match;
    }

    @Override
    public IPerson[] getPersons(String userName, int resultNumber, int start) {
        HashMap<String, PersonImpl> users = new HashMap<String, PersonImpl>();
        Set<String> names = this.persons.keySet();
        int i = 0;
        for (String name : names) {
            String email = this.persons.get(name).getEmail();
            if (name.indexOf(userName) < 0 && email.indexOf(userName) < 0) continue;
            if (i >= start && i < start + resultNumber) {
                users.put(email, new PersonImpl(name, "", email));
            }
            ++i;
        }
        return users.values().toArray(new PersonImpl[0]);
    }

    @Override
    public String getPhotoRepositoryPath() {
        return "not-implemented";
    }

    static class PersonImpl
    implements IPerson {
        String email;
        String name;
        String password;

        public PersonImpl(String userName, String password, String email) {
            this.name = userName;
            this.password = password;
            this.email = email;
        }

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public String getUserID() {
            return this.name;
        }

        @Override
        public String getDisplayName() {
            return this.email;
        }
    }

    class UsersFile
    extends XMLFile {
        UsersFile() {
        }

        @Override
        protected String getRootTag() {
            return PersonManagerImpl.USERS_TAG;
        }

        @Override
        protected String getElementTag() {
            return PersonManagerImpl.USER_TAG;
        }

        @Override
        protected String[] getAttributeNames() {
            return new String[]{PersonManagerImpl.NAME_TAG, PersonManagerImpl.PASSWORD_TAG, PersonManagerImpl.EMAIL_TAG};
        }

        @Override
        protected Object createObject(Element element, String[] attributeNames, String[] attributes) {
            String name = element.getAttribute(PersonManagerImpl.NAME_TAG);
            String email = element.getAttribute(PersonManagerImpl.EMAIL_TAG);
            String password = element.getAttribute(PersonManagerImpl.PASSWORD_TAG);
            PersonImpl user = new PersonImpl(name, password, email);
            PersonManagerImpl.this.persons.put(user.getUserID(), user);
            return user;
        }

        protected String[] getAttributeValues(Object object) {
            PersonImpl user = (PersonImpl)object;
            return new String[]{user.getUserID(), user.password, user.getEmail()};
        }

        @Override
        protected String getAttributeValue(String attribute, Object object) {
            PersonImpl user = (PersonImpl)object;
            if (attribute.equalsIgnoreCase(PersonManagerImpl.NAME_TAG)) {
                return user.getUserID();
            }
            if (attribute.equalsIgnoreCase(PersonManagerImpl.PASSWORD_TAG)) {
                return user.password;
            }
            if (attribute.equalsIgnoreCase(PersonManagerImpl.EMAIL_TAG)) {
                return user.getEmail();
            }
            return null;
        }
    }
}

