/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.util;

import java.util.ArrayList;
import java.util.Arrays;
import maqetta.core.server.util.BindingTIFilter;
import maqetta.core.server.util.DirectoryFilter;
import maqetta.core.server.util.WorkingCopyFilter;
import org.davinci.server.user.IUser;
import org.davinci.server.util.JSONWriter;
import org.maqetta.server.IVResource;
import org.maqetta.server.IVResourceFilter;
import org.maqetta.server.VLibraryResource;

public class Resource {
    static ArrayList resourceFilter = new ArrayList();

    static {
        DirectoryFilter df = new DirectoryFilter(new String[]{".settings", ".download", ".svn", ".review"});
        Resource.addFilter(df);
        Resource.addFilter(new WorkingCopyFilter());
        Resource.addFilter(new BindingTIFilter());
    }

    public static void addFilter(IVResourceFilter filterName) {
        resourceFilter.add(filterName);
    }

    public static boolean isHidden(IVResource file) {
        int i = 0;
        while (i < resourceFilter.size()) {
            IVResourceFilter filter = (IVResourceFilter)resourceFilter.get(i);
            if (filter.isHidden(file)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String vRsourcesToJson(IVResource[] listFiles, boolean fullPath) {
        JSONWriter jsonWriter = new JSONWriter(true);
        int j = 0;
        while (j < listFiles.length) {
            if (!Resource.isHidden(listFiles[j])) {
                String pathName = null;
                pathName = fullPath ? listFiles[j].getPath() : listFiles[j].getName();
                jsonWriter.startObject().addField("name", pathName);
                jsonWriter.addField("isDir", listFiles[j].isDirectory());
                jsonWriter.addField("isNew", listFiles[j].isNew());
                jsonWriter.addField("readOnly", listFiles[j].readOnly());
                jsonWriter.addField("isDirty", listFiles[j].isDirty());
                if (listFiles[j] instanceof VLibraryResource) {
                    VLibraryResource r = (VLibraryResource)listFiles[j];
                    jsonWriter.addField("libraryId", r.getLibraryId());
                    jsonWriter.addField("libVersion", r.getLibraryVersion());
                }
                jsonWriter.endObject();
            }
            ++j;
        }
        return jsonWriter.getJSON();
    }

    public static String foundVRsourcesToJson(IVResource[] listFiles, IUser user) {
        JSONWriter jsonWriter = new JSONWriter(true);
        int i = 0;
        while (i < listFiles.length) {
            ArrayList<IVResource> parents = new ArrayList<IVResource>();
            if (!Resource.isHidden(listFiles[i])) {
                parents.addAll(Arrays.asList(listFiles[i].getParents()));
                String name = listFiles[i].getPath();
                jsonWriter.startObject().addField("file", name).addFieldName("parents").startArray();
                int j = 0;
                while (j < parents.size()) {
                    if (!Resource.isHidden((IVResource)parents.get(j))) {
                        jsonWriter.startObject().addField("name", ((IVResource)parents.get(j)).getName());
                        jsonWriter.addFieldName("members").startArray();
                        String parentPath = ((IVResource)parents.get(j)).getPath();
                        IVResource[] members = user.listFiles(parentPath);
                        int k = 0;
                        while (k < members.length) {
                            if (!Resource.isHidden(members[k])) {
                                jsonWriter.startObject().addField("isDir", members[k].isDirectory());
                                jsonWriter.addField("name", members[k].getName());
                                jsonWriter.addField("readOnly", members[k].readOnly());
                                jsonWriter.addField("isDirty", members[k].isDirty());
                                if (members[k] instanceof VLibraryResource) {
                                    VLibraryResource r = (VLibraryResource)members[k];
                                    jsonWriter.addField("libraryId", r.getLibraryId());
                                    jsonWriter.addField("libVersion", r.getLibraryVersion());
                                }
                                jsonWriter.endObject();
                            }
                            ++k;
                        }
                        jsonWriter.endArray();
                        jsonWriter.endObject();
                    }
                    ++j;
                }
                jsonWriter.endArray();
                jsonWriter.endObject();
            }
            ++i;
        }
        return jsonWriter.getJSON();
    }
}

