/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import org.maqetta.server.IStorage;
import org.maqetta.server.IVResource;
import org.osgi.framework.Bundle;

public class VResourceUtils {
    public static void copyDirectory(IVResource source, IVResource destination, boolean recurse) throws IOException {
        IVResource[] list = source.listFiles();
        int i = 0;
        while (i < list.length) {
            if (!list[i].isVirtual()) {
                destination.mkdir();
                IVResource r = destination.create(list[i].getName());
                if (list[i].isDirectory()) {
                    r.mkdir();
                    if (recurse) {
                        VResourceUtils.copyDirectory(list[i], r, recurse);
                    }
                } else {
                    try {
                        if (!r.exists()) {
                            r.createNewInstance();
                            VResourceUtils.copyFile(list[i], r);
                            r.flushWorkingCopy();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public static boolean matches(String text, String pattern) {
        String[] pieces = pattern.split("\\*");
        int i = 0;
        while (i < pieces.length) {
            String chunk = pieces[i];
            int idx = text.indexOf(chunk);
            if (idx == -1) {
                return false;
            }
            text = text.substring(idx + chunk.length());
            ++i;
        }
        return true;
    }

    public static IVResource[] merge(IVResource[] first, IVResource[] second) {
        Vector<IVResource> all = new Vector<IVResource>();
        all.addAll(Arrays.asList(first));
        int i = 0;
        while (i < second.length) {
            boolean found = false;
            int j = 0;
            while (!found && j < first.length) {
                if (first[j].getPath().equals(second[i].getPath())) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                all.add(second[i]);
            }
            ++i;
        }
        return all.toArray(new IVResource[all.size()]);
    }

    public static void copyDirectory(IStorage userDir, String bundleDirName, Bundle bundle) throws IOException {
        Enumeration files = bundle.findEntries(bundleDirName, "*", true);
        Vector<URL> elements = new Vector<URL>();
        if (files != null) {
            while (files.hasMoreElements()) {
                URL o = (URL)files.nextElement();
                if (o.getPath().endsWith("/")) continue;
                elements.add(o);
            }
        }
        int i = 0;
        while (i < elements.size()) {
            block11: {
                URL source = (URL)elements.get(i);
                try {
                    URLConnection connection = source.openConnection();
                    String path = source.getPath();
                    String tail = path.substring(bundleDirName.length() + 1);
                    IStorage destination = userDir.newInstance(userDir, tail);
                    if (tail.indexOf(".svn") > -1) break block11;
                    destination.getParentFile().mkdirs();
                    InputStream in = null;
                    OutputStream out = null;
                    try {
                        int len;
                        in = connection.getInputStream();
                        out = new BufferedOutputStream(destination.getOutputStream());
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            ++i;
        }
    }

    public static void deleteDir(IStorage directory) throws IOException {
        VResourceUtils.deleteContents(directory);
        directory.delete();
    }

    public static void deleteContents(IStorage directory) throws IOException {
        IStorage[] theFiles = directory.listFiles();
        int i = 0;
        while (i < theFiles.length) {
            if (theFiles[i].isDirectory()) {
                VResourceUtils.deleteContents(theFiles[i]);
            }
            theFiles[i].delete();
            ++i;
        }
    }

    public static void setText(IVResource resource, String text) throws IOException {
        OutputStream out = null;
        try {
            out = resource.getOutputStreem();
            out.write(text.getBytes());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        resource.flushWorkingCopy();
    }

    public static void copyFile(IVResource src, IVResource dest) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = src.getInputStreem();
            out = dest.getOutputStreem();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            dest.flushWorkingCopy();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

