/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.server.review.persistence;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.SimpleTimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.davinci.server.review.Comment;
import org.davinci.server.review.CommentsDocument;
import org.davinci.server.user.IDavinciProject;
import org.maqetta.server.IStorage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Marshaller
extends DefaultHandler {
    private IDavinciProject project;

    public Marshaller(IDavinciProject project) {
        this.project = project;
    }

    public IDavinciProject getProject() {
        return this.project;
    }

    public void setProject(IDavinciProject project) {
        this.project = project;
    }

    public Document marshall(boolean append) throws ParserConfigurationException, IOException, TransformerConfigurationException, TransformerFactoryConfigurationError {
        this.persistComments(this.project.getCommentsDocument(), this.project.getCommentsFileStorage());
        return null;
    }

    public void persistComments(CommentsDocument commentsDocument, IStorage commentsStorage) throws ParserConfigurationException, IOException, TransformerConfigurationException, TransformerFactoryConfigurationError {
        List<Comment> commentList = commentsDocument.getCommentList();
        if (commentList == null || commentList.isEmpty()) {
            return;
        }
        OutputStream out = null;
        try {
            if (!commentsStorage.exists()) {
                try {
                    commentsStorage.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return;
                }
            }
            try {
                out = commentsStorage.getOutputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element rootElement = document.createElement("CommentsDocument");
                document.appendChild(rootElement);
                for (Comment comm : commentList) {
                    Element commentElement = this.createCommentElem(comm, document);
                    rootElement.appendChild(commentElement);
                }
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(out);
                transformer.transform(source, result);
            }
            catch (TransformerFactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Element createCommentElem(Comment comm, Document doc) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setCalendar(Calendar.getInstance(new SimpleTimeZone(0, "GMT")));
        Element commentElem = doc.createElement("Comment");
        Element elem = doc.createElement("id");
        this.setValue(elem, doc, comm.getId());
        commentElem.appendChild(elem);
        elem = doc.createElement("replyTo");
        this.setValue(elem, doc, comm.getReplyTo());
        commentElem.appendChild(elem);
        elem = doc.createElement("email");
        this.setValue(elem, doc, comm.getEmail());
        commentElem.appendChild(elem);
        elem = doc.createElement("ownerId");
        this.setValue(elem, doc, comm.getOwnerId());
        commentElem.appendChild(elem);
        elem = doc.createElement("designerId");
        this.setValue(elem, doc, comm.getDesignerId());
        commentElem.appendChild(elem);
        elem = doc.createElement("pageName");
        this.setValue(elem, doc, comm.getPageName());
        commentElem.appendChild(elem);
        elem = doc.createElement("pageState");
        this.setValue(elem, doc, comm.getPageState());
        commentElem.appendChild(elem);
        elem = doc.createElement("pageStateList");
        this.setValue(elem, doc, comm.getPageStateList());
        commentElem.appendChild(elem);
        elem = doc.createElement("viewScene");
        this.setValue(elem, doc, comm.getViewScene());
        commentElem.appendChild(elem);
        elem = doc.createElement("viewSceneList");
        this.setValue(elem, doc, comm.getViewSceneList());
        commentElem.appendChild(elem);
        elem = doc.createElement("subject");
        this.setValue(elem, doc, comm.getSubject());
        commentElem.appendChild(elem);
        elem = doc.createElement("content");
        this.setValue(elem, doc, comm.getContent());
        commentElem.appendChild(elem);
        elem = doc.createElement("created");
        this.setValue(elem, doc, sdf.format(comm.getCreated()));
        commentElem.appendChild(elem);
        elem = doc.createElement("drawingJson");
        this.setValue(elem, doc, comm.getDrawingJson());
        commentElem.appendChild(elem);
        return commentElem;
    }

    private void setValue(Node node, Document doc, String value) {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        Text child = doc.createTextNode(Marshaller.escapeXml(value));
        node.appendChild(child);
    }

    public static String escapeXml(String content) {
        if (content == null || content.length() == 0) {
            return "";
        }
        int len = content.length();
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < len) {
            char ch = content.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\'': {
                    str.append("&apos;");
                    break;
                }
                case '/': {
                    str.append("%2F");
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerFactoryConfigurationError {
    }
}

