/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.server.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.davinci.ajaxLibrary.ILibInfo;
import org.davinci.ajaxLibrary.LibInfo;
import org.davinci.ajaxLibrary.Library;
import org.davinci.server.util.XMLFile;
import org.maqetta.server.IStorage;
import org.maqetta.server.ServerManager;
import org.w3c.dom.Element;

public class LibrarySettings
extends XMLFile {
    IStorage libFile;
    ILibInfo[] libs;

    public LibrarySettings(IStorage dir) {
        this.libFile = dir.newInstance(dir, "libs.settings");
        if (!this.libFile.exists()) {
            this.libs = LibrarySettings.getAllDefaultLibs();
        } else {
            ArrayList list = this.load(this.libFile);
            this.libs = list.toArray(new ILibInfo[list.size()]);
        }
    }

    public boolean exists() {
        return this.libFile.exists();
    }

    public static ILibInfo[] getAllDefaultLibs() {
        Library[] all = ServerManager.getServerManager().getLibraryManager().getAllLibraries();
        ILibInfo[] results = new ILibInfo[all.length];
        int i = 0;
        while (i < all.length) {
            results[i] = new LibInfo(all[i].getID(), all[i].getName(), all[i].getVersion(), all[i].getDefaultRoot(), all[i].getRequired());
            ++i;
        }
        return results;
    }

    @Override
    protected String[] getAttributeNames() {
        return new String[]{"id", "name", "version", "virtualRoot", "base", "required"};
    }

    @Override
    protected String getAttributeValue(String attribute, Object object) {
        ILibInfo libInfo = (ILibInfo)object;
        if (attribute.equalsIgnoreCase("id")) {
            return libInfo.getId();
        }
        if (attribute.equalsIgnoreCase("name")) {
            return libInfo.getName();
        }
        if (attribute.equalsIgnoreCase("version")) {
            return libInfo.getVersion();
        }
        if (attribute.equalsIgnoreCase("virtualRoot")) {
            return libInfo.getVirtualRoot();
        }
        if (attribute.equalsIgnoreCase("base")) {
            return null;
        }
        if (attribute.equalsIgnoreCase("required")) {
            return libInfo.getRequired();
        }
        return null;
    }

    @Override
    protected String getRootTag() {
        return "libraries";
    }

    public ILibInfo[] allLibs() {
        return this.libs;
    }

    @Override
    protected String getElementTag() {
        return "library";
    }

    public boolean addLibrary(String name, String version, String id, String virtualRoot, String required) throws IOException {
        LibInfo link = new LibInfo(id, name, version, virtualRoot, required);
        LibInfo[] newLibs = new LibInfo[this.libs.length + 1];
        System.arraycopy(this.libs, 0, newLibs, 0, this.libs.length);
        newLibs[this.libs.length] = link;
        this.libs = newLibs;
        this.save();
        return true;
    }

    public boolean removeLibrary(String id, String version, String base) throws IOException {
        int i = 0;
        while (i < this.libs.length) {
            if (this.libs[i].getId().equals(id) && this.libs[i].getVersion().equals(version)) {
                LibInfo[] newLinks = new LibInfo[this.libs.length - 1];
                System.arraycopy(this.libs, 0, newLinks, 0, i);
                System.arraycopy(this.libs, i + 1, newLinks, i, this.libs.length - 1 - i);
                this.libs = newLinks;
                this.save();
                return true;
            }
            ++i;
        }
        return false;
    }

    public void modifyLibrary(String id, String version, String virtualRoot, String base, String required) throws IOException {
        this.removeLibrary(id, version, base);
        this.addLibrary(id, version, id, virtualRoot, required);
    }

    @Override
    protected Object createObject(Element element, String[] attributeNames, String[] attributeValues) {
        String id = null;
        String name = null;
        String version = null;
        String virtualRoot = null;
        String required = null;
        int i = 0;
        while (i < attributeNames.length) {
            if (attributeNames[i].equalsIgnoreCase("id")) {
                id = attributeValues[i];
            }
            if (attributeNames[i].equalsIgnoreCase("name")) {
                name = attributeValues[i];
            }
            if (attributeNames[i].equalsIgnoreCase("version")) {
                version = attributeValues[i];
            }
            if (attributeNames[i].equalsIgnoreCase("virtualRoot")) {
                virtualRoot = attributeValues[i];
            }
            if (attributeNames[i].equalsIgnoreCase("base")) {
                String cfr_ignored_0 = attributeValues[i];
            }
            if (attributeNames[i].equalsIgnoreCase("required")) {
                required = attributeValues[i];
            }
            ++i;
        }
        LibInfo link = new LibInfo(id, name, version, virtualRoot, required);
        return link;
    }

    public void save() throws IOException {
        this.save(this.libFile, Arrays.asList(this.libs));
    }
}

