/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.server.util;

import java.math.BigDecimal;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONReader {
    private static final String EMPTY_STRING = "";
    private static final String NULL = "null";

    public static Object read(String jsonString) {
        return JSONReader.parse(new StringCharacterIterator(jsonString));
    }

    private static RuntimeException error(String message, CharacterIterator it) {
        return new IllegalStateException("[" + it.getIndex() + "] " + message);
    }

    private static Object parse(CharacterIterator it) {
        JSONReader.parseWhitespace(it);
        Object result = JSONReader.parseValue(it);
        JSONReader.parseWhitespace(it);
        if (it.current() != '\uffff') {
            throw JSONReader.error("should be done", it);
        }
        return result;
    }

    private static void parseWhitespace(CharacterIterator it) {
        char c = it.current();
        while (Character.isWhitespace(c)) {
            c = it.next();
        }
    }

    private static Object parseValue(CharacterIterator it) {
        switch (it.current()) {
            case '{': {
                return JSONReader.parseObject(it);
            }
            case '[': {
                return JSONReader.parseArray(it);
            }
            case '\"': {
                return JSONReader.parseString(it);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return JSONReader.parseNumber(it);
            }
            case 't': {
                JSONReader.parseText(Boolean.TRUE.toString(), it);
                return Boolean.TRUE;
            }
            case 'f': {
                JSONReader.parseText(Boolean.FALSE.toString(), it);
                return Boolean.FALSE;
            }
            case 'n': {
                JSONReader.parseText(NULL, it);
                return null;
            }
        }
        throw JSONReader.error("Bad JSON starting character '" + it.current() + "'", it);
    }

    private static Map parseObject(CharacterIterator it) {
        it.next();
        JSONReader.parseWhitespace(it);
        if (it.current() == '}') {
            it.next();
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (true) {
            if (it.current() != '\"') {
                throw JSONReader.error("expected a string start '\"' but was '" + it.current() + "'", it);
            }
            String key = JSONReader.parseString(it);
            if (map.containsKey(key)) {
                throw JSONReader.error("' already definedkey '" + key, it);
            }
            JSONReader.parseWhitespace(it);
            if (it.current() != ':') {
                throw JSONReader.error("expected a pair separator ':' but was '" + it.current() + "'", it);
            }
            it.next();
            JSONReader.parseWhitespace(it);
            Object value = JSONReader.parseValue(it);
            map.put(key, value);
            JSONReader.parseWhitespace(it);
            if (it.current() != ',') break;
            it.next();
            JSONReader.parseWhitespace(it);
        }
        if (it.current() != '}') {
            throw JSONReader.error("expected an object close '}' but was '" + it.current() + "'", it);
        }
        it.next();
        return map;
    }

    private static List parseArray(CharacterIterator it) {
        it.next();
        JSONReader.parseWhitespace(it);
        if (it.current() == ']') {
            it.next();
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        while (true) {
            Object value = JSONReader.parseValue(it);
            list.add(value);
            JSONReader.parseWhitespace(it);
            if (it.current() != ',') break;
            it.next();
            JSONReader.parseWhitespace(it);
        }
        if (it.current() != ']') {
            throw JSONReader.error("expected an array close ']' but was '" + it.current() + "'", it);
        }
        it.next();
        return list;
    }

    private static void parseText(String string, CharacterIterator it) {
        int length = string.length();
        char c = it.current();
        int i = 0;
        while (i < length) {
            if (c != string.charAt(i)) {
                throw JSONReader.error("expected to parse '" + string + "' but character " + (i + 1) + " was '" + c + "'", it);
            }
            c = it.next();
            ++i;
        }
    }

    private static Object parseNumber(CharacterIterator it) {
        StringBuffer buffer = new StringBuffer();
        char c = it.current();
        while (Character.isDigit(c) || c == '-' || c == '+' || c == '.' || c == 'e' || c == 'E') {
            buffer.append(c);
            c = it.next();
        }
        try {
            return new BigDecimal(buffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw JSONReader.error("expected a number but was '" + buffer.toString() + "'", it);
        }
    }

    private static String parseString(CharacterIterator it) {
        char c = it.next();
        if (c == '\"') {
            it.next();
            return EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        while (c != '\"') {
            block15: {
                block16: {
                    if (Character.isISOControl(c)) {
                        throw JSONReader.error("illegal iso control character: '" + Integer.toHexString(c) + "'", it);
                    }
                    if (c != '\\') break block16;
                    c = it.next();
                    switch (c) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            buffer.append(c);
                            break block15;
                        }
                        case 'b': {
                            buffer.append('\b');
                            break block15;
                        }
                        case 'f': {
                            buffer.append('\f');
                            break block15;
                        }
                        case 'n': {
                            buffer.append('\n');
                            break block15;
                        }
                        case 'r': {
                            buffer.append('\r');
                            break block15;
                        }
                        case 't': {
                            buffer.append('\t');
                            break block15;
                        }
                        case 'u': {
                            StringBuffer unicode = new StringBuffer(4);
                            int i = 0;
                            while (i < 4) {
                                unicode.append(it.next());
                                ++i;
                            }
                            try {
                                buffer.append((char)Integer.parseInt(unicode.toString(), 16));
                                break block15;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw JSONReader.error("expected a unicode hex number but was '" + unicode.toString() + "'", it);
                            }
                        }
                        default: {
                            throw JSONReader.error("illegal escape character '" + c + "'", it);
                        }
                    }
                }
                buffer.append(c);
            }
            c = it.next();
        }
        c = it.next();
        return buffer.toString();
    }
}

