/*
 * Decompiled with CFR 0.152.
 */
package org.maqetta.server;

import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.davinci.server.internal.Activator;
import org.davinci.server.internal.command.CommandDescriptor;
import org.davinci.server.user.IUser;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.maqetta.server.Command;
import org.maqetta.server.ServerManager;

public class DavinciCommandServlet
extends HttpServlet {
    private static Logger theLogger = Logger.getLogger(DavinciCommandServlet.class.getName());
    private HashMap<String, CommandDescriptor> commands = new HashMap();
    private boolean initialized = false;

    private void log(HttpServletRequest req, String method, Throwable t) {
        theLogger.logp(Level.SEVERE, DavinciCommandServlet.class.getName(), method, "Unhandled Exception", t);
        theLogger.log(Level.INFO, "RequestURL: " + req.getRequestURL().toString());
        String query = req.getQueryString();
        if (query != null) {
            theLogger.log(Level.INFO, "Query: " + query);
        }
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String header = req.getHeader(name);
            if (header == null) continue;
            theLogger.log(Level.INFO, String.valueOf(name) + ": " + header);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            CommandDescriptor commandDescriptor;
            String pathInfo;
            resp.setCharacterEncoding("utf-8");
            if (!this.initialized) {
                this.initialize();
            }
            if ((pathInfo = req.getPathInfo()).startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            if ((commandDescriptor = this.commands.get(pathInfo)).isPut()) {
                throw new AssertionError((Object)new String("commandDescriptor is Put in doGet"));
            }
            IUser user = this.checkLogin(req, resp, commandDescriptor);
            if (user == null && !commandDescriptor.isNoLogin()) {
                return;
            }
            Command command = commandDescriptor.getCommand();
            command.init();
            command.syncHandleCommand(req, resp, user);
            if (command.getErrorString() != null) {
                resp.sendError(400, command.getErrorString());
            } else if (command.getResponse() != null) {
                ServletOutputStream stream = resp.getOutputStream();
                stream.write(command.getResponse().getBytes("utf-8"));
            }
        }
        catch (RuntimeException re) {
            this.log(req, "doGet", re);
            throw re;
        }
        catch (EOFException eof) {
            throw eof;
        }
        catch (IOException ioe) {
            this.log(req, "doGet", ioe);
            throw ioe;
        }
        catch (Error e) {
            this.log(req, "doGet", e);
            throw e;
        }
    }

    private IUser checkLogin(HttpServletRequest req, HttpServletResponse resp, CommandDescriptor commandDescriptor) throws IOException {
        IUser user = ServerManager.getServerManager().getUserManager().getUser(req);
        if (user == null && !ServerManager.LOCAL_INSTALL && !commandDescriptor.isNoLogin()) {
            resp.sendError(401);
            return null;
        }
        return user;
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            CommandDescriptor commandDescriptor;
            String pathInfo;
            if (!this.initialized) {
                this.initialize();
            }
            if ((pathInfo = req.getPathInfo()).startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            if (!(commandDescriptor = this.commands.get(pathInfo)).isPut()) {
                throw new AssertionError((Object)new String("commandDescriptor is not Put in doPut"));
            }
            IUser user = this.checkLogin(req, resp, commandDescriptor);
            if (user == null && !commandDescriptor.isNoLogin()) {
                return;
            }
            Command command = commandDescriptor.getCommand();
            command.init();
            command.syncHandleCommand(req, resp, user);
        }
        catch (RuntimeException re) {
            this.log(req, "doPut", re);
            throw re;
        }
        catch (IOException ioe) {
            this.log(req, "doPut", ioe);
            throw ioe;
        }
        catch (Error e) {
            this.log(req, "doPut", e);
            throw e;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            CommandDescriptor commandDescriptor;
            String pathInfo;
            if (!this.initialized) {
                this.initialize();
            }
            if ((pathInfo = req.getPathInfo()).startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            if ((commandDescriptor = this.commands.get(pathInfo)).isPut()) {
                throw new AssertionError((Object)new String("commandDescriptor is Put in doPost"));
            }
            IUser user = this.checkLogin(req, resp, commandDescriptor);
            if (user == null && !commandDescriptor.isNoLogin()) {
                resp.sendError(401);
                return;
            }
            Command command = commandDescriptor.getCommand();
            command.init();
            command.syncHandleCommand(req, resp, user);
            if (command.getErrorString() != null) {
                resp.sendError(400, command.getErrorString());
            } else if (command.getResponse() != null) {
                ServletOutputStream stream = resp.getOutputStream();
                stream.write(command.getResponse().getBytes("utf-8"));
            }
        }
        catch (RuntimeException re) {
            this.log(req, "doPost", re);
            throw re;
        }
        catch (IOException ioe) {
            this.log(req, "doPost", ioe);
            throw ioe;
        }
        catch (Error e) {
            this.log(req, "doPost", e);
            throw e;
        }
    }

    private void loadCommands() {
        IExtensionPoint point;
        IExtensionRegistry registry = Activator.getActivator().getRegistry();
        if (registry != null && (point = registry.getExtensionPoint("maqetta.core.server", "command")) != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals("command")) {
                        CommandDescriptor cmd = new CommandDescriptor(elements[j]);
                        this.commands.put(cmd.getPath(), cmd);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void initialize() {
        if (this.commands.isEmpty()) {
            this.loadCommands();
        }
        this.initialized = true;
    }
}

