/*
 * Decompiled with CFR 0.152.
 */
package org.maqetta.server;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import org.davinci.ajaxLibrary.ILibraryManager;
import org.davinci.ajaxLibrary.LibraryManager;
import org.davinci.server.internal.Activator;
import org.davinci.server.internal.IRegistryListener;
import org.davinci.server.user.IPersonManager;
import org.davinci.server.user.IUserManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.maqetta.server.IProjectTemplatesManager;
import org.maqetta.server.IServerManager;
import org.maqetta.server.IStorage;
import org.maqetta.server.ProjectTemplatesManager;
import org.maqetta.server.StorageFileSystem;

public class ServerManager
implements IServerManager {
    private static ServerManager theServerManager;
    private static final Logger theLogger;
    private IUserManager userManager;
    private IExtensionRegistry registry;
    private IPersonManager personManager;
    private ILibraryManager libraryManager;
    private IProjectTemplatesManager projectTemplatesManager;
    public ServletConfig servletConfig;
    private IStorage userDir;
    private Hashtable<String, String> options = new Hashtable();
    public static boolean LOCAL_INSTALL;
    private static final IExtension[] EMPTY_EXTENSIONS;

    static {
        theLogger = Logger.getLogger(ServerManager.class.getName());
        LOCAL_INSTALL = false;
        EMPTY_EXTENSIONS = new IExtension[0];
    }

    private ServerManager() {
        String localInstall = this.getDavinciProperty("maqetta.localInstall");
        if (localInstall != null) {
            LOCAL_INSTALL = Boolean.parseBoolean(localInstall);
        }
        try {
            this.readConfigFile();
        }
        catch (IOException e) {
            String desc = "Unable to read config file";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        Activator.getActivator().addRegistryChangeListener(new IRegistryListener(){

            @Override
            public void registryChanged() {
                ServerManager.this.registry = Activator.getActivator().getRegistry();
            }
        });
    }

    private void readConfigFile() throws IOException {
        String configFile = this.getDavinciProperty("orion.core.configFile");
        if (configFile == null) {
            throw new FileNotFoundException("Missing Config File: orion.core.configFile");
        }
        BufferedReader br = null;
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(configFile);
            DataInputStream in = new DataInputStream(fstream);
            br = new BufferedReader(new InputStreamReader(in));
            theLogger.log(Level.CONFIG, "Reading Config File: " + configFile);
            while ((strLine = br.readLine()) != null) {
                theLogger.log(Level.CONFIG, strLine);
                strLine = strLine.trim();
                String delims = "[=]+";
                String[] tokens = strLine.split(delims, 2);
                if (tokens.length <= 1 || tokens[0].startsWith("#")) continue;
                this.options.put(tokens[0], tokens[1]);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public static ServerManager getServerManager() {
        if (theServerManager == null) {
            theServerManager = new ServerManager();
        }
        return theServerManager;
    }

    @Override
    public String getDavinciProperty(String propertyName) {
        String property = this.options.get(propertyName);
        if (property == null) {
            property = System.getProperty(propertyName);
        }
        theLogger.log(Level.CONFIG, "servlet parm '" + propertyName + "' is : " + property);
        return property;
    }

    @Override
    public IUserManager getUserManager() {
        IConfigurationElement libraryElement;
        if (this.userManager == null && (libraryElement = ServerManager.getServerManager().getExtension("userManager", "userManager")) != null) {
            try {
                this.userManager = (IUserManager)libraryElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                theLogger.logp(Level.SEVERE, ServerManager.class.getName(), "getUserManager", "unexpected failure", e);
                throw new Error(e);
            }
        }
        return this.userManager;
    }

    @Override
    public List<IConfigurationElement> getExtensions(String extensionPoint, String elementTag) {
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        IExtension[] extensions = this.getExtensions(extensionPoint);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals(elementTag)) {
                    list.add(elements[j]);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    @Override
    public IConfigurationElement getExtension(String extensionPoint, String elementTag) {
        IExtension[] extensions = this.getExtensions(extensionPoint);
        IConfigurationElement winner = null;
        int highest = -100000;
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals(elementTag)) {
                    String stringPriority = elements[j].getAttribute("priority");
                    int priority = -10000;
                    if (stringPriority != null) {
                        priority = Integer.parseInt(stringPriority);
                    }
                    if (priority > highest) {
                        winner = elements[j];
                        highest = priority;
                    }
                }
                ++j;
            }
            ++i;
        }
        return winner;
    }

    @Override
    public IExtension[] getExtensions(String extensionPoint) {
        IExtensionPoint point;
        if (this.registry == null) {
            this.registry = Activator.getActivator().getRegistry();
        }
        if (this.registry != null && (point = this.registry.getExtensionPoint("maqetta.core.server", extensionPoint)) != null) {
            return point.getExtensions();
        }
        return EMPTY_EXTENSIONS;
    }

    @Override
    public synchronized ILibraryManager getLibraryManager() {
        if (this.libraryManager == null) {
            this.libraryManager = new LibraryManager();
        }
        return this.libraryManager;
    }

    public synchronized IProjectTemplatesManager getProjectTemplatesManager() {
        if (this.projectTemplatesManager == null) {
            this.projectTemplatesManager = new ProjectTemplatesManager();
        }
        return this.projectTemplatesManager;
    }

    public IPersonManager getPersonManager() {
        IConfigurationElement libraryElement;
        if (this.personManager == null && (libraryElement = ServerManager.getServerManager().getExtension("personManager", "personManager")) != null) {
            try {
                this.personManager = (IPersonManager)libraryElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                theLogger.logp(Level.SEVERE, ServerManager.class.getName(), "getPersonManager", "unexpected failure", e);
                throw new Error(e);
            }
        }
        return this.personManager;
    }

    public IStorage getBaseDirectory() {
        if (this.userDir == null) {
            String basePath = this.getDavinciProperty("maqetta.baseDirectory");
            if (basePath != null && basePath.length() > 0) {
                StorageFileSystem dir = new StorageFileSystem(basePath);
                if (dir.exists()) {
                    this.userDir = dir;
                } else {
                    System.err.println("FATAL!!!!! User directory does not exist.");
                    throw new RuntimeException("User directory does not exist.");
                }
            }
            if (this.userDir == null) {
                File tempDir = (File)this.servletConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
                this.userDir = new StorageFileSystem(tempDir);
            }
            if (this.userDir == null) {
                this.userDir = new StorageFileSystem(".");
            }
        }
        return this.userDir;
    }
}

