/*
 * Decompiled with CFR 0.152.
 */
package org.maqetta.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.IStorage;

public class StorageFileSystem
implements IStorage {
    private File file;

    public StorageFileSystem(IStorage userDirectory, String name) {
        this.file = new File(((StorageFileSystem)userDirectory).file, name);
    }

    public StorageFileSystem(String name) {
        this.file = new File(name);
    }

    public StorageFileSystem(File tempDir) {
        this.file = tempDir;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    @Override
    public IStorage[] listFiles() {
        File[] files = this.file.listFiles();
        IStorage[] results = new IStorage[files.length];
        int i = 0;
        while (i < files.length) {
            results[i] = new StorageFileSystem(files[i]);
            ++i;
        }
        return results;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public URI toURI() {
        return this.file.toURI();
    }

    @Override
    public IStorage getParentFile() {
        return new StorageFileSystem(this.file.getParentFile());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public IStorage newInstance(String name) {
        return new StorageFileSystem(name);
    }

    @Override
    public IStorage newInstance(IStorage parent, String name) {
        return new StorageFileSystem(parent, name);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public void createNewFile() throws IOException {
        this.file.mkdirs();
        this.file.delete();
        this.file.createNewFile();
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public void mkdir() {
        this.file.mkdir();
    }

    @Override
    public void renameTo(IStorage file) {
        this.file.renameTo(((StorageFileSystem)file).file);
    }

    @Override
    public IStorage newInstance(URI uri) {
        return new StorageFileSystem(new File(uri));
    }

    @Override
    public IStorage create(String path) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Collection findFiles(IStorage f1, String pathStr, boolean ignoreCase) {
        Object filter;
        Path path = new Path(pathStr);
        if (path.segment(0).equals("*")) {
            IOCase ioCase = ignoreCase ? IOCase.INSENSITIVE : IOCase.SENSITIVE;
            filter = new NameFileFilter(path.lastSegment(), ioCase);
        } else {
            String lastSegment = path.lastSegment();
            filter = lastSegment.startsWith("*") ? new SuffixFileFilter(lastSegment.substring(1)) : null;
        }
        return FileUtils.listFiles((File)((StorageFileSystem)f1).file, (IOFileFilter)filter, (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public String[] list() {
        return this.file.list();
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }
}

