/*
 * Decompiled with CFR 0.152.
 */
package org.maqetta.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Vector;
import org.davinci.ajaxLibrary.Library;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.IVResource;
import org.maqetta.server.VDirectory;

public class VLibraryResource
implements IVResource {
    private URL resourcePointer = null;
    private boolean isWorkingCopy;
    private Library library;
    private IVResource parent;
    private String name;
    private String bundleRoot;
    private IVResource[] _parents;
    private IVResource[] _files;
    private boolean sourceElement;

    public VLibraryResource(Library b, URL file, String name, String bundleRoot) {
        this.resourcePointer = file;
        this.isWorkingCopy = false;
        this.library = b;
        this.name = name == null ? "" : name;
        this.bundleRoot = bundleRoot;
        this.sourceElement = false;
    }

    public VLibraryResource(Library b, URL file, String name, String bundleRoot, boolean sourceElement) {
        this(b, file, name, bundleRoot);
        this.sourceElement = sourceElement;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void setParent(IVResource parent) {
        this.parent = parent;
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    @Override
    public URLConnection openConnection() throws MalformedURLException, IOException {
        return this.resourcePointer.openConnection();
    }

    @Override
    public String getPath() {
        if (this.parent == null) {
            return this.name;
        }
        return new Path(this.parent.getPath()).append(this.name).toString();
    }

    @Override
    public void createNewInstance() throws IOException {
        File f = new File(this.getPath());
        this.resourcePointer = f.toURL();
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public OutputStream getOutputStreem() throws FileNotFoundException {
        return null;
    }

    @Override
    public InputStream getInputStreem() throws IOException {
        return this.resourcePointer.openStream();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getURI() throws URISyntaxException {
        return this.resourcePointer.toURI();
    }

    @Override
    public boolean isDirectory() {
        String path = this.resourcePointer.getPath();
        return path.endsWith("/");
    }

    @Override
    public IVResource[] listFiles() {
        if (this._files == null) {
            this._files = this.listFiles("*", false);
        }
        return this._files;
    }

    public IVResource[] listFiles(String name, boolean recurse) {
        Path p1 = new Path(this.bundleRoot);
        String path = p1.append(name).toString();
        URL[] files = this.library.find(path, recurse, this.sourceElement);
        ArrayList<VLibraryResource> found = new ArrayList<VLibraryResource>();
        int i = 0;
        while (i < files.length) {
            if (files[i] != null) {
                Path myPath = new Path(this.resourcePointer.getPath());
                Path itemPath = new Path(files[i].getPath());
                IPath newPath = itemPath.removeFirstSegments(myPath.matchingFirstSegments((IPath)itemPath));
                VLibraryResource item = null;
                String[] pathSplit = newPath.segments();
                IVResource parent = this;
                VLibraryResource lastParent = null;
                int k = 0;
                while (k < pathSplit.length - 1) {
                    lastParent = parent;
                    parent = this.get(pathSplit[k]);
                    if (parent == null) {
                        parent = new VDirectory(lastParent, pathSplit[k]);
                    }
                    ++k;
                }
                String itemName = pathSplit[pathSplit.length - 1];
                item = new VLibraryResource(this.library, files[i], itemName, new Path(this.bundleRoot).append(itemName).toString(), this.sourceElement);
                item.setParent(parent);
                found.add(item);
            }
            ++i;
        }
        return found.toArray(new IVResource[found.size()]);
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    @Override
    public IVResource[] find(String path) {
        return new IVResource[]{this.get(path)};
    }

    @Override
    public void flushWorkingCopy() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void removeWorkingCopy() {
    }

    @Override
    public IVResource getParent() {
        return this.parent;
    }

    @Override
    public IVResource[] getParents() {
        if (this._parents == null) {
            Vector<IVResource> parents = new Vector<IVResource>();
            IVResource parent = this.getParent();
            while (parent != null) {
                parents.add(0, parent);
                parent = parent.getParent();
            }
            if (this.isDirectory()) {
                parents.add(this);
            }
            this._parents = parents.toArray(new IVResource[parents.size()]);
        }
        return this._parents;
    }

    @Override
    public IVResource create(String path) {
        return null;
    }

    @Override
    public void add(IVResource v) {
    }

    @Override
    public IVResource get(String childName) {
        Path p1 = new Path(this.bundleRoot);
        URL[] files = this.library.find(p1.append(childName).toString(), false, this.sourceElement);
        int i = 0;
        while (i < files.length) {
            Path myPath = new Path(this.resourcePointer.getPath());
            Path itemPath = new Path(files[i].getPath());
            IPath newPath = itemPath.removeFirstSegments(myPath.matchingFirstSegments((IPath)itemPath));
            VLibraryResource item = new VLibraryResource(this.library, files[i], newPath.removeTrailingSeparator().toString(), new Path(this.bundleRoot).append(newPath).toString());
            item.setParent(this);
            if (item != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public String getLibraryVersion() {
        return this.library.getVersion();
    }

    public String getLibraryId() {
        return this.library.getID();
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean readOnly() {
        return true;
    }

    @Override
    public IVResource[] findChildren(String childName) {
        IVResource[] children = this.listFiles(childName, true);
        return children;
    }

    @Override
    public boolean hasSource() {
        return this.library.getSourcePath() != null;
    }

    @Override
    public boolean isSource() {
        return this.sourceElement || this.parent != null && this.parent.isSource();
    }

    @Override
    public IVResource getSource() {
        return new VLibraryResource(this.library, this.resourcePointer, this.name, this.bundleRoot, true);
    }
}

