/*
 * Decompiled with CFR 0.152.
 */
package org.maqetta.server;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Vector;
import org.davinci.ajaxLibrary.ILibInfo;
import org.davinci.ajaxLibrary.Library;
import org.davinci.server.user.LibrarySettings;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.IStorage;
import org.maqetta.server.IVResource;
import org.maqetta.server.ServerManager;
import org.maqetta.server.VDirectory;
import org.maqetta.server.VFile;
import org.maqetta.server.VLibraryResource;

public class VStorageDirectory
extends VDirectory {
    private IStorage resource;

    public VStorageDirectory(IStorage resource, IVResource parent, String name) {
        super(parent, name, false);
        this.resource = resource;
        this.rebuild();
    }

    public VStorageDirectory(IStorage resource, IVResource parent, String name, boolean readOnly) {
        super(parent, name, readOnly);
        this.resource = resource;
        this.rebuild();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean delete() throws IOException {
        return this.resource.delete();
    }

    protected LibrarySettings getLibSettings() {
        return new LibrarySettings(this.resource.newInstance(this.resource, ".settings"));
    }

    protected Library getLibrary(ILibInfo li) {
        String id = li.getId();
        String version = li.getVersion();
        return ServerManager.getServerManager().getLibraryManager().getLibrary(id, version);
    }

    private boolean isConfig(String folderName) {
        if (folderName == null) {
            return true;
        }
        return folderName.equals(".settings");
    }

    private void rebuild() {
        IStorage[] userFiles = this.resource.listFiles();
        IVResource root = this;
        int j = 0;
        while (j < userFiles.length) {
            IVResource element;
            if (!this.isConfig(userFiles[j].getName()) && !userFiles[j].isDirectory()) {
                element = new VFile(userFiles[j], root, userFiles[j].getName());
                root.add(element);
            } else if (!this.isConfig(userFiles[j].getName()) && userFiles[j].isDirectory()) {
                element = new VStorageDirectory(userFiles[j], root, userFiles[j].getName(), true);
                root.add(element);
            }
            ++j;
        }
        LibrarySettings settings = this.getLibSettings();
        if (!settings.exists()) {
            return;
        }
        Vector<ILibInfo> libs = new Vector<ILibInfo>();
        libs.addAll(Arrays.asList(settings.allLibs()));
        int i = 0;
        while (i < libs.size()) {
            URL file;
            Library b;
            root = this;
            String defaultRoot = ((ILibInfo)libs.get(i)).getVirtualRoot();
            if (defaultRoot != null && (b = this.getLibrary((ILibInfo)libs.get(i))) != null && (file = b.getURL("", false)) != null) {
                Path path = new Path(defaultRoot);
                int k = 0;
                while (k < path.segmentCount()) {
                    String segment = path.segment(k);
                    IVResource v = root.get(segment);
                    if (v == null) {
                        v = new VDirectory(root, segment, true);
                        root.add(v);
                    }
                    root = v;
                    ++k;
                }
                VLibraryResource libResource = new VLibraryResource(b, file, "", "");
                IVResource[] children = libResource.listFiles();
                int p = 0;
                while (p < children.length) {
                    root.add(children[p]);
                    ++p;
                }
            }
            ++i;
        }
    }

    @Override
    public String toString() {
        return this.getPath();
    }
}

