/*
 * Decompiled with CFR 0.152.
 */
package org.maqetta.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.IVResource;

public class VURL
implements IVResource {
    private URL file = null;
    private boolean isWorkingCopy;
    private String virtualPath;

    public VURL(URL file) {
        this.file = file;
        this.virtualPath = file.getPath();
        this.isWorkingCopy = false;
    }

    public VURL(URL file, String virtualPath) {
        this.file = file;
        this.virtualPath = virtualPath;
    }

    @Override
    public boolean hasSource() {
        return false;
    }

    @Override
    public boolean isSource() {
        return false;
    }

    @Override
    public IVResource getSource() {
        return this;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    @Override
    public URLConnection openConnection() throws MalformedURLException, IOException {
        return this.file.openConnection();
    }

    @Override
    public String getPath() {
        String name = this.virtualPath;
        if (name != null && name.length() > 0 && name.charAt(name.length() - 1) == '/') {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    @Override
    public void createNewInstance() throws IOException {
        File f = new File(this.getPath());
        this.file = f.toURL();
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public OutputStream getOutputStreem() throws FileNotFoundException {
        return null;
    }

    @Override
    public InputStream getInputStreem() throws IOException {
        return this.file.openStream();
    }

    @Override
    public String getName() {
        return new Path(this.virtualPath).lastSegment();
    }

    @Override
    public URI getURI() throws URISyntaxException {
        return this.file.toURI();
    }

    @Override
    public boolean isDirectory() {
        String path = this.file.getPath();
        return path.endsWith("/");
    }

    @Override
    public IVResource[] listFiles() {
        return null;
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    @Override
    public IVResource[] find(String path) {
        return null;
    }

    @Override
    public void flushWorkingCopy() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void removeWorkingCopy() {
    }

    @Override
    public IVResource getParent() {
        return null;
    }

    @Override
    public IVResource[] getParents() {
        return null;
    }

    @Override
    public IVResource create(String path) {
        return null;
    }

    @Override
    public void setParent(IVResource parent) {
    }

    @Override
    public void add(IVResource v) {
    }

    @Override
    public IVResource get(String childName) {
        return null;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean readOnly() {
        return true;
    }

    @Override
    public IVResource[] findChildren(String childName) {
        return null;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }
}

