/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.backplane.bind.AbstractBindAction;
import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.IFinishedWithResult;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.ErrorStatus;
import com.ti.binding.stream.internal.CommCommandInfo;
import com.ti.binding.stream.internal.PortInfo;
import com.ti.binding.stream.internal.StreamModel;
import java.util.HashMap;

public class ComCommandBind
extends AbstractBindAction {
    static final String PORT_NAME_PARAM = "portName";
    static final String BAUD_PARAM = "baud";
    HashMap<String, String> paramNameToUri = new HashMap();

    public ComCommandBind(StreamModel model) {
        super((AbstractBindFactory)model);
        this.paramNameToUri.put(PORT_NAME_PARAM, "$ports.active");
        this.paramNameToUri.put(BAUD_PARAM, "$bauds.active");
    }

    public void run(Object parameters, IFinishedWithResult callback) {
        String uiPortName = null;
        String baud = null;
        String sendBuffer = null;
        IStatus[] status = new IStatus[1];
        int baudNum = 0;
        byte[] byteBuffer = null;
        uiPortName = (String)this.getParameter(parameters, PORT_NAME_PARAM, String.class, status);
        if (uiPortName == null || uiPortName.length() == 0) {
            status[0] = new ErrorStatus("portName is empty!");
        }
        if (status[0] == null && (baud = (String)this.getParameter(parameters, BAUD_PARAM, String.class, status)) != null) {
            try {
                baudNum = Integer.parseInt(baud);
            }
            catch (NumberFormatException numberFormatException) {
                status[0] = new ErrorStatus("Baud in not a number!");
            }
        }
        if (status[0] == null) {
            sendBuffer = (String)this.getParameter(parameters, "sendBuffer", String.class, status);
            if (sendBuffer == null || sendBuffer.length() == 0) {
                status[0] = new ErrorStatus("Data for the target not specified!");
            } else {
                String[] chars = sendBuffer.split(",");
                byteBuffer = new byte[chars.length];
                int i = 0;
                while (i < chars.length) {
                    int bbb = -1;
                    try {
                        chars[i] = chars[i].trim();
                        if (chars[i].startsWith("0x")) {
                            chars[i] = chars[i].substring(2);
                            bbb = Integer.parseInt(chars[i], 16);
                        } else {
                            bbb = Integer.parseInt(chars[i]);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        status[0] = new ErrorStatus("Bytes sequence is not formatted properly!");
                    }
                    if (bbb < 0 || bbb > 255) {
                        status[0] = new ErrorStatus("Numbers are too big. Only sequence of bytes can be processed!");
                    }
                    if (status[0] != null) break;
                    byteBuffer[i] = (byte)bbb;
                    ++i;
                }
            }
        }
        if (this.inCaseOfError(status[0], callback)) {
            return;
        }
        int[] timeout = new int[]{1000};
        int[] response_length = new int[]{1};
        if (!this.readOptionalInt(parameters, callback, timeout, "timeout", Integer.MIN_VALUE, Integer.MAX_VALUE)) {
            return;
        }
        if (!this.readOptionalInt(parameters, callback, response_length, "response_length", Integer.MIN_VALUE, Integer.MAX_VALUE)) {
            return;
        }
        String baseName = this.getModel().driverAssginedToBaseName(uiPortName);
        PortInfo portInfo = this.getModel().getComManager().getPortInfo(baseName, baudNum);
        CommCommandInfo commandInfo = new CommCommandInfo(byteBuffer);
        commandInfo.setResponceTimeout(timeout[0]);
        commandInfo.setResponceLength(response_length[0]);
        this.getModel().getComManager().sendCommand(portInfo, commandInfo, callback);
    }

    private boolean inCaseOfError(final IStatus status, final IFinishedWithResult callback) {
        if (status != null && callback != null) {
            this.getModel().getBackplane().getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    callback.done(status, null);
                }
            });
            return true;
        }
        return false;
    }

    private boolean readOptionalInt(Object parameters, IFinishedWithResult callback, int[] ret, String paramName, int minValue, int maxValue) {
        boolean exceptionOccured = false;
        IStatus[] status2 = new IStatus[1];
        Integer paramIntValue = (Integer)this.getParameter(parameters, paramName, Integer.class, status2);
        if (paramIntValue != null && status2[0] == null) {
            ret[0] = paramIntValue;
        } else {
            String paramValue = (String)this.getParameter(parameters, paramName, String.class, status2);
            if (paramValue != null && status2[0] == null) {
                try {
                    ret[0] = Integer.parseInt(paramValue);
                }
                catch (NumberFormatException numberFormatException) {
                    exceptionOccured = true;
                }
            }
        }
        if (exceptionOccured || ret[0] < minValue || ret[0] > maxValue) {
            status2[0] = new ErrorStatus("Parameter \"" + paramName + "\" must be an integer between " + minValue + " and " + maxValue + ".");
            if (this.inCaseOfError(status2[0], callback)) {
                return false;
            }
        }
        return true;
    }

    public StreamModel getModel() {
        return (StreamModel)this.fModel;
    }

    protected String getBindForParameter(String paramName) {
        String s = this.paramNameToUri.get(paramName);
        if (s != null) {
            return String.valueOf(this.getModel().getName()) + "." + s;
        }
        return super.getBindForParameter(paramName);
    }
}

