/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.backplane.bind.IFinishedWithResult;
import com.ti.binding.stream.internal.CommCommandInfo;
import com.ti.binding.stream.internal.IDebugFilter;
import com.ti.binding.stream.internal.IStreamListener;
import com.ti.binding.stream.internal.PortInfo;
import com.ti.binding.stream.internal.StreamModelPlugin;
import gnu.io.CommPortIdentifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;

public class ComManager {
    static final String OWNER_ID = "StreamModel";
    HashMap<String, PortInfo> openedPorts = new HashMap();
    static ArrayList<String> cahcedNames = null;
    static final int UPDATE_INTERVAL = 5000;

    public PortInfo getPortInfo(String portName, int baud) {
        PortInfo info = this.openedPorts.get(portName);
        if (info != null) {
            return info;
        }
        return this.createPortInfo(portName, baud);
    }

    PortInfo createPortInfo(String portName, int baud) {
        return new PortInfo(OWNER_ID, portName, baud);
    }

    public void sendCommand(final PortInfo portInfo, final CommCommandInfo commandInfo, final IFinishedWithResult callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean wasClosedInitially = !portInfo.isOpened();
                try {
                    if (wasClosedInitially) {
                        portInfo.open();
                    }
                    if (portInfo.isValid()) {
                        portInfo.writeByte(commandInfo.toSend);
                    }
                    if (portInfo.isValid()) {
                        portInfo.waitForResponce(commandInfo);
                    }
                    portInfo.clearRecivedBytes();
                }
                finally {
                    if (wasClosedInitially) {
                        portInfo.close();
                    }
                }
                if (callback != null) {
                    callback.done(portInfo.getStatus(), commandInfo.recieved);
                }
            }
        }).start();
    }

    public void open(String portName, int baud, IStreamListener listener) {
        PortInfo portInfo = this.createPortInfo(portName, baud);
        portInfo.open(listener);
        if (portInfo.isValid()) {
            this.openedPorts.put(portName, portInfo);
        }
    }

    public void close(String portName) {
        PortInfo portInfo = this.openedPorts.get(portName);
        if (portInfo != null) {
            portInfo.close();
            this.openedPorts.remove(portName);
        }
    }

    private static ArrayList<String> internalReadPorts() {
        long startTime = 0L;
        if (StreamModelPlugin.DEBUG) {
            startTime = System.currentTimeMillis();
        }
        ArrayList<String> ret = new ArrayList<String>();
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            if (portIdentifier.getPortType() != 1) continue;
            ret.add(portIdentifier.getName());
        }
        if (StreamModelPlugin.DEBUG) {
            long duration = System.currentTimeMillis() - startTime;
            StreamModelPlugin.debug("ComManager.ReadPorts = " + ret.size() + " timeToRead = " + duration, IDebugFilter.LIFECYCLE);
        }
        return ret;
    }

    public static ArrayList<String> getPorts() {
        if (cahcedNames == null) {
            cahcedNames = ComManager.internalReadPorts();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        cahcedNames = ComManager.internalReadPorts();
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }).start();
        }
        return cahcedNames;
    }
}

