/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.backplane.bind.AbstractBindAction;
import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IFinishedWithResult;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.ErrorStatus;
import com.ti.binding.stream.internal.StreamModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class FileActionBase
extends AbstractBindAction {
    Class<?>[] EXCEPTIONS = new Class[]{FileNotFoundException.class};
    String[] EXCEPTION_IDS = new String[]{"file_not_found"};
    static final String ID_DATA = "data";
    static final String ID_LOCAL_FILE = "localFile";
    static final String ID_SERVER_FILE = "serverFile";
    static final String ID_LOCAL_PATH = "localPath";
    static final String ID_UNTITELED_DAT = "Untitled.dat";
    static final String ID_LOCAL_NOT_ALLOWED = "local_file_operation_not_allowed";
    static final String ID_USER_CANCELLED = "operation_cancelled_by_user";
    static final String ID_INVALID_REMOTE_PATH_NAME = "invalid_remote_path_name";
    static final String ID_INVALID_LOCAL_PATH_NAME = "invalid_local_path_name";
    static final String ID_TEMPORARY_STORAGE_QUOTA_REACHED = "temporary_storage_quota_reached";
    static final String ID_PERSISTENT_STORAGE_QUOTA_REACHED = "persistent_storage_quota_reached";
    static final String TEXT_LOCAL_NOT_ALLOWED = "Local file system operation requested from a remote client.";
    static final String TEXT_USER_CANCELLED = "The user cancelled the operation.";
    static final String TEXT_INVALID_REMOTE_PATH_NAME = "The remote file path is invalid.";
    static final String TEXT_INVALID_LOCAL_PATH_NAME = "The local path is invalid.";
    static final String TEXT_TEMPORARY_STORAGE_QUOTA_REACHED = "Temporary server storage quota is reached. Please restart the applcation with -DserverTemporaryStorage=clear or -DserverTemporaryStorage=100";
    static final String TEXT_PERSISTENT_STORAGE_QUOTA_REACHED = "Persistent server storage quota is reached. Please restart the applcation with -DserverPermanentStorage=clear or -DserverPermanentStorage=20";

    public FileActionBase(StreamModel model) {
        super((AbstractBindFactory)model);
    }

    public StreamModel getModel() {
        return (StreamModel)this.fModel;
    }

    protected String loadData(String fullPath, IStatus[] status) {
        StringBuffer buffer = new StringBuffer();
        try {
            File file = new File(fullPath);
            char[] chr = new char[4096];
            FileReader reader = new FileReader(file);
            try {
                int len;
                while ((len = reader.read(chr)) > 0) {
                    buffer.append(chr, 0, len);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            status[0] = this.toStatus(e);
        }
        return buffer.toString();
    }

    protected void saveData(String data, String filePath, boolean append, boolean addCRBefore, boolean addCRAfter, IStatus[] status) {
        block18: {
            OutputStreamWriter fileWriter = null;
            if (data == null) {
                data = "";
            }
            try {
                try {
                    IPath path = new Path(filePath).removeLastSegments(1);
                    if (!path.toFile().exists()) {
                        path.toFile().mkdirs();
                    }
                    File newTextFile = new File(filePath);
                    fileWriter = new FileWriter(newTextFile, append);
                    if (addCRBefore) {
                        fileWriter.write("\n");
                    }
                    fileWriter.write(data);
                    if (addCRAfter) {
                        fileWriter.write("\n");
                    }
                    fileWriter.close();
                }
                catch (Exception ex) {
                    status[0] = this.toStatus(ex);
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                        break block18;
                    }
                    catch (Exception exception) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected String getExceptionId(Exception e) {
        int i = 0;
        while (i < this.EXCEPTIONS.length) {
            if (this.EXCEPTIONS[i].isInstance(e)) {
                return this.EXCEPTION_IDS[i];
            }
            ++i;
        }
        return "";
    }

    protected IStatus toStatus(Exception e) {
        return AbstractStatus.createErrorStatus((String)e.getLocalizedMessage(), (String)this.getExceptionId(e));
    }

    protected String getFullPath(Object parameters, IStatus[] status, boolean readOnly) {
        String appPath = (String)this.getParameter(parameters, "appPath", String.class, status);
        if (status[0] != null) {
            return null;
        }
        Path relativePath = new Path(appPath);
        if (relativePath == null || relativePath.segmentCount() < 3) {
            status[0] = new ErrorStatus("Application URI has few segments!");
            return null;
        }
        IPath appDataPath = null;
        if (readOnly) {
            IStatus[] status2 = new IStatus[1];
            String folder = (String)this.getParameter(parameters, "folder", String.class, status2);
            if (status2[0] == null && folder.equals("application") && status[0] == null) {
                String appFolder = this.getModel().getBackplane().resolveAppPath(appPath);
                if (appFolder == null) {
                    status[0] = new ErrorStatus("Application path cannot be resolved!");
                    return null;
                }
                appDataPath = new Path(appFolder);
            }
        }
        if (appDataPath == null) {
            String root = this.getModel().getBackplane().getLocalPath("", 1);
            if (root == null) {
                status[0] = new ErrorStatus("Cannot create root data folder!");
                return null;
            }
            appDataPath = new Path(root).append(relativePath.segment(0)).append(relativePath.segment(1)).append(relativePath.segment(2));
        }
        String realtive = (String)this.getParameter(parameters, "filePath", String.class, status);
        if (status[0] != null) {
            return null;
        }
        String fullPath = appDataPath.append((IPath)new Path(realtive)).toOSString();
        if (!this.isInside(fullPath, appDataPath.toOSString())) {
            status[0] = new ErrorStatus("filePath is outside of the application folder!");
            return null;
        }
        return fullPath;
    }

    protected String getData(Object parameters, IStatus[] status) {
        return (String)this.getParameter(parameters, ID_DATA, String.class, status);
    }

    protected boolean isInside(String fullPath, String parentFolder) {
        try {
            return new File(fullPath).getCanonicalPath().startsWith(new File(parentFolder).getCanonicalPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected Shell getActiveShell() {
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (activeShell == null) {
            activeShell = Display.getCurrent().getShells()[0];
        }
        return activeShell;
    }

    boolean isLocalOperationAllowed() {
        return this.getModel().getBackplane().isLocalOperationAllowed();
    }

    boolean isLocalBlocked(IFinishedWithResult callback) {
        if (!this.isLocalOperationAllowed()) {
            callback.done(AbstractStatus.createErrorStatus((String)TEXT_LOCAL_NOT_ALLOWED, (String)ID_LOCAL_NOT_ALLOWED), null);
            return true;
        }
        return false;
    }

    boolean isServerPathValid(String path) {
        if (path == null) {
            return false;
        }
        if (path.isEmpty()) {
            return false;
        }
        Path p = new Path(path);
        int i = 0;
        while (i < p.segmentCount()) {
            if (p.segment(i).equals("..")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean isServerPathInvalid(String path, IFinishedWithResult callback) {
        if (!this.isServerPathValid(path)) {
            callback.done(AbstractStatus.createErrorStatus((String)TEXT_INVALID_REMOTE_PATH_NAME, (String)ID_INVALID_REMOTE_PATH_NAME), null);
            return true;
        }
        return false;
    }

    protected String openFileDialog(FileDialog fd, String userPath) {
        String[] exts = new String[]{"*.*"};
        if (userPath != null && !userPath.isEmpty()) {
            Path path = new Path(userPath);
            String dir = path.removeLastSegments(1).toOSString();
            String file = path.lastSegment();
            if (dir != null && !dir.isEmpty()) {
                fd.setFilterPath(dir);
            }
            if (file != null && !file.isEmpty()) {
                fd.setFileName(file);
                int dotPos = file.lastIndexOf(".");
                if (dotPos != -1) {
                    String ext = file.substring(dotPos + 1);
                    exts = new String[]{"*." + ext, "*.*"};
                }
            }
        }
        fd.setFilterExtensions(exts);
        return fd.open();
    }

    protected void ensureQuota(int storageType, long bytesRequested, IStatus[] status) {
        if (status == null || status.length == 0 || storageType < 0 || storageType >= 2) {
            return;
        }
        if (this.getModel().getBackplane().ensureQuota(storageType, bytesRequested)) {
            return;
        }
        String[] quotaMsgs = new String[]{TEXT_TEMPORARY_STORAGE_QUOTA_REACHED, TEXT_PERSISTENT_STORAGE_QUOTA_REACHED};
        String[] quotaIds = new String[]{ID_TEMPORARY_STORAGE_QUOTA_REACHED, ID_PERSISTENT_STORAGE_QUOTA_REACHED};
        status[0] = AbstractStatus.createErrorStatus((String)quotaMsgs[storageType], (String)quotaIds[storageType]);
    }
}

