/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IFinishedWithResult;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.ErrorStatus;
import com.ti.binding.stream.internal.FileActionBase;
import com.ti.binding.stream.internal.StreamModel;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class FileBrowse
extends FileActionBase {
    public FileBrowse(StreamModel model) {
        super(model);
    }

    public void run(Object parameters, final IFinishedWithResult callback) {
        IStatus[] status = new IStatus[1];
        String action = (String)this.getParameter(parameters, "action", String.class, status);
        if (action != null && !action.equals("save") && !action.equals("open")) {
            IStatus error = AbstractStatus.createErrorStatus((String)"params.action can only be 'save' or 'open'.");
            callback.done(error, null);
            return;
        }
        final boolean save = "save".equals(action);
        final String path = (String)this.getParameter(parameters, "path", String.class, status);
        final Boolean override = (Boolean)this.getParameter(parameters, "promptOverride", Boolean.class, status);
        final String fileName = (String)this.getParameter(parameters, "fileName", String.class, status);
        final Integer filterIndex = (Integer)this.getParameter(parameters, "filterIndex", Integer.class, status);
        ArrayList extsObj = (ArrayList)this.getParameter(parameters, "filterExtensions", ArrayList.class, status);
        ArrayList namesObj = (ArrayList)this.getParameter(parameters, "filterNames", ArrayList.class, status);
        final String[] filterExtensions = this.toStringArray(extsObj);
        final String[] filterNamesObj = this.toStringArray(namesObj);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    FileDialog d = new FileDialog(FileBrowse.this.getActiveShell(), save ? 8192 : 4096);
                    if (fileName != null) {
                        d.setFileName(fileName);
                    }
                    if (path != null) {
                        d.setFilterPath(path);
                    }
                    if (override != null) {
                        d.setOverwrite(override.booleanValue());
                    }
                    if (filterExtensions.length > 0) {
                        d.setFilterExtensions(filterExtensions);
                    }
                    if (filterNamesObj.length > 0) {
                        d.setFilterNames(filterNamesObj);
                    }
                    if (filterIndex != null) {
                        d.setFilterIndex(filterIndex.intValue());
                    }
                    String s = d.open();
                    callback.done(null, (Object)s);
                }
                catch (Exception e) {
                    callback.done((IStatus)new ErrorStatus(e.getMessage()), null);
                }
            }
        });
    }
}

