/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IFinishedWithResult;
import com.ti.backplane.bind.IStatus;
import com.ti.binding.stream.internal.FileActionBase;
import com.ti.binding.stream.internal.StreamModel;

public class FileRead
extends FileActionBase {
    boolean local;

    public FileRead(StreamModel model, boolean local) {
        super(model);
        this.local = local;
    }

    public void run(Object parameters, IFinishedWithResult callback) {
        if (this.local && this.isLocalBlocked(callback)) {
            return;
        }
        IStatus[] status = new IStatus[1];
        String path = (String)this.getParameter(parameters, "path", String.class, status);
        String result = null;
        if (path == null || path.isEmpty()) {
            String text = this.local ? "The local path is invalid." : "The remote file path is invalid.";
            String id = this.local ? "invalid_local_path_name" : "invalid_remote_path_name";
            callback.done(AbstractStatus.createErrorStatus((String)text, (String)id), null);
            return;
        }
        if (!this.local && this.isServerPathInvalid(path, callback)) {
            return;
        }
        String localPath = this.local ? path : this.getModel().getBackplane().getLocalPath(path, 0);
        result = this.loadData(localPath, status);
        callback.done(status[0], (Object)result);
    }
}

