/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.binding.stream.internal.AbstractFileValue;
import com.ti.binding.stream.internal.StreamModel;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

class FileValue
extends AbstractFileValue {
    static boolean WRITE_NULL = false;
    BufferedWriter bufferedWriter = null;

    FileValue(StreamModel model, String name) {
        super(model, name);
    }

    @Override
    void open(boolean open) {
        if (this.fOpened == open) {
            return;
        }
        if (open) {
            if (this.name == null || this.name.isEmpty()) {
                this.setStatus("File names is not specified.");
                return;
            }
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(this.name);
                this.bufferedWriter = new BufferedWriter(fileWriter);
                this.fOpened = open;
            }
            catch (IOException e) {
                this.setStatus(e);
            }
        } else if (this.bufferedWriter != null) {
            try {
                this.bufferedWriter.close();
                this.bufferedWriter = null;
                this.clearStatus();
                this.fOpened = open;
            }
            catch (IOException e) {
                this.setStatus(e);
            }
        }
    }

    @Override
    boolean isOpened() {
        return this.fOpened && this.bufferedWriter != null;
    }

    @Override
    void addValue(Object value) {
        if (!this.isOpened()) {
            return;
        }
        if (value == null && !WRITE_NULL) {
            return;
        }
        String text = value != null ? value.toString() : "null";
        try {
            this.bufferedWriter.write(String.valueOf(text) + "\n");
        }
        catch (IOException e) {
            this.setStatus(e);
        }
    }
}

