/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IFinishedWithResult;
import com.ti.backplane.bind.IStatus;
import com.ti.binding.stream.internal.FileActionBase;
import com.ti.binding.stream.internal.StreamModel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class ListFiles
extends FileActionBase {
    public ListFiles(StreamModel model) {
        super(model);
    }

    public void run(Object parameters, IFinishedWithResult callback) {
        if (this.isLocalBlocked(callback)) {
            return;
        }
        IStatus[] status = new IStatus[1];
        IStatus retStatus = null;
        String path = (String)this.getParameter(parameters, "path", String.class, status);
        if (status[0] != null) {
            retStatus = status[0];
            callback.done(retStatus, null);
            return;
        }
        if (path == null || path.trim().length() == 0) {
            retStatus = AbstractStatus.createErrorStatus((String)"The local path is invalid.", (String)"invalid_local_path_name");
            callback.done(retStatus, null);
            return;
        }
        ArrayList files = new ArrayList();
        try {
            File folder = new File(path);
            File[] listOfFiles = folder.listFiles();
            int i = 0;
            while (i < listOfFiles.length) {
                HashMap<String, Object> obj = new HashMap<String, Object>();
                obj.put("isFile", new Boolean(listOfFiles[i].isFile()));
                obj.put("name", listOfFiles[i].getName());
                obj.put("fullPath", listOfFiles[i].getCanonicalPath());
                files.add(obj);
                ++i;
            }
        }
        catch (Exception e) {
            retStatus = this.toStatus(e);
            callback.done(retStatus, null);
            return;
        }
        HashMap ret = new HashMap();
        ret.put("files", files);
        callback.done(null, ret);
    }
}

