/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.ErrorStatus;
import com.ti.binding.stream.internal.CommCommandInfo;
import com.ti.binding.stream.internal.IDebugFilter;
import com.ti.binding.stream.internal.IStreamListener;
import com.ti.binding.stream.internal.PortListener;
import com.ti.binding.stream.internal.StreamModelPlugin;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TooManyListenersException;

public class PortInfo {
    static final int NO_ERROR = 0;
    static final int ERROR_PORT_NAME = 1;
    static final int ERROR_PORT_DIFFERENT_TYPE = 2;
    static final int ERROR_PORT_IN_USE = 3;
    static final int ERROR_UNSUPORTED_OPERATION = 4;
    static final int ERROR_TOO_MANY_LISTENERS = 5;
    static final int ERROR_EXCEPTION = 6;
    static final int ERROR_CLOSED = 7;
    static final int ERROR_WRITE_FAILED = 8;
    static final int TIMEOUT_OPEN = 2000;
    static final int TIMEOUT_RECEIVE = 4000;
    static final int BUFFER_SIZE_INPUT = 100000;
    static final int BUFFER_SIZE_OUTPUT = 4096;
    static final int[] allErrors = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    static final String[] errorMsg = new String[]{"Port does not exists.", "Port is of different type.", "Port is in use.", "Unsupported port operation.", "Too many listeners.", "Error in communication.", "Communication port is closed.", "Write failed!"};
    String ownerId;
    String portName;
    int baudRate;
    SerialPort comPort;
    int error;
    String errorDetails;
    PortListener myPortListener;
    int responseLength = 0;
    ArrayList<Byte> recieved = new ArrayList();
    ErrorStatus receiveStatus = null;
    IStreamListener streamListener = null;
    boolean fillInReciveBytes = false;

    public PortInfo(String ownerId, String portName, int baudRate) {
        this.portName = portName;
        this.baudRate = baudRate;
        this.ownerId = ownerId;
    }

    void open() {
        this.open(null);
    }

    void open(IStreamListener listener) {
        block10: {
            CommPortIdentifier portIdentifier = PortInfo.getPort(this.portName);
            if (portIdentifier != null) {
                try {
                    CommPort commPort = portIdentifier.open(this.ownerId, 2000);
                    if (commPort instanceof RXTXPort) {
                        this.comPort = (SerialPort)commPort;
                        this.comPort.setSerialPortParams(this.baudRate, 8, 1, 0);
                        this.comPort.enableReceiveTimeout(4000);
                        this.comPort.setInputBufferSize(100000);
                        this.comPort.setOutputBufferSize(4096);
                        this.streamListener = listener;
                        this.myPortListener = new PortListener(this);
                        this.comPort.addEventListener((SerialPortEventListener)this.myPortListener);
                        this.comPort.notifyOnDataAvailable(true);
                        break block10;
                    }
                    this.error = 2;
                }
                catch (PortInUseException portInUseException) {
                    this.error = 3;
                }
                catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                    this.error = 4;
                }
                catch (TooManyListenersException tooManyListenersException) {
                    this.error = 5;
                }
                catch (Exception exception) {
                    this.error = 6;
                }
            } else {
                this.error = 1;
            }
        }
        if (listener != null && !this.isValid()) {
            listener.onError(this.getStatus());
        }
        if (StreamModelPlugin.DEBUG) {
            String listenerText = listener != null ? " with listener" : "";
            StreamModelPlugin.debug("open port " + this.portName + listenerText + " , error = " + this.error, IDebugFilter.LIFECYCLE);
        }
    }

    void writeByte(byte[] data) {
        if (!this.isValid()) {
            return;
        }
        try {
            this.resetRecivedBytes();
            this.comPort.getOutputStream().write(data, 0, data.length);
        }
        catch (IOException e) {
            this.error = 8;
            this.errorDetails = e.getMessage();
        }
    }

    void resetRecivedBytes() {
        this.recieved = new ArrayList();
        this.fillInReciveBytes = true;
        this.receiveStatus = null;
    }

    void clearRecivedBytes() {
        this.fillInReciveBytes = false;
    }

    void waitForResponce(CommCommandInfo commandInfo) {
        this.responseLength = commandInfo.responseLength;
        int sleepInterval = 100;
        long startTime = System.currentTimeMillis();
        while ((this.recieved.size() < this.responseLength || this.responseLength == -1) && System.currentTimeMillis() - startTime < (long)commandInfo.responceTimeout && this.receiveStatus == null) {
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException interruptedException) {}
            commandInfo.recieved = this.recieved;
        }
        if (this.receiveStatus == null && System.currentTimeMillis() - startTime >= (long)commandInfo.responceTimeout && this.responseLength != -1) {
            this.receiveStatus = this.recieved.size() == 0 ? new ErrorStatus("No response was received after waiting for " + commandInfo.responceTimeout + " milliseconds.") : (this.recieved.size() == 1 ? new ErrorStatus("Only one byte was received after waiting for " + commandInfo.responceTimeout + " milliseconds.") : new ErrorStatus("Only " + this.recieved.size() + " bytes received after waiting for " + commandInfo.responceTimeout + " milliseconds."));
        }
    }

    void close() {
        if (this.comPort != null) {
            if (StreamModelPlugin.DEBUG) {
                StreamModelPlugin.debug("close port " + this.portName, IDebugFilter.LIFECYCLE);
            }
            this.comPort.removeEventListener();
            this.comPort.close();
            this.comPort = null;
        }
    }

    boolean isOpened() {
        return this.comPort != null && this.isValid();
    }

    void commsPort_DataReceived() {
        block5: {
            try {
                byte[] dataRxedTemp = new byte[50];
                int numBytes = this.comPort.getInputStream().available();
                if (numBytes >= 1) {
                    this.comPort.getInputStream().read(dataRxedTemp, 0, 1);
                    if (this.streamListener != null) {
                        this.streamListener.onNewByte(dataRxedTemp[0]);
                    }
                    if (this.fillInReciveBytes) {
                        this.recieved.add(dataRxedTemp[0]);
                    }
                }
            }
            catch (IOException ex) {
                this.receiveStatus = new ErrorStatus(ex.getMessage());
                if (this.streamListener == null) break block5;
                this.streamListener.onError((IStatus)this.receiveStatus);
            }
        }
    }

    boolean isValid() {
        return this.error == 0;
    }

    String getError() {
        if (this.isValid()) {
            return "";
        }
        String err = "Unspecified error.";
        int i = 0;
        while (i < allErrors.length) {
            if (this.error == allErrors[i]) {
                err = errorMsg[i];
                break;
            }
            ++i;
        }
        if (this.errorDetails != null) {
            err = String.valueOf(err) + " " + this.errorDetails;
        }
        return err;
    }

    IStatus getStatus() {
        if (!this.isValid()) {
            return new ErrorStatus(this.getError());
        }
        if (this.receiveStatus != null) {
            return this.receiveStatus;
        }
        return null;
    }

    private static CommPortIdentifier getPort(String name) {
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            if (portIdentifier.getName().compareTo(name) != 0) continue;
            return portIdentifier;
        }
        return null;
    }
}

