/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.AbstractBindValue;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.AbstractBindDependent;
import com.ti.binding.stream.internal.StreamModel;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;

public class PortNames
extends AbstractBindValue {
    static final String PORT_NAME = "_PORT_NAME_";
    static final String PORT_NAME_SUFFIX = ".*\\Q(\\E_PORT_NAME_\\Q)\\E.*";
    static final String[] DEP_BIND_NAMES = new String[]{"$ports.match_pattern", "$ports.base_names"};
    static final int INDEX_PATTERN = 0;
    static final int INDEX_BASE_NAMES = 1;
    AbstractBindDependent fParentBinds;
    HashMap<String, String> mruDriverAssignedToBaseNames = new HashMap();
    HashMap<String, String> mruBaseToDriverAssignedNames = new HashMap();

    public PortNames(StreamModel model) {
        super((AbstractBindFactory)model);
        ArrayList<IBindValue> depBindsList = new ArrayList<IBindValue>();
        int i = 0;
        while (i < DEP_BIND_NAMES.length) {
            depBindsList.add((IBindValue)model.getBinding(DEP_BIND_NAMES[i]));
            ++i;
        }
        IBindValue[] depBinds = depBindsList.toArray(new IBindValue[0]);
        this.fParentBinds = new AbstractBindDependent(depBinds){

            public void onStatusChanged(int index, IStatus status) {
                PortNames.this.onDependantChanged();
            }

            public void onValueChanged(int index, IFinished callback) {
                PortNames.this.onDependantChanged();
                if (callback != null) {
                    callback.done(null);
                }
            }
        };
        this.onDependantChanged();
    }

    void onDependantChanged() {
        String pattern = (String)this.fParentBinds.fBinds[0].getValue();
        ArrayList rowNames = (ArrayList)this.fParentBinds.fBinds[1].getValue();
        ArrayList driverAssignedNames = null;
        if ("win32".equals(Platform.getOS())) {
            driverAssignedNames = this.getDriverAssginedNames(rowNames, pattern);
        } else {
            this.fillCacheFromBaseNames(rowNames);
            driverAssignedNames = rowNames;
        }
        this.updateStatus();
        this.setValue(driverAssignedNames, null);
    }

    void updateStatus() {
        IStatus s = null;
        int i = 0;
        while (i < DEP_BIND_NAMES.length) {
            IStatus s0 = this.fParentBinds.fBinds[i].getStatus();
            if (s0 != null) {
                s = s0;
                break;
            }
            ++i;
        }
        this.setStatus(s);
    }

    ArrayList<String> getDriverAssginedNames(ArrayList<String> shortNames, String pattern) {
        this.mruDriverAssignedToBaseNames = new HashMap();
        this.mruBaseToDriverAssignedNames = new HashMap();
        ArrayList<String> all = new ArrayList<String>();
        String[] ROOT_KEY = new String[]{"USB", "FTDIBUS"};
        String[] stringArray = ROOT_KEY;
        int n = ROOT_KEY.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            try {
                String[] allTop;
                String topKey = "SYSTEM\\CurrentControlSet\\Enum\\" + root;
                String[] stringArray2 = allTop = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)topKey);
                int n3 = allTop.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] allSub;
                    String top = stringArray2[n4];
                    String[] stringArray3 = allSub = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)(String.valueOf(topKey) + "\\" + top));
                    int n5 = allSub.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String f;
                        String sub = stringArray3[n6];
                        String subFull = String.valueOf(topKey) + "\\" + top + "\\" + sub;
                        if (Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)subFull, (String)"FriendlyName") && (f = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)subFull, (String)"FriendlyName")) != null && f.length() > 0) {
                            all.add(f);
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            catch (Throwable throwable) {}
            ++n2;
        }
        String patternRow = pattern;
        if (pattern == null || pattern.length() == 0) {
            pattern = PORT_NAME_SUFFIX;
            patternRow = ".*";
        } else if (!pattern.contains(PORT_NAME)) {
            pattern = String.valueOf(pattern) + PORT_NAME_SUFFIX;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String shortName : shortNames) {
            String p = pattern.replace(PORT_NAME, shortName);
            String dsName = null;
            for (String fn : all) {
                if (!fn.matches(p)) continue;
                dsName = fn;
                break;
            }
            if (dsName == null && shortName.matches(patternRow)) {
                dsName = shortName;
            }
            if (dsName == null) continue;
            ret.add(dsName);
            this.mruDriverAssignedToBaseNames.put(dsName, shortName);
            this.mruBaseToDriverAssignedNames.put(shortName, dsName);
        }
        return ret;
    }

    public String BaseToDriverAssginedName(String baseName) {
        return this.mruBaseToDriverAssignedNames.get(baseName);
    }

    public String DriverAssginedToBaseName(String driverAssginedName) {
        return this.mruDriverAssignedToBaseNames.get(driverAssginedName);
    }

    void fillCacheFromBaseNames(ArrayList<String> shortNames) {
        this.mruDriverAssignedToBaseNames = new HashMap();
        this.mruBaseToDriverAssignedNames = new HashMap();
        for (String s : shortNames) {
            this.mruDriverAssignedToBaseNames.put(s, s);
            this.mruBaseToDriverAssignedNames.put(s, s);
        }
    }
}

