/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.backplane.bind.IStatus;
import com.ti.binding.stream.internal.AbstractFileValue;
import com.ti.binding.stream.internal.IStreamListener;
import com.ti.binding.stream.internal.StreamModel;
import java.util.ArrayList;

class PortValue
extends AbstractFileValue {
    ArrayList<IStreamListener> inListeners = new ArrayList();

    PortValue(StreamModel model, String name) {
        super(model, name);
    }

    @Override
    void open(boolean open) {
        if (open == this.fOpened) {
            return;
        }
        this.fOpened = open;
        String driverAssginedName = this.getName();
        String baseName = this.model.driverAssginedToBaseName(driverAssginedName);
        if (this.fOpened) {
            this.model.getComManager().open(baseName, this.model.getActiveBaud(), new IStreamListener(){

                @Override
                public void onNewByte(byte data) {
                    for (IStreamListener l : PortValue.this.inListeners) {
                        l.onNewByte(data);
                    }
                }

                @Override
                public void onError(IStatus status) {
                    for (IStreamListener l : PortValue.this.inListeners) {
                        l.onError(status);
                    }
                }
            });
        } else {
            this.model.getComManager().close(baseName);
        }
    }

    void addStreamListener(IStreamListener listener) {
        if (!this.inListeners.contains(listener)) {
            this.inListeners.add(listener);
        }
    }

    void removeStreamListener(IStreamListener listener) {
        if (this.inListeners.contains(listener)) {
            this.inListeners.remove(listener);
        }
    }

    @Override
    void addValue(Object value) {
    }
}

